/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.AIConfigTargetingDefaults;
import com.launchdarkly.api.model.AIConfigTargetingEnvironment;
import com.launchdarkly.api.model.AIConfigTargetingVariation;
import com.launchdarkly.api.model.AiConfigsExperimentInfoRep;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AIConfigTargeting {
    public static final String SERIALIZED_NAME_CREATED_AT = "createdAt";
    @SerializedName(value="createdAt")
    @Nonnull
    private Long createdAt;
    public static final String SERIALIZED_NAME_DEFAULTS = "defaults";
    @SerializedName(value="defaults")
    @Nullable
    private AIConfigTargetingDefaults defaults;
    public static final String SERIALIZED_NAME_ENVIRONMENTS = "environments";
    @SerializedName(value="environments")
    @Nonnull
    private Map<String, AIConfigTargetingEnvironment> environments = new HashMap<String, AIConfigTargetingEnvironment>();
    public static final String SERIALIZED_NAME_EXPERIMENTS = "experiments";
    @SerializedName(value="experiments")
    @Nonnull
    private AiConfigsExperimentInfoRep experiments;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    @Nonnull
    private String key;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    @Nonnull
    private List<String> tags = new ArrayList<String>();
    public static final String SERIALIZED_NAME_VARIATIONS = "variations";
    @SerializedName(value="variations")
    @Nonnull
    private List<AIConfigTargetingVariation> variations = new ArrayList<AIConfigTargetingVariation>();
    public static final String SERIALIZED_NAME_VERSION = "_version";
    @SerializedName(value="_version")
    @Nonnull
    private Integer version;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("createdAt", "defaults", "environments", "experiments", "key", "name", "tags", "variations", "_version"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("createdAt", "environments", "experiments", "key", "name", "tags", "variations", "_version"));

    public AIConfigTargeting createdAt(@Nonnull Long createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    public Long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(@Nonnull Long createdAt) {
        this.createdAt = createdAt;
    }

    public AIConfigTargeting defaults(@Nullable AIConfigTargetingDefaults defaults) {
        this.defaults = defaults;
        return this;
    }

    @Nullable
    public AIConfigTargetingDefaults getDefaults() {
        return this.defaults;
    }

    public void setDefaults(@Nullable AIConfigTargetingDefaults defaults) {
        this.defaults = defaults;
    }

    public AIConfigTargeting environments(@Nonnull Map<String, AIConfigTargetingEnvironment> environments) {
        this.environments = environments;
        return this;
    }

    public AIConfigTargeting putEnvironmentsItem(String key, AIConfigTargetingEnvironment environmentsItem) {
        if (this.environments == null) {
            this.environments = new HashMap<String, AIConfigTargetingEnvironment>();
        }
        this.environments.put(key, environmentsItem);
        return this;
    }

    @Nonnull
    public Map<String, AIConfigTargetingEnvironment> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(@Nonnull Map<String, AIConfigTargetingEnvironment> environments) {
        this.environments = environments;
    }

    public AIConfigTargeting experiments(@Nonnull AiConfigsExperimentInfoRep experiments) {
        this.experiments = experiments;
        return this;
    }

    @Nonnull
    public AiConfigsExperimentInfoRep getExperiments() {
        return this.experiments;
    }

    public void setExperiments(@Nonnull AiConfigsExperimentInfoRep experiments) {
        this.experiments = experiments;
    }

    public AIConfigTargeting key(@Nonnull String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    public void setKey(@Nonnull String key) {
        this.key = key;
    }

    public AIConfigTargeting name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public AIConfigTargeting tags(@Nonnull List<String> tags) {
        this.tags = tags;
        return this;
    }

    public AIConfigTargeting addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nonnull
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(@Nonnull List<String> tags) {
        this.tags = tags;
    }

    public AIConfigTargeting variations(@Nonnull List<AIConfigTargetingVariation> variations) {
        this.variations = variations;
        return this;
    }

    public AIConfigTargeting addVariationsItem(AIConfigTargetingVariation variationsItem) {
        if (this.variations == null) {
            this.variations = new ArrayList<AIConfigTargetingVariation>();
        }
        this.variations.add(variationsItem);
        return this;
    }

    @Nonnull
    public List<AIConfigTargetingVariation> getVariations() {
        return this.variations;
    }

    public void setVariations(@Nonnull List<AIConfigTargetingVariation> variations) {
        this.variations = variations;
    }

    public AIConfigTargeting version(@Nonnull Integer version) {
        this.version = version;
        return this;
    }

    @Nonnull
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(@Nonnull Integer version) {
        this.version = version;
    }

    public AIConfigTargeting putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AIConfigTargeting aiConfigTargeting = (AIConfigTargeting)o;
        return Objects.equals(this.createdAt, aiConfigTargeting.createdAt) && Objects.equals(this.defaults, aiConfigTargeting.defaults) && Objects.equals(this.environments, aiConfigTargeting.environments) && Objects.equals(this.experiments, aiConfigTargeting.experiments) && Objects.equals(this.key, aiConfigTargeting.key) && Objects.equals(this.name, aiConfigTargeting.name) && Objects.equals(this.tags, aiConfigTargeting.tags) && Objects.equals(this.variations, aiConfigTargeting.variations) && Objects.equals(this.version, aiConfigTargeting.version) && Objects.equals(this.additionalProperties, aiConfigTargeting.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.createdAt, this.defaults, this.environments, this.experiments, this.key, this.name, this.tags, this.variations, this.version, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AIConfigTargeting {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    defaults: ").append(this.toIndentedString(this.defaults)).append("\n");
        sb.append("    environments: ").append(this.toIndentedString(this.environments)).append("\n");
        sb.append("    experiments: ").append(this.toIndentedString(this.experiments)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    variations: ").append(this.toIndentedString(this.variations)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in AIConfigTargeting is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_DEFAULTS) != null && !jsonObj.get(SERIALIZED_NAME_DEFAULTS).isJsonNull()) {
            AIConfigTargetingDefaults.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DEFAULTS));
        }
        AiConfigsExperimentInfoRep.validateJsonElement(jsonObj.get(SERIALIZED_NAME_EXPERIMENTS));
        if (!jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_VARIATIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `variations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VARIATIONS).toString()));
        }
        JsonArray jsonArrayvariations = jsonObj.getAsJsonArray(SERIALIZED_NAME_VARIATIONS);
        for (int i = 0; i < jsonArrayvariations.size(); ++i) {
            AIConfigTargetingVariation.validateJsonElement(jsonArrayvariations.get(i));
        }
    }

    public static AIConfigTargeting fromJson(String jsonString) throws IOException {
        return (AIConfigTargeting)JSON.getGson().fromJson(jsonString, AIConfigTargeting.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!AIConfigTargeting.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(AIConfigTargeting.class));
            return new TypeAdapter<AIConfigTargeting>(){

                public void write(JsonWriter out, AIConfigTargeting value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public AIConfigTargeting read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    AIConfigTargeting.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    AIConfigTargeting instance = (AIConfigTargeting)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

