/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.AbstractOpenApiSchema;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AIConfigTargetingVariationValue
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(AIConfigTargetingVariationValue.class.getName());
    public static final Map<String, Class<?>> schemas = new HashMap();

    public AIConfigTargetingVariationValue() {
        super("oneOf", Boolean.FALSE);
    }

    public AIConfigTargetingVariationValue(Object o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (instance instanceof Boolean) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof Object) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof BigDecimal) {
            super.setActualInstance(instance);
            return;
        }
        if (instance instanceof String) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be BigDecimal, Boolean, Object, String");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public Boolean getBoolean() throws ClassCastException {
        return (Boolean)super.getActualInstance();
    }

    public Object getObject() throws ClassCastException {
        return super.getActualInstance();
    }

    public BigDecimal getBigDecimal() throws ClassCastException {
        return (BigDecimal)super.getActualInstance();
    }

    public String getString() throws ClassCastException {
        return (String)super.getActualInstance();
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        int validCount = 0;
        ArrayList<String> errorMessages = new ArrayList<String>();
        try {
            if (!jsonElement.getAsJsonPrimitive().isBoolean()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected json element to be of type Boolean in the JSON string but got `%s`", jsonElement.toString()));
            }
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format(Locale.ROOT, "Deserialization for Boolean failed with `%s`.", e.getMessage()));
        }
        try {
            if (!jsonElement.getAsJsonPrimitive().isNumber()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected json element to be of type Number in the JSON string but got `%s`", jsonElement.toString()));
            }
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format(Locale.ROOT, "Deserialization for Object failed with `%s`.", e.getMessage()));
        }
        try {
            if (!jsonElement.getAsJsonPrimitive().isNumber()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected json element to be of type Number in the JSON string but got `%s`", jsonElement.toString()));
            }
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format(Locale.ROOT, "Deserialization for BigDecimal failed with `%s`.", e.getMessage()));
        }
        try {
            if (!jsonElement.getAsJsonPrimitive().isString()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected json element to be of type String in the JSON string but got `%s`", jsonElement.toString()));
            }
            ++validCount;
        }
        catch (Exception e) {
            errorMessages.add(String.format(Locale.ROOT, "Deserialization for String failed with `%s`.", e.getMessage()));
        }
        if (validCount != 1) {
            throw new IOException(String.format(Locale.ROOT, "The JSON string is invalid for AIConfigTargetingVariationValue with oneOf schemas: BigDecimal, Boolean, Object, String. %d class(es) match the result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", validCount, errorMessages, jsonElement.toString()));
        }
    }

    public static AIConfigTargetingVariationValue fromJson(String jsonString) throws IOException {
        return (AIConfigTargetingVariationValue)JSON.getGson().fromJson(jsonString, AIConfigTargetingVariationValue.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        schemas.put("Boolean", Boolean.class);
        schemas.put("Object", Object.class);
        schemas.put("BigDecimal", BigDecimal.class);
        schemas.put("String", String.class);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!AIConfigTargetingVariationValue.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter adapterBoolean = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Boolean.class));
            final TypeAdapter adapterObject = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Object.class));
            final TypeAdapter adapterBigDecimal = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(BigDecimal.class));
            final TypeAdapter adapterString = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(String.class));
            return new TypeAdapter<AIConfigTargetingVariationValue>(){

                public void write(JsonWriter out, AIConfigTargetingVariationValue value) throws IOException {
                    if (value == null || value.getActualInstance() == null) {
                        elementAdapter.write(out, null);
                        return;
                    }
                    if (value.getActualInstance() instanceof Boolean) {
                        JsonPrimitive primitive = adapterBoolean.toJsonTree((Object)((Boolean)value.getActualInstance())).getAsJsonPrimitive();
                        elementAdapter.write(out, (Object)primitive);
                        return;
                    }
                    if (value.getActualInstance() instanceof Object) {
                        JsonPrimitive primitive = adapterObject.toJsonTree(value.getActualInstance()).getAsJsonPrimitive();
                        elementAdapter.write(out, (Object)primitive);
                        return;
                    }
                    if (value.getActualInstance() instanceof BigDecimal) {
                        JsonElement element = adapterBigDecimal.toJsonTree((Object)((BigDecimal)value.getActualInstance()));
                        elementAdapter.write(out, (Object)element);
                        return;
                    }
                    if (value.getActualInstance() instanceof String) {
                        JsonPrimitive primitive = adapterString.toJsonTree((Object)((String)value.getActualInstance())).getAsJsonPrimitive();
                        elementAdapter.write(out, (Object)primitive);
                        return;
                    }
                    throw new IOException("Failed to serialize as the type doesn't match oneOf schemas: BigDecimal, Boolean, Object, String");
                }

                public AIConfigTargetingVariationValue read(JsonReader in) throws IOException {
                    Object deserialized = null;
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    int match = 0;
                    ArrayList<String> errorMessages = new ArrayList<String>();
                    TypeAdapter actualAdapter = elementAdapter;
                    try {
                        if (!jsonElement.getAsJsonPrimitive().isBoolean()) {
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected json element to be of type Boolean in the JSON string but got `%s`", jsonElement.toString()));
                        }
                        actualAdapter = adapterBoolean;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'Boolean'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format(Locale.ROOT, "Deserialization for Boolean failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'Boolean'", e);
                    }
                    try {
                        if (!jsonElement.getAsJsonPrimitive().isNumber()) {
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected json element to be of type Number in the JSON string but got `%s`", jsonElement.toString()));
                        }
                        actualAdapter = adapterObject;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'Object'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format(Locale.ROOT, "Deserialization for Object failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'Object'", e);
                    }
                    try {
                        if (!jsonElement.getAsJsonPrimitive().isNumber()) {
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected json element to be of type Number in the JSON string but got `%s`", jsonElement.toString()));
                        }
                        actualAdapter = adapterBigDecimal;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'BigDecimal'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format(Locale.ROOT, "Deserialization for BigDecimal failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'BigDecimal'", e);
                    }
                    try {
                        if (!jsonElement.getAsJsonPrimitive().isString()) {
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected json element to be of type String in the JSON string but got `%s`", jsonElement.toString()));
                        }
                        actualAdapter = adapterString;
                        ++match;
                        log.log(Level.FINER, "Input data matches schema 'String'");
                    }
                    catch (Exception e) {
                        errorMessages.add(String.format(Locale.ROOT, "Deserialization for String failed with `%s`.", e.getMessage()));
                        log.log(Level.FINER, "Input data does not match schema 'String'", e);
                    }
                    if (match == 1) {
                        AIConfigTargetingVariationValue ret = new AIConfigTargetingVariationValue();
                        ret.setActualInstance(actualAdapter.fromJsonTree(jsonElement));
                        return ret;
                    }
                    throw new IOException(String.format(Locale.ROOT, "Failed deserialization for AIConfigTargetingVariationValue: %d classes match result, expected 1. Detailed failure message for oneOf schemas: %s. JSON: %s", match, errorMessages, jsonElement.toString()));
                }
            }.nullSafe();
        }
    }
}

