/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Access;
import com.launchdarkly.api.model.ApplicationFlagCollectionRep;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.MaintainerRep;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApplicationRep {
    public static final String SERIALIZED_NAME_FLAGS = "flags";
    @SerializedName(value="flags")
    @Nullable
    private ApplicationFlagCollectionRep flags;
    public static final String SERIALIZED_NAME_ACCESS = "_access";
    @SerializedName(value="_access")
    @Nullable
    private Access access;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    @Nullable
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_VERSION = "_version";
    @SerializedName(value="_version")
    @Nullable
    private Integer version;
    public static final String SERIALIZED_NAME_AUTO_ADDED = "autoAdded";
    @SerializedName(value="autoAdded")
    @Nonnull
    private Boolean autoAdded;
    public static final String SERIALIZED_NAME_CREATION_DATE = "creationDate";
    @SerializedName(value="creationDate")
    @Nullable
    private Long creationDate;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    @Nullable
    private String description;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    @Nonnull
    private String key;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    @Nonnull
    private KindEnum kind;
    public static final String SERIALIZED_NAME_MAINTAINER = "_maintainer";
    @SerializedName(value="_maintainer")
    @Nullable
    private MaintainerRep maintainer;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("flags", "_access", "_links", "_version", "autoAdded", "creationDate", "description", "key", "kind", "_maintainer", "name"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("autoAdded", "key", "kind", "name"));

    public ApplicationRep flags(@Nullable ApplicationFlagCollectionRep flags) {
        this.flags = flags;
        return this;
    }

    @Nullable
    public ApplicationFlagCollectionRep getFlags() {
        return this.flags;
    }

    public void setFlags(@Nullable ApplicationFlagCollectionRep flags) {
        this.flags = flags;
    }

    public ApplicationRep access(@Nullable Access access) {
        this.access = access;
        return this;
    }

    @Nullable
    public Access getAccess() {
        return this.access;
    }

    public void setAccess(@Nullable Access access) {
        this.access = access;
    }

    public ApplicationRep links(@Nullable Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public ApplicationRep putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(@Nullable Map<String, Link> links) {
        this.links = links;
    }

    public ApplicationRep version(@Nullable Integer version) {
        this.version = version;
        return this;
    }

    @Nullable
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable Integer version) {
        this.version = version;
    }

    public ApplicationRep autoAdded(@Nonnull Boolean autoAdded) {
        this.autoAdded = autoAdded;
        return this;
    }

    @Nonnull
    public Boolean getAutoAdded() {
        return this.autoAdded;
    }

    public void setAutoAdded(@Nonnull Boolean autoAdded) {
        this.autoAdded = autoAdded;
    }

    public ApplicationRep creationDate(@Nullable Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nullable
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(@Nullable Long creationDate) {
        this.creationDate = creationDate;
    }

    public ApplicationRep description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public ApplicationRep key(@Nonnull String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    public void setKey(@Nonnull String key) {
        this.key = key;
    }

    public ApplicationRep kind(@Nonnull KindEnum kind) {
        this.kind = kind;
        return this;
    }

    @Nonnull
    public KindEnum getKind() {
        return this.kind;
    }

    public void setKind(@Nonnull KindEnum kind) {
        this.kind = kind;
    }

    public ApplicationRep maintainer(@Nullable MaintainerRep maintainer) {
        this.maintainer = maintainer;
        return this;
    }

    @Nullable
    public MaintainerRep getMaintainer() {
        return this.maintainer;
    }

    public void setMaintainer(@Nullable MaintainerRep maintainer) {
        this.maintainer = maintainer;
    }

    public ApplicationRep name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public ApplicationRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationRep applicationRep = (ApplicationRep)o;
        return Objects.equals(this.flags, applicationRep.flags) && Objects.equals(this.access, applicationRep.access) && Objects.equals(this.links, applicationRep.links) && Objects.equals(this.version, applicationRep.version) && Objects.equals(this.autoAdded, applicationRep.autoAdded) && Objects.equals(this.creationDate, applicationRep.creationDate) && Objects.equals(this.description, applicationRep.description) && Objects.equals(this.key, applicationRep.key) && Objects.equals((Object)this.kind, (Object)applicationRep.kind) && Objects.equals(this.maintainer, applicationRep.maintainer) && Objects.equals(this.name, applicationRep.name) && Objects.equals(this.additionalProperties, applicationRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.flags, this.access, this.links, this.version, this.autoAdded, this.creationDate, this.description, this.key, this.kind, this.maintainer, this.name, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationRep {\n");
        sb.append("    flags: ").append(this.toIndentedString(this.flags)).append("\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    autoAdded: ").append(this.toIndentedString(this.autoAdded)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString((Object)this.kind)).append("\n");
        sb.append("    maintainer: ").append(this.toIndentedString(this.maintainer)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in ApplicationRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_FLAGS) != null && !jsonObj.get(SERIALIZED_NAME_FLAGS).isJsonNull()) {
            ApplicationFlagCollectionRep.validateJsonElement(jsonObj.get(SERIALIZED_NAME_FLAGS));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESS) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS).isJsonNull()) {
            Access.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ACCESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        KindEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_KIND));
        if (jsonObj.get(SERIALIZED_NAME_MAINTAINER) != null && !jsonObj.get(SERIALIZED_NAME_MAINTAINER).isJsonNull()) {
            MaintainerRep.validateJsonElement(jsonObj.get(SERIALIZED_NAME_MAINTAINER));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
    }

    public static ApplicationRep fromJson(String jsonString) throws IOException {
        return (ApplicationRep)JSON.getGson().fromJson(jsonString, ApplicationRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ApplicationRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ApplicationRep.class));
            return new TypeAdapter<ApplicationRep>(){

                public void write(JsonWriter out, ApplicationRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ApplicationRep read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ApplicationRep.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    ApplicationRep instance = (ApplicationRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum KindEnum {
        BROWSER("browser"),
        MOBILE("mobile"),
        SERVER("server");

        private String value;

        private KindEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static KindEnum fromValue(String value) {
            for (KindEnum b : KindEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            KindEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<KindEnum> {
            public void write(JsonWriter jsonWriter, KindEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public KindEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return KindEnum.fromValue(value);
            }
        }
    }
}

