/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.ApprovalSettings;
import com.launchdarkly.api.model.Conflict;
import com.launchdarkly.api.model.CopiedFromEnv;
import com.launchdarkly.api.model.CustomWorkflowMeta;
import com.launchdarkly.api.model.IntegrationMetadata;
import com.launchdarkly.api.model.ReviewResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApprovalRequestResponse {
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    @Nonnull
    private String id;
    public static final String SERIALIZED_NAME_VERSION = "_version";
    @SerializedName(value="_version")
    @Nonnull
    private Integer version;
    public static final String SERIALIZED_NAME_CREATION_DATE = "creationDate";
    @SerializedName(value="creationDate")
    @Nonnull
    private Long creationDate;
    public static final String SERIALIZED_NAME_SERVICE_KIND = "serviceKind";
    @SerializedName(value="serviceKind")
    @Nonnull
    private String serviceKind;
    public static final String SERIALIZED_NAME_REQUESTOR_ID = "requestorId";
    @SerializedName(value="requestorId")
    @Nullable
    private String requestorId;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    @Nullable
    private String description;
    public static final String SERIALIZED_NAME_REVIEW_STATUS = "reviewStatus";
    @SerializedName(value="reviewStatus")
    @Nonnull
    private ReviewStatusEnum reviewStatus;
    public static final String SERIALIZED_NAME_ALL_REVIEWS = "allReviews";
    @SerializedName(value="allReviews")
    @Nonnull
    private List<ReviewResponse> allReviews = new ArrayList<ReviewResponse>();
    public static final String SERIALIZED_NAME_NOTIFY_MEMBER_IDS = "notifyMemberIds";
    @SerializedName(value="notifyMemberIds")
    @Nonnull
    private List<String> notifyMemberIds = new ArrayList<String>();
    public static final String SERIALIZED_NAME_APPLIED_DATE = "appliedDate";
    @SerializedName(value="appliedDate")
    @Nullable
    private Long appliedDate;
    public static final String SERIALIZED_NAME_APPLIED_BY_MEMBER_ID = "appliedByMemberId";
    @SerializedName(value="appliedByMemberId")
    @Nullable
    private String appliedByMemberId;
    public static final String SERIALIZED_NAME_APPLIED_BY_SERVICE_TOKEN_ID = "appliedByServiceTokenId";
    @SerializedName(value="appliedByServiceTokenId")
    @Nullable
    private String appliedByServiceTokenId;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    @Nonnull
    private StatusEnum status;
    public static final String SERIALIZED_NAME_INSTRUCTIONS = "instructions";
    @SerializedName(value="instructions")
    @Nonnull
    private List<Map<String, Object>> instructions = new ArrayList<Map<String, Object>>();
    public static final String SERIALIZED_NAME_CONFLICTS = "conflicts";
    @SerializedName(value="conflicts")
    @Nonnull
    private List<Conflict> conflicts = new ArrayList<Conflict>();
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    @Nonnull
    private Map<String, Object> links = new HashMap<String, Object>();
    public static final String SERIALIZED_NAME_EXECUTION_DATE = "executionDate";
    @SerializedName(value="executionDate")
    @Nullable
    private Long executionDate;
    public static final String SERIALIZED_NAME_OPERATING_ON_ID = "operatingOnId";
    @SerializedName(value="operatingOnId")
    @Nullable
    private String operatingOnId;
    public static final String SERIALIZED_NAME_INTEGRATION_METADATA = "integrationMetadata";
    @SerializedName(value="integrationMetadata")
    @Nullable
    private IntegrationMetadata integrationMetadata;
    public static final String SERIALIZED_NAME_SOURCE = "source";
    @SerializedName(value="source")
    @Nullable
    private CopiedFromEnv source;
    public static final String SERIALIZED_NAME_CUSTOM_WORKFLOW_METADATA = "customWorkflowMetadata";
    @SerializedName(value="customWorkflowMetadata")
    @Nullable
    private CustomWorkflowMeta customWorkflowMetadata;
    public static final String SERIALIZED_NAME_RESOURCE_ID = "resourceId";
    @SerializedName(value="resourceId")
    @Nullable
    private String resourceId;
    public static final String SERIALIZED_NAME_APPROVAL_SETTINGS = "approvalSettings";
    @SerializedName(value="approvalSettings")
    @Nullable
    private ApprovalSettings approvalSettings;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("_id", "_version", "creationDate", "serviceKind", "requestorId", "description", "reviewStatus", "allReviews", "notifyMemberIds", "appliedDate", "appliedByMemberId", "appliedByServiceTokenId", "status", "instructions", "conflicts", "_links", "executionDate", "operatingOnId", "integrationMetadata", "source", "customWorkflowMetadata", "resourceId", "approvalSettings"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("_id", "_version", "creationDate", "serviceKind", "reviewStatus", "allReviews", "notifyMemberIds", "status", "instructions", "conflicts", "_links"));

    public ApprovalRequestResponse id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public ApprovalRequestResponse version(@Nonnull Integer version) {
        this.version = version;
        return this;
    }

    @Nonnull
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(@Nonnull Integer version) {
        this.version = version;
    }

    public ApprovalRequestResponse creationDate(@Nonnull Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nonnull
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(@Nonnull Long creationDate) {
        this.creationDate = creationDate;
    }

    public ApprovalRequestResponse serviceKind(@Nonnull String serviceKind) {
        this.serviceKind = serviceKind;
        return this;
    }

    @Nonnull
    public String getServiceKind() {
        return this.serviceKind;
    }

    public void setServiceKind(@Nonnull String serviceKind) {
        this.serviceKind = serviceKind;
    }

    public ApprovalRequestResponse requestorId(@Nullable String requestorId) {
        this.requestorId = requestorId;
        return this;
    }

    @Nullable
    public String getRequestorId() {
        return this.requestorId;
    }

    public void setRequestorId(@Nullable String requestorId) {
        this.requestorId = requestorId;
    }

    public ApprovalRequestResponse description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public ApprovalRequestResponse reviewStatus(@Nonnull ReviewStatusEnum reviewStatus) {
        this.reviewStatus = reviewStatus;
        return this;
    }

    @Nonnull
    public ReviewStatusEnum getReviewStatus() {
        return this.reviewStatus;
    }

    public void setReviewStatus(@Nonnull ReviewStatusEnum reviewStatus) {
        this.reviewStatus = reviewStatus;
    }

    public ApprovalRequestResponse allReviews(@Nonnull List<ReviewResponse> allReviews) {
        this.allReviews = allReviews;
        return this;
    }

    public ApprovalRequestResponse addAllReviewsItem(ReviewResponse allReviewsItem) {
        if (this.allReviews == null) {
            this.allReviews = new ArrayList<ReviewResponse>();
        }
        this.allReviews.add(allReviewsItem);
        return this;
    }

    @Nonnull
    public List<ReviewResponse> getAllReviews() {
        return this.allReviews;
    }

    public void setAllReviews(@Nonnull List<ReviewResponse> allReviews) {
        this.allReviews = allReviews;
    }

    public ApprovalRequestResponse notifyMemberIds(@Nonnull List<String> notifyMemberIds) {
        this.notifyMemberIds = notifyMemberIds;
        return this;
    }

    public ApprovalRequestResponse addNotifyMemberIdsItem(String notifyMemberIdsItem) {
        if (this.notifyMemberIds == null) {
            this.notifyMemberIds = new ArrayList<String>();
        }
        this.notifyMemberIds.add(notifyMemberIdsItem);
        return this;
    }

    @Nonnull
    public List<String> getNotifyMemberIds() {
        return this.notifyMemberIds;
    }

    public void setNotifyMemberIds(@Nonnull List<String> notifyMemberIds) {
        this.notifyMemberIds = notifyMemberIds;
    }

    public ApprovalRequestResponse appliedDate(@Nullable Long appliedDate) {
        this.appliedDate = appliedDate;
        return this;
    }

    @Nullable
    public Long getAppliedDate() {
        return this.appliedDate;
    }

    public void setAppliedDate(@Nullable Long appliedDate) {
        this.appliedDate = appliedDate;
    }

    public ApprovalRequestResponse appliedByMemberId(@Nullable String appliedByMemberId) {
        this.appliedByMemberId = appliedByMemberId;
        return this;
    }

    @Nullable
    public String getAppliedByMemberId() {
        return this.appliedByMemberId;
    }

    public void setAppliedByMemberId(@Nullable String appliedByMemberId) {
        this.appliedByMemberId = appliedByMemberId;
    }

    public ApprovalRequestResponse appliedByServiceTokenId(@Nullable String appliedByServiceTokenId) {
        this.appliedByServiceTokenId = appliedByServiceTokenId;
        return this;
    }

    @Nullable
    public String getAppliedByServiceTokenId() {
        return this.appliedByServiceTokenId;
    }

    public void setAppliedByServiceTokenId(@Nullable String appliedByServiceTokenId) {
        this.appliedByServiceTokenId = appliedByServiceTokenId;
    }

    public ApprovalRequestResponse status(@Nonnull StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(@Nonnull StatusEnum status) {
        this.status = status;
    }

    public ApprovalRequestResponse instructions(@Nonnull List<Map<String, Object>> instructions) {
        this.instructions = instructions;
        return this;
    }

    public ApprovalRequestResponse addInstructionsItem(Map<String, Object> instructionsItem) {
        if (this.instructions == null) {
            this.instructions = new ArrayList<Map<String, Object>>();
        }
        this.instructions.add(instructionsItem);
        return this;
    }

    @Nonnull
    public List<Map<String, Object>> getInstructions() {
        return this.instructions;
    }

    public void setInstructions(@Nonnull List<Map<String, Object>> instructions) {
        this.instructions = instructions;
    }

    public ApprovalRequestResponse conflicts(@Nonnull List<Conflict> conflicts) {
        this.conflicts = conflicts;
        return this;
    }

    public ApprovalRequestResponse addConflictsItem(Conflict conflictsItem) {
        if (this.conflicts == null) {
            this.conflicts = new ArrayList<Conflict>();
        }
        this.conflicts.add(conflictsItem);
        return this;
    }

    @Nonnull
    public List<Conflict> getConflicts() {
        return this.conflicts;
    }

    public void setConflicts(@Nonnull List<Conflict> conflicts) {
        this.conflicts = conflicts;
    }

    public ApprovalRequestResponse links(@Nonnull Map<String, Object> links) {
        this.links = links;
        return this;
    }

    public ApprovalRequestResponse putLinksItem(String key, Object linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Object>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    public Map<String, Object> getLinks() {
        return this.links;
    }

    public void setLinks(@Nonnull Map<String, Object> links) {
        this.links = links;
    }

    public ApprovalRequestResponse executionDate(@Nullable Long executionDate) {
        this.executionDate = executionDate;
        return this;
    }

    @Nullable
    public Long getExecutionDate() {
        return this.executionDate;
    }

    public void setExecutionDate(@Nullable Long executionDate) {
        this.executionDate = executionDate;
    }

    public ApprovalRequestResponse operatingOnId(@Nullable String operatingOnId) {
        this.operatingOnId = operatingOnId;
        return this;
    }

    @Nullable
    public String getOperatingOnId() {
        return this.operatingOnId;
    }

    public void setOperatingOnId(@Nullable String operatingOnId) {
        this.operatingOnId = operatingOnId;
    }

    public ApprovalRequestResponse integrationMetadata(@Nullable IntegrationMetadata integrationMetadata) {
        this.integrationMetadata = integrationMetadata;
        return this;
    }

    @Nullable
    public IntegrationMetadata getIntegrationMetadata() {
        return this.integrationMetadata;
    }

    public void setIntegrationMetadata(@Nullable IntegrationMetadata integrationMetadata) {
        this.integrationMetadata = integrationMetadata;
    }

    public ApprovalRequestResponse source(@Nullable CopiedFromEnv source) {
        this.source = source;
        return this;
    }

    @Nullable
    public CopiedFromEnv getSource() {
        return this.source;
    }

    public void setSource(@Nullable CopiedFromEnv source) {
        this.source = source;
    }

    public ApprovalRequestResponse customWorkflowMetadata(@Nullable CustomWorkflowMeta customWorkflowMetadata) {
        this.customWorkflowMetadata = customWorkflowMetadata;
        return this;
    }

    @Nullable
    public CustomWorkflowMeta getCustomWorkflowMetadata() {
        return this.customWorkflowMetadata;
    }

    public void setCustomWorkflowMetadata(@Nullable CustomWorkflowMeta customWorkflowMetadata) {
        this.customWorkflowMetadata = customWorkflowMetadata;
    }

    public ApprovalRequestResponse resourceId(@Nullable String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @Nullable
    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(@Nullable String resourceId) {
        this.resourceId = resourceId;
    }

    public ApprovalRequestResponse approvalSettings(@Nullable ApprovalSettings approvalSettings) {
        this.approvalSettings = approvalSettings;
        return this;
    }

    @Nullable
    public ApprovalSettings getApprovalSettings() {
        return this.approvalSettings;
    }

    public void setApprovalSettings(@Nullable ApprovalSettings approvalSettings) {
        this.approvalSettings = approvalSettings;
    }

    public ApprovalRequestResponse putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApprovalRequestResponse approvalRequestResponse = (ApprovalRequestResponse)o;
        return Objects.equals(this.id, approvalRequestResponse.id) && Objects.equals(this.version, approvalRequestResponse.version) && Objects.equals(this.creationDate, approvalRequestResponse.creationDate) && Objects.equals(this.serviceKind, approvalRequestResponse.serviceKind) && Objects.equals(this.requestorId, approvalRequestResponse.requestorId) && Objects.equals(this.description, approvalRequestResponse.description) && Objects.equals((Object)this.reviewStatus, (Object)approvalRequestResponse.reviewStatus) && Objects.equals(this.allReviews, approvalRequestResponse.allReviews) && Objects.equals(this.notifyMemberIds, approvalRequestResponse.notifyMemberIds) && Objects.equals(this.appliedDate, approvalRequestResponse.appliedDate) && Objects.equals(this.appliedByMemberId, approvalRequestResponse.appliedByMemberId) && Objects.equals(this.appliedByServiceTokenId, approvalRequestResponse.appliedByServiceTokenId) && Objects.equals((Object)this.status, (Object)approvalRequestResponse.status) && Objects.equals(this.instructions, approvalRequestResponse.instructions) && Objects.equals(this.conflicts, approvalRequestResponse.conflicts) && Objects.equals(this.links, approvalRequestResponse.links) && Objects.equals(this.executionDate, approvalRequestResponse.executionDate) && Objects.equals(this.operatingOnId, approvalRequestResponse.operatingOnId) && Objects.equals(this.integrationMetadata, approvalRequestResponse.integrationMetadata) && Objects.equals(this.source, approvalRequestResponse.source) && Objects.equals(this.customWorkflowMetadata, approvalRequestResponse.customWorkflowMetadata) && Objects.equals(this.resourceId, approvalRequestResponse.resourceId) && Objects.equals(this.approvalSettings, approvalRequestResponse.approvalSettings) && Objects.equals(this.additionalProperties, approvalRequestResponse.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.version, this.creationDate, this.serviceKind, this.requestorId, this.description, this.reviewStatus, this.allReviews, this.notifyMemberIds, this.appliedDate, this.appliedByMemberId, this.appliedByServiceTokenId, this.status, this.instructions, this.conflicts, this.links, this.executionDate, this.operatingOnId, this.integrationMetadata, this.source, this.customWorkflowMetadata, this.resourceId, this.approvalSettings, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApprovalRequestResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    serviceKind: ").append(this.toIndentedString(this.serviceKind)).append("\n");
        sb.append("    requestorId: ").append(this.toIndentedString(this.requestorId)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    reviewStatus: ").append(this.toIndentedString((Object)this.reviewStatus)).append("\n");
        sb.append("    allReviews: ").append(this.toIndentedString(this.allReviews)).append("\n");
        sb.append("    notifyMemberIds: ").append(this.toIndentedString(this.notifyMemberIds)).append("\n");
        sb.append("    appliedDate: ").append(this.toIndentedString(this.appliedDate)).append("\n");
        sb.append("    appliedByMemberId: ").append(this.toIndentedString(this.appliedByMemberId)).append("\n");
        sb.append("    appliedByServiceTokenId: ").append(this.toIndentedString(this.appliedByServiceTokenId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    instructions: ").append(this.toIndentedString(this.instructions)).append("\n");
        sb.append("    conflicts: ").append(this.toIndentedString(this.conflicts)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    executionDate: ").append(this.toIndentedString(this.executionDate)).append("\n");
        sb.append("    operatingOnId: ").append(this.toIndentedString(this.operatingOnId)).append("\n");
        sb.append("    integrationMetadata: ").append(this.toIndentedString(this.integrationMetadata)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    customWorkflowMetadata: ").append(this.toIndentedString(this.customWorkflowMetadata)).append("\n");
        sb.append("    resourceId: ").append(this.toIndentedString(this.resourceId)).append("\n");
        sb.append("    approvalSettings: ").append(this.toIndentedString(this.approvalSettings)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in ApprovalRequestResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_SERVICE_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `serviceKind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SERVICE_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REQUESTOR_ID) != null && !jsonObj.get(SERIALIZED_NAME_REQUESTOR_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REQUESTOR_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `requestorId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUESTOR_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_REVIEW_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `reviewStatus` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REVIEW_STATUS).toString()));
        }
        ReviewStatusEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_REVIEW_STATUS));
        if (!jsonObj.get(SERIALIZED_NAME_ALL_REVIEWS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `allReviews` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ALL_REVIEWS).toString()));
        }
        JsonArray jsonArrayallReviews = jsonObj.getAsJsonArray(SERIALIZED_NAME_ALL_REVIEWS);
        for (int i = 0; i < jsonArrayallReviews.size(); ++i) {
            ReviewResponse.validateJsonElement(jsonArrayallReviews.get(i));
        }
        if (jsonObj.get(SERIALIZED_NAME_NOTIFY_MEMBER_IDS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_NOTIFY_MEMBER_IDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `notifyMemberIds` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NOTIFY_MEMBER_IDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_APPLIED_BY_MEMBER_ID) != null && !jsonObj.get(SERIALIZED_NAME_APPLIED_BY_MEMBER_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_APPLIED_BY_MEMBER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `appliedByMemberId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APPLIED_BY_MEMBER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_APPLIED_BY_SERVICE_TOKEN_ID) != null && !jsonObj.get(SERIALIZED_NAME_APPLIED_BY_SERVICE_TOKEN_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_APPLIED_BY_SERVICE_TOKEN_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `appliedByServiceTokenId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APPLIED_BY_SERVICE_TOKEN_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        StatusEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        if (jsonObj.get(SERIALIZED_NAME_INSTRUCTIONS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_INSTRUCTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `instructions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INSTRUCTIONS).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_CONFLICTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `conflicts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONFLICTS).toString()));
        }
        JsonArray jsonArrayconflicts = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONFLICTS);
        for (int i = 0; i < jsonArrayconflicts.size(); ++i) {
            Conflict.validateJsonElement(jsonArrayconflicts.get(i));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPERATING_ON_ID) != null && !jsonObj.get(SERIALIZED_NAME_OPERATING_ON_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OPERATING_ON_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `operatingOnId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPERATING_ON_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INTEGRATION_METADATA) != null && !jsonObj.get(SERIALIZED_NAME_INTEGRATION_METADATA).isJsonNull()) {
            IntegrationMetadata.validateJsonElement(jsonObj.get(SERIALIZED_NAME_INTEGRATION_METADATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_SOURCE) != null && !jsonObj.get(SERIALIZED_NAME_SOURCE).isJsonNull()) {
            CopiedFromEnv.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SOURCE));
        }
        if (jsonObj.get(SERIALIZED_NAME_CUSTOM_WORKFLOW_METADATA) != null && !jsonObj.get(SERIALIZED_NAME_CUSTOM_WORKFLOW_METADATA).isJsonNull()) {
            CustomWorkflowMeta.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CUSTOM_WORKFLOW_METADATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_ID) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESOURCE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `resourceId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_APPROVAL_SETTINGS) != null && !jsonObj.get(SERIALIZED_NAME_APPROVAL_SETTINGS).isJsonNull()) {
            ApprovalSettings.validateJsonElement(jsonObj.get(SERIALIZED_NAME_APPROVAL_SETTINGS));
        }
    }

    public static ApprovalRequestResponse fromJson(String jsonString) throws IOException {
        return (ApprovalRequestResponse)JSON.getGson().fromJson(jsonString, ApprovalRequestResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ApprovalRequestResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ApprovalRequestResponse.class));
            return new TypeAdapter<ApprovalRequestResponse>(){

                public void write(JsonWriter out, ApprovalRequestResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ApprovalRequestResponse read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ApprovalRequestResponse.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    ApprovalRequestResponse instance = (ApprovalRequestResponse)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        PENDING("pending"),
        COMPLETED("completed"),
        FAILED("failed"),
        SCHEDULED("scheduled");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            StatusEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ReviewStatusEnum {
        APPROVED("approved"),
        DECLINED("declined"),
        PENDING("pending");

        private String value;

        private ReviewStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ReviewStatusEnum fromValue(String value) {
            for (ReviewStatusEnum b : ReviewStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            ReviewStatusEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<ReviewStatusEnum> {
            public void write(JsonWriter jsonWriter, ReviewStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ReviewStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ReviewStatusEnum.fromValue(value);
            }
        }
    }
}

