/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Access;
import com.launchdarkly.api.model.AssignedToRep;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.Statement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CustomRole {
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    @Nonnull
    private String id;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    @Nonnull
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_ACCESS = "_access";
    @SerializedName(value="_access")
    @Nullable
    private Access access;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    @Nullable
    private String description;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    @Nonnull
    private String key;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_POLICY = "policy";
    @SerializedName(value="policy")
    @Nonnull
    private List<Statement> policy = new ArrayList<Statement>();
    public static final String SERIALIZED_NAME_BASE_PERMISSIONS = "basePermissions";
    @SerializedName(value="basePermissions")
    @Nullable
    private String basePermissions;
    public static final String SERIALIZED_NAME_RESOURCE_CATEGORY = "resourceCategory";
    @SerializedName(value="resourceCategory")
    @Nullable
    private String resourceCategory;
    public static final String SERIALIZED_NAME_ASSIGNED_TO = "assignedTo";
    @SerializedName(value="assignedTo")
    @Nullable
    private AssignedToRep assignedTo;
    public static final String SERIALIZED_NAME_PRESET_BUNDLE_VERSION = "_presetBundleVersion";
    @SerializedName(value="_presetBundleVersion")
    @Nullable
    private Integer presetBundleVersion;
    public static final String SERIALIZED_NAME_PRESET_STATEMENTS = "_presetStatements";
    @SerializedName(value="_presetStatements")
    @Nullable
    private List<Statement> presetStatements = new ArrayList<Statement>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("_id", "_links", "_access", "description", "key", "name", "policy", "basePermissions", "resourceCategory", "assignedTo", "_presetBundleVersion", "_presetStatements"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("_id", "_links", "key", "name", "policy"));

    public CustomRole id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public CustomRole links(@Nonnull Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public CustomRole putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(@Nonnull Map<String, Link> links) {
        this.links = links;
    }

    public CustomRole access(@Nullable Access access) {
        this.access = access;
        return this;
    }

    @Nullable
    public Access getAccess() {
        return this.access;
    }

    public void setAccess(@Nullable Access access) {
        this.access = access;
    }

    public CustomRole description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public CustomRole key(@Nonnull String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    public void setKey(@Nonnull String key) {
        this.key = key;
    }

    public CustomRole name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public CustomRole policy(@Nonnull List<Statement> policy) {
        this.policy = policy;
        return this;
    }

    public CustomRole addPolicyItem(Statement policyItem) {
        if (this.policy == null) {
            this.policy = new ArrayList<Statement>();
        }
        this.policy.add(policyItem);
        return this;
    }

    @Nonnull
    public List<Statement> getPolicy() {
        return this.policy;
    }

    public void setPolicy(@Nonnull List<Statement> policy) {
        this.policy = policy;
    }

    public CustomRole basePermissions(@Nullable String basePermissions) {
        this.basePermissions = basePermissions;
        return this;
    }

    @Nullable
    public String getBasePermissions() {
        return this.basePermissions;
    }

    public void setBasePermissions(@Nullable String basePermissions) {
        this.basePermissions = basePermissions;
    }

    public CustomRole resourceCategory(@Nullable String resourceCategory) {
        this.resourceCategory = resourceCategory;
        return this;
    }

    @Nullable
    public String getResourceCategory() {
        return this.resourceCategory;
    }

    public void setResourceCategory(@Nullable String resourceCategory) {
        this.resourceCategory = resourceCategory;
    }

    public CustomRole assignedTo(@Nullable AssignedToRep assignedTo) {
        this.assignedTo = assignedTo;
        return this;
    }

    @Nullable
    public AssignedToRep getAssignedTo() {
        return this.assignedTo;
    }

    public void setAssignedTo(@Nullable AssignedToRep assignedTo) {
        this.assignedTo = assignedTo;
    }

    public CustomRole presetBundleVersion(@Nullable Integer presetBundleVersion) {
        this.presetBundleVersion = presetBundleVersion;
        return this;
    }

    @Nullable
    public Integer getPresetBundleVersion() {
        return this.presetBundleVersion;
    }

    public void setPresetBundleVersion(@Nullable Integer presetBundleVersion) {
        this.presetBundleVersion = presetBundleVersion;
    }

    public CustomRole presetStatements(@Nullable List<Statement> presetStatements) {
        this.presetStatements = presetStatements;
        return this;
    }

    public CustomRole addPresetStatementsItem(Statement presetStatementsItem) {
        if (this.presetStatements == null) {
            this.presetStatements = new ArrayList<Statement>();
        }
        this.presetStatements.add(presetStatementsItem);
        return this;
    }

    @Nullable
    public List<Statement> getPresetStatements() {
        return this.presetStatements;
    }

    public void setPresetStatements(@Nullable List<Statement> presetStatements) {
        this.presetStatements = presetStatements;
    }

    public CustomRole putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomRole customRole = (CustomRole)o;
        return Objects.equals(this.id, customRole.id) && Objects.equals(this.links, customRole.links) && Objects.equals(this.access, customRole.access) && Objects.equals(this.description, customRole.description) && Objects.equals(this.key, customRole.key) && Objects.equals(this.name, customRole.name) && Objects.equals(this.policy, customRole.policy) && Objects.equals(this.basePermissions, customRole.basePermissions) && Objects.equals(this.resourceCategory, customRole.resourceCategory) && Objects.equals(this.assignedTo, customRole.assignedTo) && Objects.equals(this.presetBundleVersion, customRole.presetBundleVersion) && Objects.equals(this.presetStatements, customRole.presetStatements) && Objects.equals(this.additionalProperties, customRole.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.links, this.access, this.description, this.key, this.name, this.policy, this.basePermissions, this.resourceCategory, this.assignedTo, this.presetBundleVersion, this.presetStatements, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomRole {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    basePermissions: ").append(this.toIndentedString(this.basePermissions)).append("\n");
        sb.append("    resourceCategory: ").append(this.toIndentedString(this.resourceCategory)).append("\n");
        sb.append("    assignedTo: ").append(this.toIndentedString(this.assignedTo)).append("\n");
        sb.append("    presetBundleVersion: ").append(this.toIndentedString(this.presetBundleVersion)).append("\n");
        sb.append("    presetStatements: ").append(this.toIndentedString(this.presetStatements)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraypresetStatements;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in CustomRole is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESS) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS).isJsonNull()) {
            Access.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ACCESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_POLICY).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `policy` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POLICY).toString()));
        }
        JsonArray jsonArraypolicy = jsonObj.getAsJsonArray(SERIALIZED_NAME_POLICY);
        for (int i = 0; i < jsonArraypolicy.size(); ++i) {
            Statement.validateJsonElement(jsonArraypolicy.get(i));
        }
        if (jsonObj.get(SERIALIZED_NAME_BASE_PERMISSIONS) != null && !jsonObj.get(SERIALIZED_NAME_BASE_PERMISSIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BASE_PERMISSIONS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `basePermissions` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BASE_PERMISSIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_CATEGORY) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_CATEGORY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESOURCE_CATEGORY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `resourceCategory` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_CATEGORY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ASSIGNED_TO) != null && !jsonObj.get(SERIALIZED_NAME_ASSIGNED_TO).isJsonNull()) {
            AssignedToRep.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ASSIGNED_TO));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRESET_STATEMENTS) != null && !jsonObj.get(SERIALIZED_NAME_PRESET_STATEMENTS).isJsonNull() && (jsonArraypresetStatements = jsonObj.getAsJsonArray(SERIALIZED_NAME_PRESET_STATEMENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PRESET_STATEMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `_presetStatements` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRESET_STATEMENTS).toString()));
            }
            for (int i = 0; i < jsonArraypresetStatements.size(); ++i) {
                Statement.validateJsonElement(jsonArraypresetStatements.get(i));
            }
        }
    }

    public static CustomRole fromJson(String jsonString) throws IOException {
        return (CustomRole)JSON.getGson().fromJson(jsonString, CustomRole.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!CustomRole.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CustomRole.class));
            return new TypeAdapter<CustomRole>(){

                public void write(JsonWriter out, CustomRole value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public CustomRole read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CustomRole.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    CustomRole instance = (CustomRole)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

