/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.ConflictOutput;
import com.launchdarkly.api.model.ExecutionOutput;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.StageOutput;
import com.launchdarkly.api.model.WorkflowTemplateMetadata;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CustomWorkflowOutput {
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    @Nonnull
    private String id;
    public static final String SERIALIZED_NAME_VERSION = "_version";
    @SerializedName(value="_version")
    @Nonnull
    private Integer version;
    public static final String SERIALIZED_NAME_CONFLICTS = "_conflicts";
    @SerializedName(value="_conflicts")
    @Nonnull
    private List<ConflictOutput> conflicts = new ArrayList<ConflictOutput>();
    public static final String SERIALIZED_NAME_CREATION_DATE = "_creationDate";
    @SerializedName(value="_creationDate")
    @Nonnull
    private Long creationDate;
    public static final String SERIALIZED_NAME_MAINTAINER_ID = "_maintainerId";
    @SerializedName(value="_maintainerId")
    @Nonnull
    private String maintainerId;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    @Nonnull
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    @Nullable
    private String description;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    @Nullable
    private String kind;
    public static final String SERIALIZED_NAME_STAGES = "stages";
    @SerializedName(value="stages")
    @Nullable
    private List<StageOutput> stages = new ArrayList<StageOutput>();
    public static final String SERIALIZED_NAME_EXECUTION = "_execution";
    @SerializedName(value="_execution")
    @Nonnull
    private ExecutionOutput execution;
    public static final String SERIALIZED_NAME_META = "meta";
    @SerializedName(value="meta")
    @Nullable
    private WorkflowTemplateMetadata meta;
    public static final String SERIALIZED_NAME_TEMPLATE_KEY = "templateKey";
    @SerializedName(value="templateKey")
    @Nullable
    private String templateKey;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("_id", "_version", "_conflicts", "_creationDate", "_maintainerId", "_links", "name", "description", "kind", "stages", "_execution", "meta", "templateKey"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("_id", "_version", "_conflicts", "_creationDate", "_maintainerId", "_links", "name", "_execution"));

    public CustomWorkflowOutput id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public CustomWorkflowOutput version(@Nonnull Integer version) {
        this.version = version;
        return this;
    }

    @Nonnull
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(@Nonnull Integer version) {
        this.version = version;
    }

    public CustomWorkflowOutput conflicts(@Nonnull List<ConflictOutput> conflicts) {
        this.conflicts = conflicts;
        return this;
    }

    public CustomWorkflowOutput addConflictsItem(ConflictOutput conflictsItem) {
        if (this.conflicts == null) {
            this.conflicts = new ArrayList<ConflictOutput>();
        }
        this.conflicts.add(conflictsItem);
        return this;
    }

    @Nonnull
    public List<ConflictOutput> getConflicts() {
        return this.conflicts;
    }

    public void setConflicts(@Nonnull List<ConflictOutput> conflicts) {
        this.conflicts = conflicts;
    }

    public CustomWorkflowOutput creationDate(@Nonnull Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nonnull
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(@Nonnull Long creationDate) {
        this.creationDate = creationDate;
    }

    public CustomWorkflowOutput maintainerId(@Nonnull String maintainerId) {
        this.maintainerId = maintainerId;
        return this;
    }

    @Nonnull
    public String getMaintainerId() {
        return this.maintainerId;
    }

    public void setMaintainerId(@Nonnull String maintainerId) {
        this.maintainerId = maintainerId;
    }

    public CustomWorkflowOutput links(@Nonnull Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public CustomWorkflowOutput putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(@Nonnull Map<String, Link> links) {
        this.links = links;
    }

    public CustomWorkflowOutput name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public CustomWorkflowOutput description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public CustomWorkflowOutput kind(@Nullable String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    public String getKind() {
        return this.kind;
    }

    public void setKind(@Nullable String kind) {
        this.kind = kind;
    }

    public CustomWorkflowOutput stages(@Nullable List<StageOutput> stages) {
        this.stages = stages;
        return this;
    }

    public CustomWorkflowOutput addStagesItem(StageOutput stagesItem) {
        if (this.stages == null) {
            this.stages = new ArrayList<StageOutput>();
        }
        this.stages.add(stagesItem);
        return this;
    }

    @Nullable
    public List<StageOutput> getStages() {
        return this.stages;
    }

    public void setStages(@Nullable List<StageOutput> stages) {
        this.stages = stages;
    }

    public CustomWorkflowOutput execution(@Nonnull ExecutionOutput execution) {
        this.execution = execution;
        return this;
    }

    @Nonnull
    public ExecutionOutput getExecution() {
        return this.execution;
    }

    public void setExecution(@Nonnull ExecutionOutput execution) {
        this.execution = execution;
    }

    public CustomWorkflowOutput meta(@Nullable WorkflowTemplateMetadata meta) {
        this.meta = meta;
        return this;
    }

    @Nullable
    public WorkflowTemplateMetadata getMeta() {
        return this.meta;
    }

    public void setMeta(@Nullable WorkflowTemplateMetadata meta) {
        this.meta = meta;
    }

    public CustomWorkflowOutput templateKey(@Nullable String templateKey) {
        this.templateKey = templateKey;
        return this;
    }

    @Nullable
    public String getTemplateKey() {
        return this.templateKey;
    }

    public void setTemplateKey(@Nullable String templateKey) {
        this.templateKey = templateKey;
    }

    public CustomWorkflowOutput putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomWorkflowOutput customWorkflowOutput = (CustomWorkflowOutput)o;
        return Objects.equals(this.id, customWorkflowOutput.id) && Objects.equals(this.version, customWorkflowOutput.version) && Objects.equals(this.conflicts, customWorkflowOutput.conflicts) && Objects.equals(this.creationDate, customWorkflowOutput.creationDate) && Objects.equals(this.maintainerId, customWorkflowOutput.maintainerId) && Objects.equals(this.links, customWorkflowOutput.links) && Objects.equals(this.name, customWorkflowOutput.name) && Objects.equals(this.description, customWorkflowOutput.description) && Objects.equals(this.kind, customWorkflowOutput.kind) && Objects.equals(this.stages, customWorkflowOutput.stages) && Objects.equals(this.execution, customWorkflowOutput.execution) && Objects.equals(this.meta, customWorkflowOutput.meta) && Objects.equals(this.templateKey, customWorkflowOutput.templateKey) && Objects.equals(this.additionalProperties, customWorkflowOutput.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.conflicts, this.creationDate, this.maintainerId, this.links, this.name, this.description, this.kind, this.stages, this.execution, this.meta, this.templateKey, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomWorkflowOutput {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    conflicts: ").append(this.toIndentedString(this.conflicts)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    maintainerId: ").append(this.toIndentedString(this.maintainerId)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    stages: ").append(this.toIndentedString(this.stages)).append("\n");
        sb.append("    execution: ").append(this.toIndentedString(this.execution)).append("\n");
        sb.append("    meta: ").append(this.toIndentedString(this.meta)).append("\n");
        sb.append("    templateKey: ").append(this.toIndentedString(this.templateKey)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraystages;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in CustomWorkflowOutput is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_CONFLICTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `_conflicts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONFLICTS).toString()));
        }
        JsonArray jsonArrayconflicts = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONFLICTS);
        for (int i = 0; i < jsonArrayconflicts.size(); ++i) {
            ConflictOutput.validateJsonElement(jsonArrayconflicts.get(i));
        }
        if (!jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `_maintainerId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STAGES) != null && !jsonObj.get(SERIALIZED_NAME_STAGES).isJsonNull() && (jsonArraystages = jsonObj.getAsJsonArray(SERIALIZED_NAME_STAGES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_STAGES).isJsonArray()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `stages` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STAGES).toString()));
            }
            for (int i = 0; i < jsonArraystages.size(); ++i) {
                StageOutput.validateJsonElement(jsonArraystages.get(i));
            }
        }
        ExecutionOutput.validateJsonElement(jsonObj.get(SERIALIZED_NAME_EXECUTION));
        if (jsonObj.get(SERIALIZED_NAME_META) != null && !jsonObj.get(SERIALIZED_NAME_META).isJsonNull()) {
            WorkflowTemplateMetadata.validateJsonElement(jsonObj.get(SERIALIZED_NAME_META));
        }
        if (jsonObj.get(SERIALIZED_NAME_TEMPLATE_KEY) != null && !jsonObj.get(SERIALIZED_NAME_TEMPLATE_KEY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TEMPLATE_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `templateKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TEMPLATE_KEY).toString()));
        }
    }

    public static CustomWorkflowOutput fromJson(String jsonString) throws IOException {
        return (CustomWorkflowOutput)JSON.getGson().fromJson(jsonString, CustomWorkflowOutput.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!CustomWorkflowOutput.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CustomWorkflowOutput.class));
            return new TypeAdapter<CustomWorkflowOutput>(){

                public void write(JsonWriter out, CustomWorkflowOutput value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public CustomWorkflowOutput read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CustomWorkflowOutput.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    CustomWorkflowOutput instance = (CustomWorkflowOutput)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

