/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Access;
import com.launchdarkly.api.model.ApprovalSettings;
import com.launchdarkly.api.model.Link;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Environment {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    @Nonnull
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    @Nonnull
    private String id;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    @Nonnull
    private String key;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_API_KEY = "apiKey";
    @SerializedName(value="apiKey")
    @Nonnull
    private String apiKey;
    public static final String SERIALIZED_NAME_MOBILE_KEY = "mobileKey";
    @SerializedName(value="mobileKey")
    @Nonnull
    private String mobileKey;
    public static final String SERIALIZED_NAME_COLOR = "color";
    @SerializedName(value="color")
    @Nonnull
    private String color;
    public static final String SERIALIZED_NAME_DEFAULT_TTL = "defaultTtl";
    @SerializedName(value="defaultTtl")
    @Nonnull
    private Integer defaultTtl;
    public static final String SERIALIZED_NAME_SECURE_MODE = "secureMode";
    @SerializedName(value="secureMode")
    @Nonnull
    private Boolean secureMode;
    public static final String SERIALIZED_NAME_ACCESS = "_access";
    @SerializedName(value="_access")
    @Nullable
    private Access access;
    public static final String SERIALIZED_NAME_DEFAULT_TRACK_EVENTS = "defaultTrackEvents";
    @SerializedName(value="defaultTrackEvents")
    @Nonnull
    private Boolean defaultTrackEvents;
    public static final String SERIALIZED_NAME_REQUIRE_COMMENTS = "requireComments";
    @SerializedName(value="requireComments")
    @Nonnull
    private Boolean requireComments;
    public static final String SERIALIZED_NAME_CONFIRM_CHANGES = "confirmChanges";
    @SerializedName(value="confirmChanges")
    @Nonnull
    private Boolean confirmChanges;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    @Nonnull
    private List<String> tags = new ArrayList<String>();
    public static final String SERIALIZED_NAME_APPROVAL_SETTINGS = "approvalSettings";
    @SerializedName(value="approvalSettings")
    @Nullable
    private ApprovalSettings approvalSettings;
    public static final String SERIALIZED_NAME_RESOURCE_APPROVAL_SETTINGS = "resourceApprovalSettings";
    @SerializedName(value="resourceApprovalSettings")
    @Nullable
    private Map<String, ApprovalSettings> resourceApprovalSettings = new HashMap<String, ApprovalSettings>();
    public static final String SERIALIZED_NAME_CRITICAL = "critical";
    @SerializedName(value="critical")
    @Nonnull
    private Boolean critical;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("_links", "_id", "key", "name", "apiKey", "mobileKey", "color", "defaultTtl", "secureMode", "_access", "defaultTrackEvents", "requireComments", "confirmChanges", "tags", "approvalSettings", "resourceApprovalSettings", "critical"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("_links", "_id", "key", "name", "apiKey", "mobileKey", "color", "defaultTtl", "secureMode", "defaultTrackEvents", "requireComments", "confirmChanges", "tags", "critical"));

    public Environment links(@Nonnull Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public Environment putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(@Nonnull Map<String, Link> links) {
        this.links = links;
    }

    public Environment id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public Environment key(@Nonnull String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    public void setKey(@Nonnull String key) {
        this.key = key;
    }

    public Environment name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public Environment apiKey(@Nonnull String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @Nonnull
    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(@Nonnull String apiKey) {
        this.apiKey = apiKey;
    }

    public Environment mobileKey(@Nonnull String mobileKey) {
        this.mobileKey = mobileKey;
        return this;
    }

    @Nonnull
    public String getMobileKey() {
        return this.mobileKey;
    }

    public void setMobileKey(@Nonnull String mobileKey) {
        this.mobileKey = mobileKey;
    }

    public Environment color(@Nonnull String color) {
        this.color = color;
        return this;
    }

    @Nonnull
    public String getColor() {
        return this.color;
    }

    public void setColor(@Nonnull String color) {
        this.color = color;
    }

    public Environment defaultTtl(@Nonnull Integer defaultTtl) {
        this.defaultTtl = defaultTtl;
        return this;
    }

    @Nonnull
    public Integer getDefaultTtl() {
        return this.defaultTtl;
    }

    public void setDefaultTtl(@Nonnull Integer defaultTtl) {
        this.defaultTtl = defaultTtl;
    }

    public Environment secureMode(@Nonnull Boolean secureMode) {
        this.secureMode = secureMode;
        return this;
    }

    @Nonnull
    public Boolean getSecureMode() {
        return this.secureMode;
    }

    public void setSecureMode(@Nonnull Boolean secureMode) {
        this.secureMode = secureMode;
    }

    public Environment access(@Nullable Access access) {
        this.access = access;
        return this;
    }

    @Nullable
    public Access getAccess() {
        return this.access;
    }

    public void setAccess(@Nullable Access access) {
        this.access = access;
    }

    public Environment defaultTrackEvents(@Nonnull Boolean defaultTrackEvents) {
        this.defaultTrackEvents = defaultTrackEvents;
        return this;
    }

    @Nonnull
    public Boolean getDefaultTrackEvents() {
        return this.defaultTrackEvents;
    }

    public void setDefaultTrackEvents(@Nonnull Boolean defaultTrackEvents) {
        this.defaultTrackEvents = defaultTrackEvents;
    }

    public Environment requireComments(@Nonnull Boolean requireComments) {
        this.requireComments = requireComments;
        return this;
    }

    @Nonnull
    public Boolean getRequireComments() {
        return this.requireComments;
    }

    public void setRequireComments(@Nonnull Boolean requireComments) {
        this.requireComments = requireComments;
    }

    public Environment confirmChanges(@Nonnull Boolean confirmChanges) {
        this.confirmChanges = confirmChanges;
        return this;
    }

    @Nonnull
    public Boolean getConfirmChanges() {
        return this.confirmChanges;
    }

    public void setConfirmChanges(@Nonnull Boolean confirmChanges) {
        this.confirmChanges = confirmChanges;
    }

    public Environment tags(@Nonnull List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Environment addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nonnull
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(@Nonnull List<String> tags) {
        this.tags = tags;
    }

    public Environment approvalSettings(@Nullable ApprovalSettings approvalSettings) {
        this.approvalSettings = approvalSettings;
        return this;
    }

    @Nullable
    public ApprovalSettings getApprovalSettings() {
        return this.approvalSettings;
    }

    public void setApprovalSettings(@Nullable ApprovalSettings approvalSettings) {
        this.approvalSettings = approvalSettings;
    }

    public Environment resourceApprovalSettings(@Nullable Map<String, ApprovalSettings> resourceApprovalSettings) {
        this.resourceApprovalSettings = resourceApprovalSettings;
        return this;
    }

    public Environment putResourceApprovalSettingsItem(String key, ApprovalSettings resourceApprovalSettingsItem) {
        if (this.resourceApprovalSettings == null) {
            this.resourceApprovalSettings = new HashMap<String, ApprovalSettings>();
        }
        this.resourceApprovalSettings.put(key, resourceApprovalSettingsItem);
        return this;
    }

    @Nullable
    public Map<String, ApprovalSettings> getResourceApprovalSettings() {
        return this.resourceApprovalSettings;
    }

    public void setResourceApprovalSettings(@Nullable Map<String, ApprovalSettings> resourceApprovalSettings) {
        this.resourceApprovalSettings = resourceApprovalSettings;
    }

    public Environment critical(@Nonnull Boolean critical) {
        this.critical = critical;
        return this;
    }

    @Nonnull
    public Boolean getCritical() {
        return this.critical;
    }

    public void setCritical(@Nonnull Boolean critical) {
        this.critical = critical;
    }

    public Environment putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Environment environment = (Environment)o;
        return Objects.equals(this.links, environment.links) && Objects.equals(this.id, environment.id) && Objects.equals(this.key, environment.key) && Objects.equals(this.name, environment.name) && Objects.equals(this.apiKey, environment.apiKey) && Objects.equals(this.mobileKey, environment.mobileKey) && Objects.equals(this.color, environment.color) && Objects.equals(this.defaultTtl, environment.defaultTtl) && Objects.equals(this.secureMode, environment.secureMode) && Objects.equals(this.access, environment.access) && Objects.equals(this.defaultTrackEvents, environment.defaultTrackEvents) && Objects.equals(this.requireComments, environment.requireComments) && Objects.equals(this.confirmChanges, environment.confirmChanges) && Objects.equals(this.tags, environment.tags) && Objects.equals(this.approvalSettings, environment.approvalSettings) && Objects.equals(this.resourceApprovalSettings, environment.resourceApprovalSettings) && Objects.equals(this.critical, environment.critical) && Objects.equals(this.additionalProperties, environment.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.id, this.key, this.name, this.apiKey, this.mobileKey, this.color, this.defaultTtl, this.secureMode, this.access, this.defaultTrackEvents, this.requireComments, this.confirmChanges, this.tags, this.approvalSettings, this.resourceApprovalSettings, this.critical, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Environment {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    mobileKey: ").append(this.toIndentedString(this.mobileKey)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    defaultTtl: ").append(this.toIndentedString(this.defaultTtl)).append("\n");
        sb.append("    secureMode: ").append(this.toIndentedString(this.secureMode)).append("\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    defaultTrackEvents: ").append(this.toIndentedString(this.defaultTrackEvents)).append("\n");
        sb.append("    requireComments: ").append(this.toIndentedString(this.requireComments)).append("\n");
        sb.append("    confirmChanges: ").append(this.toIndentedString(this.confirmChanges)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    approvalSettings: ").append(this.toIndentedString(this.approvalSettings)).append("\n");
        sb.append("    resourceApprovalSettings: ").append(this.toIndentedString(this.resourceApprovalSettings)).append("\n");
        sb.append("    critical: ").append(this.toIndentedString(this.critical)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in Environment is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_API_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `apiKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_KEY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_MOBILE_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `mobileKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MOBILE_KEY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_COLOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `color` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COLOR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESS) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS).isJsonNull()) {
            Access.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ACCESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_APPROVAL_SETTINGS) != null && !jsonObj.get(SERIALIZED_NAME_APPROVAL_SETTINGS).isJsonNull()) {
            ApprovalSettings.validateJsonElement(jsonObj.get(SERIALIZED_NAME_APPROVAL_SETTINGS));
        }
    }

    public static Environment fromJson(String jsonString) throws IOException {
        return (Environment)JSON.getGson().fromJson(jsonString, Environment.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Environment.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Environment.class));
            return new TypeAdapter<Environment>(){

                public void write(JsonWriter out, Environment value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public Environment read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Environment.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    Environment instance = (Environment)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

