/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FailedResourceLink {
    public static final String SERIALIZED_NAME_RESOURCE_KEY = "resourceKey";
    @SerializedName(value="resourceKey")
    @Nonnull
    private String resourceKey;
    public static final String SERIALIZED_NAME_ENVIRONMENT_ID = "environmentId";
    @SerializedName(value="environmentId")
    @Nullable
    private String environmentId;
    public static final String SERIALIZED_NAME_RESOURCE_TYPE = "resourceType";
    @SerializedName(value="resourceType")
    @Nonnull
    private ResourceTypeEnum resourceType;
    public static final String SERIALIZED_NAME_ERROR_MESSAGE = "errorMessage";
    @SerializedName(value="errorMessage")
    @Nonnull
    private String errorMessage;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("resourceKey", "environmentId", "resourceType", "errorMessage"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("resourceKey", "resourceType", "errorMessage"));

    public FailedResourceLink resourceKey(@Nonnull String resourceKey) {
        this.resourceKey = resourceKey;
        return this;
    }

    @Nonnull
    public String getResourceKey() {
        return this.resourceKey;
    }

    public void setResourceKey(@Nonnull String resourceKey) {
        this.resourceKey = resourceKey;
    }

    public FailedResourceLink environmentId(@Nullable String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    @Nullable
    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(@Nullable String environmentId) {
        this.environmentId = environmentId;
    }

    public FailedResourceLink resourceType(@Nonnull ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Nonnull
    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(@Nonnull ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public FailedResourceLink errorMessage(@Nonnull String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Nonnull
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(@Nonnull String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public FailedResourceLink putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FailedResourceLink failedResourceLink = (FailedResourceLink)o;
        return Objects.equals(this.resourceKey, failedResourceLink.resourceKey) && Objects.equals(this.environmentId, failedResourceLink.environmentId) && Objects.equals((Object)this.resourceType, (Object)failedResourceLink.resourceType) && Objects.equals(this.errorMessage, failedResourceLink.errorMessage) && Objects.equals(this.additionalProperties, failedResourceLink.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resourceKey, this.environmentId, this.resourceType, this.errorMessage, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FailedResourceLink {\n");
        sb.append("    resourceKey: ").append(this.toIndentedString(this.resourceKey)).append("\n");
        sb.append("    environmentId: ").append(this.toIndentedString(this.environmentId)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString((Object)this.resourceType)).append("\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in FailedResourceLink is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_RESOURCE_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `resourceKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `environmentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `resourceType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE).toString()));
        }
        ResourceTypeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE));
        if (!jsonObj.get(SERIALIZED_NAME_ERROR_MESSAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `errorMessage` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ERROR_MESSAGE).toString()));
        }
    }

    public static FailedResourceLink fromJson(String jsonString) throws IOException {
        return (FailedResourceLink)JSON.getGson().fromJson(jsonString, FailedResourceLink.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!FailedResourceLink.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FailedResourceLink.class));
            return new TypeAdapter<FailedResourceLink>(){

                public void write(JsonWriter out, FailedResourceLink value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public FailedResourceLink read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    FailedResourceLink.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    FailedResourceLink instance = (FailedResourceLink)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ResourceTypeEnum {
        FLAG("flag"),
        SEGMENT("segment"),
        METRIC("metric"),
        AI_CONFIG("aiConfig");

        private String value;

        private ResourceTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResourceTypeEnum fromValue(String value) {
            for (ResourceTypeEnum b : ResourceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            ResourceTypeEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<ResourceTypeEnum> {
            public void write(JsonWriter jsonWriter, ResourceTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ResourceTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ResourceTypeEnum.fromValue(value);
            }
        }
    }
}

