/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.ClientSideAvailabilityPost;
import com.launchdarkly.api.model.CustomProperty;
import com.launchdarkly.api.model.Defaults;
import com.launchdarkly.api.model.FlagPrerequisitePost;
import com.launchdarkly.api.model.MigrationSettingsPost;
import com.launchdarkly.api.model.Variation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FeatureFlagBody {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    @Nonnull
    private String key;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    @Nullable
    private String description;
    public static final String SERIALIZED_NAME_INCLUDE_IN_SNIPPET = "includeInSnippet";
    @Deprecated
    @SerializedName(value="includeInSnippet")
    @Nullable
    private Boolean includeInSnippet;
    public static final String SERIALIZED_NAME_CLIENT_SIDE_AVAILABILITY = "clientSideAvailability";
    @SerializedName(value="clientSideAvailability")
    @Nullable
    private ClientSideAvailabilityPost clientSideAvailability;
    public static final String SERIALIZED_NAME_VARIATIONS = "variations";
    @SerializedName(value="variations")
    @Nullable
    private List<Variation> variations = new ArrayList<Variation>();
    public static final String SERIALIZED_NAME_TEMPORARY = "temporary";
    @SerializedName(value="temporary")
    @Nullable
    private Boolean temporary;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    @Nullable
    private List<String> tags = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CUSTOM_PROPERTIES = "customProperties";
    @SerializedName(value="customProperties")
    @Nullable
    private Map<String, CustomProperty> customProperties = new HashMap<String, CustomProperty>();
    public static final String SERIALIZED_NAME_DEFAULTS = "defaults";
    @SerializedName(value="defaults")
    @Nullable
    private Defaults defaults;
    public static final String SERIALIZED_NAME_PURPOSE = "purpose";
    @SerializedName(value="purpose")
    @Nullable
    private PurposeEnum purpose;
    public static final String SERIALIZED_NAME_MIGRATION_SETTINGS = "migrationSettings";
    @SerializedName(value="migrationSettings")
    @Nullable
    private MigrationSettingsPost migrationSettings;
    public static final String SERIALIZED_NAME_MAINTAINER_ID = "maintainerId";
    @SerializedName(value="maintainerId")
    @Nullable
    private String maintainerId;
    public static final String SERIALIZED_NAME_MAINTAINER_TEAM_KEY = "maintainerTeamKey";
    @SerializedName(value="maintainerTeamKey")
    @Nullable
    private String maintainerTeamKey;
    public static final String SERIALIZED_NAME_INITIAL_PREREQUISITES = "initialPrerequisites";
    @SerializedName(value="initialPrerequisites")
    @Nullable
    private List<FlagPrerequisitePost> initialPrerequisites = new ArrayList<FlagPrerequisitePost>();
    public static final String SERIALIZED_NAME_IS_FLAG_ON = "isFlagOn";
    @SerializedName(value="isFlagOn")
    @Nullable
    private Boolean isFlagOn;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("name", "key", "description", "includeInSnippet", "clientSideAvailability", "variations", "temporary", "tags", "customProperties", "defaults", "purpose", "migrationSettings", "maintainerId", "maintainerTeamKey", "initialPrerequisites", "isFlagOn"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("name", "key"));

    public FeatureFlagBody name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public FeatureFlagBody key(@Nonnull String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    public void setKey(@Nonnull String key) {
        this.key = key;
    }

    public FeatureFlagBody description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @Deprecated
    public FeatureFlagBody includeInSnippet(@Nullable Boolean includeInSnippet) {
        this.includeInSnippet = includeInSnippet;
        return this;
    }

    @Deprecated
    @Nullable
    public Boolean getIncludeInSnippet() {
        return this.includeInSnippet;
    }

    @Deprecated
    public void setIncludeInSnippet(@Nullable Boolean includeInSnippet) {
        this.includeInSnippet = includeInSnippet;
    }

    public FeatureFlagBody clientSideAvailability(@Nullable ClientSideAvailabilityPost clientSideAvailability) {
        this.clientSideAvailability = clientSideAvailability;
        return this;
    }

    @Nullable
    public ClientSideAvailabilityPost getClientSideAvailability() {
        return this.clientSideAvailability;
    }

    public void setClientSideAvailability(@Nullable ClientSideAvailabilityPost clientSideAvailability) {
        this.clientSideAvailability = clientSideAvailability;
    }

    public FeatureFlagBody variations(@Nullable List<Variation> variations) {
        this.variations = variations;
        return this;
    }

    public FeatureFlagBody addVariationsItem(Variation variationsItem) {
        if (this.variations == null) {
            this.variations = new ArrayList<Variation>();
        }
        this.variations.add(variationsItem);
        return this;
    }

    @Nullable
    public List<Variation> getVariations() {
        return this.variations;
    }

    public void setVariations(@Nullable List<Variation> variations) {
        this.variations = variations;
    }

    public FeatureFlagBody temporary(@Nullable Boolean temporary) {
        this.temporary = temporary;
        return this;
    }

    @Nullable
    public Boolean getTemporary() {
        return this.temporary;
    }

    public void setTemporary(@Nullable Boolean temporary) {
        this.temporary = temporary;
    }

    public FeatureFlagBody tags(@Nullable List<String> tags) {
        this.tags = tags;
        return this;
    }

    public FeatureFlagBody addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nullable
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(@Nullable List<String> tags) {
        this.tags = tags;
    }

    public FeatureFlagBody customProperties(@Nullable Map<String, CustomProperty> customProperties) {
        this.customProperties = customProperties;
        return this;
    }

    public FeatureFlagBody putCustomPropertiesItem(String key, CustomProperty customPropertiesItem) {
        if (this.customProperties == null) {
            this.customProperties = new HashMap<String, CustomProperty>();
        }
        this.customProperties.put(key, customPropertiesItem);
        return this;
    }

    @Nullable
    public Map<String, CustomProperty> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(@Nullable Map<String, CustomProperty> customProperties) {
        this.customProperties = customProperties;
    }

    public FeatureFlagBody defaults(@Nullable Defaults defaults) {
        this.defaults = defaults;
        return this;
    }

    @Nullable
    public Defaults getDefaults() {
        return this.defaults;
    }

    public void setDefaults(@Nullable Defaults defaults) {
        this.defaults = defaults;
    }

    public FeatureFlagBody purpose(@Nullable PurposeEnum purpose) {
        this.purpose = purpose;
        return this;
    }

    @Nullable
    public PurposeEnum getPurpose() {
        return this.purpose;
    }

    public void setPurpose(@Nullable PurposeEnum purpose) {
        this.purpose = purpose;
    }

    public FeatureFlagBody migrationSettings(@Nullable MigrationSettingsPost migrationSettings) {
        this.migrationSettings = migrationSettings;
        return this;
    }

    @Nullable
    public MigrationSettingsPost getMigrationSettings() {
        return this.migrationSettings;
    }

    public void setMigrationSettings(@Nullable MigrationSettingsPost migrationSettings) {
        this.migrationSettings = migrationSettings;
    }

    public FeatureFlagBody maintainerId(@Nullable String maintainerId) {
        this.maintainerId = maintainerId;
        return this;
    }

    @Nullable
    public String getMaintainerId() {
        return this.maintainerId;
    }

    public void setMaintainerId(@Nullable String maintainerId) {
        this.maintainerId = maintainerId;
    }

    public FeatureFlagBody maintainerTeamKey(@Nullable String maintainerTeamKey) {
        this.maintainerTeamKey = maintainerTeamKey;
        return this;
    }

    @Nullable
    public String getMaintainerTeamKey() {
        return this.maintainerTeamKey;
    }

    public void setMaintainerTeamKey(@Nullable String maintainerTeamKey) {
        this.maintainerTeamKey = maintainerTeamKey;
    }

    public FeatureFlagBody initialPrerequisites(@Nullable List<FlagPrerequisitePost> initialPrerequisites) {
        this.initialPrerequisites = initialPrerequisites;
        return this;
    }

    public FeatureFlagBody addInitialPrerequisitesItem(FlagPrerequisitePost initialPrerequisitesItem) {
        if (this.initialPrerequisites == null) {
            this.initialPrerequisites = new ArrayList<FlagPrerequisitePost>();
        }
        this.initialPrerequisites.add(initialPrerequisitesItem);
        return this;
    }

    @Nullable
    public List<FlagPrerequisitePost> getInitialPrerequisites() {
        return this.initialPrerequisites;
    }

    public void setInitialPrerequisites(@Nullable List<FlagPrerequisitePost> initialPrerequisites) {
        this.initialPrerequisites = initialPrerequisites;
    }

    public FeatureFlagBody isFlagOn(@Nullable Boolean isFlagOn) {
        this.isFlagOn = isFlagOn;
        return this;
    }

    @Nullable
    public Boolean getIsFlagOn() {
        return this.isFlagOn;
    }

    public void setIsFlagOn(@Nullable Boolean isFlagOn) {
        this.isFlagOn = isFlagOn;
    }

    public FeatureFlagBody putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureFlagBody featureFlagBody = (FeatureFlagBody)o;
        return Objects.equals(this.name, featureFlagBody.name) && Objects.equals(this.key, featureFlagBody.key) && Objects.equals(this.description, featureFlagBody.description) && Objects.equals(this.includeInSnippet, featureFlagBody.includeInSnippet) && Objects.equals(this.clientSideAvailability, featureFlagBody.clientSideAvailability) && Objects.equals(this.variations, featureFlagBody.variations) && Objects.equals(this.temporary, featureFlagBody.temporary) && Objects.equals(this.tags, featureFlagBody.tags) && Objects.equals(this.customProperties, featureFlagBody.customProperties) && Objects.equals(this.defaults, featureFlagBody.defaults) && Objects.equals((Object)this.purpose, (Object)featureFlagBody.purpose) && Objects.equals(this.migrationSettings, featureFlagBody.migrationSettings) && Objects.equals(this.maintainerId, featureFlagBody.maintainerId) && Objects.equals(this.maintainerTeamKey, featureFlagBody.maintainerTeamKey) && Objects.equals(this.initialPrerequisites, featureFlagBody.initialPrerequisites) && Objects.equals(this.isFlagOn, featureFlagBody.isFlagOn) && Objects.equals(this.additionalProperties, featureFlagBody.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.key, this.description, this.includeInSnippet, this.clientSideAvailability, this.variations, this.temporary, this.tags, this.customProperties, this.defaults, this.purpose, this.migrationSettings, this.maintainerId, this.maintainerTeamKey, this.initialPrerequisites, this.isFlagOn, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureFlagBody {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    includeInSnippet: ").append(this.toIndentedString(this.includeInSnippet)).append("\n");
        sb.append("    clientSideAvailability: ").append(this.toIndentedString(this.clientSideAvailability)).append("\n");
        sb.append("    variations: ").append(this.toIndentedString(this.variations)).append("\n");
        sb.append("    temporary: ").append(this.toIndentedString(this.temporary)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    customProperties: ").append(this.toIndentedString(this.customProperties)).append("\n");
        sb.append("    defaults: ").append(this.toIndentedString(this.defaults)).append("\n");
        sb.append("    purpose: ").append(this.toIndentedString((Object)this.purpose)).append("\n");
        sb.append("    migrationSettings: ").append(this.toIndentedString(this.migrationSettings)).append("\n");
        sb.append("    maintainerId: ").append(this.toIndentedString(this.maintainerId)).append("\n");
        sb.append("    maintainerTeamKey: ").append(this.toIndentedString(this.maintainerTeamKey)).append("\n");
        sb.append("    initialPrerequisites: ").append(this.toIndentedString(this.initialPrerequisites)).append("\n");
        sb.append("    isFlagOn: ").append(this.toIndentedString(this.isFlagOn)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayinitialPrerequisites;
        int i;
        JsonArray jsonArrayvariations;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in FeatureFlagBody is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CLIENT_SIDE_AVAILABILITY) != null && !jsonObj.get(SERIALIZED_NAME_CLIENT_SIDE_AVAILABILITY).isJsonNull()) {
            ClientSideAvailabilityPost.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CLIENT_SIDE_AVAILABILITY));
        }
        if (jsonObj.get(SERIALIZED_NAME_VARIATIONS) != null && !jsonObj.get(SERIALIZED_NAME_VARIATIONS).isJsonNull() && (jsonArrayvariations = jsonObj.getAsJsonArray(SERIALIZED_NAME_VARIATIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VARIATIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `variations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VARIATIONS).toString()));
            }
            for (i = 0; i < jsonArrayvariations.size(); ++i) {
                Variation.validateJsonElement(jsonArrayvariations.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) != null && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEFAULTS) != null && !jsonObj.get(SERIALIZED_NAME_DEFAULTS).isJsonNull()) {
            Defaults.validateJsonElement(jsonObj.get(SERIALIZED_NAME_DEFAULTS));
        }
        if (jsonObj.get(SERIALIZED_NAME_PURPOSE) != null && !jsonObj.get(SERIALIZED_NAME_PURPOSE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PURPOSE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `purpose` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PURPOSE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PURPOSE) != null && !jsonObj.get(SERIALIZED_NAME_PURPOSE).isJsonNull()) {
            PurposeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PURPOSE));
        }
        if (jsonObj.get(SERIALIZED_NAME_MIGRATION_SETTINGS) != null && !jsonObj.get(SERIALIZED_NAME_MIGRATION_SETTINGS).isJsonNull()) {
            MigrationSettingsPost.validateJsonElement(jsonObj.get(SERIALIZED_NAME_MIGRATION_SETTINGS));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID) != null && !jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `maintainerId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAINTAINER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAINTAINER_TEAM_KEY) != null && !jsonObj.get(SERIALIZED_NAME_MAINTAINER_TEAM_KEY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_MAINTAINER_TEAM_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `maintainerTeamKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MAINTAINER_TEAM_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INITIAL_PREREQUISITES) != null && !jsonObj.get(SERIALIZED_NAME_INITIAL_PREREQUISITES).isJsonNull() && (jsonArrayinitialPrerequisites = jsonObj.getAsJsonArray(SERIALIZED_NAME_INITIAL_PREREQUISITES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_INITIAL_PREREQUISITES).isJsonArray()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `initialPrerequisites` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INITIAL_PREREQUISITES).toString()));
            }
            for (i = 0; i < jsonArrayinitialPrerequisites.size(); ++i) {
                FlagPrerequisitePost.validateJsonElement(jsonArrayinitialPrerequisites.get(i));
            }
        }
    }

    public static FeatureFlagBody fromJson(String jsonString) throws IOException {
        return (FeatureFlagBody)JSON.getGson().fromJson(jsonString, FeatureFlagBody.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!FeatureFlagBody.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FeatureFlagBody.class));
            return new TypeAdapter<FeatureFlagBody>(){

                public void write(JsonWriter out, FeatureFlagBody value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public FeatureFlagBody read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    FeatureFlagBody.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    FeatureFlagBody instance = (FeatureFlagBody)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PurposeEnum {
        MIGRATION("migration"),
        HOLDOUT("holdout");

        private String value;

        private PurposeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PurposeEnum fromValue(String value) {
            for (PurposeEnum b : PurposeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            PurposeEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<PurposeEnum> {
            public void write(JsonWriter jsonWriter, PurposeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PurposeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PurposeEnum.fromValue(value);
            }
        }
    }
}

