/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Access;
import com.launchdarkly.api.model.IntegrationDeliveryConfigurationLinks;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IntegrationDeliveryConfiguration {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    @Nonnull
    private IntegrationDeliveryConfigurationLinks links;
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    @Nonnull
    private String id;
    public static final String SERIALIZED_NAME_INTEGRATION_KEY = "integrationKey";
    @SerializedName(value="integrationKey")
    @Nonnull
    private String integrationKey;
    public static final String SERIALIZED_NAME_PROJECT_KEY = "projectKey";
    @SerializedName(value="projectKey")
    @Nonnull
    private String projectKey;
    public static final String SERIALIZED_NAME_ENVIRONMENT_KEY = "environmentKey";
    @SerializedName(value="environmentKey")
    @Nonnull
    private String environmentKey;
    public static final String SERIALIZED_NAME_CONFIG = "config";
    @SerializedName(value="config")
    @Nonnull
    private Map<String, Object> config = new HashMap<String, Object>();
    public static final String SERIALIZED_NAME_ON = "on";
    @SerializedName(value="on")
    @Nonnull
    private Boolean on;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    @Nonnull
    private List<String> tags = new ArrayList<String>();
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    @Nonnull
    private Integer version;
    public static final String SERIALIZED_NAME_ACCESS = "_access";
    @SerializedName(value="_access")
    @Nullable
    private Access access;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("_links", "_id", "integrationKey", "projectKey", "environmentKey", "config", "on", "tags", "name", "version", "_access"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("_links", "_id", "integrationKey", "projectKey", "environmentKey", "config", "on", "tags", "name", "version"));

    public IntegrationDeliveryConfiguration links(@Nonnull IntegrationDeliveryConfigurationLinks links) {
        this.links = links;
        return this;
    }

    @Nonnull
    public IntegrationDeliveryConfigurationLinks getLinks() {
        return this.links;
    }

    public void setLinks(@Nonnull IntegrationDeliveryConfigurationLinks links) {
        this.links = links;
    }

    public IntegrationDeliveryConfiguration id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public IntegrationDeliveryConfiguration integrationKey(@Nonnull String integrationKey) {
        this.integrationKey = integrationKey;
        return this;
    }

    @Nonnull
    public String getIntegrationKey() {
        return this.integrationKey;
    }

    public void setIntegrationKey(@Nonnull String integrationKey) {
        this.integrationKey = integrationKey;
    }

    public IntegrationDeliveryConfiguration projectKey(@Nonnull String projectKey) {
        this.projectKey = projectKey;
        return this;
    }

    @Nonnull
    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(@Nonnull String projectKey) {
        this.projectKey = projectKey;
    }

    public IntegrationDeliveryConfiguration environmentKey(@Nonnull String environmentKey) {
        this.environmentKey = environmentKey;
        return this;
    }

    @Nonnull
    public String getEnvironmentKey() {
        return this.environmentKey;
    }

    public void setEnvironmentKey(@Nonnull String environmentKey) {
        this.environmentKey = environmentKey;
    }

    public IntegrationDeliveryConfiguration config(@Nonnull Map<String, Object> config) {
        this.config = config;
        return this;
    }

    public IntegrationDeliveryConfiguration putConfigItem(String key, Object configItem) {
        if (this.config == null) {
            this.config = new HashMap<String, Object>();
        }
        this.config.put(key, configItem);
        return this;
    }

    @Nonnull
    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(@Nonnull Map<String, Object> config) {
        this.config = config;
    }

    public IntegrationDeliveryConfiguration on(@Nonnull Boolean on) {
        this.on = on;
        return this;
    }

    @Nonnull
    public Boolean getOn() {
        return this.on;
    }

    public void setOn(@Nonnull Boolean on) {
        this.on = on;
    }

    public IntegrationDeliveryConfiguration tags(@Nonnull List<String> tags) {
        this.tags = tags;
        return this;
    }

    public IntegrationDeliveryConfiguration addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nonnull
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(@Nonnull List<String> tags) {
        this.tags = tags;
    }

    public IntegrationDeliveryConfiguration name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public IntegrationDeliveryConfiguration version(@Nonnull Integer version) {
        this.version = version;
        return this;
    }

    @Nonnull
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(@Nonnull Integer version) {
        this.version = version;
    }

    public IntegrationDeliveryConfiguration access(@Nullable Access access) {
        this.access = access;
        return this;
    }

    @Nullable
    public Access getAccess() {
        return this.access;
    }

    public void setAccess(@Nullable Access access) {
        this.access = access;
    }

    public IntegrationDeliveryConfiguration putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegrationDeliveryConfiguration integrationDeliveryConfiguration = (IntegrationDeliveryConfiguration)o;
        return Objects.equals(this.links, integrationDeliveryConfiguration.links) && Objects.equals(this.id, integrationDeliveryConfiguration.id) && Objects.equals(this.integrationKey, integrationDeliveryConfiguration.integrationKey) && Objects.equals(this.projectKey, integrationDeliveryConfiguration.projectKey) && Objects.equals(this.environmentKey, integrationDeliveryConfiguration.environmentKey) && Objects.equals(this.config, integrationDeliveryConfiguration.config) && Objects.equals(this.on, integrationDeliveryConfiguration.on) && Objects.equals(this.tags, integrationDeliveryConfiguration.tags) && Objects.equals(this.name, integrationDeliveryConfiguration.name) && Objects.equals(this.version, integrationDeliveryConfiguration.version) && Objects.equals(this.access, integrationDeliveryConfiguration.access) && Objects.equals(this.additionalProperties, integrationDeliveryConfiguration.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.id, this.integrationKey, this.projectKey, this.environmentKey, this.config, this.on, this.tags, this.name, this.version, this.access, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IntegrationDeliveryConfiguration {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    integrationKey: ").append(this.toIndentedString(this.integrationKey)).append("\n");
        sb.append("    projectKey: ").append(this.toIndentedString(this.projectKey)).append("\n");
        sb.append("    environmentKey: ").append(this.toIndentedString(this.environmentKey)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    on: ").append(this.toIndentedString(this.on)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in IntegrationDeliveryConfiguration is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        IntegrationDeliveryConfigurationLinks.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LINKS));
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_INTEGRATION_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `integrationKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INTEGRATION_KEY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_PROJECT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `projectKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROJECT_KEY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `environmentKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESS) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS).isJsonNull()) {
            Access.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ACCESS));
        }
    }

    public static IntegrationDeliveryConfiguration fromJson(String jsonString) throws IOException {
        return (IntegrationDeliveryConfiguration)JSON.getGson().fromJson(jsonString, IntegrationDeliveryConfiguration.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!IntegrationDeliveryConfiguration.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(IntegrationDeliveryConfiguration.class));
            return new TypeAdapter<IntegrationDeliveryConfiguration>(){

                public void write(JsonWriter out, IntegrationDeliveryConfiguration value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public IntegrationDeliveryConfiguration read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    IntegrationDeliveryConfiguration.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    IntegrationDeliveryConfiguration instance = (IntegrationDeliveryConfiguration)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

