/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.FlagInput;
import com.launchdarkly.api.model.MetricInput;
import com.launchdarkly.api.model.TreatmentInput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IterationInput {
    public static final String SERIALIZED_NAME_HYPOTHESIS = "hypothesis";
    @SerializedName(value="hypothesis")
    @Nonnull
    private String hypothesis;
    public static final String SERIALIZED_NAME_CAN_RESHUFFLE_TRAFFIC = "canReshuffleTraffic";
    @SerializedName(value="canReshuffleTraffic")
    @Nullable
    private Boolean canReshuffleTraffic;
    public static final String SERIALIZED_NAME_METRICS = "metrics";
    @SerializedName(value="metrics")
    @Nonnull
    private List<MetricInput> metrics = new ArrayList<MetricInput>();
    public static final String SERIALIZED_NAME_PRIMARY_SINGLE_METRIC_KEY = "primarySingleMetricKey";
    @SerializedName(value="primarySingleMetricKey")
    @Nullable
    private String primarySingleMetricKey;
    public static final String SERIALIZED_NAME_PRIMARY_FUNNEL_KEY = "primaryFunnelKey";
    @SerializedName(value="primaryFunnelKey")
    @Nullable
    private String primaryFunnelKey;
    public static final String SERIALIZED_NAME_TREATMENTS = "treatments";
    @SerializedName(value="treatments")
    @Nonnull
    private List<TreatmentInput> treatments = new ArrayList<TreatmentInput>();
    public static final String SERIALIZED_NAME_FLAGS = "flags";
    @SerializedName(value="flags")
    @Nonnull
    private Map<String, FlagInput> flags = new HashMap<String, FlagInput>();
    public static final String SERIALIZED_NAME_RANDOMIZATION_UNIT = "randomizationUnit";
    @SerializedName(value="randomizationUnit")
    @Nullable
    private String randomizationUnit;
    public static final String SERIALIZED_NAME_COVARIANCE_ID = "covarianceId";
    @SerializedName(value="covarianceId")
    @Nullable
    private String covarianceId;
    public static final String SERIALIZED_NAME_ATTRIBUTES = "attributes";
    @SerializedName(value="attributes")
    @Nullable
    private List<String> attributes = new ArrayList<String>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("hypothesis", "canReshuffleTraffic", "metrics", "primarySingleMetricKey", "primaryFunnelKey", "treatments", "flags", "randomizationUnit", "covarianceId", "attributes"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("hypothesis", "metrics", "treatments", "flags"));

    public IterationInput hypothesis(@Nonnull String hypothesis) {
        this.hypothesis = hypothesis;
        return this;
    }

    @Nonnull
    public String getHypothesis() {
        return this.hypothesis;
    }

    public void setHypothesis(@Nonnull String hypothesis) {
        this.hypothesis = hypothesis;
    }

    public IterationInput canReshuffleTraffic(@Nullable Boolean canReshuffleTraffic) {
        this.canReshuffleTraffic = canReshuffleTraffic;
        return this;
    }

    @Nullable
    public Boolean getCanReshuffleTraffic() {
        return this.canReshuffleTraffic;
    }

    public void setCanReshuffleTraffic(@Nullable Boolean canReshuffleTraffic) {
        this.canReshuffleTraffic = canReshuffleTraffic;
    }

    public IterationInput metrics(@Nonnull List<MetricInput> metrics) {
        this.metrics = metrics;
        return this;
    }

    public IterationInput addMetricsItem(MetricInput metricsItem) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<MetricInput>();
        }
        this.metrics.add(metricsItem);
        return this;
    }

    @Nonnull
    public List<MetricInput> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(@Nonnull List<MetricInput> metrics) {
        this.metrics = metrics;
    }

    public IterationInput primarySingleMetricKey(@Nullable String primarySingleMetricKey) {
        this.primarySingleMetricKey = primarySingleMetricKey;
        return this;
    }

    @Nullable
    public String getPrimarySingleMetricKey() {
        return this.primarySingleMetricKey;
    }

    public void setPrimarySingleMetricKey(@Nullable String primarySingleMetricKey) {
        this.primarySingleMetricKey = primarySingleMetricKey;
    }

    public IterationInput primaryFunnelKey(@Nullable String primaryFunnelKey) {
        this.primaryFunnelKey = primaryFunnelKey;
        return this;
    }

    @Nullable
    public String getPrimaryFunnelKey() {
        return this.primaryFunnelKey;
    }

    public void setPrimaryFunnelKey(@Nullable String primaryFunnelKey) {
        this.primaryFunnelKey = primaryFunnelKey;
    }

    public IterationInput treatments(@Nonnull List<TreatmentInput> treatments) {
        this.treatments = treatments;
        return this;
    }

    public IterationInput addTreatmentsItem(TreatmentInput treatmentsItem) {
        if (this.treatments == null) {
            this.treatments = new ArrayList<TreatmentInput>();
        }
        this.treatments.add(treatmentsItem);
        return this;
    }

    @Nonnull
    public List<TreatmentInput> getTreatments() {
        return this.treatments;
    }

    public void setTreatments(@Nonnull List<TreatmentInput> treatments) {
        this.treatments = treatments;
    }

    public IterationInput flags(@Nonnull Map<String, FlagInput> flags) {
        this.flags = flags;
        return this;
    }

    public IterationInput putFlagsItem(String key, FlagInput flagsItem) {
        if (this.flags == null) {
            this.flags = new HashMap<String, FlagInput>();
        }
        this.flags.put(key, flagsItem);
        return this;
    }

    @Nonnull
    public Map<String, FlagInput> getFlags() {
        return this.flags;
    }

    public void setFlags(@Nonnull Map<String, FlagInput> flags) {
        this.flags = flags;
    }

    public IterationInput randomizationUnit(@Nullable String randomizationUnit) {
        this.randomizationUnit = randomizationUnit;
        return this;
    }

    @Nullable
    public String getRandomizationUnit() {
        return this.randomizationUnit;
    }

    public void setRandomizationUnit(@Nullable String randomizationUnit) {
        this.randomizationUnit = randomizationUnit;
    }

    public IterationInput covarianceId(@Nullable String covarianceId) {
        this.covarianceId = covarianceId;
        return this;
    }

    @Nullable
    public String getCovarianceId() {
        return this.covarianceId;
    }

    public void setCovarianceId(@Nullable String covarianceId) {
        this.covarianceId = covarianceId;
    }

    public IterationInput attributes(@Nullable List<String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public IterationInput addAttributesItem(String attributesItem) {
        if (this.attributes == null) {
            this.attributes = new ArrayList<String>();
        }
        this.attributes.add(attributesItem);
        return this;
    }

    @Nullable
    public List<String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(@Nullable List<String> attributes) {
        this.attributes = attributes;
    }

    public IterationInput putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IterationInput iterationInput = (IterationInput)o;
        return Objects.equals(this.hypothesis, iterationInput.hypothesis) && Objects.equals(this.canReshuffleTraffic, iterationInput.canReshuffleTraffic) && Objects.equals(this.metrics, iterationInput.metrics) && Objects.equals(this.primarySingleMetricKey, iterationInput.primarySingleMetricKey) && Objects.equals(this.primaryFunnelKey, iterationInput.primaryFunnelKey) && Objects.equals(this.treatments, iterationInput.treatments) && Objects.equals(this.flags, iterationInput.flags) && Objects.equals(this.randomizationUnit, iterationInput.randomizationUnit) && Objects.equals(this.covarianceId, iterationInput.covarianceId) && Objects.equals(this.attributes, iterationInput.attributes) && Objects.equals(this.additionalProperties, iterationInput.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.hypothesis, this.canReshuffleTraffic, this.metrics, this.primarySingleMetricKey, this.primaryFunnelKey, this.treatments, this.flags, this.randomizationUnit, this.covarianceId, this.attributes, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IterationInput {\n");
        sb.append("    hypothesis: ").append(this.toIndentedString(this.hypothesis)).append("\n");
        sb.append("    canReshuffleTraffic: ").append(this.toIndentedString(this.canReshuffleTraffic)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    primarySingleMetricKey: ").append(this.toIndentedString(this.primarySingleMetricKey)).append("\n");
        sb.append("    primaryFunnelKey: ").append(this.toIndentedString(this.primaryFunnelKey)).append("\n");
        sb.append("    treatments: ").append(this.toIndentedString(this.treatments)).append("\n");
        sb.append("    flags: ").append(this.toIndentedString(this.flags)).append("\n");
        sb.append("    randomizationUnit: ").append(this.toIndentedString(this.randomizationUnit)).append("\n");
        sb.append("    covarianceId: ").append(this.toIndentedString(this.covarianceId)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in IterationInput is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_HYPOTHESIS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `hypothesis` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HYPOTHESIS).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_METRICS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `metrics` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_METRICS).toString()));
        }
        JsonArray jsonArraymetrics = jsonObj.getAsJsonArray(SERIALIZED_NAME_METRICS);
        for (int i = 0; i < jsonArraymetrics.size(); ++i) {
            MetricInput.validateJsonElement(jsonArraymetrics.get(i));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRIMARY_SINGLE_METRIC_KEY) != null && !jsonObj.get(SERIALIZED_NAME_PRIMARY_SINGLE_METRIC_KEY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PRIMARY_SINGLE_METRIC_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `primarySingleMetricKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRIMARY_SINGLE_METRIC_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PRIMARY_FUNNEL_KEY) != null && !jsonObj.get(SERIALIZED_NAME_PRIMARY_FUNNEL_KEY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PRIMARY_FUNNEL_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `primaryFunnelKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PRIMARY_FUNNEL_KEY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_TREATMENTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `treatments` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TREATMENTS).toString()));
        }
        JsonArray jsonArraytreatments = jsonObj.getAsJsonArray(SERIALIZED_NAME_TREATMENTS);
        for (int i = 0; i < jsonArraytreatments.size(); ++i) {
            TreatmentInput.validateJsonElement(jsonArraytreatments.get(i));
        }
        if (jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNIT) != null && !jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNIT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNIT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `randomizationUnit` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RANDOMIZATION_UNIT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COVARIANCE_ID) != null && !jsonObj.get(SERIALIZED_NAME_COVARIANCE_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COVARIANCE_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `covarianceId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COVARIANCE_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ATTRIBUTES) != null && !jsonObj.get(SERIALIZED_NAME_ATTRIBUTES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ATTRIBUTES).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `attributes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ATTRIBUTES).toString()));
        }
    }

    public static IterationInput fromJson(String jsonString) throws IOException {
        return (IterationInput)JSON.getGson().fromJson(jsonString, IterationInput.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!IterationInput.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(IterationInput.class));
            return new TypeAdapter<IterationInput>(){

                public void write(JsonWriter out, IterationInput value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public IterationInput read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    IterationInput.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    IterationInput instance = (IterationInput)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

