/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.IntegrationMetadata;
import com.launchdarkly.api.model.LastSeenMetadata;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.MemberPermissionGrantSummaryRep;
import com.launchdarkly.api.model.MemberTeamSummaryRep;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Member {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    @Nonnull
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    @Nonnull
    private String id;
    public static final String SERIALIZED_NAME_FIRST_NAME = "firstName";
    @SerializedName(value="firstName")
    @Nullable
    private String firstName;
    public static final String SERIALIZED_NAME_LAST_NAME = "lastName";
    @SerializedName(value="lastName")
    @Nullable
    private String lastName;
    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(value="role")
    @Nonnull
    private String role;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    @Nonnull
    private String email;
    public static final String SERIALIZED_NAME_PENDING_INVITE = "_pendingInvite";
    @SerializedName(value="_pendingInvite")
    @Nonnull
    private Boolean pendingInvite;
    public static final String SERIALIZED_NAME_VERIFIED = "_verified";
    @SerializedName(value="_verified")
    @Nonnull
    private Boolean verified;
    public static final String SERIALIZED_NAME_PENDING_EMAIL = "_pendingEmail";
    @SerializedName(value="_pendingEmail")
    @Nullable
    private String pendingEmail;
    public static final String SERIALIZED_NAME_CUSTOM_ROLES = "customRoles";
    @SerializedName(value="customRoles")
    @Nonnull
    private List<String> customRoles = new ArrayList<String>();
    public static final String SERIALIZED_NAME_MFA = "mfa";
    @SerializedName(value="mfa")
    @Nonnull
    private String mfa;
    public static final String SERIALIZED_NAME_EXCLUDED_DASHBOARDS = "excludedDashboards";
    @SerializedName(value="excludedDashboards")
    @Nullable
    private List<String> excludedDashboards = new ArrayList<String>();
    public static final String SERIALIZED_NAME_LAST_SEEN = "_lastSeen";
    @SerializedName(value="_lastSeen")
    @Nonnull
    private Long lastSeen;
    public static final String SERIALIZED_NAME_LAST_SEEN_METADATA = "_lastSeenMetadata";
    @SerializedName(value="_lastSeenMetadata")
    @Nullable
    private LastSeenMetadata lastSeenMetadata;
    public static final String SERIALIZED_NAME_INTEGRATION_METADATA = "_integrationMetadata";
    @SerializedName(value="_integrationMetadata")
    @Nullable
    private IntegrationMetadata integrationMetadata;
    public static final String SERIALIZED_NAME_TEAMS = "teams";
    @SerializedName(value="teams")
    @Nullable
    private List<MemberTeamSummaryRep> teams = new ArrayList<MemberTeamSummaryRep>();
    public static final String SERIALIZED_NAME_PERMISSION_GRANTS = "permissionGrants";
    @SerializedName(value="permissionGrants")
    @Nullable
    private List<MemberPermissionGrantSummaryRep> permissionGrants = new ArrayList<MemberPermissionGrantSummaryRep>();
    public static final String SERIALIZED_NAME_CREATION_DATE = "creationDate";
    @SerializedName(value="creationDate")
    @Nonnull
    private Long creationDate;
    public static final String SERIALIZED_NAME_OAUTH_PROVIDERS = "oauthProviders";
    @SerializedName(value="oauthProviders")
    @Nullable
    private List<String> oauthProviders = new ArrayList<String>();
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    @Nullable
    private Integer version;
    public static final String SERIALIZED_NAME_ROLE_ATTRIBUTES = "roleAttributes";
    @SerializedName(value="roleAttributes")
    @Nullable
    private Map<String, List<String>> roleAttributes = new HashMap<String, List<String>>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("_links", "_id", "firstName", "lastName", "role", "email", "_pendingInvite", "_verified", "_pendingEmail", "customRoles", "mfa", "excludedDashboards", "_lastSeen", "_lastSeenMetadata", "_integrationMetadata", "teams", "permissionGrants", "creationDate", "oauthProviders", "version", "roleAttributes"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("_links", "_id", "role", "email", "_pendingInvite", "_verified", "customRoles", "mfa", "_lastSeen", "creationDate"));

    public Member links(@Nonnull Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public Member putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(@Nonnull Map<String, Link> links) {
        this.links = links;
    }

    public Member id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public Member firstName(@Nullable String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nullable
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(@Nullable String firstName) {
        this.firstName = firstName;
    }

    public Member lastName(@Nullable String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nullable
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(@Nullable String lastName) {
        this.lastName = lastName;
    }

    public Member role(@Nonnull String role) {
        this.role = role;
        return this;
    }

    @Nonnull
    public String getRole() {
        return this.role;
    }

    public void setRole(@Nonnull String role) {
        this.role = role;
    }

    public Member email(@Nonnull String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    public String getEmail() {
        return this.email;
    }

    public void setEmail(@Nonnull String email) {
        this.email = email;
    }

    public Member pendingInvite(@Nonnull Boolean pendingInvite) {
        this.pendingInvite = pendingInvite;
        return this;
    }

    @Nonnull
    public Boolean getPendingInvite() {
        return this.pendingInvite;
    }

    public void setPendingInvite(@Nonnull Boolean pendingInvite) {
        this.pendingInvite = pendingInvite;
    }

    public Member verified(@Nonnull Boolean verified) {
        this.verified = verified;
        return this;
    }

    @Nonnull
    public Boolean getVerified() {
        return this.verified;
    }

    public void setVerified(@Nonnull Boolean verified) {
        this.verified = verified;
    }

    public Member pendingEmail(@Nullable String pendingEmail) {
        this.pendingEmail = pendingEmail;
        return this;
    }

    @Nullable
    public String getPendingEmail() {
        return this.pendingEmail;
    }

    public void setPendingEmail(@Nullable String pendingEmail) {
        this.pendingEmail = pendingEmail;
    }

    public Member customRoles(@Nonnull List<String> customRoles) {
        this.customRoles = customRoles;
        return this;
    }

    public Member addCustomRolesItem(String customRolesItem) {
        if (this.customRoles == null) {
            this.customRoles = new ArrayList<String>();
        }
        this.customRoles.add(customRolesItem);
        return this;
    }

    @Nonnull
    public List<String> getCustomRoles() {
        return this.customRoles;
    }

    public void setCustomRoles(@Nonnull List<String> customRoles) {
        this.customRoles = customRoles;
    }

    public Member mfa(@Nonnull String mfa) {
        this.mfa = mfa;
        return this;
    }

    @Nonnull
    public String getMfa() {
        return this.mfa;
    }

    public void setMfa(@Nonnull String mfa) {
        this.mfa = mfa;
    }

    public Member excludedDashboards(@Nullable List<String> excludedDashboards) {
        this.excludedDashboards = excludedDashboards;
        return this;
    }

    public Member addExcludedDashboardsItem(String excludedDashboardsItem) {
        if (this.excludedDashboards == null) {
            this.excludedDashboards = new ArrayList<String>();
        }
        this.excludedDashboards.add(excludedDashboardsItem);
        return this;
    }

    @Nullable
    public List<String> getExcludedDashboards() {
        return this.excludedDashboards;
    }

    public void setExcludedDashboards(@Nullable List<String> excludedDashboards) {
        this.excludedDashboards = excludedDashboards;
    }

    public Member lastSeen(@Nonnull Long lastSeen) {
        this.lastSeen = lastSeen;
        return this;
    }

    @Nonnull
    public Long getLastSeen() {
        return this.lastSeen;
    }

    public void setLastSeen(@Nonnull Long lastSeen) {
        this.lastSeen = lastSeen;
    }

    public Member lastSeenMetadata(@Nullable LastSeenMetadata lastSeenMetadata) {
        this.lastSeenMetadata = lastSeenMetadata;
        return this;
    }

    @Nullable
    public LastSeenMetadata getLastSeenMetadata() {
        return this.lastSeenMetadata;
    }

    public void setLastSeenMetadata(@Nullable LastSeenMetadata lastSeenMetadata) {
        this.lastSeenMetadata = lastSeenMetadata;
    }

    public Member integrationMetadata(@Nullable IntegrationMetadata integrationMetadata) {
        this.integrationMetadata = integrationMetadata;
        return this;
    }

    @Nullable
    public IntegrationMetadata getIntegrationMetadata() {
        return this.integrationMetadata;
    }

    public void setIntegrationMetadata(@Nullable IntegrationMetadata integrationMetadata) {
        this.integrationMetadata = integrationMetadata;
    }

    public Member teams(@Nullable List<MemberTeamSummaryRep> teams) {
        this.teams = teams;
        return this;
    }

    public Member addTeamsItem(MemberTeamSummaryRep teamsItem) {
        if (this.teams == null) {
            this.teams = new ArrayList<MemberTeamSummaryRep>();
        }
        this.teams.add(teamsItem);
        return this;
    }

    @Nullable
    public List<MemberTeamSummaryRep> getTeams() {
        return this.teams;
    }

    public void setTeams(@Nullable List<MemberTeamSummaryRep> teams) {
        this.teams = teams;
    }

    public Member permissionGrants(@Nullable List<MemberPermissionGrantSummaryRep> permissionGrants) {
        this.permissionGrants = permissionGrants;
        return this;
    }

    public Member addPermissionGrantsItem(MemberPermissionGrantSummaryRep permissionGrantsItem) {
        if (this.permissionGrants == null) {
            this.permissionGrants = new ArrayList<MemberPermissionGrantSummaryRep>();
        }
        this.permissionGrants.add(permissionGrantsItem);
        return this;
    }

    @Nullable
    public List<MemberPermissionGrantSummaryRep> getPermissionGrants() {
        return this.permissionGrants;
    }

    public void setPermissionGrants(@Nullable List<MemberPermissionGrantSummaryRep> permissionGrants) {
        this.permissionGrants = permissionGrants;
    }

    public Member creationDate(@Nonnull Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nonnull
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(@Nonnull Long creationDate) {
        this.creationDate = creationDate;
    }

    public Member oauthProviders(@Nullable List<String> oauthProviders) {
        this.oauthProviders = oauthProviders;
        return this;
    }

    public Member addOauthProvidersItem(String oauthProvidersItem) {
        if (this.oauthProviders == null) {
            this.oauthProviders = new ArrayList<String>();
        }
        this.oauthProviders.add(oauthProvidersItem);
        return this;
    }

    @Nullable
    public List<String> getOauthProviders() {
        return this.oauthProviders;
    }

    public void setOauthProviders(@Nullable List<String> oauthProviders) {
        this.oauthProviders = oauthProviders;
    }

    public Member version(@Nullable Integer version) {
        this.version = version;
        return this;
    }

    @Nullable
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable Integer version) {
        this.version = version;
    }

    public Member roleAttributes(@Nullable Map<String, List<String>> roleAttributes) {
        this.roleAttributes = roleAttributes;
        return this;
    }

    public Member putRoleAttributesItem(String key, List<String> roleAttributesItem) {
        if (this.roleAttributes == null) {
            this.roleAttributes = new HashMap<String, List<String>>();
        }
        this.roleAttributes.put(key, roleAttributesItem);
        return this;
    }

    @Nullable
    public Map<String, List<String>> getRoleAttributes() {
        return this.roleAttributes;
    }

    public void setRoleAttributes(@Nullable Map<String, List<String>> roleAttributes) {
        this.roleAttributes = roleAttributes;
    }

    public Member putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Member member = (Member)o;
        return Objects.equals(this.links, member.links) && Objects.equals(this.id, member.id) && Objects.equals(this.firstName, member.firstName) && Objects.equals(this.lastName, member.lastName) && Objects.equals(this.role, member.role) && Objects.equals(this.email, member.email) && Objects.equals(this.pendingInvite, member.pendingInvite) && Objects.equals(this.verified, member.verified) && Objects.equals(this.pendingEmail, member.pendingEmail) && Objects.equals(this.customRoles, member.customRoles) && Objects.equals(this.mfa, member.mfa) && Objects.equals(this.excludedDashboards, member.excludedDashboards) && Objects.equals(this.lastSeen, member.lastSeen) && Objects.equals(this.lastSeenMetadata, member.lastSeenMetadata) && Objects.equals(this.integrationMetadata, member.integrationMetadata) && Objects.equals(this.teams, member.teams) && Objects.equals(this.permissionGrants, member.permissionGrants) && Objects.equals(this.creationDate, member.creationDate) && Objects.equals(this.oauthProviders, member.oauthProviders) && Objects.equals(this.version, member.version) && Objects.equals(this.roleAttributes, member.roleAttributes) && Objects.equals(this.additionalProperties, member.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.id, this.firstName, this.lastName, this.role, this.email, this.pendingInvite, this.verified, this.pendingEmail, this.customRoles, this.mfa, this.excludedDashboards, this.lastSeen, this.lastSeenMetadata, this.integrationMetadata, this.teams, this.permissionGrants, this.creationDate, this.oauthProviders, this.version, this.roleAttributes, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Member {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    pendingInvite: ").append(this.toIndentedString(this.pendingInvite)).append("\n");
        sb.append("    verified: ").append(this.toIndentedString(this.verified)).append("\n");
        sb.append("    pendingEmail: ").append(this.toIndentedString(this.pendingEmail)).append("\n");
        sb.append("    customRoles: ").append(this.toIndentedString(this.customRoles)).append("\n");
        sb.append("    mfa: ").append(this.toIndentedString(this.mfa)).append("\n");
        sb.append("    excludedDashboards: ").append(this.toIndentedString(this.excludedDashboards)).append("\n");
        sb.append("    lastSeen: ").append(this.toIndentedString(this.lastSeen)).append("\n");
        sb.append("    lastSeenMetadata: ").append(this.toIndentedString(this.lastSeenMetadata)).append("\n");
        sb.append("    integrationMetadata: ").append(this.toIndentedString(this.integrationMetadata)).append("\n");
        sb.append("    teams: ").append(this.toIndentedString(this.teams)).append("\n");
        sb.append("    permissionGrants: ").append(this.toIndentedString(this.permissionGrants)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    oauthProviders: ").append(this.toIndentedString(this.oauthProviders)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    roleAttributes: ").append(this.toIndentedString(this.roleAttributes)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraypermissionGrants;
        int i;
        JsonArray jsonArrayteams;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in Member is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_FIRST_NAME) != null && !jsonObj.get(SERIALIZED_NAME_FIRST_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FIRST_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `firstName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FIRST_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_NAME) != null && !jsonObj.get(SERIALIZED_NAME_LAST_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_LAST_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `lastName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LAST_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_ROLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `role` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROLE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `email` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PENDING_EMAIL) != null && !jsonObj.get(SERIALIZED_NAME_PENDING_EMAIL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PENDING_EMAIL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `_pendingEmail` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PENDING_EMAIL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CUSTOM_ROLES) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_CUSTOM_ROLES).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `customRoles` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CUSTOM_ROLES).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_MFA).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `mfa` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MFA).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXCLUDED_DASHBOARDS) != null && !jsonObj.get(SERIALIZED_NAME_EXCLUDED_DASHBOARDS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EXCLUDED_DASHBOARDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `excludedDashboards` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXCLUDED_DASHBOARDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LAST_SEEN_METADATA) != null && !jsonObj.get(SERIALIZED_NAME_LAST_SEEN_METADATA).isJsonNull()) {
            LastSeenMetadata.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LAST_SEEN_METADATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_INTEGRATION_METADATA) != null && !jsonObj.get(SERIALIZED_NAME_INTEGRATION_METADATA).isJsonNull()) {
            IntegrationMetadata.validateJsonElement(jsonObj.get(SERIALIZED_NAME_INTEGRATION_METADATA));
        }
        if (jsonObj.get(SERIALIZED_NAME_TEAMS) != null && !jsonObj.get(SERIALIZED_NAME_TEAMS).isJsonNull() && (jsonArrayteams = jsonObj.getAsJsonArray(SERIALIZED_NAME_TEAMS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TEAMS).isJsonArray()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `teams` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TEAMS).toString()));
            }
            for (i = 0; i < jsonArrayteams.size(); ++i) {
                MemberTeamSummaryRep.validateJsonElement(jsonArrayteams.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_PERMISSION_GRANTS) != null && !jsonObj.get(SERIALIZED_NAME_PERMISSION_GRANTS).isJsonNull() && (jsonArraypermissionGrants = jsonObj.getAsJsonArray(SERIALIZED_NAME_PERMISSION_GRANTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PERMISSION_GRANTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `permissionGrants` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PERMISSION_GRANTS).toString()));
            }
            for (i = 0; i < jsonArraypermissionGrants.size(); ++i) {
                MemberPermissionGrantSummaryRep.validateJsonElement(jsonArraypermissionGrants.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_OAUTH_PROVIDERS) != null && !jsonObj.get(SERIALIZED_NAME_OAUTH_PROVIDERS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_OAUTH_PROVIDERS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `oauthProviders` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OAUTH_PROVIDERS).toString()));
        }
    }

    public static Member fromJson(String jsonString) throws IOException {
        return (Member)JSON.getGson().fromJson(jsonString, Member.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Member.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Member.class));
            return new TypeAdapter<Member>(){

                public void write(JsonWriter out, Member value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public Member read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Member.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    Member instance = (Member)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

