/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Access;
import com.launchdarkly.api.model.DependentExperimentRep;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.MaintainerRep;
import com.launchdarkly.api.model.MetricInGroupRep;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MetricGroupRep {
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    @Nonnull
    private String id;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    @Nonnull
    private String key;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    @Nonnull
    private KindEnum kind;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    @Nullable
    private String description;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    @Nonnull
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_ACCESS = "_access";
    @SerializedName(value="_access")
    @Nullable
    private Access access;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    @Nonnull
    private List<String> tags = new ArrayList<String>();
    public static final String SERIALIZED_NAME_CREATION_DATE = "_creationDate";
    @SerializedName(value="_creationDate")
    @Nonnull
    private Long creationDate;
    public static final String SERIALIZED_NAME_LAST_MODIFIED = "_lastModified";
    @SerializedName(value="_lastModified")
    @Nonnull
    private Long lastModified;
    public static final String SERIALIZED_NAME_MAINTAINER = "maintainer";
    @SerializedName(value="maintainer")
    @Nonnull
    private MaintainerRep maintainer;
    public static final String SERIALIZED_NAME_METRICS = "metrics";
    @SerializedName(value="metrics")
    @Nonnull
    private List<MetricInGroupRep> metrics = new ArrayList<MetricInGroupRep>();
    public static final String SERIALIZED_NAME_VERSION = "_version";
    @SerializedName(value="_version")
    @Nonnull
    private Integer version;
    public static final String SERIALIZED_NAME_EXPERIMENTS = "experiments";
    @SerializedName(value="experiments")
    @Nullable
    private List<DependentExperimentRep> experiments = new ArrayList<DependentExperimentRep>();
    public static final String SERIALIZED_NAME_EXPERIMENT_COUNT = "experimentCount";
    @SerializedName(value="experimentCount")
    @Nullable
    private Integer experimentCount;
    public static final String SERIALIZED_NAME_ACTIVE_EXPERIMENT_COUNT = "activeExperimentCount";
    @SerializedName(value="activeExperimentCount")
    @Nullable
    private Integer activeExperimentCount;
    public static final String SERIALIZED_NAME_ACTIVE_GUARDED_ROLLOUT_COUNT = "activeGuardedRolloutCount";
    @SerializedName(value="activeGuardedRolloutCount")
    @Nullable
    private Integer activeGuardedRolloutCount;
    public static final String SERIALIZED_NAME_TOTAL_CONNECTIONS_COUNT = "totalConnectionsCount";
    @SerializedName(value="totalConnectionsCount")
    @Nullable
    private Integer totalConnectionsCount;
    public static final String SERIALIZED_NAME_TOTAL_ACTIVE_CONNECTIONS_COUNT = "totalActiveConnectionsCount";
    @SerializedName(value="totalActiveConnectionsCount")
    @Nullable
    private Integer totalActiveConnectionsCount;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("_id", "key", "name", "kind", "description", "_links", "_access", "tags", "_creationDate", "_lastModified", "maintainer", "metrics", "_version", "experiments", "experimentCount", "activeExperimentCount", "activeGuardedRolloutCount", "totalConnectionsCount", "totalActiveConnectionsCount"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("_id", "key", "name", "kind", "_links", "tags", "_creationDate", "_lastModified", "maintainer", "metrics", "_version"));

    public MetricGroupRep id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(@Nonnull String id) {
        this.id = id;
    }

    public MetricGroupRep key(@Nonnull String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    public void setKey(@Nonnull String key) {
        this.key = key;
    }

    public MetricGroupRep name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public MetricGroupRep kind(@Nonnull KindEnum kind) {
        this.kind = kind;
        return this;
    }

    @Nonnull
    public KindEnum getKind() {
        return this.kind;
    }

    public void setKind(@Nonnull KindEnum kind) {
        this.kind = kind;
    }

    public MetricGroupRep description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public MetricGroupRep links(@Nonnull Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public MetricGroupRep putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nonnull
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(@Nonnull Map<String, Link> links) {
        this.links = links;
    }

    public MetricGroupRep access(@Nullable Access access) {
        this.access = access;
        return this;
    }

    @Nullable
    public Access getAccess() {
        return this.access;
    }

    public void setAccess(@Nullable Access access) {
        this.access = access;
    }

    public MetricGroupRep tags(@Nonnull List<String> tags) {
        this.tags = tags;
        return this;
    }

    public MetricGroupRep addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nonnull
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(@Nonnull List<String> tags) {
        this.tags = tags;
    }

    public MetricGroupRep creationDate(@Nonnull Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nonnull
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(@Nonnull Long creationDate) {
        this.creationDate = creationDate;
    }

    public MetricGroupRep lastModified(@Nonnull Long lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @Nonnull
    public Long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(@Nonnull Long lastModified) {
        this.lastModified = lastModified;
    }

    public MetricGroupRep maintainer(@Nonnull MaintainerRep maintainer) {
        this.maintainer = maintainer;
        return this;
    }

    @Nonnull
    public MaintainerRep getMaintainer() {
        return this.maintainer;
    }

    public void setMaintainer(@Nonnull MaintainerRep maintainer) {
        this.maintainer = maintainer;
    }

    public MetricGroupRep metrics(@Nonnull List<MetricInGroupRep> metrics) {
        this.metrics = metrics;
        return this;
    }

    public MetricGroupRep addMetricsItem(MetricInGroupRep metricsItem) {
        if (this.metrics == null) {
            this.metrics = new ArrayList<MetricInGroupRep>();
        }
        this.metrics.add(metricsItem);
        return this;
    }

    @Nonnull
    public List<MetricInGroupRep> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(@Nonnull List<MetricInGroupRep> metrics) {
        this.metrics = metrics;
    }

    public MetricGroupRep version(@Nonnull Integer version) {
        this.version = version;
        return this;
    }

    @Nonnull
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(@Nonnull Integer version) {
        this.version = version;
    }

    public MetricGroupRep experiments(@Nullable List<DependentExperimentRep> experiments) {
        this.experiments = experiments;
        return this;
    }

    public MetricGroupRep addExperimentsItem(DependentExperimentRep experimentsItem) {
        if (this.experiments == null) {
            this.experiments = new ArrayList<DependentExperimentRep>();
        }
        this.experiments.add(experimentsItem);
        return this;
    }

    @Nullable
    public List<DependentExperimentRep> getExperiments() {
        return this.experiments;
    }

    public void setExperiments(@Nullable List<DependentExperimentRep> experiments) {
        this.experiments = experiments;
    }

    public MetricGroupRep experimentCount(@Nullable Integer experimentCount) {
        this.experimentCount = experimentCount;
        return this;
    }

    @Nullable
    public Integer getExperimentCount() {
        return this.experimentCount;
    }

    public void setExperimentCount(@Nullable Integer experimentCount) {
        this.experimentCount = experimentCount;
    }

    public MetricGroupRep activeExperimentCount(@Nullable Integer activeExperimentCount) {
        this.activeExperimentCount = activeExperimentCount;
        return this;
    }

    @Nullable
    public Integer getActiveExperimentCount() {
        return this.activeExperimentCount;
    }

    public void setActiveExperimentCount(@Nullable Integer activeExperimentCount) {
        this.activeExperimentCount = activeExperimentCount;
    }

    public MetricGroupRep activeGuardedRolloutCount(@Nullable Integer activeGuardedRolloutCount) {
        this.activeGuardedRolloutCount = activeGuardedRolloutCount;
        return this;
    }

    @Nullable
    public Integer getActiveGuardedRolloutCount() {
        return this.activeGuardedRolloutCount;
    }

    public void setActiveGuardedRolloutCount(@Nullable Integer activeGuardedRolloutCount) {
        this.activeGuardedRolloutCount = activeGuardedRolloutCount;
    }

    public MetricGroupRep totalConnectionsCount(@Nullable Integer totalConnectionsCount) {
        this.totalConnectionsCount = totalConnectionsCount;
        return this;
    }

    @Nullable
    public Integer getTotalConnectionsCount() {
        return this.totalConnectionsCount;
    }

    public void setTotalConnectionsCount(@Nullable Integer totalConnectionsCount) {
        this.totalConnectionsCount = totalConnectionsCount;
    }

    public MetricGroupRep totalActiveConnectionsCount(@Nullable Integer totalActiveConnectionsCount) {
        this.totalActiveConnectionsCount = totalActiveConnectionsCount;
        return this;
    }

    @Nullable
    public Integer getTotalActiveConnectionsCount() {
        return this.totalActiveConnectionsCount;
    }

    public void setTotalActiveConnectionsCount(@Nullable Integer totalActiveConnectionsCount) {
        this.totalActiveConnectionsCount = totalActiveConnectionsCount;
    }

    public MetricGroupRep putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricGroupRep metricGroupRep = (MetricGroupRep)o;
        return Objects.equals(this.id, metricGroupRep.id) && Objects.equals(this.key, metricGroupRep.key) && Objects.equals(this.name, metricGroupRep.name) && Objects.equals((Object)this.kind, (Object)metricGroupRep.kind) && Objects.equals(this.description, metricGroupRep.description) && Objects.equals(this.links, metricGroupRep.links) && Objects.equals(this.access, metricGroupRep.access) && Objects.equals(this.tags, metricGroupRep.tags) && Objects.equals(this.creationDate, metricGroupRep.creationDate) && Objects.equals(this.lastModified, metricGroupRep.lastModified) && Objects.equals(this.maintainer, metricGroupRep.maintainer) && Objects.equals(this.metrics, metricGroupRep.metrics) && Objects.equals(this.version, metricGroupRep.version) && Objects.equals(this.experiments, metricGroupRep.experiments) && Objects.equals(this.experimentCount, metricGroupRep.experimentCount) && Objects.equals(this.activeExperimentCount, metricGroupRep.activeExperimentCount) && Objects.equals(this.activeGuardedRolloutCount, metricGroupRep.activeGuardedRolloutCount) && Objects.equals(this.totalConnectionsCount, metricGroupRep.totalConnectionsCount) && Objects.equals(this.totalActiveConnectionsCount, metricGroupRep.totalActiveConnectionsCount) && Objects.equals(this.additionalProperties, metricGroupRep.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.key, this.name, this.kind, this.description, this.links, this.access, this.tags, this.creationDate, this.lastModified, this.maintainer, this.metrics, this.version, this.experiments, this.experimentCount, this.activeExperimentCount, this.activeGuardedRolloutCount, this.totalConnectionsCount, this.totalActiveConnectionsCount, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetricGroupRep {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString((Object)this.kind)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    lastModified: ").append(this.toIndentedString(this.lastModified)).append("\n");
        sb.append("    maintainer: ").append(this.toIndentedString(this.maintainer)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString(this.metrics)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    experiments: ").append(this.toIndentedString(this.experiments)).append("\n");
        sb.append("    experimentCount: ").append(this.toIndentedString(this.experimentCount)).append("\n");
        sb.append("    activeExperimentCount: ").append(this.toIndentedString(this.activeExperimentCount)).append("\n");
        sb.append("    activeGuardedRolloutCount: ").append(this.toIndentedString(this.activeGuardedRolloutCount)).append("\n");
        sb.append("    totalConnectionsCount: ").append(this.toIndentedString(this.totalConnectionsCount)).append("\n");
        sb.append("    totalActiveConnectionsCount: ").append(this.toIndentedString(this.totalActiveConnectionsCount)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayexperiments;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in MetricGroupRep is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        KindEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_KIND));
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESS) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS).isJsonNull()) {
            Access.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ACCESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_TAGS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
        MaintainerRep.validateJsonElement(jsonObj.get(SERIALIZED_NAME_MAINTAINER));
        if (!jsonObj.get(SERIALIZED_NAME_METRICS).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `metrics` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_METRICS).toString()));
        }
        JsonArray jsonArraymetrics = jsonObj.getAsJsonArray(SERIALIZED_NAME_METRICS);
        for (int i = 0; i < jsonArraymetrics.size(); ++i) {
            MetricInGroupRep.validateJsonElement(jsonArraymetrics.get(i));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXPERIMENTS) != null && !jsonObj.get(SERIALIZED_NAME_EXPERIMENTS).isJsonNull() && (jsonArrayexperiments = jsonObj.getAsJsonArray(SERIALIZED_NAME_EXPERIMENTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_EXPERIMENTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `experiments` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXPERIMENTS).toString()));
            }
            for (int i = 0; i < jsonArrayexperiments.size(); ++i) {
                DependentExperimentRep.validateJsonElement(jsonArrayexperiments.get(i));
            }
        }
    }

    public static MetricGroupRep fromJson(String jsonString) throws IOException {
        return (MetricGroupRep)JSON.getGson().fromJson(jsonString, MetricGroupRep.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!MetricGroupRep.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MetricGroupRep.class));
            return new TypeAdapter<MetricGroupRep>(){

                public void write(JsonWriter out, MetricGroupRep value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public MetricGroupRep read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    MetricGroupRep.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    MetricGroupRep instance = (MetricGroupRep)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum KindEnum {
        FUNNEL("funnel"),
        STANDARD("standard"),
        GUARDRAIL("guardrail");

        private String value;

        private KindEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static KindEnum fromValue(String value) {
            for (KindEnum b : KindEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            KindEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<KindEnum> {
            public void write(JsonWriter jsonWriter, KindEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public KindEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return KindEnum.fromValue(value);
            }
        }
    }
}

