/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PostDeploymentEventInput {
    public static final String SERIALIZED_NAME_PROJECT_KEY = "projectKey";
    @SerializedName(value="projectKey")
    @Nonnull
    private String projectKey;
    public static final String SERIALIZED_NAME_ENVIRONMENT_KEY = "environmentKey";
    @SerializedName(value="environmentKey")
    @Nonnull
    private String environmentKey;
    public static final String SERIALIZED_NAME_APPLICATION_KEY = "applicationKey";
    @SerializedName(value="applicationKey")
    @Nonnull
    private String applicationKey;
    public static final String SERIALIZED_NAME_APPLICATION_NAME = "applicationName";
    @SerializedName(value="applicationName")
    @Nullable
    private String applicationName;
    public static final String SERIALIZED_NAME_APPLICATION_KIND = "applicationKind";
    @SerializedName(value="applicationKind")
    @Nullable
    private ApplicationKindEnum applicationKind;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    @Nonnull
    private String version;
    public static final String SERIALIZED_NAME_VERSION_NAME = "versionName";
    @SerializedName(value="versionName")
    @Nullable
    private String versionName;
    public static final String SERIALIZED_NAME_EVENT_TYPE = "eventType";
    @SerializedName(value="eventType")
    @Nonnull
    private EventTypeEnum eventType;
    public static final String SERIALIZED_NAME_EVENT_TIME = "eventTime";
    @SerializedName(value="eventTime")
    @Nullable
    private Long eventTime;
    public static final String SERIALIZED_NAME_EVENT_METADATA = "eventMetadata";
    @SerializedName(value="eventMetadata")
    @Nullable
    private Map<String, Object> eventMetadata = new HashMap<String, Object>();
    public static final String SERIALIZED_NAME_DEPLOYMENT_METADATA = "deploymentMetadata";
    @SerializedName(value="deploymentMetadata")
    @Nullable
    private Map<String, Object> deploymentMetadata = new HashMap<String, Object>();
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("projectKey", "environmentKey", "applicationKey", "applicationName", "applicationKind", "version", "versionName", "eventType", "eventTime", "eventMetadata", "deploymentMetadata"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("projectKey", "environmentKey", "applicationKey", "version", "eventType"));

    public PostDeploymentEventInput projectKey(@Nonnull String projectKey) {
        this.projectKey = projectKey;
        return this;
    }

    @Nonnull
    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(@Nonnull String projectKey) {
        this.projectKey = projectKey;
    }

    public PostDeploymentEventInput environmentKey(@Nonnull String environmentKey) {
        this.environmentKey = environmentKey;
        return this;
    }

    @Nonnull
    public String getEnvironmentKey() {
        return this.environmentKey;
    }

    public void setEnvironmentKey(@Nonnull String environmentKey) {
        this.environmentKey = environmentKey;
    }

    public PostDeploymentEventInput applicationKey(@Nonnull String applicationKey) {
        this.applicationKey = applicationKey;
        return this;
    }

    @Nonnull
    public String getApplicationKey() {
        return this.applicationKey;
    }

    public void setApplicationKey(@Nonnull String applicationKey) {
        this.applicationKey = applicationKey;
    }

    public PostDeploymentEventInput applicationName(@Nullable String applicationName) {
        this.applicationName = applicationName;
        return this;
    }

    @Nullable
    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(@Nullable String applicationName) {
        this.applicationName = applicationName;
    }

    public PostDeploymentEventInput applicationKind(@Nullable ApplicationKindEnum applicationKind) {
        this.applicationKind = applicationKind;
        return this;
    }

    @Nullable
    public ApplicationKindEnum getApplicationKind() {
        return this.applicationKind;
    }

    public void setApplicationKind(@Nullable ApplicationKindEnum applicationKind) {
        this.applicationKind = applicationKind;
    }

    public PostDeploymentEventInput version(@Nonnull String version) {
        this.version = version;
        return this;
    }

    @Nonnull
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@Nonnull String version) {
        this.version = version;
    }

    public PostDeploymentEventInput versionName(@Nullable String versionName) {
        this.versionName = versionName;
        return this;
    }

    @Nullable
    public String getVersionName() {
        return this.versionName;
    }

    public void setVersionName(@Nullable String versionName) {
        this.versionName = versionName;
    }

    public PostDeploymentEventInput eventType(@Nonnull EventTypeEnum eventType) {
        this.eventType = eventType;
        return this;
    }

    @Nonnull
    public EventTypeEnum getEventType() {
        return this.eventType;
    }

    public void setEventType(@Nonnull EventTypeEnum eventType) {
        this.eventType = eventType;
    }

    public PostDeploymentEventInput eventTime(@Nullable Long eventTime) {
        this.eventTime = eventTime;
        return this;
    }

    @Nullable
    public Long getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(@Nullable Long eventTime) {
        this.eventTime = eventTime;
    }

    public PostDeploymentEventInput eventMetadata(@Nullable Map<String, Object> eventMetadata) {
        this.eventMetadata = eventMetadata;
        return this;
    }

    public PostDeploymentEventInput putEventMetadataItem(String key, Object eventMetadataItem) {
        if (this.eventMetadata == null) {
            this.eventMetadata = new HashMap<String, Object>();
        }
        this.eventMetadata.put(key, eventMetadataItem);
        return this;
    }

    @Nullable
    public Map<String, Object> getEventMetadata() {
        return this.eventMetadata;
    }

    public void setEventMetadata(@Nullable Map<String, Object> eventMetadata) {
        this.eventMetadata = eventMetadata;
    }

    public PostDeploymentEventInput deploymentMetadata(@Nullable Map<String, Object> deploymentMetadata) {
        this.deploymentMetadata = deploymentMetadata;
        return this;
    }

    public PostDeploymentEventInput putDeploymentMetadataItem(String key, Object deploymentMetadataItem) {
        if (this.deploymentMetadata == null) {
            this.deploymentMetadata = new HashMap<String, Object>();
        }
        this.deploymentMetadata.put(key, deploymentMetadataItem);
        return this;
    }

    @Nullable
    public Map<String, Object> getDeploymentMetadata() {
        return this.deploymentMetadata;
    }

    public void setDeploymentMetadata(@Nullable Map<String, Object> deploymentMetadata) {
        this.deploymentMetadata = deploymentMetadata;
    }

    public PostDeploymentEventInput putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostDeploymentEventInput postDeploymentEventInput = (PostDeploymentEventInput)o;
        return Objects.equals(this.projectKey, postDeploymentEventInput.projectKey) && Objects.equals(this.environmentKey, postDeploymentEventInput.environmentKey) && Objects.equals(this.applicationKey, postDeploymentEventInput.applicationKey) && Objects.equals(this.applicationName, postDeploymentEventInput.applicationName) && Objects.equals((Object)this.applicationKind, (Object)postDeploymentEventInput.applicationKind) && Objects.equals(this.version, postDeploymentEventInput.version) && Objects.equals(this.versionName, postDeploymentEventInput.versionName) && Objects.equals((Object)this.eventType, (Object)postDeploymentEventInput.eventType) && Objects.equals(this.eventTime, postDeploymentEventInput.eventTime) && Objects.equals(this.eventMetadata, postDeploymentEventInput.eventMetadata) && Objects.equals(this.deploymentMetadata, postDeploymentEventInput.deploymentMetadata) && Objects.equals(this.additionalProperties, postDeploymentEventInput.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.projectKey, this.environmentKey, this.applicationKey, this.applicationName, this.applicationKind, this.version, this.versionName, this.eventType, this.eventTime, this.eventMetadata, this.deploymentMetadata, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostDeploymentEventInput {\n");
        sb.append("    projectKey: ").append(this.toIndentedString(this.projectKey)).append("\n");
        sb.append("    environmentKey: ").append(this.toIndentedString(this.environmentKey)).append("\n");
        sb.append("    applicationKey: ").append(this.toIndentedString(this.applicationKey)).append("\n");
        sb.append("    applicationName: ").append(this.toIndentedString(this.applicationName)).append("\n");
        sb.append("    applicationKind: ").append(this.toIndentedString((Object)this.applicationKind)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    versionName: ").append(this.toIndentedString(this.versionName)).append("\n");
        sb.append("    eventType: ").append(this.toIndentedString((Object)this.eventType)).append("\n");
        sb.append("    eventTime: ").append(this.toIndentedString(this.eventTime)).append("\n");
        sb.append("    eventMetadata: ").append(this.toIndentedString(this.eventMetadata)).append("\n");
        sb.append("    deploymentMetadata: ").append(this.toIndentedString(this.deploymentMetadata)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in PostDeploymentEventInput is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_PROJECT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `projectKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROJECT_KEY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `environmentKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_KEY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_APPLICATION_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `applicationKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APPLICATION_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_APPLICATION_NAME) != null && !jsonObj.get(SERIALIZED_NAME_APPLICATION_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_APPLICATION_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `applicationName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APPLICATION_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_APPLICATION_KIND) != null && !jsonObj.get(SERIALIZED_NAME_APPLICATION_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_APPLICATION_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `applicationKind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_APPLICATION_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_APPLICATION_KIND) != null && !jsonObj.get(SERIALIZED_NAME_APPLICATION_KIND).isJsonNull()) {
            ApplicationKindEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_APPLICATION_KIND));
        }
        if (!jsonObj.get(SERIALIZED_NAME_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `version` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERSION_NAME) != null && !jsonObj.get(SERIALIZED_NAME_VERSION_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VERSION_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `versionName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERSION_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_EVENT_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `eventType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EVENT_TYPE).toString()));
        }
        EventTypeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_EVENT_TYPE));
    }

    public static PostDeploymentEventInput fromJson(String jsonString) throws IOException {
        return (PostDeploymentEventInput)JSON.getGson().fromJson(jsonString, PostDeploymentEventInput.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!PostDeploymentEventInput.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(PostDeploymentEventInput.class));
            return new TypeAdapter<PostDeploymentEventInput>(){

                public void write(JsonWriter out, PostDeploymentEventInput value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public PostDeploymentEventInput read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    PostDeploymentEventInput.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    PostDeploymentEventInput instance = (PostDeploymentEventInput)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EventTypeEnum {
        STARTED("started"),
        FAILED("failed"),
        FINISHED("finished"),
        CUSTOM("custom");

        private String value;

        private EventTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EventTypeEnum fromValue(String value) {
            for (EventTypeEnum b : EventTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            EventTypeEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<EventTypeEnum> {
            public void write(JsonWriter jsonWriter, EventTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EventTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EventTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ApplicationKindEnum {
        SERVER("server"),
        BROWSER("browser"),
        MOBILE("mobile");

        private String value;

        private ApplicationKindEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ApplicationKindEnum fromValue(String value) {
            for (ApplicationKindEnum b : ApplicationKindEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            ApplicationKindEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<ApplicationKindEnum> {
            public void write(JsonWriter jsonWriter, ApplicationKindEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ApplicationKindEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ApplicationKindEnum.fromValue(value);
            }
        }
    }
}

