/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Clause;
import com.launchdarkly.api.model.Rollout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Rule {
    public static final String SERIALIZED_NAME_ID = "_id";
    @SerializedName(value="_id")
    @Nullable
    private String id;
    public static final String SERIALIZED_NAME_VARIATION = "variation";
    @SerializedName(value="variation")
    @Nullable
    private Integer variation;
    public static final String SERIALIZED_NAME_ROLLOUT = "rollout";
    @SerializedName(value="rollout")
    @Nullable
    private Rollout rollout;
    public static final String SERIALIZED_NAME_CLAUSES = "clauses";
    @SerializedName(value="clauses")
    @Nonnull
    private List<Clause> clauses = new ArrayList<Clause>();
    public static final String SERIALIZED_NAME_TRACK_EVENTS = "trackEvents";
    @SerializedName(value="trackEvents")
    @Nonnull
    private Boolean trackEvents;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    @Nullable
    private String description;
    public static final String SERIALIZED_NAME_REF = "ref";
    @SerializedName(value="ref")
    @Nullable
    private String ref;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("_id", "variation", "rollout", "clauses", "trackEvents", "description", "ref"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("clauses", "trackEvents"));

    public Rule id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public Rule variation(@Nullable Integer variation) {
        this.variation = variation;
        return this;
    }

    @Nullable
    public Integer getVariation() {
        return this.variation;
    }

    public void setVariation(@Nullable Integer variation) {
        this.variation = variation;
    }

    public Rule rollout(@Nullable Rollout rollout) {
        this.rollout = rollout;
        return this;
    }

    @Nullable
    public Rollout getRollout() {
        return this.rollout;
    }

    public void setRollout(@Nullable Rollout rollout) {
        this.rollout = rollout;
    }

    public Rule clauses(@Nonnull List<Clause> clauses) {
        this.clauses = clauses;
        return this;
    }

    public Rule addClausesItem(Clause clausesItem) {
        if (this.clauses == null) {
            this.clauses = new ArrayList<Clause>();
        }
        this.clauses.add(clausesItem);
        return this;
    }

    @Nonnull
    public List<Clause> getClauses() {
        return this.clauses;
    }

    public void setClauses(@Nonnull List<Clause> clauses) {
        this.clauses = clauses;
    }

    public Rule trackEvents(@Nonnull Boolean trackEvents) {
        this.trackEvents = trackEvents;
        return this;
    }

    @Nonnull
    public Boolean getTrackEvents() {
        return this.trackEvents;
    }

    public void setTrackEvents(@Nonnull Boolean trackEvents) {
        this.trackEvents = trackEvents;
    }

    public Rule description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public Rule ref(@Nullable String ref) {
        this.ref = ref;
        return this;
    }

    @Nullable
    public String getRef() {
        return this.ref;
    }

    public void setRef(@Nullable String ref) {
        this.ref = ref;
    }

    public Rule putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rule rule = (Rule)o;
        return Objects.equals(this.id, rule.id) && Objects.equals(this.variation, rule.variation) && Objects.equals(this.rollout, rule.rollout) && Objects.equals(this.clauses, rule.clauses) && Objects.equals(this.trackEvents, rule.trackEvents) && Objects.equals(this.description, rule.description) && Objects.equals(this.ref, rule.ref) && Objects.equals(this.additionalProperties, rule.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.variation, this.rollout, this.clauses, this.trackEvents, this.description, this.ref, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Rule {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    variation: ").append(this.toIndentedString(this.variation)).append("\n");
        sb.append("    rollout: ").append(this.toIndentedString(this.rollout)).append("\n");
        sb.append("    clauses: ").append(this.toIndentedString(this.clauses)).append("\n");
        sb.append("    trackEvents: ").append(this.toIndentedString(this.trackEvents)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    ref: ").append(this.toIndentedString(this.ref)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in Rule is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROLLOUT) != null && !jsonObj.get(SERIALIZED_NAME_ROLLOUT).isJsonNull()) {
            Rollout.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ROLLOUT));
        }
        if (!jsonObj.get(SERIALIZED_NAME_CLAUSES).isJsonArray()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `clauses` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CLAUSES).toString()));
        }
        JsonArray jsonArrayclauses = jsonObj.getAsJsonArray(SERIALIZED_NAME_CLAUSES);
        for (int i = 0; i < jsonArrayclauses.size(); ++i) {
            Clause.validateJsonElement(jsonArrayclauses.get(i));
        }
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REF) != null && !jsonObj.get(SERIALIZED_NAME_REF).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REF).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `ref` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REF).toString()));
        }
    }

    public static Rule fromJson(String jsonString) throws IOException {
        return (Rule)JSON.getGson().fromJson(jsonString, Rule.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Rule.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Rule.class));
            return new TypeAdapter<Rule>(){

                public void write(JsonWriter out, Rule value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public Rule read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Rule.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    Rule instance = (Rule)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

