/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.Access;
import com.launchdarkly.api.model.Link;
import com.launchdarkly.api.model.TeamCustomRoles;
import com.launchdarkly.api.model.TeamMaintainers;
import com.launchdarkly.api.model.TeamMembers;
import com.launchdarkly.api.model.TeamProjects;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public class Team {
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    @Nullable
    private String description;
    public static final String SERIALIZED_NAME_KEY = "key";
    @SerializedName(value="key")
    @Nullable
    private String key;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nullable
    private String name;
    public static final String SERIALIZED_NAME_ACCESS = "_access";
    @SerializedName(value="_access")
    @Nullable
    private Access access;
    public static final String SERIALIZED_NAME_CREATION_DATE = "_creationDate";
    @SerializedName(value="_creationDate")
    @Nullable
    private Long creationDate;
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    @Nullable
    private Map<String, Link> links = new HashMap<String, Link>();
    public static final String SERIALIZED_NAME_LAST_MODIFIED = "_lastModified";
    @SerializedName(value="_lastModified")
    @Nullable
    private Long lastModified;
    public static final String SERIALIZED_NAME_VERSION = "_version";
    @SerializedName(value="_version")
    @Nullable
    private Integer version;
    public static final String SERIALIZED_NAME_IDP_SYNCED = "_idpSynced";
    @SerializedName(value="_idpSynced")
    @Nullable
    private Boolean idpSynced;
    public static final String SERIALIZED_NAME_ROLE_ATTRIBUTES = "roleAttributes";
    @SerializedName(value="roleAttributes")
    @Nullable
    private Map<String, List<String>> roleAttributes = new HashMap<String, List<String>>();
    public static final String SERIALIZED_NAME_ROLES = "roles";
    @SerializedName(value="roles")
    @Nullable
    private TeamCustomRoles roles;
    public static final String SERIALIZED_NAME_MEMBERS = "members";
    @SerializedName(value="members")
    @Nullable
    private TeamMembers members;
    public static final String SERIALIZED_NAME_PROJECTS = "projects";
    @SerializedName(value="projects")
    @Nullable
    private TeamProjects projects;
    public static final String SERIALIZED_NAME_MAINTAINERS = "maintainers";
    @SerializedName(value="maintainers")
    @Nullable
    private TeamMaintainers maintainers;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("description", "key", "name", "_access", "_creationDate", "_links", "_lastModified", "_version", "_idpSynced", "roleAttributes", "roles", "members", "projects", "maintainers"));
    public static HashSet<String> openapiRequiredFields = new HashSet(0);

    public Team description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public Team key(@Nullable String key) {
        this.key = key;
        return this;
    }

    @Nullable
    public String getKey() {
        return this.key;
    }

    public void setKey(@Nullable String key) {
        this.key = key;
    }

    public Team name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public Team access(@Nullable Access access) {
        this.access = access;
        return this;
    }

    @Nullable
    public Access getAccess() {
        return this.access;
    }

    public void setAccess(@Nullable Access access) {
        this.access = access;
    }

    public Team creationDate(@Nullable Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Nullable
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(@Nullable Long creationDate) {
        this.creationDate = creationDate;
    }

    public Team links(@Nullable Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public Team putLinksItem(String key, Link linksItem) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(key, linksItem);
        return this;
    }

    @Nullable
    public Map<String, Link> getLinks() {
        return this.links;
    }

    public void setLinks(@Nullable Map<String, Link> links) {
        this.links = links;
    }

    public Team lastModified(@Nullable Long lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @Nullable
    public Long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(@Nullable Long lastModified) {
        this.lastModified = lastModified;
    }

    public Team version(@Nullable Integer version) {
        this.version = version;
        return this;
    }

    @Nullable
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable Integer version) {
        this.version = version;
    }

    public Team idpSynced(@Nullable Boolean idpSynced) {
        this.idpSynced = idpSynced;
        return this;
    }

    @Nullable
    public Boolean getIdpSynced() {
        return this.idpSynced;
    }

    public void setIdpSynced(@Nullable Boolean idpSynced) {
        this.idpSynced = idpSynced;
    }

    public Team roleAttributes(@Nullable Map<String, List<String>> roleAttributes) {
        this.roleAttributes = roleAttributes;
        return this;
    }

    public Team putRoleAttributesItem(String key, List<String> roleAttributesItem) {
        if (this.roleAttributes == null) {
            this.roleAttributes = new HashMap<String, List<String>>();
        }
        this.roleAttributes.put(key, roleAttributesItem);
        return this;
    }

    @Nullable
    public Map<String, List<String>> getRoleAttributes() {
        return this.roleAttributes;
    }

    public void setRoleAttributes(@Nullable Map<String, List<String>> roleAttributes) {
        this.roleAttributes = roleAttributes;
    }

    public Team roles(@Nullable TeamCustomRoles roles) {
        this.roles = roles;
        return this;
    }

    @Nullable
    public TeamCustomRoles getRoles() {
        return this.roles;
    }

    public void setRoles(@Nullable TeamCustomRoles roles) {
        this.roles = roles;
    }

    public Team members(@Nullable TeamMembers members) {
        this.members = members;
        return this;
    }

    @Nullable
    public TeamMembers getMembers() {
        return this.members;
    }

    public void setMembers(@Nullable TeamMembers members) {
        this.members = members;
    }

    public Team projects(@Nullable TeamProjects projects) {
        this.projects = projects;
        return this;
    }

    @Nullable
    public TeamProjects getProjects() {
        return this.projects;
    }

    public void setProjects(@Nullable TeamProjects projects) {
        this.projects = projects;
    }

    public Team maintainers(@Nullable TeamMaintainers maintainers) {
        this.maintainers = maintainers;
        return this;
    }

    @Nullable
    public TeamMaintainers getMaintainers() {
        return this.maintainers;
    }

    public void setMaintainers(@Nullable TeamMaintainers maintainers) {
        this.maintainers = maintainers;
    }

    public Team putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Team team = (Team)o;
        return Objects.equals(this.description, team.description) && Objects.equals(this.key, team.key) && Objects.equals(this.name, team.name) && Objects.equals(this.access, team.access) && Objects.equals(this.creationDate, team.creationDate) && Objects.equals(this.links, team.links) && Objects.equals(this.lastModified, team.lastModified) && Objects.equals(this.version, team.version) && Objects.equals(this.idpSynced, team.idpSynced) && Objects.equals(this.roleAttributes, team.roleAttributes) && Objects.equals(this.roles, team.roles) && Objects.equals(this.members, team.members) && Objects.equals(this.projects, team.projects) && Objects.equals(this.maintainers, team.maintainers) && Objects.equals(this.additionalProperties, team.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.key, this.name, this.access, this.creationDate, this.links, this.lastModified, this.version, this.idpSynced, this.roleAttributes, this.roles, this.members, this.projects, this.maintainers, this.additionalProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Team {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    access: ").append(this.toIndentedString(this.access)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    lastModified: ").append(this.toIndentedString(this.lastModified)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    idpSynced: ").append(this.toIndentedString(this.idpSynced)).append("\n");
        sb.append("    roleAttributes: ").append(this.toIndentedString(this.roleAttributes)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    members: ").append(this.toIndentedString(this.members)).append("\n");
        sb.append("    projects: ").append(this.toIndentedString(this.projects)).append("\n");
        sb.append("    maintainers: ").append(this.toIndentedString(this.maintainers)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in Team is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_DESCRIPTION) != null && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DESCRIPTION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `description` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DESCRIPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KEY) != null && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `key` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ACCESS) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS).isJsonNull()) {
            Access.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ACCESS));
        }
        if (jsonObj.get(SERIALIZED_NAME_ROLES) != null && !jsonObj.get(SERIALIZED_NAME_ROLES).isJsonNull()) {
            TeamCustomRoles.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ROLES));
        }
        if (jsonObj.get(SERIALIZED_NAME_MEMBERS) != null && !jsonObj.get(SERIALIZED_NAME_MEMBERS).isJsonNull()) {
            TeamMembers.validateJsonElement(jsonObj.get(SERIALIZED_NAME_MEMBERS));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROJECTS) != null && !jsonObj.get(SERIALIZED_NAME_PROJECTS).isJsonNull()) {
            TeamProjects.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PROJECTS));
        }
        if (jsonObj.get(SERIALIZED_NAME_MAINTAINERS) != null && !jsonObj.get(SERIALIZED_NAME_MAINTAINERS).isJsonNull()) {
            TeamMaintainers.validateJsonElement(jsonObj.get(SERIALIZED_NAME_MAINTAINERS));
        }
    }

    public static Team fromJson(String jsonString) throws IOException {
        return (Team)JSON.getGson().fromJson(jsonString, Team.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!Team.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Team.class));
            return new TypeAdapter<Team>(){

                public void write(JsonWriter out, Team value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public Team read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Team.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    Team instance = (Team)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }
}

