/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.JSON;
import com.launchdarkly.api.model.ParentAndSelfLinks;
import com.launchdarkly.api.model.ViewLinkedResourceDetails;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ViewLinkedResource {
    public static final String SERIALIZED_NAME_LINKS = "_links";
    @SerializedName(value="_links")
    @Nonnull
    private ParentAndSelfLinks links;
    public static final String SERIALIZED_NAME_RESOURCE_KEY = "resourceKey";
    @SerializedName(value="resourceKey")
    @Nonnull
    private String resourceKey;
    public static final String SERIALIZED_NAME_ENVIRONMENT_ID = "environmentId";
    @SerializedName(value="environmentId")
    @Nullable
    private String environmentId;
    public static final String SERIALIZED_NAME_ENVIRONMENT_KEY = "environmentKey";
    @SerializedName(value="environmentKey")
    @Nullable
    private String environmentKey;
    public static final String SERIALIZED_NAME_RESOURCE_TYPE = "resourceType";
    @SerializedName(value="resourceType")
    @Nonnull
    private ResourceTypeEnum resourceType;
    public static final String SERIALIZED_NAME_LINKED_AT = "linkedAt";
    @SerializedName(value="linkedAt")
    @Nonnull
    private Long linkedAt;
    public static final String SERIALIZED_NAME_RESOURCE_DETAILS = "resourceDetails";
    @SerializedName(value="resourceDetails")
    @Nullable
    private ViewLinkedResourceDetails resourceDetails;
    private Map<String, Object> additionalProperties;
    public static HashSet<String> openapiFields = new HashSet<String>(Arrays.asList("_links", "resourceKey", "environmentId", "environmentKey", "resourceType", "linkedAt", "resourceDetails"));
    public static HashSet<String> openapiRequiredFields = new HashSet<String>(Arrays.asList("_links", "resourceKey", "resourceType", "linkedAt"));

    public ViewLinkedResource links(@Nonnull ParentAndSelfLinks links) {
        this.links = links;
        return this;
    }

    @Nonnull
    public ParentAndSelfLinks getLinks() {
        return this.links;
    }

    public void setLinks(@Nonnull ParentAndSelfLinks links) {
        this.links = links;
    }

    public ViewLinkedResource resourceKey(@Nonnull String resourceKey) {
        this.resourceKey = resourceKey;
        return this;
    }

    @Nonnull
    public String getResourceKey() {
        return this.resourceKey;
    }

    public void setResourceKey(@Nonnull String resourceKey) {
        this.resourceKey = resourceKey;
    }

    public ViewLinkedResource environmentId(@Nullable String environmentId) {
        this.environmentId = environmentId;
        return this;
    }

    @Nullable
    public String getEnvironmentId() {
        return this.environmentId;
    }

    public void setEnvironmentId(@Nullable String environmentId) {
        this.environmentId = environmentId;
    }

    public ViewLinkedResource environmentKey(@Nullable String environmentKey) {
        this.environmentKey = environmentKey;
        return this;
    }

    @Nullable
    public String getEnvironmentKey() {
        return this.environmentKey;
    }

    public void setEnvironmentKey(@Nullable String environmentKey) {
        this.environmentKey = environmentKey;
    }

    public ViewLinkedResource resourceType(@Nonnull ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
        return this;
    }

    @Nonnull
    public ResourceTypeEnum getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(@Nonnull ResourceTypeEnum resourceType) {
        this.resourceType = resourceType;
    }

    public ViewLinkedResource linkedAt(@Nonnull Long linkedAt) {
        this.linkedAt = linkedAt;
        return this;
    }

    @Nonnull
    public Long getLinkedAt() {
        return this.linkedAt;
    }

    public void setLinkedAt(@Nonnull Long linkedAt) {
        this.linkedAt = linkedAt;
    }

    public ViewLinkedResource resourceDetails(@Nullable ViewLinkedResourceDetails resourceDetails) {
        this.resourceDetails = resourceDetails;
        return this;
    }

    @Nullable
    public ViewLinkedResourceDetails getResourceDetails() {
        return this.resourceDetails;
    }

    public void setResourceDetails(@Nullable ViewLinkedResourceDetails resourceDetails) {
        this.resourceDetails = resourceDetails;
    }

    public ViewLinkedResource putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewLinkedResource viewLinkedResource = (ViewLinkedResource)o;
        return Objects.equals(this.links, viewLinkedResource.links) && Objects.equals(this.resourceKey, viewLinkedResource.resourceKey) && Objects.equals(this.environmentId, viewLinkedResource.environmentId) && Objects.equals(this.environmentKey, viewLinkedResource.environmentKey) && Objects.equals((Object)this.resourceType, (Object)viewLinkedResource.resourceType) && Objects.equals(this.linkedAt, viewLinkedResource.linkedAt) && Objects.equals(this.resourceDetails, viewLinkedResource.resourceDetails) && Objects.equals(this.additionalProperties, viewLinkedResource.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.links, this.resourceKey, this.environmentId, this.environmentKey, this.resourceType, this.linkedAt, this.resourceDetails, this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ViewLinkedResource {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    resourceKey: ").append(this.toIndentedString(this.resourceKey)).append("\n");
        sb.append("    environmentId: ").append(this.toIndentedString(this.environmentId)).append("\n");
        sb.append("    environmentKey: ").append(this.toIndentedString(this.environmentKey)).append("\n");
        sb.append("    resourceType: ").append(this.toIndentedString((Object)this.resourceType)).append("\n");
        sb.append("    linkedAt: ").append(this.toIndentedString(this.linkedAt)).append("\n");
        sb.append("    resourceDetails: ").append(this.toIndentedString(this.resourceDetails)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field(s) %s in ViewLinkedResource is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format(Locale.ROOT, "The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        ParentAndSelfLinks.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LINKS));
        if (!jsonObj.get(SERIALIZED_NAME_RESOURCE_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `resourceKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_KEY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_ID) != null && !jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `environmentId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_KEY) != null && !jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_KEY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_KEY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `environmentKey` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENVIRONMENT_KEY).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Expected the field `resourceType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE).toString()));
        }
        ResourceTypeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RESOURCE_TYPE));
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_DETAILS) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_DETAILS).isJsonNull()) {
            ViewLinkedResourceDetails.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RESOURCE_DETAILS));
        }
    }

    public static ViewLinkedResource fromJson(String jsonString) throws IOException {
        return (ViewLinkedResource)JSON.getGson().fromJson(jsonString, ViewLinkedResource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(final Gson gson, TypeToken<T> type) {
            if (!ViewLinkedResource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ViewLinkedResource.class));
            return new TypeAdapter<ViewLinkedResource>(){

                public void write(JsonWriter out, ViewLinkedResource value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    obj.remove("additionalProperties");
                    if (value.getAdditionalProperties() != null) {
                        for (Map.Entry<String, Object> entry : value.getAdditionalProperties().entrySet()) {
                            if (entry.getValue() instanceof String) {
                                obj.addProperty(entry.getKey(), (String)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Number) {
                                obj.addProperty(entry.getKey(), (Number)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Boolean) {
                                obj.addProperty(entry.getKey(), (Boolean)entry.getValue());
                                continue;
                            }
                            if (entry.getValue() instanceof Character) {
                                obj.addProperty(entry.getKey(), (Character)entry.getValue());
                                continue;
                            }
                            JsonElement jsonElement = gson.toJsonTree(entry.getValue());
                            if (jsonElement.isJsonArray()) {
                                obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonArray());
                                continue;
                            }
                            obj.add(entry.getKey(), (JsonElement)jsonElement.getAsJsonObject());
                        }
                    }
                    elementAdapter.write(out, (Object)obj);
                }

                public ViewLinkedResource read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ViewLinkedResource.validateJsonElement(jsonElement);
                    JsonObject jsonObj = jsonElement.getAsJsonObject();
                    ViewLinkedResource instance = (ViewLinkedResource)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                    for (Map.Entry entry : jsonObj.entrySet()) {
                        if (openapiFields.contains(entry.getKey())) continue;
                        if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isString()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isNumber()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsNumber());
                                continue;
                            }
                            if (((JsonElement)entry.getValue()).getAsJsonPrimitive().isBoolean()) {
                                instance.putAdditionalProperty((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsBoolean());
                                continue;
                            }
                            throw new IllegalArgumentException(String.format(Locale.ROOT, "The field `%s` has unknown primitive type. Value: %s", entry.getKey(), ((JsonElement)entry.getValue()).toString()));
                        }
                        if (((JsonElement)entry.getValue()).isJsonArray()) {
                            instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), List.class));
                            continue;
                        }
                        instance.putAdditionalProperty((String)entry.getKey(), gson.fromJson((JsonElement)entry.getValue(), HashMap.class));
                    }
                    return instance;
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ResourceTypeEnum {
        FLAG("flag"),
        SEGMENT("segment"),
        METRIC("metric"),
        AI_CONFIG("aiConfig");

        private String value;

        private ResourceTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ResourceTypeEnum fromValue(String value) {
            for (ResourceTypeEnum b : ResourceTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            ResourceTypeEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<ResourceTypeEnum> {
            public void write(JsonWriter jsonWriter, ResourceTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ResourceTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ResourceTypeEnum.fromValue(value);
            }
        }
    }
}

