/*
 * LaunchDarkly REST API
 * Build custom integrations with the LaunchDarkly REST API
 *
 * OpenAPI spec version: 5.3.0
 * Contact: support@launchdarkly.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.launchdarkly.api.api;

import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.ProgressRequestBody;
import com.launchdarkly.api.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.launchdarkly.api.model.ApprovalRequest;
import com.launchdarkly.api.model.ApprovalRequestApplyConfigBody;
import com.launchdarkly.api.model.ApprovalRequestConfigBody;
import com.launchdarkly.api.model.ApprovalRequestReviewConfigBody;
import com.launchdarkly.api.model.ApprovalRequests;
import java.math.BigDecimal;
import com.launchdarkly.api.model.DependentFlagsByEnvironment;
import com.launchdarkly.api.model.FeatureFlag;
import com.launchdarkly.api.model.FeatureFlagBody;
import com.launchdarkly.api.model.FeatureFlagCopyBody;
import com.launchdarkly.api.model.FeatureFlagScheduledChange;
import com.launchdarkly.api.model.FeatureFlagScheduledChanges;
import com.launchdarkly.api.model.FeatureFlagScheduledChangesConflicts;
import com.launchdarkly.api.model.FeatureFlagStatus;
import com.launchdarkly.api.model.FeatureFlagStatusAcrossEnvironments;
import com.launchdarkly.api.model.FeatureFlagStatuses;
import com.launchdarkly.api.model.FeatureFlags;
import com.launchdarkly.api.model.FlagConfigScheduledChangesConflictsBody;
import com.launchdarkly.api.model.FlagConfigScheduledChangesPatchBody;
import com.launchdarkly.api.model.FlagConfigScheduledChangesPostBody;
import com.launchdarkly.api.model.MultiEnvironmentDependentFlags;
import com.launchdarkly.api.model.PatchComment;
import com.launchdarkly.api.model.UsageError;
import com.launchdarkly.api.model.UserTargetingExpirationForFlags;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FeatureFlagsApi {
    private ApiClient apiClient;

    public FeatureFlagsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FeatureFlagsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for copyFeatureFlag
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param featureFlagCopyBody Copy feature flag configurations between environments. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call copyFeatureFlagCall(String projectKey, String featureFlagKey, FeatureFlagCopyBody featureFlagCopyBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = featureFlagCopyBody;

        // create path and map variables
        String localVarPath = "/flags/{projectKey}/{featureFlagKey}/copy"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call copyFeatureFlagValidateBeforeCall(String projectKey, String featureFlagKey, FeatureFlagCopyBody featureFlagCopyBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling copyFeatureFlag(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling copyFeatureFlag(Async)");
        }
        
        // verify the required parameter 'featureFlagCopyBody' is set
        if (featureFlagCopyBody == null) {
            throw new ApiException("Missing the required parameter 'featureFlagCopyBody' when calling copyFeatureFlag(Async)");
        }
        

        com.squareup.okhttp.Call call = copyFeatureFlagCall(projectKey, featureFlagKey, featureFlagCopyBody, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Copies the feature flag configuration from one environment to the same feature flag in another environment.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param featureFlagCopyBody Copy feature flag configurations between environments. (required)
     * @return FeatureFlag
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FeatureFlag copyFeatureFlag(String projectKey, String featureFlagKey, FeatureFlagCopyBody featureFlagCopyBody) throws ApiException {
        ApiResponse<FeatureFlag> resp = copyFeatureFlagWithHttpInfo(projectKey, featureFlagKey, featureFlagCopyBody);
        return resp.getData();
    }

    /**
     * Copies the feature flag configuration from one environment to the same feature flag in another environment.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param featureFlagCopyBody Copy feature flag configurations between environments. (required)
     * @return ApiResponse&lt;FeatureFlag&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FeatureFlag> copyFeatureFlagWithHttpInfo(String projectKey, String featureFlagKey, FeatureFlagCopyBody featureFlagCopyBody) throws ApiException {
        com.squareup.okhttp.Call call = copyFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, featureFlagCopyBody, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Copies the feature flag configuration from one environment to the same feature flag in another environment. (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param featureFlagCopyBody Copy feature flag configurations between environments. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call copyFeatureFlagAsync(String projectKey, String featureFlagKey, FeatureFlagCopyBody featureFlagCopyBody, final ApiCallback<FeatureFlag> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = copyFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, featureFlagCopyBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for deleteApprovalRequest
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param approvalRequestId The approval request ID (required)
     * @param approvalRequestConfigBody Create a new approval request (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteApprovalRequestCall(String projectKey, String environmentKey, String featureFlagKey, String approvalRequestId, ApprovalRequestConfigBody approvalRequestConfigBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = approvalRequestConfigBody;

        // create path and map variables
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/approval-requests/{approvalRequestId}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()))
            .replaceAll("\\{" + "approvalRequestId" + "\\}", apiClient.escapeString(approvalRequestId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteApprovalRequestValidateBeforeCall(String projectKey, String environmentKey, String featureFlagKey, String approvalRequestId, ApprovalRequestConfigBody approvalRequestConfigBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteApprovalRequest(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling deleteApprovalRequest(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling deleteApprovalRequest(Async)");
        }
        
        // verify the required parameter 'approvalRequestId' is set
        if (approvalRequestId == null) {
            throw new ApiException("Missing the required parameter 'approvalRequestId' when calling deleteApprovalRequest(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteApprovalRequestCall(projectKey, environmentKey, featureFlagKey, approvalRequestId, approvalRequestConfigBody, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete an approval request for a feature flag config
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param approvalRequestId The approval request ID (required)
     * @param approvalRequestConfigBody Create a new approval request (optional)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteApprovalRequest(String projectKey, String environmentKey, String featureFlagKey, String approvalRequestId, ApprovalRequestConfigBody approvalRequestConfigBody) throws ApiException {
        deleteApprovalRequestWithHttpInfo(projectKey, environmentKey, featureFlagKey, approvalRequestId, approvalRequestConfigBody);
    }

    /**
     * Delete an approval request for a feature flag config
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param approvalRequestId The approval request ID (required)
     * @param approvalRequestConfigBody Create a new approval request (optional)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteApprovalRequestWithHttpInfo(String projectKey, String environmentKey, String featureFlagKey, String approvalRequestId, ApprovalRequestConfigBody approvalRequestConfigBody) throws ApiException {
        com.squareup.okhttp.Call call = deleteApprovalRequestValidateBeforeCall(projectKey, environmentKey, featureFlagKey, approvalRequestId, approvalRequestConfigBody, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete an approval request for a feature flag config (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param approvalRequestId The approval request ID (required)
     * @param approvalRequestConfigBody Create a new approval request (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteApprovalRequestAsync(String projectKey, String environmentKey, String featureFlagKey, String approvalRequestId, ApprovalRequestConfigBody approvalRequestConfigBody, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteApprovalRequestValidateBeforeCall(projectKey, environmentKey, featureFlagKey, approvalRequestId, approvalRequestConfigBody, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deleteFeatureFlag
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteFeatureFlagCall(String projectKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/flags/{projectKey}/{featureFlagKey}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteFeatureFlagValidateBeforeCall(String projectKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteFeatureFlag(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling deleteFeatureFlag(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteFeatureFlagCall(projectKey, featureFlagKey, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a feature flag in all environments. Be careful-- only delete feature flags that are no longer being used by your application.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteFeatureFlag(String projectKey, String featureFlagKey) throws ApiException {
        deleteFeatureFlagWithHttpInfo(projectKey, featureFlagKey);
    }

    /**
     * Delete a feature flag in all environments. Be careful-- only delete feature flags that are no longer being used by your application.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteFeatureFlagWithHttpInfo(String projectKey, String featureFlagKey) throws ApiException {
        com.squareup.okhttp.Call call = deleteFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a feature flag in all environments. Be careful-- only delete feature flags that are no longer being used by your application. (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteFeatureFlagAsync(String projectKey, String featureFlagKey, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for deleteFlagConfigScheduledChanges
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param scheduledChangeId The id of the scheduled change (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteFlagConfigScheduledChangesCall(String projectKey, String featureFlagKey, String environmentKey, String scheduledChangeId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/scheduled-changes/{scheduledChangeId}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()))
            .replaceAll("\\{" + "scheduledChangeId" + "\\}", apiClient.escapeString(scheduledChangeId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteFlagConfigScheduledChangesValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, String scheduledChangeId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteFlagConfigScheduledChanges(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling deleteFlagConfigScheduledChanges(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling deleteFlagConfigScheduledChanges(Async)");
        }
        
        // verify the required parameter 'scheduledChangeId' is set
        if (scheduledChangeId == null) {
            throw new ApiException("Missing the required parameter 'scheduledChangeId' when calling deleteFlagConfigScheduledChanges(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteFlagConfigScheduledChangesCall(projectKey, featureFlagKey, environmentKey, scheduledChangeId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a scheduled change on a feature flag in an environment.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param scheduledChangeId The id of the scheduled change (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteFlagConfigScheduledChanges(String projectKey, String featureFlagKey, String environmentKey, String scheduledChangeId) throws ApiException {
        deleteFlagConfigScheduledChangesWithHttpInfo(projectKey, featureFlagKey, environmentKey, scheduledChangeId);
    }

    /**
     * Delete a scheduled change on a feature flag in an environment.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param scheduledChangeId The id of the scheduled change (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteFlagConfigScheduledChangesWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey, String scheduledChangeId) throws ApiException {
        com.squareup.okhttp.Call call = deleteFlagConfigScheduledChangesValidateBeforeCall(projectKey, featureFlagKey, environmentKey, scheduledChangeId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a scheduled change on a feature flag in an environment. (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param scheduledChangeId The id of the scheduled change (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteFlagConfigScheduledChangesAsync(String projectKey, String featureFlagKey, String environmentKey, String scheduledChangeId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteFlagConfigScheduledChangesValidateBeforeCall(projectKey, featureFlagKey, environmentKey, scheduledChangeId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGet
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGetCall(String projectKey, String environmentKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/flags/{projectKey}/{environmentKey}/{featureFlagKey}/dependent-flags"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGetValidateBeforeCall(String projectKey, String environmentKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGet(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGet(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGet(Async)");
        }
        

        com.squareup.okhttp.Call call = flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGetCall(projectKey, environmentKey, featureFlagKey, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get dependent flags for the flag in the environment specified in path parameters
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @return DependentFlagsByEnvironment
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public DependentFlagsByEnvironment flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGet(String projectKey, String environmentKey, String featureFlagKey) throws ApiException {
        ApiResponse<DependentFlagsByEnvironment> resp = flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGetWithHttpInfo(projectKey, environmentKey, featureFlagKey);
        return resp.getData();
    }

    /**
     * Get dependent flags for the flag in the environment specified in path parameters
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @return ApiResponse&lt;DependentFlagsByEnvironment&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<DependentFlagsByEnvironment> flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGetWithHttpInfo(String projectKey, String environmentKey, String featureFlagKey) throws ApiException {
        com.squareup.okhttp.Call call = flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGetValidateBeforeCall(projectKey, environmentKey, featureFlagKey, null, null);
        Type localVarReturnType = new TypeToken<DependentFlagsByEnvironment>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get dependent flags for the flag in the environment specified in path parameters (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGetAsync(String projectKey, String environmentKey, String featureFlagKey, final ApiCallback<DependentFlagsByEnvironment> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGetValidateBeforeCall(projectKey, environmentKey, featureFlagKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DependentFlagsByEnvironment>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for flagsProjectKeyFeatureFlagKeyDependentFlagsGet
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call flagsProjectKeyFeatureFlagKeyDependentFlagsGetCall(String projectKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/flags/{projectKey}/{featureFlagKey}/dependent-flags"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call flagsProjectKeyFeatureFlagKeyDependentFlagsGetValidateBeforeCall(String projectKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling flagsProjectKeyFeatureFlagKeyDependentFlagsGet(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling flagsProjectKeyFeatureFlagKeyDependentFlagsGet(Async)");
        }
        

        com.squareup.okhttp.Call call = flagsProjectKeyFeatureFlagKeyDependentFlagsGetCall(projectKey, featureFlagKey, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get dependent flags across all environments for the flag specified in the path parameters
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @return MultiEnvironmentDependentFlags
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public MultiEnvironmentDependentFlags flagsProjectKeyFeatureFlagKeyDependentFlagsGet(String projectKey, String featureFlagKey) throws ApiException {
        ApiResponse<MultiEnvironmentDependentFlags> resp = flagsProjectKeyFeatureFlagKeyDependentFlagsGetWithHttpInfo(projectKey, featureFlagKey);
        return resp.getData();
    }

    /**
     * Get dependent flags across all environments for the flag specified in the path parameters
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @return ApiResponse&lt;MultiEnvironmentDependentFlags&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<MultiEnvironmentDependentFlags> flagsProjectKeyFeatureFlagKeyDependentFlagsGetWithHttpInfo(String projectKey, String featureFlagKey) throws ApiException {
        com.squareup.okhttp.Call call = flagsProjectKeyFeatureFlagKeyDependentFlagsGetValidateBeforeCall(projectKey, featureFlagKey, null, null);
        Type localVarReturnType = new TypeToken<MultiEnvironmentDependentFlags>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get dependent flags across all environments for the flag specified in the path parameters (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call flagsProjectKeyFeatureFlagKeyDependentFlagsGetAsync(String projectKey, String featureFlagKey, final ApiCallback<MultiEnvironmentDependentFlags> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = flagsProjectKeyFeatureFlagKeyDependentFlagsGetValidateBeforeCall(projectKey, featureFlagKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MultiEnvironmentDependentFlags>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getApprovalRequest
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param approvalRequestId The approval request ID (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getApprovalRequestCall(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/approval-requests/{approvalRequestId}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()))
            .replaceAll("\\{" + "approvalRequestId" + "\\}", apiClient.escapeString(approvalRequestId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getApprovalRequestValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getApprovalRequest(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getApprovalRequest(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getApprovalRequest(Async)");
        }
        
        // verify the required parameter 'approvalRequestId' is set
        if (approvalRequestId == null) {
            throw new ApiException("Missing the required parameter 'approvalRequestId' when calling getApprovalRequest(Async)");
        }
        

        com.squareup.okhttp.Call call = getApprovalRequestCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a single approval request for a feature flag config
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param approvalRequestId The approval request ID (required)
     * @return ApprovalRequests
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApprovalRequests getApprovalRequest(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId) throws ApiException {
        ApiResponse<ApprovalRequests> resp = getApprovalRequestWithHttpInfo(projectKey, featureFlagKey, environmentKey, approvalRequestId);
        return resp.getData();
    }

    /**
     * Get a single approval request for a feature flag config
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param approvalRequestId The approval request ID (required)
     * @return ApiResponse&lt;ApprovalRequests&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ApprovalRequests> getApprovalRequestWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId) throws ApiException {
        com.squareup.okhttp.Call call = getApprovalRequestValidateBeforeCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, null, null);
        Type localVarReturnType = new TypeToken<ApprovalRequests>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a single approval request for a feature flag config (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param approvalRequestId The approval request ID (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getApprovalRequestAsync(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, final ApiCallback<ApprovalRequests> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getApprovalRequestValidateBeforeCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApprovalRequests>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getApprovalRequests
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getApprovalRequestsCall(String projectKey, String featureFlagKey, String environmentKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/approval-requests"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getApprovalRequestsValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getApprovalRequests(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getApprovalRequests(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getApprovalRequests(Async)");
        }
        

        com.squareup.okhttp.Call call = getApprovalRequestsCall(projectKey, featureFlagKey, environmentKey, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get all approval requests for a feature flag config
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @return ApprovalRequests
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApprovalRequests getApprovalRequests(String projectKey, String featureFlagKey, String environmentKey) throws ApiException {
        ApiResponse<ApprovalRequests> resp = getApprovalRequestsWithHttpInfo(projectKey, featureFlagKey, environmentKey);
        return resp.getData();
    }

    /**
     * Get all approval requests for a feature flag config
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @return ApiResponse&lt;ApprovalRequests&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ApprovalRequests> getApprovalRequestsWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey) throws ApiException {
        com.squareup.okhttp.Call call = getApprovalRequestsValidateBeforeCall(projectKey, featureFlagKey, environmentKey, null, null);
        Type localVarReturnType = new TypeToken<ApprovalRequests>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all approval requests for a feature flag config (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getApprovalRequestsAsync(String projectKey, String featureFlagKey, String environmentKey, final ApiCallback<ApprovalRequests> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getApprovalRequestsValidateBeforeCall(projectKey, featureFlagKey, environmentKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApprovalRequests>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getExpiringUserTargets
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getExpiringUserTargetsCall(String projectKey, String environmentKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/flags/{projectKey}/{featureFlagKey}/expiring-user-targets/{environmentKey}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getExpiringUserTargetsValidateBeforeCall(String projectKey, String environmentKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getExpiringUserTargets(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getExpiringUserTargets(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getExpiringUserTargets(Async)");
        }
        

        com.squareup.okhttp.Call call = getExpiringUserTargetsCall(projectKey, environmentKey, featureFlagKey, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get expiring user targets for feature flag
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @return UserTargetingExpirationForFlags
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UserTargetingExpirationForFlags getExpiringUserTargets(String projectKey, String environmentKey, String featureFlagKey) throws ApiException {
        ApiResponse<UserTargetingExpirationForFlags> resp = getExpiringUserTargetsWithHttpInfo(projectKey, environmentKey, featureFlagKey);
        return resp.getData();
    }

    /**
     * Get expiring user targets for feature flag
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @return ApiResponse&lt;UserTargetingExpirationForFlags&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UserTargetingExpirationForFlags> getExpiringUserTargetsWithHttpInfo(String projectKey, String environmentKey, String featureFlagKey) throws ApiException {
        com.squareup.okhttp.Call call = getExpiringUserTargetsValidateBeforeCall(projectKey, environmentKey, featureFlagKey, null, null);
        Type localVarReturnType = new TypeToken<UserTargetingExpirationForFlags>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get expiring user targets for feature flag (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getExpiringUserTargetsAsync(String projectKey, String environmentKey, String featureFlagKey, final ApiCallback<UserTargetingExpirationForFlags> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getExpiringUserTargetsValidateBeforeCall(projectKey, environmentKey, featureFlagKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserTargetingExpirationForFlags>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getFeatureFlag
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param env By default, each feature will include configurations for each environment. You can filter environments with the env query parameter. For example, setting env&#x3D;[\&quot;production\&quot;] will restrict the returned configurations to just your production environment. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFeatureFlagCall(String projectKey, String featureFlagKey, List<String> env, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/flags/{projectKey}/{featureFlagKey}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (env != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "env", env));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFeatureFlagValidateBeforeCall(String projectKey, String featureFlagKey, List<String> env, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFeatureFlag(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getFeatureFlag(Async)");
        }
        

        com.squareup.okhttp.Call call = getFeatureFlagCall(projectKey, featureFlagKey, env, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a single feature flag by key.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param env By default, each feature will include configurations for each environment. You can filter environments with the env query parameter. For example, setting env&#x3D;[\&quot;production\&quot;] will restrict the returned configurations to just your production environment. (optional)
     * @return FeatureFlag
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FeatureFlag getFeatureFlag(String projectKey, String featureFlagKey, List<String> env) throws ApiException {
        ApiResponse<FeatureFlag> resp = getFeatureFlagWithHttpInfo(projectKey, featureFlagKey, env);
        return resp.getData();
    }

    /**
     * Get a single feature flag by key.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param env By default, each feature will include configurations for each environment. You can filter environments with the env query parameter. For example, setting env&#x3D;[\&quot;production\&quot;] will restrict the returned configurations to just your production environment. (optional)
     * @return ApiResponse&lt;FeatureFlag&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FeatureFlag> getFeatureFlagWithHttpInfo(String projectKey, String featureFlagKey, List<String> env) throws ApiException {
        com.squareup.okhttp.Call call = getFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, env, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a single feature flag by key. (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param env By default, each feature will include configurations for each environment. You can filter environments with the env query parameter. For example, setting env&#x3D;[\&quot;production\&quot;] will restrict the returned configurations to just your production environment. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFeatureFlagAsync(String projectKey, String featureFlagKey, List<String> env, final ApiCallback<FeatureFlag> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, env, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getFeatureFlagStatus
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFeatureFlagStatusCall(String projectKey, String environmentKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/flag-statuses/{projectKey}/{environmentKey}/{featureFlagKey}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFeatureFlagStatusValidateBeforeCall(String projectKey, String environmentKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFeatureFlagStatus(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getFeatureFlagStatus(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getFeatureFlagStatus(Async)");
        }
        

        com.squareup.okhttp.Call call = getFeatureFlagStatusCall(projectKey, environmentKey, featureFlagKey, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get the status for a particular feature flag.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @return FeatureFlagStatus
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FeatureFlagStatus getFeatureFlagStatus(String projectKey, String environmentKey, String featureFlagKey) throws ApiException {
        ApiResponse<FeatureFlagStatus> resp = getFeatureFlagStatusWithHttpInfo(projectKey, environmentKey, featureFlagKey);
        return resp.getData();
    }

    /**
     * Get the status for a particular feature flag.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @return ApiResponse&lt;FeatureFlagStatus&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FeatureFlagStatus> getFeatureFlagStatusWithHttpInfo(String projectKey, String environmentKey, String featureFlagKey) throws ApiException {
        com.squareup.okhttp.Call call = getFeatureFlagStatusValidateBeforeCall(projectKey, environmentKey, featureFlagKey, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlagStatus>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get the status for a particular feature flag. (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFeatureFlagStatusAsync(String projectKey, String environmentKey, String featureFlagKey, final ApiCallback<FeatureFlagStatus> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFeatureFlagStatusValidateBeforeCall(projectKey, environmentKey, featureFlagKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlagStatus>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getFeatureFlagStatusAcrossEnvironments
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFeatureFlagStatusAcrossEnvironmentsCall(String projectKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/flag-status/{projectKey}/{featureFlagKey}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFeatureFlagStatusAcrossEnvironmentsValidateBeforeCall(String projectKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFeatureFlagStatusAcrossEnvironments(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getFeatureFlagStatusAcrossEnvironments(Async)");
        }
        

        com.squareup.okhttp.Call call = getFeatureFlagStatusAcrossEnvironmentsCall(projectKey, featureFlagKey, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get the status for a particular feature flag across environments
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @return FeatureFlagStatusAcrossEnvironments
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FeatureFlagStatusAcrossEnvironments getFeatureFlagStatusAcrossEnvironments(String projectKey, String featureFlagKey) throws ApiException {
        ApiResponse<FeatureFlagStatusAcrossEnvironments> resp = getFeatureFlagStatusAcrossEnvironmentsWithHttpInfo(projectKey, featureFlagKey);
        return resp.getData();
    }

    /**
     * Get the status for a particular feature flag across environments
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @return ApiResponse&lt;FeatureFlagStatusAcrossEnvironments&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FeatureFlagStatusAcrossEnvironments> getFeatureFlagStatusAcrossEnvironmentsWithHttpInfo(String projectKey, String featureFlagKey) throws ApiException {
        com.squareup.okhttp.Call call = getFeatureFlagStatusAcrossEnvironmentsValidateBeforeCall(projectKey, featureFlagKey, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlagStatusAcrossEnvironments>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get the status for a particular feature flag across environments (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFeatureFlagStatusAcrossEnvironmentsAsync(String projectKey, String featureFlagKey, final ApiCallback<FeatureFlagStatusAcrossEnvironments> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFeatureFlagStatusAcrossEnvironmentsValidateBeforeCall(projectKey, featureFlagKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlagStatusAcrossEnvironments>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getFeatureFlagStatuses
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFeatureFlagStatusesCall(String projectKey, String environmentKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/flag-statuses/{projectKey}/{environmentKey}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFeatureFlagStatusesValidateBeforeCall(String projectKey, String environmentKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFeatureFlagStatuses(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getFeatureFlagStatuses(Async)");
        }
        

        com.squareup.okhttp.Call call = getFeatureFlagStatusesCall(projectKey, environmentKey, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a list of statuses for all feature flags. The status includes the last time the feature flag was requested, as well as the state of the flag.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @return FeatureFlagStatuses
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FeatureFlagStatuses getFeatureFlagStatuses(String projectKey, String environmentKey) throws ApiException {
        ApiResponse<FeatureFlagStatuses> resp = getFeatureFlagStatusesWithHttpInfo(projectKey, environmentKey);
        return resp.getData();
    }

    /**
     * Get a list of statuses for all feature flags. The status includes the last time the feature flag was requested, as well as the state of the flag.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @return ApiResponse&lt;FeatureFlagStatuses&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FeatureFlagStatuses> getFeatureFlagStatusesWithHttpInfo(String projectKey, String environmentKey) throws ApiException {
        com.squareup.okhttp.Call call = getFeatureFlagStatusesValidateBeforeCall(projectKey, environmentKey, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlagStatuses>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a list of statuses for all feature flags. The status includes the last time the feature flag was requested, as well as the state of the flag. (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFeatureFlagStatusesAsync(String projectKey, String environmentKey, final ApiCallback<FeatureFlagStatuses> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFeatureFlagStatusesValidateBeforeCall(projectKey, environmentKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlagStatuses>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getFeatureFlags
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param env By default, each feature will include configurations for each environment. You can filter environments with the env query parameter. For example, setting env&#x3D;[\&quot;production\&quot;] will restrict the returned configurations to just your production environment. (optional)
     * @param summary By default in api version &gt;&#x3D; 1, flags will _not_ include their list of prerequisites, targets or rules.  Set summary&#x3D;0 to include these fields for each flag returned. (optional)
     * @param archived When set to 1, only archived flags will be included in the list of flags returned.  By default, archived flags are not included in the list of flags. (optional)
     * @param limit The number of objects to return. Defaults to -1, which returns everything. (optional)
     * @param offset Where to start in the list. This is for use with pagination. For example, an offset of 10 would skip the first 10 items and then return the next limit items. (optional)
     * @param filter A comma-separated list of filters. Each filter is of the form field:value. (optional)
     * @param sort A comma-separated list of fields to sort by. A field prefixed by a - will be sorted in descending order. (optional)
     * @param tag Filter by tag. A tag can be used to group flags across projects. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFeatureFlagsCall(String projectKey, List<String> env, Boolean summary, Boolean archived, BigDecimal limit, BigDecimal offset, String filter, String sort, String tag, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/flags/{projectKey}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (env != null)
        localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "env", env));
        if (summary != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("summary", summary));
        if (archived != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("archived", archived));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("limit", limit));
        if (offset != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("offset", offset));
        if (filter != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("filter", filter));
        if (sort != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("sort", sort));
        if (tag != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("tag", tag));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFeatureFlagsValidateBeforeCall(String projectKey, List<String> env, Boolean summary, Boolean archived, BigDecimal limit, BigDecimal offset, String filter, String sort, String tag, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFeatureFlags(Async)");
        }
        

        com.squareup.okhttp.Call call = getFeatureFlagsCall(projectKey, env, summary, archived, limit, offset, filter, sort, tag, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a list of all features in the given project.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param env By default, each feature will include configurations for each environment. You can filter environments with the env query parameter. For example, setting env&#x3D;[\&quot;production\&quot;] will restrict the returned configurations to just your production environment. (optional)
     * @param summary By default in api version &gt;&#x3D; 1, flags will _not_ include their list of prerequisites, targets or rules.  Set summary&#x3D;0 to include these fields for each flag returned. (optional)
     * @param archived When set to 1, only archived flags will be included in the list of flags returned.  By default, archived flags are not included in the list of flags. (optional)
     * @param limit The number of objects to return. Defaults to -1, which returns everything. (optional)
     * @param offset Where to start in the list. This is for use with pagination. For example, an offset of 10 would skip the first 10 items and then return the next limit items. (optional)
     * @param filter A comma-separated list of filters. Each filter is of the form field:value. (optional)
     * @param sort A comma-separated list of fields to sort by. A field prefixed by a - will be sorted in descending order. (optional)
     * @param tag Filter by tag. A tag can be used to group flags across projects. (optional)
     * @return FeatureFlags
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FeatureFlags getFeatureFlags(String projectKey, List<String> env, Boolean summary, Boolean archived, BigDecimal limit, BigDecimal offset, String filter, String sort, String tag) throws ApiException {
        ApiResponse<FeatureFlags> resp = getFeatureFlagsWithHttpInfo(projectKey, env, summary, archived, limit, offset, filter, sort, tag);
        return resp.getData();
    }

    /**
     * Get a list of all features in the given project.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param env By default, each feature will include configurations for each environment. You can filter environments with the env query parameter. For example, setting env&#x3D;[\&quot;production\&quot;] will restrict the returned configurations to just your production environment. (optional)
     * @param summary By default in api version &gt;&#x3D; 1, flags will _not_ include their list of prerequisites, targets or rules.  Set summary&#x3D;0 to include these fields for each flag returned. (optional)
     * @param archived When set to 1, only archived flags will be included in the list of flags returned.  By default, archived flags are not included in the list of flags. (optional)
     * @param limit The number of objects to return. Defaults to -1, which returns everything. (optional)
     * @param offset Where to start in the list. This is for use with pagination. For example, an offset of 10 would skip the first 10 items and then return the next limit items. (optional)
     * @param filter A comma-separated list of filters. Each filter is of the form field:value. (optional)
     * @param sort A comma-separated list of fields to sort by. A field prefixed by a - will be sorted in descending order. (optional)
     * @param tag Filter by tag. A tag can be used to group flags across projects. (optional)
     * @return ApiResponse&lt;FeatureFlags&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FeatureFlags> getFeatureFlagsWithHttpInfo(String projectKey, List<String> env, Boolean summary, Boolean archived, BigDecimal limit, BigDecimal offset, String filter, String sort, String tag) throws ApiException {
        com.squareup.okhttp.Call call = getFeatureFlagsValidateBeforeCall(projectKey, env, summary, archived, limit, offset, filter, sort, tag, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlags>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a list of all features in the given project. (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param env By default, each feature will include configurations for each environment. You can filter environments with the env query parameter. For example, setting env&#x3D;[\&quot;production\&quot;] will restrict the returned configurations to just your production environment. (optional)
     * @param summary By default in api version &gt;&#x3D; 1, flags will _not_ include their list of prerequisites, targets or rules.  Set summary&#x3D;0 to include these fields for each flag returned. (optional)
     * @param archived When set to 1, only archived flags will be included in the list of flags returned.  By default, archived flags are not included in the list of flags. (optional)
     * @param limit The number of objects to return. Defaults to -1, which returns everything. (optional)
     * @param offset Where to start in the list. This is for use with pagination. For example, an offset of 10 would skip the first 10 items and then return the next limit items. (optional)
     * @param filter A comma-separated list of filters. Each filter is of the form field:value. (optional)
     * @param sort A comma-separated list of fields to sort by. A field prefixed by a - will be sorted in descending order. (optional)
     * @param tag Filter by tag. A tag can be used to group flags across projects. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFeatureFlagsAsync(String projectKey, List<String> env, Boolean summary, Boolean archived, BigDecimal limit, BigDecimal offset, String filter, String sort, String tag, final ApiCallback<FeatureFlags> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFeatureFlagsValidateBeforeCall(projectKey, env, summary, archived, limit, offset, filter, sort, tag, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlags>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getFlagConfigScheduledChange
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param scheduledChangeId The id of the scheduled change (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFlagConfigScheduledChangeCall(String projectKey, String featureFlagKey, String environmentKey, String scheduledChangeId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/scheduled-changes/{scheduledChangeId}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()))
            .replaceAll("\\{" + "scheduledChangeId" + "\\}", apiClient.escapeString(scheduledChangeId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFlagConfigScheduledChangeValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, String scheduledChangeId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFlagConfigScheduledChange(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getFlagConfigScheduledChange(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getFlagConfigScheduledChange(Async)");
        }
        
        // verify the required parameter 'scheduledChangeId' is set
        if (scheduledChangeId == null) {
            throw new ApiException("Missing the required parameter 'scheduledChangeId' when calling getFlagConfigScheduledChange(Async)");
        }
        

        com.squareup.okhttp.Call call = getFlagConfigScheduledChangeCall(projectKey, featureFlagKey, environmentKey, scheduledChangeId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a scheduled change on a feature flag by id.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param scheduledChangeId The id of the scheduled change (required)
     * @return FeatureFlagScheduledChange
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FeatureFlagScheduledChange getFlagConfigScheduledChange(String projectKey, String featureFlagKey, String environmentKey, String scheduledChangeId) throws ApiException {
        ApiResponse<FeatureFlagScheduledChange> resp = getFlagConfigScheduledChangeWithHttpInfo(projectKey, featureFlagKey, environmentKey, scheduledChangeId);
        return resp.getData();
    }

    /**
     * Get a scheduled change on a feature flag by id.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param scheduledChangeId The id of the scheduled change (required)
     * @return ApiResponse&lt;FeatureFlagScheduledChange&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FeatureFlagScheduledChange> getFlagConfigScheduledChangeWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey, String scheduledChangeId) throws ApiException {
        com.squareup.okhttp.Call call = getFlagConfigScheduledChangeValidateBeforeCall(projectKey, featureFlagKey, environmentKey, scheduledChangeId, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlagScheduledChange>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a scheduled change on a feature flag by id. (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param scheduledChangeId The id of the scheduled change (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFlagConfigScheduledChangeAsync(String projectKey, String featureFlagKey, String environmentKey, String scheduledChangeId, final ApiCallback<FeatureFlagScheduledChange> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFlagConfigScheduledChangeValidateBeforeCall(projectKey, featureFlagKey, environmentKey, scheduledChangeId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlagScheduledChange>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getFlagConfigScheduledChanges
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFlagConfigScheduledChangesCall(String projectKey, String featureFlagKey, String environmentKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/scheduled-changes"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFlagConfigScheduledChangesValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFlagConfigScheduledChanges(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getFlagConfigScheduledChanges(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getFlagConfigScheduledChanges(Async)");
        }
        

        com.squareup.okhttp.Call call = getFlagConfigScheduledChangesCall(projectKey, featureFlagKey, environmentKey, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get all scheduled workflows for a feature flag by key.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @return FeatureFlagScheduledChanges
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FeatureFlagScheduledChanges getFlagConfigScheduledChanges(String projectKey, String featureFlagKey, String environmentKey) throws ApiException {
        ApiResponse<FeatureFlagScheduledChanges> resp = getFlagConfigScheduledChangesWithHttpInfo(projectKey, featureFlagKey, environmentKey);
        return resp.getData();
    }

    /**
     * Get all scheduled workflows for a feature flag by key.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @return ApiResponse&lt;FeatureFlagScheduledChanges&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FeatureFlagScheduledChanges> getFlagConfigScheduledChangesWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey) throws ApiException {
        com.squareup.okhttp.Call call = getFlagConfigScheduledChangesValidateBeforeCall(projectKey, featureFlagKey, environmentKey, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlagScheduledChanges>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all scheduled workflows for a feature flag by key. (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFlagConfigScheduledChangesAsync(String projectKey, String featureFlagKey, String environmentKey, final ApiCallback<FeatureFlagScheduledChanges> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFlagConfigScheduledChangesValidateBeforeCall(projectKey, featureFlagKey, environmentKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlagScheduledChanges>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getFlagConfigScheduledChangesConflicts
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param flagConfigScheduledChangesConflictsBody Used to determine if a semantic patch will result in conflicts with scheduled changes on a feature flag. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getFlagConfigScheduledChangesConflictsCall(String projectKey, String featureFlagKey, String environmentKey, FlagConfigScheduledChangesConflictsBody flagConfigScheduledChangesConflictsBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = flagConfigScheduledChangesConflictsBody;

        // create path and map variables
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/scheduled-changes-conflicts"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getFlagConfigScheduledChangesConflictsValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, FlagConfigScheduledChangesConflictsBody flagConfigScheduledChangesConflictsBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFlagConfigScheduledChangesConflicts(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getFlagConfigScheduledChangesConflicts(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getFlagConfigScheduledChangesConflicts(Async)");
        }
        
        // verify the required parameter 'flagConfigScheduledChangesConflictsBody' is set
        if (flagConfigScheduledChangesConflictsBody == null) {
            throw new ApiException("Missing the required parameter 'flagConfigScheduledChangesConflictsBody' when calling getFlagConfigScheduledChangesConflicts(Async)");
        }
        

        com.squareup.okhttp.Call call = getFlagConfigScheduledChangesConflictsCall(projectKey, featureFlagKey, environmentKey, flagConfigScheduledChangesConflictsBody, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Lists conflicts between the given instructions and any existing scheduled changes for the feature flag. The actual HTTP verb should be REPORT, not POST.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param flagConfigScheduledChangesConflictsBody Used to determine if a semantic patch will result in conflicts with scheduled changes on a feature flag. (required)
     * @return FeatureFlagScheduledChangesConflicts
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FeatureFlagScheduledChangesConflicts getFlagConfigScheduledChangesConflicts(String projectKey, String featureFlagKey, String environmentKey, FlagConfigScheduledChangesConflictsBody flagConfigScheduledChangesConflictsBody) throws ApiException {
        ApiResponse<FeatureFlagScheduledChangesConflicts> resp = getFlagConfigScheduledChangesConflictsWithHttpInfo(projectKey, featureFlagKey, environmentKey, flagConfigScheduledChangesConflictsBody);
        return resp.getData();
    }

    /**
     * Lists conflicts between the given instructions and any existing scheduled changes for the feature flag. The actual HTTP verb should be REPORT, not POST.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param flagConfigScheduledChangesConflictsBody Used to determine if a semantic patch will result in conflicts with scheduled changes on a feature flag. (required)
     * @return ApiResponse&lt;FeatureFlagScheduledChangesConflicts&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FeatureFlagScheduledChangesConflicts> getFlagConfigScheduledChangesConflictsWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey, FlagConfigScheduledChangesConflictsBody flagConfigScheduledChangesConflictsBody) throws ApiException {
        com.squareup.okhttp.Call call = getFlagConfigScheduledChangesConflictsValidateBeforeCall(projectKey, featureFlagKey, environmentKey, flagConfigScheduledChangesConflictsBody, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlagScheduledChangesConflicts>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Lists conflicts between the given instructions and any existing scheduled changes for the feature flag. The actual HTTP verb should be REPORT, not POST. (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param flagConfigScheduledChangesConflictsBody Used to determine if a semantic patch will result in conflicts with scheduled changes on a feature flag. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getFlagConfigScheduledChangesConflictsAsync(String projectKey, String featureFlagKey, String environmentKey, FlagConfigScheduledChangesConflictsBody flagConfigScheduledChangesConflictsBody, final ApiCallback<FeatureFlagScheduledChangesConflicts> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getFlagConfigScheduledChangesConflictsValidateBeforeCall(projectKey, featureFlagKey, environmentKey, flagConfigScheduledChangesConflictsBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlagScheduledChangesConflicts>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for patchExpiringUserTargets
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param semanticPatchWithComment Requires a Semantic Patch representation of the desired changes to the resource. &#39;https://apidocs.launchdarkly.com/reference#updates-via-semantic-patches&#39;. The addition of comments is also supported. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call patchExpiringUserTargetsCall(String projectKey, String environmentKey, String featureFlagKey, Object semanticPatchWithComment, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = semanticPatchWithComment;

        // create path and map variables
        String localVarPath = "/flags/{projectKey}/{featureFlagKey}/expiring-user-targets/{environmentKey}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call patchExpiringUserTargetsValidateBeforeCall(String projectKey, String environmentKey, String featureFlagKey, Object semanticPatchWithComment, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchExpiringUserTargets(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchExpiringUserTargets(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling patchExpiringUserTargets(Async)");
        }
        
        // verify the required parameter 'semanticPatchWithComment' is set
        if (semanticPatchWithComment == null) {
            throw new ApiException("Missing the required parameter 'semanticPatchWithComment' when calling patchExpiringUserTargets(Async)");
        }
        

        com.squareup.okhttp.Call call = patchExpiringUserTargetsCall(projectKey, environmentKey, featureFlagKey, semanticPatchWithComment, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Update, add, or delete expiring user targets on feature flag
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param semanticPatchWithComment Requires a Semantic Patch representation of the desired changes to the resource. &#39;https://apidocs.launchdarkly.com/reference#updates-via-semantic-patches&#39;. The addition of comments is also supported. (required)
     * @return UserTargetingExpirationForFlags
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UserTargetingExpirationForFlags patchExpiringUserTargets(String projectKey, String environmentKey, String featureFlagKey, Object semanticPatchWithComment) throws ApiException {
        ApiResponse<UserTargetingExpirationForFlags> resp = patchExpiringUserTargetsWithHttpInfo(projectKey, environmentKey, featureFlagKey, semanticPatchWithComment);
        return resp.getData();
    }

    /**
     * Update, add, or delete expiring user targets on feature flag
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param semanticPatchWithComment Requires a Semantic Patch representation of the desired changes to the resource. &#39;https://apidocs.launchdarkly.com/reference#updates-via-semantic-patches&#39;. The addition of comments is also supported. (required)
     * @return ApiResponse&lt;UserTargetingExpirationForFlags&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UserTargetingExpirationForFlags> patchExpiringUserTargetsWithHttpInfo(String projectKey, String environmentKey, String featureFlagKey, Object semanticPatchWithComment) throws ApiException {
        com.squareup.okhttp.Call call = patchExpiringUserTargetsValidateBeforeCall(projectKey, environmentKey, featureFlagKey, semanticPatchWithComment, null, null);
        Type localVarReturnType = new TypeToken<UserTargetingExpirationForFlags>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update, add, or delete expiring user targets on feature flag (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param semanticPatchWithComment Requires a Semantic Patch representation of the desired changes to the resource. &#39;https://apidocs.launchdarkly.com/reference#updates-via-semantic-patches&#39;. The addition of comments is also supported. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call patchExpiringUserTargetsAsync(String projectKey, String environmentKey, String featureFlagKey, Object semanticPatchWithComment, final ApiCallback<UserTargetingExpirationForFlags> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = patchExpiringUserTargetsValidateBeforeCall(projectKey, environmentKey, featureFlagKey, semanticPatchWithComment, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserTargetingExpirationForFlags>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for patchFeatureFlag
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param patchComment Requires a JSON Patch representation of the desired changes to the project, and an optional comment. &#39;http://jsonpatch.com/&#39; Feature flag patches also support JSON Merge Patch format. &#39;https://tools.ietf.org/html/rfc7386&#39; The addition of comments is also supported. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call patchFeatureFlagCall(String projectKey, String featureFlagKey, PatchComment patchComment, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = patchComment;

        // create path and map variables
        String localVarPath = "/flags/{projectKey}/{featureFlagKey}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call patchFeatureFlagValidateBeforeCall(String projectKey, String featureFlagKey, PatchComment patchComment, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchFeatureFlag(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling patchFeatureFlag(Async)");
        }
        
        // verify the required parameter 'patchComment' is set
        if (patchComment == null) {
            throw new ApiException("Missing the required parameter 'patchComment' when calling patchFeatureFlag(Async)");
        }
        

        com.squareup.okhttp.Call call = patchFeatureFlagCall(projectKey, featureFlagKey, patchComment, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Perform a partial update to a feature.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param patchComment Requires a JSON Patch representation of the desired changes to the project, and an optional comment. &#39;http://jsonpatch.com/&#39; Feature flag patches also support JSON Merge Patch format. &#39;https://tools.ietf.org/html/rfc7386&#39; The addition of comments is also supported. (required)
     * @return FeatureFlag
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FeatureFlag patchFeatureFlag(String projectKey, String featureFlagKey, PatchComment patchComment) throws ApiException {
        ApiResponse<FeatureFlag> resp = patchFeatureFlagWithHttpInfo(projectKey, featureFlagKey, patchComment);
        return resp.getData();
    }

    /**
     * Perform a partial update to a feature.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param patchComment Requires a JSON Patch representation of the desired changes to the project, and an optional comment. &#39;http://jsonpatch.com/&#39; Feature flag patches also support JSON Merge Patch format. &#39;https://tools.ietf.org/html/rfc7386&#39; The addition of comments is also supported. (required)
     * @return ApiResponse&lt;FeatureFlag&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FeatureFlag> patchFeatureFlagWithHttpInfo(String projectKey, String featureFlagKey, PatchComment patchComment) throws ApiException {
        com.squareup.okhttp.Call call = patchFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, patchComment, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Perform a partial update to a feature. (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param patchComment Requires a JSON Patch representation of the desired changes to the project, and an optional comment. &#39;http://jsonpatch.com/&#39; Feature flag patches also support JSON Merge Patch format. &#39;https://tools.ietf.org/html/rfc7386&#39; The addition of comments is also supported. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call patchFeatureFlagAsync(String projectKey, String featureFlagKey, PatchComment patchComment, final ApiCallback<FeatureFlag> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = patchFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, patchComment, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for patchFlagConfigScheduledChange
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param flagConfigScheduledChangesPatchBody Update scheduled changes on a feature flag. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param scheduledChangeId The id of the scheduled change (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call patchFlagConfigScheduledChangeCall(String projectKey, String featureFlagKey, FlagConfigScheduledChangesPatchBody flagConfigScheduledChangesPatchBody, String environmentKey, String scheduledChangeId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = flagConfigScheduledChangesPatchBody;

        // create path and map variables
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/scheduled-changes/{scheduledChangeId}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()))
            .replaceAll("\\{" + "scheduledChangeId" + "\\}", apiClient.escapeString(scheduledChangeId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call patchFlagConfigScheduledChangeValidateBeforeCall(String projectKey, String featureFlagKey, FlagConfigScheduledChangesPatchBody flagConfigScheduledChangesPatchBody, String environmentKey, String scheduledChangeId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchFlagConfigScheduledChange(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling patchFlagConfigScheduledChange(Async)");
        }
        
        // verify the required parameter 'flagConfigScheduledChangesPatchBody' is set
        if (flagConfigScheduledChangesPatchBody == null) {
            throw new ApiException("Missing the required parameter 'flagConfigScheduledChangesPatchBody' when calling patchFlagConfigScheduledChange(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchFlagConfigScheduledChange(Async)");
        }
        
        // verify the required parameter 'scheduledChangeId' is set
        if (scheduledChangeId == null) {
            throw new ApiException("Missing the required parameter 'scheduledChangeId' when calling patchFlagConfigScheduledChange(Async)");
        }
        

        com.squareup.okhttp.Call call = patchFlagConfigScheduledChangeCall(projectKey, featureFlagKey, flagConfigScheduledChangesPatchBody, environmentKey, scheduledChangeId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Updates an existing scheduled-change on a feature flag in an environment.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param flagConfigScheduledChangesPatchBody Update scheduled changes on a feature flag. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param scheduledChangeId The id of the scheduled change (required)
     * @return FeatureFlagScheduledChange
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FeatureFlagScheduledChange patchFlagConfigScheduledChange(String projectKey, String featureFlagKey, FlagConfigScheduledChangesPatchBody flagConfigScheduledChangesPatchBody, String environmentKey, String scheduledChangeId) throws ApiException {
        ApiResponse<FeatureFlagScheduledChange> resp = patchFlagConfigScheduledChangeWithHttpInfo(projectKey, featureFlagKey, flagConfigScheduledChangesPatchBody, environmentKey, scheduledChangeId);
        return resp.getData();
    }

    /**
     * Updates an existing scheduled-change on a feature flag in an environment.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param flagConfigScheduledChangesPatchBody Update scheduled changes on a feature flag. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param scheduledChangeId The id of the scheduled change (required)
     * @return ApiResponse&lt;FeatureFlagScheduledChange&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FeatureFlagScheduledChange> patchFlagConfigScheduledChangeWithHttpInfo(String projectKey, String featureFlagKey, FlagConfigScheduledChangesPatchBody flagConfigScheduledChangesPatchBody, String environmentKey, String scheduledChangeId) throws ApiException {
        com.squareup.okhttp.Call call = patchFlagConfigScheduledChangeValidateBeforeCall(projectKey, featureFlagKey, flagConfigScheduledChangesPatchBody, environmentKey, scheduledChangeId, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlagScheduledChange>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Updates an existing scheduled-change on a feature flag in an environment. (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param flagConfigScheduledChangesPatchBody Update scheduled changes on a feature flag. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param scheduledChangeId The id of the scheduled change (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call patchFlagConfigScheduledChangeAsync(String projectKey, String featureFlagKey, FlagConfigScheduledChangesPatchBody flagConfigScheduledChangesPatchBody, String environmentKey, String scheduledChangeId, final ApiCallback<FeatureFlagScheduledChange> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = patchFlagConfigScheduledChangeValidateBeforeCall(projectKey, featureFlagKey, flagConfigScheduledChangesPatchBody, environmentKey, scheduledChangeId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlagScheduledChange>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for postApplyApprovalRequest
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param approvalRequestId The approval request ID (required)
     * @param approvalRequestApplyConfigBody Apply an approval request (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postApplyApprovalRequestCall(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestApplyConfigBody approvalRequestApplyConfigBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = approvalRequestApplyConfigBody;

        // create path and map variables
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/approval-requests/{approvalRequestId}/apply"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()))
            .replaceAll("\\{" + "approvalRequestId" + "\\}", apiClient.escapeString(approvalRequestId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postApplyApprovalRequestValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestApplyConfigBody approvalRequestApplyConfigBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postApplyApprovalRequest(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling postApplyApprovalRequest(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling postApplyApprovalRequest(Async)");
        }
        
        // verify the required parameter 'approvalRequestId' is set
        if (approvalRequestId == null) {
            throw new ApiException("Missing the required parameter 'approvalRequestId' when calling postApplyApprovalRequest(Async)");
        }
        
        // verify the required parameter 'approvalRequestApplyConfigBody' is set
        if (approvalRequestApplyConfigBody == null) {
            throw new ApiException("Missing the required parameter 'approvalRequestApplyConfigBody' when calling postApplyApprovalRequest(Async)");
        }
        

        com.squareup.okhttp.Call call = postApplyApprovalRequestCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestApplyConfigBody, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Apply approval request for a feature flag config
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param approvalRequestId The approval request ID (required)
     * @param approvalRequestApplyConfigBody Apply an approval request (required)
     * @return ApprovalRequests
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApprovalRequests postApplyApprovalRequest(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestApplyConfigBody approvalRequestApplyConfigBody) throws ApiException {
        ApiResponse<ApprovalRequests> resp = postApplyApprovalRequestWithHttpInfo(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestApplyConfigBody);
        return resp.getData();
    }

    /**
     * Apply approval request for a feature flag config
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param approvalRequestId The approval request ID (required)
     * @param approvalRequestApplyConfigBody Apply an approval request (required)
     * @return ApiResponse&lt;ApprovalRequests&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ApprovalRequests> postApplyApprovalRequestWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestApplyConfigBody approvalRequestApplyConfigBody) throws ApiException {
        com.squareup.okhttp.Call call = postApplyApprovalRequestValidateBeforeCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestApplyConfigBody, null, null);
        Type localVarReturnType = new TypeToken<ApprovalRequests>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Apply approval request for a feature flag config (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param approvalRequestId The approval request ID (required)
     * @param approvalRequestApplyConfigBody Apply an approval request (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postApplyApprovalRequestAsync(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestApplyConfigBody approvalRequestApplyConfigBody, final ApiCallback<ApprovalRequests> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = postApplyApprovalRequestValidateBeforeCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestApplyConfigBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApprovalRequests>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for postApprovalRequest
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param approvalRequestId The approval request ID (required)
     * @param approvalRequestConfigBody Create a new approval request (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postApprovalRequestCall(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestConfigBody approvalRequestConfigBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = approvalRequestConfigBody;

        // create path and map variables
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/approval-requests/{approvalRequestId}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()))
            .replaceAll("\\{" + "approvalRequestId" + "\\}", apiClient.escapeString(approvalRequestId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postApprovalRequestValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestConfigBody approvalRequestConfigBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postApprovalRequest(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling postApprovalRequest(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling postApprovalRequest(Async)");
        }
        
        // verify the required parameter 'approvalRequestId' is set
        if (approvalRequestId == null) {
            throw new ApiException("Missing the required parameter 'approvalRequestId' when calling postApprovalRequest(Async)");
        }
        

        com.squareup.okhttp.Call call = postApprovalRequestCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestConfigBody, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create an approval request for a feature flag config
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param approvalRequestId The approval request ID (required)
     * @param approvalRequestConfigBody Create a new approval request (optional)
     * @return ApprovalRequest
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApprovalRequest postApprovalRequest(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestConfigBody approvalRequestConfigBody) throws ApiException {
        ApiResponse<ApprovalRequest> resp = postApprovalRequestWithHttpInfo(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestConfigBody);
        return resp.getData();
    }

    /**
     * Create an approval request for a feature flag config
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param approvalRequestId The approval request ID (required)
     * @param approvalRequestConfigBody Create a new approval request (optional)
     * @return ApiResponse&lt;ApprovalRequest&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ApprovalRequest> postApprovalRequestWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestConfigBody approvalRequestConfigBody) throws ApiException {
        com.squareup.okhttp.Call call = postApprovalRequestValidateBeforeCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestConfigBody, null, null);
        Type localVarReturnType = new TypeToken<ApprovalRequest>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create an approval request for a feature flag config (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param approvalRequestId The approval request ID (required)
     * @param approvalRequestConfigBody Create a new approval request (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postApprovalRequestAsync(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestConfigBody approvalRequestConfigBody, final ApiCallback<ApprovalRequest> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = postApprovalRequestValidateBeforeCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestConfigBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApprovalRequest>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for postFeatureFlag
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagBody Create a new feature flag. (required)
     * @param clone The key of the feature flag to be cloned. The key identifies the flag in your code.  For example, setting clone&#x3D;flagKey will copy the full targeting configuration for all environments (including on/off state) from the original flag to the new flag. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postFeatureFlagCall(String projectKey, FeatureFlagBody featureFlagBody, String clone, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = featureFlagBody;

        // create path and map variables
        String localVarPath = "/flags/{projectKey}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (clone != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("clone", clone));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postFeatureFlagValidateBeforeCall(String projectKey, FeatureFlagBody featureFlagBody, String clone, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postFeatureFlag(Async)");
        }
        
        // verify the required parameter 'featureFlagBody' is set
        if (featureFlagBody == null) {
            throw new ApiException("Missing the required parameter 'featureFlagBody' when calling postFeatureFlag(Async)");
        }
        

        com.squareup.okhttp.Call call = postFeatureFlagCall(projectKey, featureFlagBody, clone, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Creates a new feature flag.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagBody Create a new feature flag. (required)
     * @param clone The key of the feature flag to be cloned. The key identifies the flag in your code.  For example, setting clone&#x3D;flagKey will copy the full targeting configuration for all environments (including on/off state) from the original flag to the new flag. (optional)
     * @return FeatureFlag
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FeatureFlag postFeatureFlag(String projectKey, FeatureFlagBody featureFlagBody, String clone) throws ApiException {
        ApiResponse<FeatureFlag> resp = postFeatureFlagWithHttpInfo(projectKey, featureFlagBody, clone);
        return resp.getData();
    }

    /**
     * Creates a new feature flag.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagBody Create a new feature flag. (required)
     * @param clone The key of the feature flag to be cloned. The key identifies the flag in your code.  For example, setting clone&#x3D;flagKey will copy the full targeting configuration for all environments (including on/off state) from the original flag to the new flag. (optional)
     * @return ApiResponse&lt;FeatureFlag&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FeatureFlag> postFeatureFlagWithHttpInfo(String projectKey, FeatureFlagBody featureFlagBody, String clone) throws ApiException {
        com.squareup.okhttp.Call call = postFeatureFlagValidateBeforeCall(projectKey, featureFlagBody, clone, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Creates a new feature flag. (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagBody Create a new feature flag. (required)
     * @param clone The key of the feature flag to be cloned. The key identifies the flag in your code.  For example, setting clone&#x3D;flagKey will copy the full targeting configuration for all environments (including on/off state) from the original flag to the new flag. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postFeatureFlagAsync(String projectKey, FeatureFlagBody featureFlagBody, String clone, final ApiCallback<FeatureFlag> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = postFeatureFlagValidateBeforeCall(projectKey, featureFlagBody, clone, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for postFlagConfigScheduledChanges
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param flagConfigScheduledChangesPostBody Create scheduled changes on a feature flag. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postFlagConfigScheduledChangesCall(String projectKey, FlagConfigScheduledChangesPostBody flagConfigScheduledChangesPostBody, String featureFlagKey, String environmentKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = flagConfigScheduledChangesPostBody;

        // create path and map variables
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/scheduled-changes"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postFlagConfigScheduledChangesValidateBeforeCall(String projectKey, FlagConfigScheduledChangesPostBody flagConfigScheduledChangesPostBody, String featureFlagKey, String environmentKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postFlagConfigScheduledChanges(Async)");
        }
        
        // verify the required parameter 'flagConfigScheduledChangesPostBody' is set
        if (flagConfigScheduledChangesPostBody == null) {
            throw new ApiException("Missing the required parameter 'flagConfigScheduledChangesPostBody' when calling postFlagConfigScheduledChanges(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling postFlagConfigScheduledChanges(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling postFlagConfigScheduledChanges(Async)");
        }
        

        com.squareup.okhttp.Call call = postFlagConfigScheduledChangesCall(projectKey, flagConfigScheduledChangesPostBody, featureFlagKey, environmentKey, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Creates a new scheduled change for a feature flag.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param flagConfigScheduledChangesPostBody Create scheduled changes on a feature flag. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @return FeatureFlagScheduledChange
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public FeatureFlagScheduledChange postFlagConfigScheduledChanges(String projectKey, FlagConfigScheduledChangesPostBody flagConfigScheduledChangesPostBody, String featureFlagKey, String environmentKey) throws ApiException {
        ApiResponse<FeatureFlagScheduledChange> resp = postFlagConfigScheduledChangesWithHttpInfo(projectKey, flagConfigScheduledChangesPostBody, featureFlagKey, environmentKey);
        return resp.getData();
    }

    /**
     * Creates a new scheduled change for a feature flag.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param flagConfigScheduledChangesPostBody Create scheduled changes on a feature flag. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @return ApiResponse&lt;FeatureFlagScheduledChange&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<FeatureFlagScheduledChange> postFlagConfigScheduledChangesWithHttpInfo(String projectKey, FlagConfigScheduledChangesPostBody flagConfigScheduledChangesPostBody, String featureFlagKey, String environmentKey) throws ApiException {
        com.squareup.okhttp.Call call = postFlagConfigScheduledChangesValidateBeforeCall(projectKey, flagConfigScheduledChangesPostBody, featureFlagKey, environmentKey, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlagScheduledChange>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Creates a new scheduled change for a feature flag. (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param flagConfigScheduledChangesPostBody Create scheduled changes on a feature flag. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postFlagConfigScheduledChangesAsync(String projectKey, FlagConfigScheduledChangesPostBody flagConfigScheduledChangesPostBody, String featureFlagKey, String environmentKey, final ApiCallback<FeatureFlagScheduledChange> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = postFlagConfigScheduledChangesValidateBeforeCall(projectKey, flagConfigScheduledChangesPostBody, featureFlagKey, environmentKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlagScheduledChange>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for postReviewApprovalRequest
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param approvalRequestId The approval request ID (required)
     * @param approvalRequestReviewConfigBody Review an approval request (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postReviewApprovalRequestCall(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestReviewConfigBody approvalRequestReviewConfigBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = approvalRequestReviewConfigBody;

        // create path and map variables
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/approval-requests/{approvalRequestId}/review"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "featureFlagKey" + "\\}", apiClient.escapeString(featureFlagKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()))
            .replaceAll("\\{" + "approvalRequestId" + "\\}", apiClient.escapeString(approvalRequestId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postReviewApprovalRequestValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestReviewConfigBody approvalRequestReviewConfigBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postReviewApprovalRequest(Async)");
        }
        
        // verify the required parameter 'featureFlagKey' is set
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling postReviewApprovalRequest(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling postReviewApprovalRequest(Async)");
        }
        
        // verify the required parameter 'approvalRequestId' is set
        if (approvalRequestId == null) {
            throw new ApiException("Missing the required parameter 'approvalRequestId' when calling postReviewApprovalRequest(Async)");
        }
        
        // verify the required parameter 'approvalRequestReviewConfigBody' is set
        if (approvalRequestReviewConfigBody == null) {
            throw new ApiException("Missing the required parameter 'approvalRequestReviewConfigBody' when calling postReviewApprovalRequest(Async)");
        }
        

        com.squareup.okhttp.Call call = postReviewApprovalRequestCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestReviewConfigBody, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Review approval request for a feature flag config
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param approvalRequestId The approval request ID (required)
     * @param approvalRequestReviewConfigBody Review an approval request (required)
     * @return ApprovalRequests
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApprovalRequests postReviewApprovalRequest(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestReviewConfigBody approvalRequestReviewConfigBody) throws ApiException {
        ApiResponse<ApprovalRequests> resp = postReviewApprovalRequestWithHttpInfo(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestReviewConfigBody);
        return resp.getData();
    }

    /**
     * Review approval request for a feature flag config
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param approvalRequestId The approval request ID (required)
     * @param approvalRequestReviewConfigBody Review an approval request (required)
     * @return ApiResponse&lt;ApprovalRequests&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<ApprovalRequests> postReviewApprovalRequestWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestReviewConfigBody approvalRequestReviewConfigBody) throws ApiException {
        com.squareup.okhttp.Call call = postReviewApprovalRequestValidateBeforeCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestReviewConfigBody, null, null);
        Type localVarReturnType = new TypeToken<ApprovalRequests>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Review approval request for a feature flag config (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param featureFlagKey The feature flag&#39;s key. The key identifies the flag in your code. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param approvalRequestId The approval request ID (required)
     * @param approvalRequestReviewConfigBody Review an approval request (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postReviewApprovalRequestAsync(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestReviewConfigBody approvalRequestReviewConfigBody, final ApiCallback<ApprovalRequests> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = postReviewApprovalRequestValidateBeforeCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestReviewConfigBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApprovalRequests>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
