/*
 * LaunchDarkly REST API
 * Build custom integrations with the LaunchDarkly REST API
 *
 * OpenAPI spec version: 5.3.0
 * Contact: support@launchdarkly.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.launchdarkly.api.api;

import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.ProgressRequestBody;
import com.launchdarkly.api.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.launchdarkly.api.model.Integration;
import com.launchdarkly.api.model.IntegrationSubscription;
import com.launchdarkly.api.model.Integrations;
import com.launchdarkly.api.model.PatchOperation;
import com.launchdarkly.api.model.SubscriptionBody;
import com.launchdarkly.api.model.UsageError;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IntegrationsApi {
    private ApiClient apiClient;

    public IntegrationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IntegrationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for deleteIntegrationSubscription
     * @param integrationKey The key used to specify the integration kind. (required)
     * @param integrationId The integration ID. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteIntegrationSubscriptionCall(String integrationKey, String integrationId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/integrations/{integrationKey}/{integrationId}"
            .replaceAll("\\{" + "integrationKey" + "\\}", apiClient.escapeString(integrationKey.toString()))
            .replaceAll("\\{" + "integrationId" + "\\}", apiClient.escapeString(integrationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteIntegrationSubscriptionValidateBeforeCall(String integrationKey, String integrationId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'integrationKey' is set
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling deleteIntegrationSubscription(Async)");
        }
        
        // verify the required parameter 'integrationId' is set
        if (integrationId == null) {
            throw new ApiException("Missing the required parameter 'integrationId' when calling deleteIntegrationSubscription(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteIntegrationSubscriptionCall(integrationKey, integrationId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete an integration subscription by ID.
     * 
     * @param integrationKey The key used to specify the integration kind. (required)
     * @param integrationId The integration ID. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteIntegrationSubscription(String integrationKey, String integrationId) throws ApiException {
        deleteIntegrationSubscriptionWithHttpInfo(integrationKey, integrationId);
    }

    /**
     * Delete an integration subscription by ID.
     * 
     * @param integrationKey The key used to specify the integration kind. (required)
     * @param integrationId The integration ID. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteIntegrationSubscriptionWithHttpInfo(String integrationKey, String integrationId) throws ApiException {
        com.squareup.okhttp.Call call = deleteIntegrationSubscriptionValidateBeforeCall(integrationKey, integrationId, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete an integration subscription by ID. (asynchronously)
     * 
     * @param integrationKey The key used to specify the integration kind. (required)
     * @param integrationId The integration ID. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteIntegrationSubscriptionAsync(String integrationKey, String integrationId, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteIntegrationSubscriptionValidateBeforeCall(integrationKey, integrationId, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for getIntegrationSubscription
     * @param integrationKey The key used to specify the integration kind. (required)
     * @param integrationId The integration ID. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getIntegrationSubscriptionCall(String integrationKey, String integrationId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/integrations/{integrationKey}/{integrationId}"
            .replaceAll("\\{" + "integrationKey" + "\\}", apiClient.escapeString(integrationKey.toString()))
            .replaceAll("\\{" + "integrationId" + "\\}", apiClient.escapeString(integrationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getIntegrationSubscriptionValidateBeforeCall(String integrationKey, String integrationId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'integrationKey' is set
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling getIntegrationSubscription(Async)");
        }
        
        // verify the required parameter 'integrationId' is set
        if (integrationId == null) {
            throw new ApiException("Missing the required parameter 'integrationId' when calling getIntegrationSubscription(Async)");
        }
        

        com.squareup.okhttp.Call call = getIntegrationSubscriptionCall(integrationKey, integrationId, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a single integration subscription by ID.
     * 
     * @param integrationKey The key used to specify the integration kind. (required)
     * @param integrationId The integration ID. (required)
     * @return IntegrationSubscription
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public IntegrationSubscription getIntegrationSubscription(String integrationKey, String integrationId) throws ApiException {
        ApiResponse<IntegrationSubscription> resp = getIntegrationSubscriptionWithHttpInfo(integrationKey, integrationId);
        return resp.getData();
    }

    /**
     * Get a single integration subscription by ID.
     * 
     * @param integrationKey The key used to specify the integration kind. (required)
     * @param integrationId The integration ID. (required)
     * @return ApiResponse&lt;IntegrationSubscription&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<IntegrationSubscription> getIntegrationSubscriptionWithHttpInfo(String integrationKey, String integrationId) throws ApiException {
        com.squareup.okhttp.Call call = getIntegrationSubscriptionValidateBeforeCall(integrationKey, integrationId, null, null);
        Type localVarReturnType = new TypeToken<IntegrationSubscription>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a single integration subscription by ID. (asynchronously)
     * 
     * @param integrationKey The key used to specify the integration kind. (required)
     * @param integrationId The integration ID. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getIntegrationSubscriptionAsync(String integrationKey, String integrationId, final ApiCallback<IntegrationSubscription> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getIntegrationSubscriptionValidateBeforeCall(integrationKey, integrationId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IntegrationSubscription>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getIntegrationSubscriptions
     * @param integrationKey The key used to specify the integration kind. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getIntegrationSubscriptionsCall(String integrationKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/integrations/{integrationKey}"
            .replaceAll("\\{" + "integrationKey" + "\\}", apiClient.escapeString(integrationKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getIntegrationSubscriptionsValidateBeforeCall(String integrationKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'integrationKey' is set
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling getIntegrationSubscriptions(Async)");
        }
        

        com.squareup.okhttp.Call call = getIntegrationSubscriptionsCall(integrationKey, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a list of all configured integrations of a given kind.
     * 
     * @param integrationKey The key used to specify the integration kind. (required)
     * @return Integration
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Integration getIntegrationSubscriptions(String integrationKey) throws ApiException {
        ApiResponse<Integration> resp = getIntegrationSubscriptionsWithHttpInfo(integrationKey);
        return resp.getData();
    }

    /**
     * Get a list of all configured integrations of a given kind.
     * 
     * @param integrationKey The key used to specify the integration kind. (required)
     * @return ApiResponse&lt;Integration&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Integration> getIntegrationSubscriptionsWithHttpInfo(String integrationKey) throws ApiException {
        com.squareup.okhttp.Call call = getIntegrationSubscriptionsValidateBeforeCall(integrationKey, null, null);
        Type localVarReturnType = new TypeToken<Integration>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a list of all configured integrations of a given kind. (asynchronously)
     * 
     * @param integrationKey The key used to specify the integration kind. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getIntegrationSubscriptionsAsync(String integrationKey, final ApiCallback<Integration> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getIntegrationSubscriptionsValidateBeforeCall(integrationKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Integration>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getIntegrations
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getIntegrationsCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/integrations";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getIntegrationsValidateBeforeCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = getIntegrationsCall(progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a list of all configured audit log event integrations associated with this account.
     * 
     * @return Integrations
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public Integrations getIntegrations() throws ApiException {
        ApiResponse<Integrations> resp = getIntegrationsWithHttpInfo();
        return resp.getData();
    }

    /**
     * Get a list of all configured audit log event integrations associated with this account.
     * 
     * @return ApiResponse&lt;Integrations&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Integrations> getIntegrationsWithHttpInfo() throws ApiException {
        com.squareup.okhttp.Call call = getIntegrationsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<Integrations>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a list of all configured audit log event integrations associated with this account. (asynchronously)
     * 
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getIntegrationsAsync(final ApiCallback<Integrations> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getIntegrationsValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Integrations>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for patchIntegrationSubscription
     * @param integrationKey The key used to specify the integration kind. (required)
     * @param integrationId The integration ID. (required)
     * @param patchDelta Requires a JSON Patch representation of the desired changes to the project. &#39;http://jsonpatch.com/&#39; (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call patchIntegrationSubscriptionCall(String integrationKey, String integrationId, List<PatchOperation> patchDelta, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = patchDelta;

        // create path and map variables
        String localVarPath = "/integrations/{integrationKey}/{integrationId}"
            .replaceAll("\\{" + "integrationKey" + "\\}", apiClient.escapeString(integrationKey.toString()))
            .replaceAll("\\{" + "integrationId" + "\\}", apiClient.escapeString(integrationId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call patchIntegrationSubscriptionValidateBeforeCall(String integrationKey, String integrationId, List<PatchOperation> patchDelta, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'integrationKey' is set
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling patchIntegrationSubscription(Async)");
        }
        
        // verify the required parameter 'integrationId' is set
        if (integrationId == null) {
            throw new ApiException("Missing the required parameter 'integrationId' when calling patchIntegrationSubscription(Async)");
        }
        
        // verify the required parameter 'patchDelta' is set
        if (patchDelta == null) {
            throw new ApiException("Missing the required parameter 'patchDelta' when calling patchIntegrationSubscription(Async)");
        }
        

        com.squareup.okhttp.Call call = patchIntegrationSubscriptionCall(integrationKey, integrationId, patchDelta, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Modify an integration subscription by ID.
     * 
     * @param integrationKey The key used to specify the integration kind. (required)
     * @param integrationId The integration ID. (required)
     * @param patchDelta Requires a JSON Patch representation of the desired changes to the project. &#39;http://jsonpatch.com/&#39; (required)
     * @return IntegrationSubscription
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public IntegrationSubscription patchIntegrationSubscription(String integrationKey, String integrationId, List<PatchOperation> patchDelta) throws ApiException {
        ApiResponse<IntegrationSubscription> resp = patchIntegrationSubscriptionWithHttpInfo(integrationKey, integrationId, patchDelta);
        return resp.getData();
    }

    /**
     * Modify an integration subscription by ID.
     * 
     * @param integrationKey The key used to specify the integration kind. (required)
     * @param integrationId The integration ID. (required)
     * @param patchDelta Requires a JSON Patch representation of the desired changes to the project. &#39;http://jsonpatch.com/&#39; (required)
     * @return ApiResponse&lt;IntegrationSubscription&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<IntegrationSubscription> patchIntegrationSubscriptionWithHttpInfo(String integrationKey, String integrationId, List<PatchOperation> patchDelta) throws ApiException {
        com.squareup.okhttp.Call call = patchIntegrationSubscriptionValidateBeforeCall(integrationKey, integrationId, patchDelta, null, null);
        Type localVarReturnType = new TypeToken<IntegrationSubscription>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Modify an integration subscription by ID. (asynchronously)
     * 
     * @param integrationKey The key used to specify the integration kind. (required)
     * @param integrationId The integration ID. (required)
     * @param patchDelta Requires a JSON Patch representation of the desired changes to the project. &#39;http://jsonpatch.com/&#39; (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call patchIntegrationSubscriptionAsync(String integrationKey, String integrationId, List<PatchOperation> patchDelta, final ApiCallback<IntegrationSubscription> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = patchIntegrationSubscriptionValidateBeforeCall(integrationKey, integrationId, patchDelta, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IntegrationSubscription>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for postIntegrationSubscription
     * @param integrationKey The key used to specify the integration kind. (required)
     * @param subscriptionBody Create a new integration subscription. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postIntegrationSubscriptionCall(String integrationKey, SubscriptionBody subscriptionBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = subscriptionBody;

        // create path and map variables
        String localVarPath = "/integrations/{integrationKey}"
            .replaceAll("\\{" + "integrationKey" + "\\}", apiClient.escapeString(integrationKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postIntegrationSubscriptionValidateBeforeCall(String integrationKey, SubscriptionBody subscriptionBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'integrationKey' is set
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling postIntegrationSubscription(Async)");
        }
        
        // verify the required parameter 'subscriptionBody' is set
        if (subscriptionBody == null) {
            throw new ApiException("Missing the required parameter 'subscriptionBody' when calling postIntegrationSubscription(Async)");
        }
        

        com.squareup.okhttp.Call call = postIntegrationSubscriptionCall(integrationKey, subscriptionBody, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Create a new integration subscription of a given kind.
     * 
     * @param integrationKey The key used to specify the integration kind. (required)
     * @param subscriptionBody Create a new integration subscription. (required)
     * @return IntegrationSubscription
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public IntegrationSubscription postIntegrationSubscription(String integrationKey, SubscriptionBody subscriptionBody) throws ApiException {
        ApiResponse<IntegrationSubscription> resp = postIntegrationSubscriptionWithHttpInfo(integrationKey, subscriptionBody);
        return resp.getData();
    }

    /**
     * Create a new integration subscription of a given kind.
     * 
     * @param integrationKey The key used to specify the integration kind. (required)
     * @param subscriptionBody Create a new integration subscription. (required)
     * @return ApiResponse&lt;IntegrationSubscription&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<IntegrationSubscription> postIntegrationSubscriptionWithHttpInfo(String integrationKey, SubscriptionBody subscriptionBody) throws ApiException {
        com.squareup.okhttp.Call call = postIntegrationSubscriptionValidateBeforeCall(integrationKey, subscriptionBody, null, null);
        Type localVarReturnType = new TypeToken<IntegrationSubscription>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Create a new integration subscription of a given kind. (asynchronously)
     * 
     * @param integrationKey The key used to specify the integration kind. (required)
     * @param subscriptionBody Create a new integration subscription. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postIntegrationSubscriptionAsync(String integrationKey, SubscriptionBody subscriptionBody, final ApiCallback<IntegrationSubscription> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = postIntegrationSubscriptionValidateBeforeCall(integrationKey, subscriptionBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IntegrationSubscription>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
