/*
 * LaunchDarkly REST API
 * Build custom integrations with the LaunchDarkly REST API
 *
 * OpenAPI spec version: 5.3.0
 * Contact: support@launchdarkly.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.launchdarkly.api.api;

import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.ProgressRequestBody;
import com.launchdarkly.api.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import com.launchdarkly.api.model.BigSegmentTargetsBody;
import com.launchdarkly.api.model.PatchOperation;
import com.launchdarkly.api.model.UserSegment;
import com.launchdarkly.api.model.UserSegmentBody;
import com.launchdarkly.api.model.UserSegments;
import com.launchdarkly.api.model.UserTargetingExpirationForSegment;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserSegmentsApi {
    private ApiClient apiClient;

    public UserSegmentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserSegmentsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for deleteUserSegment
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call deleteUserSegmentCall(String projectKey, String environmentKey, String userSegmentKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/segments/{projectKey}/{environmentKey}/{userSegmentKey}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()))
            .replaceAll("\\{" + "userSegmentKey" + "\\}", apiClient.escapeString(userSegmentKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call deleteUserSegmentValidateBeforeCall(String projectKey, String environmentKey, String userSegmentKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteUserSegment(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling deleteUserSegment(Async)");
        }
        
        // verify the required parameter 'userSegmentKey' is set
        if (userSegmentKey == null) {
            throw new ApiException("Missing the required parameter 'userSegmentKey' when calling deleteUserSegment(Async)");
        }
        

        com.squareup.okhttp.Call call = deleteUserSegmentCall(projectKey, environmentKey, userSegmentKey, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Delete a user segment.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void deleteUserSegment(String projectKey, String environmentKey, String userSegmentKey) throws ApiException {
        deleteUserSegmentWithHttpInfo(projectKey, environmentKey, userSegmentKey);
    }

    /**
     * Delete a user segment.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> deleteUserSegmentWithHttpInfo(String projectKey, String environmentKey, String userSegmentKey) throws ApiException {
        com.squareup.okhttp.Call call = deleteUserSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentKey, null, null);
        return apiClient.execute(call);
    }

    /**
     * Delete a user segment. (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call deleteUserSegmentAsync(String projectKey, String environmentKey, String userSegmentKey, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = deleteUserSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentKey, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
    /**
     * Build call for getExpiringUserTargetsOnSegment
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getExpiringUserTargetsOnSegmentCall(String projectKey, String environmentKey, String userSegmentKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/segments/{projectKey}/{userSegmentKey}/expiring-user-targets/{environmentKey}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()))
            .replaceAll("\\{" + "userSegmentKey" + "\\}", apiClient.escapeString(userSegmentKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getExpiringUserTargetsOnSegmentValidateBeforeCall(String projectKey, String environmentKey, String userSegmentKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getExpiringUserTargetsOnSegment(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getExpiringUserTargetsOnSegment(Async)");
        }
        
        // verify the required parameter 'userSegmentKey' is set
        if (userSegmentKey == null) {
            throw new ApiException("Missing the required parameter 'userSegmentKey' when calling getExpiringUserTargetsOnSegment(Async)");
        }
        

        com.squareup.okhttp.Call call = getExpiringUserTargetsOnSegmentCall(projectKey, environmentKey, userSegmentKey, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get expiring user targets for user segment
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @return UserTargetingExpirationForSegment
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UserTargetingExpirationForSegment getExpiringUserTargetsOnSegment(String projectKey, String environmentKey, String userSegmentKey) throws ApiException {
        ApiResponse<UserTargetingExpirationForSegment> resp = getExpiringUserTargetsOnSegmentWithHttpInfo(projectKey, environmentKey, userSegmentKey);
        return resp.getData();
    }

    /**
     * Get expiring user targets for user segment
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @return ApiResponse&lt;UserTargetingExpirationForSegment&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UserTargetingExpirationForSegment> getExpiringUserTargetsOnSegmentWithHttpInfo(String projectKey, String environmentKey, String userSegmentKey) throws ApiException {
        com.squareup.okhttp.Call call = getExpiringUserTargetsOnSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentKey, null, null);
        Type localVarReturnType = new TypeToken<UserTargetingExpirationForSegment>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get expiring user targets for user segment (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getExpiringUserTargetsOnSegmentAsync(String projectKey, String environmentKey, String userSegmentKey, final ApiCallback<UserTargetingExpirationForSegment> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getExpiringUserTargetsOnSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserTargetingExpirationForSegment>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getUserSegment
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUserSegmentCall(String projectKey, String environmentKey, String userSegmentKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/segments/{projectKey}/{environmentKey}/{userSegmentKey}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()))
            .replaceAll("\\{" + "userSegmentKey" + "\\}", apiClient.escapeString(userSegmentKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUserSegmentValidateBeforeCall(String projectKey, String environmentKey, String userSegmentKey, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getUserSegment(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getUserSegment(Async)");
        }
        
        // verify the required parameter 'userSegmentKey' is set
        if (userSegmentKey == null) {
            throw new ApiException("Missing the required parameter 'userSegmentKey' when calling getUserSegment(Async)");
        }
        

        com.squareup.okhttp.Call call = getUserSegmentCall(projectKey, environmentKey, userSegmentKey, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a single user segment by key.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @return UserSegment
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UserSegment getUserSegment(String projectKey, String environmentKey, String userSegmentKey) throws ApiException {
        ApiResponse<UserSegment> resp = getUserSegmentWithHttpInfo(projectKey, environmentKey, userSegmentKey);
        return resp.getData();
    }

    /**
     * Get a single user segment by key.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @return ApiResponse&lt;UserSegment&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UserSegment> getUserSegmentWithHttpInfo(String projectKey, String environmentKey, String userSegmentKey) throws ApiException {
        com.squareup.okhttp.Call call = getUserSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentKey, null, null);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a single user segment by key. (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getUserSegmentAsync(String projectKey, String environmentKey, String userSegmentKey, final ApiCallback<UserSegment> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getUserSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for getUserSegments
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param tag Filter by tag. A tag can be used to group flags across projects. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call getUserSegmentsCall(String projectKey, String environmentKey, String tag, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/segments/{projectKey}/{environmentKey}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (tag != null)
        localVarQueryParams.addAll(apiClient.parameterToPair("tag", tag));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call getUserSegmentsValidateBeforeCall(String projectKey, String environmentKey, String tag, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getUserSegments(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getUserSegments(Async)");
        }
        

        com.squareup.okhttp.Call call = getUserSegmentsCall(projectKey, environmentKey, tag, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Get a list of all user segments in the given project.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param tag Filter by tag. A tag can be used to group flags across projects. (optional)
     * @return UserSegments
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UserSegments getUserSegments(String projectKey, String environmentKey, String tag) throws ApiException {
        ApiResponse<UserSegments> resp = getUserSegmentsWithHttpInfo(projectKey, environmentKey, tag);
        return resp.getData();
    }

    /**
     * Get a list of all user segments in the given project.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param tag Filter by tag. A tag can be used to group flags across projects. (optional)
     * @return ApiResponse&lt;UserSegments&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UserSegments> getUserSegmentsWithHttpInfo(String projectKey, String environmentKey, String tag) throws ApiException {
        com.squareup.okhttp.Call call = getUserSegmentsValidateBeforeCall(projectKey, environmentKey, tag, null, null);
        Type localVarReturnType = new TypeToken<UserSegments>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get a list of all user segments in the given project. (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param tag Filter by tag. A tag can be used to group flags across projects. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call getUserSegmentsAsync(String projectKey, String environmentKey, String tag, final ApiCallback<UserSegments> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = getUserSegmentsValidateBeforeCall(projectKey, environmentKey, tag, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserSegments>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for patchExpiringUserTargetsOnSegment
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @param semanticPatchWithComment Requires a Semantic Patch representation of the desired changes to the resource. &#39;https://apidocs.launchdarkly.com/reference#updates-via-semantic-patches&#39;. The addition of comments is also supported. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call patchExpiringUserTargetsOnSegmentCall(String projectKey, String environmentKey, String userSegmentKey, Object semanticPatchWithComment, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = semanticPatchWithComment;

        // create path and map variables
        String localVarPath = "/segments/{projectKey}/{userSegmentKey}/expiring-user-targets/{environmentKey}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()))
            .replaceAll("\\{" + "userSegmentKey" + "\\}", apiClient.escapeString(userSegmentKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call patchExpiringUserTargetsOnSegmentValidateBeforeCall(String projectKey, String environmentKey, String userSegmentKey, Object semanticPatchWithComment, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchExpiringUserTargetsOnSegment(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchExpiringUserTargetsOnSegment(Async)");
        }
        
        // verify the required parameter 'userSegmentKey' is set
        if (userSegmentKey == null) {
            throw new ApiException("Missing the required parameter 'userSegmentKey' when calling patchExpiringUserTargetsOnSegment(Async)");
        }
        
        // verify the required parameter 'semanticPatchWithComment' is set
        if (semanticPatchWithComment == null) {
            throw new ApiException("Missing the required parameter 'semanticPatchWithComment' when calling patchExpiringUserTargetsOnSegment(Async)");
        }
        

        com.squareup.okhttp.Call call = patchExpiringUserTargetsOnSegmentCall(projectKey, environmentKey, userSegmentKey, semanticPatchWithComment, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Update, add, or delete expiring user targets on user segment
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @param semanticPatchWithComment Requires a Semantic Patch representation of the desired changes to the resource. &#39;https://apidocs.launchdarkly.com/reference#updates-via-semantic-patches&#39;. The addition of comments is also supported. (required)
     * @return UserTargetingExpirationForSegment
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UserTargetingExpirationForSegment patchExpiringUserTargetsOnSegment(String projectKey, String environmentKey, String userSegmentKey, Object semanticPatchWithComment) throws ApiException {
        ApiResponse<UserTargetingExpirationForSegment> resp = patchExpiringUserTargetsOnSegmentWithHttpInfo(projectKey, environmentKey, userSegmentKey, semanticPatchWithComment);
        return resp.getData();
    }

    /**
     * Update, add, or delete expiring user targets on user segment
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @param semanticPatchWithComment Requires a Semantic Patch representation of the desired changes to the resource. &#39;https://apidocs.launchdarkly.com/reference#updates-via-semantic-patches&#39;. The addition of comments is also supported. (required)
     * @return ApiResponse&lt;UserTargetingExpirationForSegment&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UserTargetingExpirationForSegment> patchExpiringUserTargetsOnSegmentWithHttpInfo(String projectKey, String environmentKey, String userSegmentKey, Object semanticPatchWithComment) throws ApiException {
        com.squareup.okhttp.Call call = patchExpiringUserTargetsOnSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentKey, semanticPatchWithComment, null, null);
        Type localVarReturnType = new TypeToken<UserTargetingExpirationForSegment>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update, add, or delete expiring user targets on user segment (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @param semanticPatchWithComment Requires a Semantic Patch representation of the desired changes to the resource. &#39;https://apidocs.launchdarkly.com/reference#updates-via-semantic-patches&#39;. The addition of comments is also supported. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call patchExpiringUserTargetsOnSegmentAsync(String projectKey, String environmentKey, String userSegmentKey, Object semanticPatchWithComment, final ApiCallback<UserTargetingExpirationForSegment> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = patchExpiringUserTargetsOnSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentKey, semanticPatchWithComment, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserTargetingExpirationForSegment>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for patchUserSegment
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @param patchOnly Requires a JSON Patch representation of the desired changes to the project. &#39;http://jsonpatch.com/&#39; Feature flag patches also support JSON Merge Patch format. &#39;https://tools.ietf.org/html/rfc7386&#39; The addition of comments is also supported. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call patchUserSegmentCall(String projectKey, String environmentKey, String userSegmentKey, List<PatchOperation> patchOnly, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = patchOnly;

        // create path and map variables
        String localVarPath = "/segments/{projectKey}/{environmentKey}/{userSegmentKey}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()))
            .replaceAll("\\{" + "userSegmentKey" + "\\}", apiClient.escapeString(userSegmentKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call patchUserSegmentValidateBeforeCall(String projectKey, String environmentKey, String userSegmentKey, List<PatchOperation> patchOnly, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchUserSegment(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchUserSegment(Async)");
        }
        
        // verify the required parameter 'userSegmentKey' is set
        if (userSegmentKey == null) {
            throw new ApiException("Missing the required parameter 'userSegmentKey' when calling patchUserSegment(Async)");
        }
        
        // verify the required parameter 'patchOnly' is set
        if (patchOnly == null) {
            throw new ApiException("Missing the required parameter 'patchOnly' when calling patchUserSegment(Async)");
        }
        

        com.squareup.okhttp.Call call = patchUserSegmentCall(projectKey, environmentKey, userSegmentKey, patchOnly, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Perform a partial update to a user segment.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @param patchOnly Requires a JSON Patch representation of the desired changes to the project. &#39;http://jsonpatch.com/&#39; Feature flag patches also support JSON Merge Patch format. &#39;https://tools.ietf.org/html/rfc7386&#39; The addition of comments is also supported. (required)
     * @return UserSegment
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UserSegment patchUserSegment(String projectKey, String environmentKey, String userSegmentKey, List<PatchOperation> patchOnly) throws ApiException {
        ApiResponse<UserSegment> resp = patchUserSegmentWithHttpInfo(projectKey, environmentKey, userSegmentKey, patchOnly);
        return resp.getData();
    }

    /**
     * Perform a partial update to a user segment.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @param patchOnly Requires a JSON Patch representation of the desired changes to the project. &#39;http://jsonpatch.com/&#39; Feature flag patches also support JSON Merge Patch format. &#39;https://tools.ietf.org/html/rfc7386&#39; The addition of comments is also supported. (required)
     * @return ApiResponse&lt;UserSegment&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UserSegment> patchUserSegmentWithHttpInfo(String projectKey, String environmentKey, String userSegmentKey, List<PatchOperation> patchOnly) throws ApiException {
        com.squareup.okhttp.Call call = patchUserSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentKey, patchOnly, null, null);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Perform a partial update to a user segment. (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @param patchOnly Requires a JSON Patch representation of the desired changes to the project. &#39;http://jsonpatch.com/&#39; Feature flag patches also support JSON Merge Patch format. &#39;https://tools.ietf.org/html/rfc7386&#39; The addition of comments is also supported. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call patchUserSegmentAsync(String projectKey, String environmentKey, String userSegmentKey, List<PatchOperation> patchOnly, final ApiCallback<UserSegment> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = patchUserSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentKey, patchOnly, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for postUserSegment
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentBody Create a new user segment. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call postUserSegmentCall(String projectKey, String environmentKey, UserSegmentBody userSegmentBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = userSegmentBody;

        // create path and map variables
        String localVarPath = "/segments/{projectKey}/{environmentKey}"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call postUserSegmentValidateBeforeCall(String projectKey, String environmentKey, UserSegmentBody userSegmentBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postUserSegment(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling postUserSegment(Async)");
        }
        
        // verify the required parameter 'userSegmentBody' is set
        if (userSegmentBody == null) {
            throw new ApiException("Missing the required parameter 'userSegmentBody' when calling postUserSegment(Async)");
        }
        

        com.squareup.okhttp.Call call = postUserSegmentCall(projectKey, environmentKey, userSegmentBody, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Creates a new user segment.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentBody Create a new user segment. (required)
     * @return UserSegment
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public UserSegment postUserSegment(String projectKey, String environmentKey, UserSegmentBody userSegmentBody) throws ApiException {
        ApiResponse<UserSegment> resp = postUserSegmentWithHttpInfo(projectKey, environmentKey, userSegmentBody);
        return resp.getData();
    }

    /**
     * Creates a new user segment.
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentBody Create a new user segment. (required)
     * @return ApiResponse&lt;UserSegment&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<UserSegment> postUserSegmentWithHttpInfo(String projectKey, String environmentKey, UserSegmentBody userSegmentBody) throws ApiException {
        com.squareup.okhttp.Call call = postUserSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentBody, null, null);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Creates a new user segment. (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentBody Create a new user segment. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call postUserSegmentAsync(String projectKey, String environmentKey, UserSegmentBody userSegmentBody, final ApiCallback<UserSegment> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = postUserSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for updateBigSegmentTargets
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @param bigSegmentTargetsBody Add or remove user targets to the included or excluded lists on a big segment. Contact your account manager for early access to this feature. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call updateBigSegmentTargetsCall(String projectKey, String environmentKey, String userSegmentKey, BigSegmentTargetsBody bigSegmentTargetsBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = bigSegmentTargetsBody;

        // create path and map variables
        String localVarPath = "/segments/{projectKey}/{environmentKey}/{userSegmentKey}/users"
            .replaceAll("\\{" + "projectKey" + "\\}", apiClient.escapeString(projectKey.toString()))
            .replaceAll("\\{" + "environmentKey" + "\\}", apiClient.escapeString(environmentKey.toString()))
            .replaceAll("\\{" + "userSegmentKey" + "\\}", apiClient.escapeString(userSegmentKey.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "Token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call updateBigSegmentTargetsValidateBeforeCall(String projectKey, String environmentKey, String userSegmentKey, BigSegmentTargetsBody bigSegmentTargetsBody, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'projectKey' is set
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling updateBigSegmentTargets(Async)");
        }
        
        // verify the required parameter 'environmentKey' is set
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling updateBigSegmentTargets(Async)");
        }
        
        // verify the required parameter 'userSegmentKey' is set
        if (userSegmentKey == null) {
            throw new ApiException("Missing the required parameter 'userSegmentKey' when calling updateBigSegmentTargets(Async)");
        }
        
        // verify the required parameter 'bigSegmentTargetsBody' is set
        if (bigSegmentTargetsBody == null) {
            throw new ApiException("Missing the required parameter 'bigSegmentTargetsBody' when calling updateBigSegmentTargets(Async)");
        }
        

        com.squareup.okhttp.Call call = updateBigSegmentTargetsCall(projectKey, environmentKey, userSegmentKey, bigSegmentTargetsBody, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Update targets included or excluded in a big segment
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @param bigSegmentTargetsBody Add or remove user targets to the included or excluded lists on a big segment. Contact your account manager for early access to this feature. (required)
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public void updateBigSegmentTargets(String projectKey, String environmentKey, String userSegmentKey, BigSegmentTargetsBody bigSegmentTargetsBody) throws ApiException {
        updateBigSegmentTargetsWithHttpInfo(projectKey, environmentKey, userSegmentKey, bigSegmentTargetsBody);
    }

    /**
     * Update targets included or excluded in a big segment
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @param bigSegmentTargetsBody Add or remove user targets to the included or excluded lists on a big segment. Contact your account manager for early access to this feature. (required)
     * @return ApiResponse&lt;Void&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<Void> updateBigSegmentTargetsWithHttpInfo(String projectKey, String environmentKey, String userSegmentKey, BigSegmentTargetsBody bigSegmentTargetsBody) throws ApiException {
        com.squareup.okhttp.Call call = updateBigSegmentTargetsValidateBeforeCall(projectKey, environmentKey, userSegmentKey, bigSegmentTargetsBody, null, null);
        return apiClient.execute(call);
    }

    /**
     * Update targets included or excluded in a big segment (asynchronously)
     * 
     * @param projectKey The project key, used to tie the flags together under one project so they can be managed together. (required)
     * @param environmentKey The environment key, used to tie together flag configuration and users under one environment so they can be managed together. (required)
     * @param userSegmentKey The user segment&#39;s key. The key identifies the user segment in your code. (required)
     * @param bigSegmentTargetsBody Add or remove user targets to the included or excluded lists on a big segment. Contact your account manager for early access to this feature. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call updateBigSegmentTargetsAsync(String projectKey, String environmentKey, String userSegmentKey, BigSegmentTargetsBody bigSegmentTargetsBody, final ApiCallback<Void> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = updateBigSegmentTargetsValidateBeforeCall(projectKey, environmentKey, userSegmentKey, bigSegmentTargetsBody, progressListener, progressRequestListener);
        apiClient.executeAsync(call, callback);
        return call;
    }
}
