/*
 * LaunchDarkly REST API
 * Build custom integrations with the LaunchDarkly REST API
 *
 * OpenAPI spec version: 5.3.0
 * Contact: support@launchdarkly.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.launchdarkly.api.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.model.ApprovalRequestReview;
import com.launchdarkly.api.model.ApprovalRequestReviewStatus;
import com.launchdarkly.api.model.SemanticPatchInstruction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * ApprovalRequest
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2021-07-14T18:58:43.744Z")



public class ApprovalRequest {
  @SerializedName("_id")
  private String id = null;

  @SerializedName("_version")
  private Integer version = null;

  @SerializedName("creationDate")
  private Integer creationDate = null;

  @SerializedName("requestorId")
  private String requestorId = null;

  @SerializedName("reviewStatus")
  private ApprovalRequestReviewStatus reviewStatus = null;

  /**
   * | Name      | Description | | ---------:| ----------- | | pending   | the approval request has not been applied yet | | completed | the approval request has been applied successfully | | scheduled | the approval request for a scheduled change has been applied successfully | | failed    | the approval request has been applied but the changes were not applied successfully | 
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    PENDING("pending"),
    
    COMPLETED("completed"),
    
    SCHEDULED("scheduled"),
    
    FAILED("failed");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String text) {
      for (StatusEnum b : StatusEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return StatusEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("status")
  private StatusEnum status = null;

  @SerializedName("appliedByMemberID")
  private String appliedByMemberID = null;

  @SerializedName("appliedDate")
  private Integer appliedDate = null;

  @SerializedName("allReviews")
  private List<ApprovalRequestReview> allReviews = null;

  @SerializedName("notifyMemberIds")
  private List<String> notifyMemberIds = null;

  @SerializedName("instructions")
  private SemanticPatchInstruction instructions = null;

  @SerializedName("executionDate")
  private Long executionDate = null;

  @SerializedName("operatingOnId")
  private String operatingOnId = null;

  public ApprovalRequest id(String id) {
    this.id = id;
    return this;
  }

   /**
   * Get id
   * @return id
  **/
  @ApiModelProperty(value = "")
  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public ApprovalRequest version(Integer version) {
    this.version = version;
    return this;
  }

   /**
   * Get version
   * @return version
  **/
  @ApiModelProperty(value = "")
  public Integer getVersion() {
    return version;
  }

  public void setVersion(Integer version) {
    this.version = version;
  }

  public ApprovalRequest creationDate(Integer creationDate) {
    this.creationDate = creationDate;
    return this;
  }

   /**
   * A unix epoch time in milliseconds specifying the date the approval request was requested
   * @return creationDate
  **/
  @ApiModelProperty(value = "A unix epoch time in milliseconds specifying the date the approval request was requested")
  public Integer getCreationDate() {
    return creationDate;
  }

  public void setCreationDate(Integer creationDate) {
    this.creationDate = creationDate;
  }

  public ApprovalRequest requestorId(String requestorId) {
    this.requestorId = requestorId;
    return this;
  }

   /**
   * The id of the member that requested the change
   * @return requestorId
  **/
  @ApiModelProperty(value = "The id of the member that requested the change")
  public String getRequestorId() {
    return requestorId;
  }

  public void setRequestorId(String requestorId) {
    this.requestorId = requestorId;
  }

  public ApprovalRequest reviewStatus(ApprovalRequestReviewStatus reviewStatus) {
    this.reviewStatus = reviewStatus;
    return this;
  }

   /**
   * Get reviewStatus
   * @return reviewStatus
  **/
  @ApiModelProperty(value = "")
  public ApprovalRequestReviewStatus getReviewStatus() {
    return reviewStatus;
  }

  public void setReviewStatus(ApprovalRequestReviewStatus reviewStatus) {
    this.reviewStatus = reviewStatus;
  }

  public ApprovalRequest status(StatusEnum status) {
    this.status = status;
    return this;
  }

   /**
   * | Name      | Description | | ---------:| ----------- | | pending   | the approval request has not been applied yet | | completed | the approval request has been applied successfully | | scheduled | the approval request for a scheduled change has been applied successfully | | failed    | the approval request has been applied but the changes were not applied successfully | 
   * @return status
  **/
  @ApiModelProperty(value = "| Name      | Description | | ---------:| ----------- | | pending   | the approval request has not been applied yet | | completed | the approval request has been applied successfully | | scheduled | the approval request for a scheduled change has been applied successfully | | failed    | the approval request has been applied but the changes were not applied successfully | ")
  public StatusEnum getStatus() {
    return status;
  }

  public void setStatus(StatusEnum status) {
    this.status = status;
  }

  public ApprovalRequest appliedByMemberID(String appliedByMemberID) {
    this.appliedByMemberID = appliedByMemberID;
    return this;
  }

   /**
   * The id of the member that applied the approval request
   * @return appliedByMemberID
  **/
  @ApiModelProperty(value = "The id of the member that applied the approval request")
  public String getAppliedByMemberID() {
    return appliedByMemberID;
  }

  public void setAppliedByMemberID(String appliedByMemberID) {
    this.appliedByMemberID = appliedByMemberID;
  }

  public ApprovalRequest appliedDate(Integer appliedDate) {
    this.appliedDate = appliedDate;
    return this;
  }

   /**
   * A unix epoch time in milliseconds specifying the date the approval request was applied
   * @return appliedDate
  **/
  @ApiModelProperty(value = "A unix epoch time in milliseconds specifying the date the approval request was applied")
  public Integer getAppliedDate() {
    return appliedDate;
  }

  public void setAppliedDate(Integer appliedDate) {
    this.appliedDate = appliedDate;
  }

  public ApprovalRequest allReviews(List<ApprovalRequestReview> allReviews) {
    this.allReviews = allReviews;
    return this;
  }

  public ApprovalRequest addAllReviewsItem(ApprovalRequestReview allReviewsItem) {
    if (this.allReviews == null) {
      this.allReviews = new ArrayList<ApprovalRequestReview>();
    }
    this.allReviews.add(allReviewsItem);
    return this;
  }

   /**
   * Get allReviews
   * @return allReviews
  **/
  @ApiModelProperty(value = "")
  public List<ApprovalRequestReview> getAllReviews() {
    return allReviews;
  }

  public void setAllReviews(List<ApprovalRequestReview> allReviews) {
    this.allReviews = allReviews;
  }

  public ApprovalRequest notifyMemberIds(List<String> notifyMemberIds) {
    this.notifyMemberIds = notifyMemberIds;
    return this;
  }

  public ApprovalRequest addNotifyMemberIdsItem(String notifyMemberIdsItem) {
    if (this.notifyMemberIds == null) {
      this.notifyMemberIds = new ArrayList<String>();
    }
    this.notifyMemberIds.add(notifyMemberIdsItem);
    return this;
  }

   /**
   * Get notifyMemberIds
   * @return notifyMemberIds
  **/
  @ApiModelProperty(example = "[\"memberId\",\"memberId2\"]", value = "")
  public List<String> getNotifyMemberIds() {
    return notifyMemberIds;
  }

  public void setNotifyMemberIds(List<String> notifyMemberIds) {
    this.notifyMemberIds = notifyMemberIds;
  }

  public ApprovalRequest instructions(SemanticPatchInstruction instructions) {
    this.instructions = instructions;
    return this;
  }

   /**
   * Get instructions
   * @return instructions
  **/
  @ApiModelProperty(value = "")
  public SemanticPatchInstruction getInstructions() {
    return instructions;
  }

  public void setInstructions(SemanticPatchInstruction instructions) {
    this.instructions = instructions;
  }

  public ApprovalRequest executionDate(Long executionDate) {
    this.executionDate = executionDate;
    return this;
  }

   /**
   * Timestamp for when instructions will be executed
   * @return executionDate
  **/
  @ApiModelProperty(value = "Timestamp for when instructions will be executed")
  public Long getExecutionDate() {
    return executionDate;
  }

  public void setExecutionDate(Long executionDate) {
    this.executionDate = executionDate;
  }

  public ApprovalRequest operatingOnId(String operatingOnId) {
    this.operatingOnId = operatingOnId;
    return this;
  }

   /**
   * ID of scheduled change to edit or delete
   * @return operatingOnId
  **/
  @ApiModelProperty(value = "ID of scheduled change to edit or delete")
  public String getOperatingOnId() {
    return operatingOnId;
  }

  public void setOperatingOnId(String operatingOnId) {
    this.operatingOnId = operatingOnId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApprovalRequest approvalRequest = (ApprovalRequest) o;
    return Objects.equals(this.id, approvalRequest.id) &&
        Objects.equals(this.version, approvalRequest.version) &&
        Objects.equals(this.creationDate, approvalRequest.creationDate) &&
        Objects.equals(this.requestorId, approvalRequest.requestorId) &&
        Objects.equals(this.reviewStatus, approvalRequest.reviewStatus) &&
        Objects.equals(this.status, approvalRequest.status) &&
        Objects.equals(this.appliedByMemberID, approvalRequest.appliedByMemberID) &&
        Objects.equals(this.appliedDate, approvalRequest.appliedDate) &&
        Objects.equals(this.allReviews, approvalRequest.allReviews) &&
        Objects.equals(this.notifyMemberIds, approvalRequest.notifyMemberIds) &&
        Objects.equals(this.instructions, approvalRequest.instructions) &&
        Objects.equals(this.executionDate, approvalRequest.executionDate) &&
        Objects.equals(this.operatingOnId, approvalRequest.operatingOnId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, version, creationDate, requestorId, reviewStatus, status, appliedByMemberID, appliedDate, allReviews, notifyMemberIds, instructions, executionDate, operatingOnId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApprovalRequest {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    creationDate: ").append(toIndentedString(creationDate)).append("\n");
    sb.append("    requestorId: ").append(toIndentedString(requestorId)).append("\n");
    sb.append("    reviewStatus: ").append(toIndentedString(reviewStatus)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    appliedByMemberID: ").append(toIndentedString(appliedByMemberID)).append("\n");
    sb.append("    appliedDate: ").append(toIndentedString(appliedDate)).append("\n");
    sb.append("    allReviews: ").append(toIndentedString(allReviews)).append("\n");
    sb.append("    notifyMemberIds: ").append(toIndentedString(notifyMemberIds)).append("\n");
    sb.append("    instructions: ").append(toIndentedString(instructions)).append("\n");
    sb.append("    executionDate: ").append(toIndentedString(executionDate)).append("\n");
    sb.append("    operatingOnId: ").append(toIndentedString(operatingOnId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

