/*
 * LaunchDarkly REST API
 * Build custom integrations with the LaunchDarkly REST API
 *
 * OpenAPI spec version: 5.3.0
 * Contact: support@launchdarkly.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package com.launchdarkly.api.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * Approval settings for an environment. Only appears if the approvals feature is enabled.
 */
@ApiModel(description = "Approval settings for an environment. Only appears if the approvals feature is enabled.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2021-07-14T18:58:43.744Z")



public class EnvironmentApprovalSettings {
  /**
   * The approvals system used.
   */
  @JsonAdapter(ServiceKindEnum.Adapter.class)
  public enum ServiceKindEnum {
    LAUNCHDARKLY("launchdarkly"),
    
    SERVICE_NOW("service-now");

    private String value;

    ServiceKindEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static ServiceKindEnum fromValue(String text) {
      for (ServiceKindEnum b : ServiceKindEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<ServiceKindEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final ServiceKindEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public ServiceKindEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return ServiceKindEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("serviceKind")
  private ServiceKindEnum serviceKind = null;

  @SerializedName("required")
  private Boolean required = null;

  @SerializedName("canReviewOwnRequest")
  private Boolean canReviewOwnRequest = null;

  @SerializedName("minNumApprovals")
  private Long minNumApprovals = null;

  @SerializedName("canApplyDeclinedChanges")
  private Boolean canApplyDeclinedChanges = null;

  @SerializedName("requiredApprovalTags")
  private List<String> requiredApprovalTags = null;

  public EnvironmentApprovalSettings serviceKind(ServiceKindEnum serviceKind) {
    this.serviceKind = serviceKind;
    return this;
  }

   /**
   * The approvals system used.
   * @return serviceKind
  **/
  @ApiModelProperty(value = "The approvals system used.")
  public ServiceKindEnum getServiceKind() {
    return serviceKind;
  }

  public void setServiceKind(ServiceKindEnum serviceKind) {
    this.serviceKind = serviceKind;
  }

  public EnvironmentApprovalSettings required(Boolean required) {
    this.required = required;
    return this;
  }

   /**
   * Whether any changes to flags in this environment will require approval. You may only set required or requiredApprovalTags, not both.
   * @return required
  **/
  @ApiModelProperty(value = "Whether any changes to flags in this environment will require approval. You may only set required or requiredApprovalTags, not both.")
  public Boolean isRequired() {
    return required;
  }

  public void setRequired(Boolean required) {
    this.required = required;
  }

  public EnvironmentApprovalSettings canReviewOwnRequest(Boolean canReviewOwnRequest) {
    this.canReviewOwnRequest = canReviewOwnRequest;
    return this;
  }

   /**
   * Whether requesters can approve or decline their own request. They may always comment.
   * @return canReviewOwnRequest
  **/
  @ApiModelProperty(value = "Whether requesters can approve or decline their own request. They may always comment.")
  public Boolean isCanReviewOwnRequest() {
    return canReviewOwnRequest;
  }

  public void setCanReviewOwnRequest(Boolean canReviewOwnRequest) {
    this.canReviewOwnRequest = canReviewOwnRequest;
  }

  public EnvironmentApprovalSettings minNumApprovals(Long minNumApprovals) {
    this.minNumApprovals = minNumApprovals;
    return this;
  }

   /**
   * The number of approvals required before an approval request can be applied.
   * @return minNumApprovals
  **/
  @ApiModelProperty(example = "2", value = "The number of approvals required before an approval request can be applied.")
  public Long getMinNumApprovals() {
    return minNumApprovals;
  }

  public void setMinNumApprovals(Long minNumApprovals) {
    this.minNumApprovals = minNumApprovals;
  }

  public EnvironmentApprovalSettings canApplyDeclinedChanges(Boolean canApplyDeclinedChanges) {
    this.canApplyDeclinedChanges = canApplyDeclinedChanges;
    return this;
  }

   /**
   * Whether changes can be applied as long as minNumApprovals is met, regardless of if any reviewers have declined a request.
   * @return canApplyDeclinedChanges
  **/
  @ApiModelProperty(value = "Whether changes can be applied as long as minNumApprovals is met, regardless of if any reviewers have declined a request.")
  public Boolean isCanApplyDeclinedChanges() {
    return canApplyDeclinedChanges;
  }

  public void setCanApplyDeclinedChanges(Boolean canApplyDeclinedChanges) {
    this.canApplyDeclinedChanges = canApplyDeclinedChanges;
  }

  public EnvironmentApprovalSettings requiredApprovalTags(List<String> requiredApprovalTags) {
    this.requiredApprovalTags = requiredApprovalTags;
    return this;
  }

  public EnvironmentApprovalSettings addRequiredApprovalTagsItem(String requiredApprovalTagsItem) {
    if (this.requiredApprovalTags == null) {
      this.requiredApprovalTags = new ArrayList<String>();
    }
    this.requiredApprovalTags.add(requiredApprovalTagsItem);
    return this;
  }

   /**
   * An array of tags used to specify which flags with those tags require approval. You may only set requiredApprovalTags or required, not both.
   * @return requiredApprovalTags
  **/
  @ApiModelProperty(value = "An array of tags used to specify which flags with those tags require approval. You may only set requiredApprovalTags or required, not both.")
  public List<String> getRequiredApprovalTags() {
    return requiredApprovalTags;
  }

  public void setRequiredApprovalTags(List<String> requiredApprovalTags) {
    this.requiredApprovalTags = requiredApprovalTags;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EnvironmentApprovalSettings environmentApprovalSettings = (EnvironmentApprovalSettings) o;
    return Objects.equals(this.serviceKind, environmentApprovalSettings.serviceKind) &&
        Objects.equals(this.required, environmentApprovalSettings.required) &&
        Objects.equals(this.canReviewOwnRequest, environmentApprovalSettings.canReviewOwnRequest) &&
        Objects.equals(this.minNumApprovals, environmentApprovalSettings.minNumApprovals) &&
        Objects.equals(this.canApplyDeclinedChanges, environmentApprovalSettings.canApplyDeclinedChanges) &&
        Objects.equals(this.requiredApprovalTags, environmentApprovalSettings.requiredApprovalTags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(serviceKind, required, canReviewOwnRequest, minNumApprovals, canApplyDeclinedChanges, requiredApprovalTags);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EnvironmentApprovalSettings {\n");
    
    sb.append("    serviceKind: ").append(toIndentedString(serviceKind)).append("\n");
    sb.append("    required: ").append(toIndentedString(required)).append("\n");
    sb.append("    canReviewOwnRequest: ").append(toIndentedString(canReviewOwnRequest)).append("\n");
    sb.append("    minNumApprovals: ").append(toIndentedString(minNumApprovals)).append("\n");
    sb.append("    canApplyDeclinedChanges: ").append(toIndentedString(canApplyDeclinedChanges)).append("\n");
    sb.append("    requiredApprovalTags: ").append(toIndentedString(requiredApprovalTags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

