/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.ProgressRequestBody;
import com.launchdarkly.api.ProgressResponseBody;
import com.launchdarkly.api.model.CustomRole;
import com.launchdarkly.api.model.CustomRoleBody;
import com.launchdarkly.api.model.CustomRoles;
import com.launchdarkly.api.model.PatchOperation;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CustomRolesApi {
    private ApiClient apiClient;

    public CustomRolesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CustomRolesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteCustomRoleCall(String customRoleKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/roles/{customRoleKey}".replaceAll("\\{customRoleKey\\}", this.apiClient.escapeString(customRoleKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteCustomRoleValidateBeforeCall(String customRoleKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customRoleKey == null) {
            throw new ApiException("Missing the required parameter 'customRoleKey' when calling deleteCustomRole(Async)");
        }
        Call call = this.deleteCustomRoleCall(customRoleKey, progressListener, progressRequestListener);
        return call;
    }

    public void deleteCustomRole(String customRoleKey) throws ApiException {
        this.deleteCustomRoleWithHttpInfo(customRoleKey);
    }

    public ApiResponse<Void> deleteCustomRoleWithHttpInfo(String customRoleKey) throws ApiException {
        Call call = this.deleteCustomRoleValidateBeforeCall(customRoleKey, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteCustomRoleAsync(String customRoleKey, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteCustomRoleValidateBeforeCall(customRoleKey, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getCustomRoleCall(String customRoleKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/roles/{customRoleKey}".replaceAll("\\{customRoleKey\\}", this.apiClient.escapeString(customRoleKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCustomRoleValidateBeforeCall(String customRoleKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customRoleKey == null) {
            throw new ApiException("Missing the required parameter 'customRoleKey' when calling getCustomRole(Async)");
        }
        Call call = this.getCustomRoleCall(customRoleKey, progressListener, progressRequestListener);
        return call;
    }

    public CustomRole getCustomRole(String customRoleKey) throws ApiException {
        ApiResponse<CustomRole> resp = this.getCustomRoleWithHttpInfo(customRoleKey);
        return resp.getData();
    }

    public ApiResponse<CustomRole> getCustomRoleWithHttpInfo(String customRoleKey) throws ApiException {
        Call call = this.getCustomRoleValidateBeforeCall(customRoleKey, null, null);
        Type localVarReturnType = new TypeToken<CustomRole>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCustomRoleAsync(String customRoleKey, final ApiCallback<CustomRole> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCustomRoleValidateBeforeCall(customRoleKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomRole>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getCustomRolesCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/roles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getCustomRolesValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getCustomRolesCall(progressListener, progressRequestListener);
        return call;
    }

    public CustomRoles getCustomRoles() throws ApiException {
        ApiResponse<CustomRoles> resp = this.getCustomRolesWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<CustomRoles> getCustomRolesWithHttpInfo() throws ApiException {
        Call call = this.getCustomRolesValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<CustomRoles>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getCustomRolesAsync(final ApiCallback<CustomRoles> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getCustomRolesValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomRoles>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchCustomRoleCall(String customRoleKey, List<PatchOperation> patchDelta, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        List<PatchOperation> localVarPostBody = patchDelta;
        String localVarPath = "/roles/{customRoleKey}".replaceAll("\\{customRoleKey\\}", this.apiClient.escapeString(customRoleKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchCustomRoleValidateBeforeCall(String customRoleKey, List<PatchOperation> patchDelta, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customRoleKey == null) {
            throw new ApiException("Missing the required parameter 'customRoleKey' when calling patchCustomRole(Async)");
        }
        if (patchDelta == null) {
            throw new ApiException("Missing the required parameter 'patchDelta' when calling patchCustomRole(Async)");
        }
        Call call = this.patchCustomRoleCall(customRoleKey, patchDelta, progressListener, progressRequestListener);
        return call;
    }

    public CustomRole patchCustomRole(String customRoleKey, List<PatchOperation> patchDelta) throws ApiException {
        ApiResponse<CustomRole> resp = this.patchCustomRoleWithHttpInfo(customRoleKey, patchDelta);
        return resp.getData();
    }

    public ApiResponse<CustomRole> patchCustomRoleWithHttpInfo(String customRoleKey, List<PatchOperation> patchDelta) throws ApiException {
        Call call = this.patchCustomRoleValidateBeforeCall(customRoleKey, patchDelta, null, null);
        Type localVarReturnType = new TypeToken<CustomRole>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchCustomRoleAsync(String customRoleKey, List<PatchOperation> patchDelta, final ApiCallback<CustomRole> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchCustomRoleValidateBeforeCall(customRoleKey, patchDelta, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomRole>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postCustomRoleCall(CustomRoleBody customRoleBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        CustomRoleBody localVarPostBody = customRoleBody;
        String localVarPath = "/roles";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postCustomRoleValidateBeforeCall(CustomRoleBody customRoleBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (customRoleBody == null) {
            throw new ApiException("Missing the required parameter 'customRoleBody' when calling postCustomRole(Async)");
        }
        Call call = this.postCustomRoleCall(customRoleBody, progressListener, progressRequestListener);
        return call;
    }

    public CustomRole postCustomRole(CustomRoleBody customRoleBody) throws ApiException {
        ApiResponse<CustomRole> resp = this.postCustomRoleWithHttpInfo(customRoleBody);
        return resp.getData();
    }

    public ApiResponse<CustomRole> postCustomRoleWithHttpInfo(CustomRoleBody customRoleBody) throws ApiException {
        Call call = this.postCustomRoleValidateBeforeCall(customRoleBody, null, null);
        Type localVarReturnType = new TypeToken<CustomRole>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postCustomRoleAsync(CustomRoleBody customRoleBody, final ApiCallback<CustomRole> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postCustomRoleValidateBeforeCall(customRoleBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CustomRole>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

