/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.ProgressRequestBody;
import com.launchdarkly.api.ProgressResponseBody;
import com.launchdarkly.api.model.Environment;
import com.launchdarkly.api.model.EnvironmentPost;
import com.launchdarkly.api.model.PatchOperation;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class EnvironmentsApi {
    private ApiClient apiClient;

    public EnvironmentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public EnvironmentsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteEnvironmentCall(String projectKey, String environmentKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/projects/{projectKey}/environments/{environmentKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteEnvironmentValidateBeforeCall(String projectKey, String environmentKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteEnvironment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling deleteEnvironment(Async)");
        }
        Call call = this.deleteEnvironmentCall(projectKey, environmentKey, progressListener, progressRequestListener);
        return call;
    }

    public void deleteEnvironment(String projectKey, String environmentKey) throws ApiException {
        this.deleteEnvironmentWithHttpInfo(projectKey, environmentKey);
    }

    public ApiResponse<Void> deleteEnvironmentWithHttpInfo(String projectKey, String environmentKey) throws ApiException {
        Call call = this.deleteEnvironmentValidateBeforeCall(projectKey, environmentKey, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteEnvironmentAsync(String projectKey, String environmentKey, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteEnvironmentValidateBeforeCall(projectKey, environmentKey, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getEnvironmentCall(String projectKey, String environmentKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/projects/{projectKey}/environments/{environmentKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getEnvironmentValidateBeforeCall(String projectKey, String environmentKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getEnvironment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getEnvironment(Async)");
        }
        Call call = this.getEnvironmentCall(projectKey, environmentKey, progressListener, progressRequestListener);
        return call;
    }

    public Environment getEnvironment(String projectKey, String environmentKey) throws ApiException {
        ApiResponse<Environment> resp = this.getEnvironmentWithHttpInfo(projectKey, environmentKey);
        return resp.getData();
    }

    public ApiResponse<Environment> getEnvironmentWithHttpInfo(String projectKey, String environmentKey) throws ApiException {
        Call call = this.getEnvironmentValidateBeforeCall(projectKey, environmentKey, null, null);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getEnvironmentAsync(String projectKey, String environmentKey, final ApiCallback<Environment> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getEnvironmentValidateBeforeCall(projectKey, environmentKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchEnvironmentCall(String projectKey, String environmentKey, List<PatchOperation> patchDelta, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        List<PatchOperation> localVarPostBody = patchDelta;
        String localVarPath = "/projects/{projectKey}/environments/{environmentKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchEnvironmentValidateBeforeCall(String projectKey, String environmentKey, List<PatchOperation> patchDelta, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchEnvironment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchEnvironment(Async)");
        }
        if (patchDelta == null) {
            throw new ApiException("Missing the required parameter 'patchDelta' when calling patchEnvironment(Async)");
        }
        Call call = this.patchEnvironmentCall(projectKey, environmentKey, patchDelta, progressListener, progressRequestListener);
        return call;
    }

    public Environment patchEnvironment(String projectKey, String environmentKey, List<PatchOperation> patchDelta) throws ApiException {
        ApiResponse<Environment> resp = this.patchEnvironmentWithHttpInfo(projectKey, environmentKey, patchDelta);
        return resp.getData();
    }

    public ApiResponse<Environment> patchEnvironmentWithHttpInfo(String projectKey, String environmentKey, List<PatchOperation> patchDelta) throws ApiException {
        Call call = this.patchEnvironmentValidateBeforeCall(projectKey, environmentKey, patchDelta, null, null);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchEnvironmentAsync(String projectKey, String environmentKey, List<PatchOperation> patchDelta, final ApiCallback<Environment> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchEnvironmentValidateBeforeCall(projectKey, environmentKey, patchDelta, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postEnvironmentCall(String projectKey, EnvironmentPost environmentBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        EnvironmentPost localVarPostBody = environmentBody;
        String localVarPath = "/projects/{projectKey}/environments".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postEnvironmentValidateBeforeCall(String projectKey, EnvironmentPost environmentBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postEnvironment(Async)");
        }
        if (environmentBody == null) {
            throw new ApiException("Missing the required parameter 'environmentBody' when calling postEnvironment(Async)");
        }
        Call call = this.postEnvironmentCall(projectKey, environmentBody, progressListener, progressRequestListener);
        return call;
    }

    public Environment postEnvironment(String projectKey, EnvironmentPost environmentBody) throws ApiException {
        ApiResponse<Environment> resp = this.postEnvironmentWithHttpInfo(projectKey, environmentBody);
        return resp.getData();
    }

    public ApiResponse<Environment> postEnvironmentWithHttpInfo(String projectKey, EnvironmentPost environmentBody) throws ApiException {
        Call call = this.postEnvironmentValidateBeforeCall(projectKey, environmentBody, null, null);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postEnvironmentAsync(String projectKey, EnvironmentPost environmentBody, final ApiCallback<Environment> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postEnvironmentValidateBeforeCall(projectKey, environmentBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call resetEnvironmentMobileKeyCall(String projectKey, String environmentKey, Long expiry, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/projects/{projectKey}/environments/{environmentKey}/mobileKey".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expiry != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("expiry", expiry));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call resetEnvironmentMobileKeyValidateBeforeCall(String projectKey, String environmentKey, Long expiry, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling resetEnvironmentMobileKey(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling resetEnvironmentMobileKey(Async)");
        }
        Call call = this.resetEnvironmentMobileKeyCall(projectKey, environmentKey, expiry, progressListener, progressRequestListener);
        return call;
    }

    public Environment resetEnvironmentMobileKey(String projectKey, String environmentKey, Long expiry) throws ApiException {
        ApiResponse<Environment> resp = this.resetEnvironmentMobileKeyWithHttpInfo(projectKey, environmentKey, expiry);
        return resp.getData();
    }

    public ApiResponse<Environment> resetEnvironmentMobileKeyWithHttpInfo(String projectKey, String environmentKey, Long expiry) throws ApiException {
        Call call = this.resetEnvironmentMobileKeyValidateBeforeCall(projectKey, environmentKey, expiry, null, null);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call resetEnvironmentMobileKeyAsync(String projectKey, String environmentKey, Long expiry, final ApiCallback<Environment> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.resetEnvironmentMobileKeyValidateBeforeCall(projectKey, environmentKey, expiry, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call resetEnvironmentSDKKeyCall(String projectKey, String environmentKey, Long expiry, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/projects/{projectKey}/environments/{environmentKey}/apiKey".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (expiry != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("expiry", expiry));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call resetEnvironmentSDKKeyValidateBeforeCall(String projectKey, String environmentKey, Long expiry, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling resetEnvironmentSDKKey(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling resetEnvironmentSDKKey(Async)");
        }
        Call call = this.resetEnvironmentSDKKeyCall(projectKey, environmentKey, expiry, progressListener, progressRequestListener);
        return call;
    }

    public Environment resetEnvironmentSDKKey(String projectKey, String environmentKey, Long expiry) throws ApiException {
        ApiResponse<Environment> resp = this.resetEnvironmentSDKKeyWithHttpInfo(projectKey, environmentKey, expiry);
        return resp.getData();
    }

    public ApiResponse<Environment> resetEnvironmentSDKKeyWithHttpInfo(String projectKey, String environmentKey, Long expiry) throws ApiException {
        Call call = this.resetEnvironmentSDKKeyValidateBeforeCall(projectKey, environmentKey, expiry, null, null);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call resetEnvironmentSDKKeyAsync(String projectKey, String environmentKey, Long expiry, final ApiCallback<Environment> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.resetEnvironmentSDKKeyValidateBeforeCall(projectKey, environmentKey, expiry, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Environment>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

