/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.ProgressRequestBody;
import com.launchdarkly.api.ProgressResponseBody;
import com.launchdarkly.api.model.ApprovalRequest;
import com.launchdarkly.api.model.ApprovalRequestApplyConfigBody;
import com.launchdarkly.api.model.ApprovalRequestConfigBody;
import com.launchdarkly.api.model.ApprovalRequestReviewConfigBody;
import com.launchdarkly.api.model.ApprovalRequests;
import com.launchdarkly.api.model.DependentFlagsByEnvironment;
import com.launchdarkly.api.model.FeatureFlag;
import com.launchdarkly.api.model.FeatureFlagBody;
import com.launchdarkly.api.model.FeatureFlagCopyBody;
import com.launchdarkly.api.model.FeatureFlagScheduledChange;
import com.launchdarkly.api.model.FeatureFlagScheduledChanges;
import com.launchdarkly.api.model.FeatureFlagScheduledChangesConflicts;
import com.launchdarkly.api.model.FeatureFlagStatus;
import com.launchdarkly.api.model.FeatureFlagStatusAcrossEnvironments;
import com.launchdarkly.api.model.FeatureFlagStatuses;
import com.launchdarkly.api.model.FeatureFlags;
import com.launchdarkly.api.model.FlagConfigScheduledChangesConflictsBody;
import com.launchdarkly.api.model.FlagConfigScheduledChangesPatchBody;
import com.launchdarkly.api.model.FlagConfigScheduledChangesPostBody;
import com.launchdarkly.api.model.MultiEnvironmentDependentFlags;
import com.launchdarkly.api.model.PatchComment;
import com.launchdarkly.api.model.UserTargetingExpirationForFlags;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FeatureFlagsApi {
    private ApiClient apiClient;

    public FeatureFlagsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public FeatureFlagsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call copyFeatureFlagCall(String projectKey, String featureFlagKey, FeatureFlagCopyBody featureFlagCopyBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        FeatureFlagCopyBody localVarPostBody = featureFlagCopyBody;
        String localVarPath = "/flags/{projectKey}/{featureFlagKey}/copy".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call copyFeatureFlagValidateBeforeCall(String projectKey, String featureFlagKey, FeatureFlagCopyBody featureFlagCopyBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling copyFeatureFlag(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling copyFeatureFlag(Async)");
        }
        if (featureFlagCopyBody == null) {
            throw new ApiException("Missing the required parameter 'featureFlagCopyBody' when calling copyFeatureFlag(Async)");
        }
        Call call = this.copyFeatureFlagCall(projectKey, featureFlagKey, featureFlagCopyBody, progressListener, progressRequestListener);
        return call;
    }

    public FeatureFlag copyFeatureFlag(String projectKey, String featureFlagKey, FeatureFlagCopyBody featureFlagCopyBody) throws ApiException {
        ApiResponse<FeatureFlag> resp = this.copyFeatureFlagWithHttpInfo(projectKey, featureFlagKey, featureFlagCopyBody);
        return resp.getData();
    }

    public ApiResponse<FeatureFlag> copyFeatureFlagWithHttpInfo(String projectKey, String featureFlagKey, FeatureFlagCopyBody featureFlagCopyBody) throws ApiException {
        Call call = this.copyFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, featureFlagCopyBody, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call copyFeatureFlagAsync(String projectKey, String featureFlagKey, FeatureFlagCopyBody featureFlagCopyBody, final ApiCallback<FeatureFlag> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.copyFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, featureFlagCopyBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call deleteApprovalRequestCall(String projectKey, String environmentKey, String featureFlagKey, String approvalRequestId, ApprovalRequestConfigBody approvalRequestConfigBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApprovalRequestConfigBody localVarPostBody = approvalRequestConfigBody;
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/approval-requests/{approvalRequestId}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{approvalRequestId\\}", this.apiClient.escapeString(approvalRequestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteApprovalRequestValidateBeforeCall(String projectKey, String environmentKey, String featureFlagKey, String approvalRequestId, ApprovalRequestConfigBody approvalRequestConfigBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteApprovalRequest(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling deleteApprovalRequest(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling deleteApprovalRequest(Async)");
        }
        if (approvalRequestId == null) {
            throw new ApiException("Missing the required parameter 'approvalRequestId' when calling deleteApprovalRequest(Async)");
        }
        Call call = this.deleteApprovalRequestCall(projectKey, environmentKey, featureFlagKey, approvalRequestId, approvalRequestConfigBody, progressListener, progressRequestListener);
        return call;
    }

    public void deleteApprovalRequest(String projectKey, String environmentKey, String featureFlagKey, String approvalRequestId, ApprovalRequestConfigBody approvalRequestConfigBody) throws ApiException {
        this.deleteApprovalRequestWithHttpInfo(projectKey, environmentKey, featureFlagKey, approvalRequestId, approvalRequestConfigBody);
    }

    public ApiResponse<Void> deleteApprovalRequestWithHttpInfo(String projectKey, String environmentKey, String featureFlagKey, String approvalRequestId, ApprovalRequestConfigBody approvalRequestConfigBody) throws ApiException {
        Call call = this.deleteApprovalRequestValidateBeforeCall(projectKey, environmentKey, featureFlagKey, approvalRequestId, approvalRequestConfigBody, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteApprovalRequestAsync(String projectKey, String environmentKey, String featureFlagKey, String approvalRequestId, ApprovalRequestConfigBody approvalRequestConfigBody, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteApprovalRequestValidateBeforeCall(projectKey, environmentKey, featureFlagKey, approvalRequestId, approvalRequestConfigBody, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteFeatureFlagCall(String projectKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/flags/{projectKey}/{featureFlagKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteFeatureFlagValidateBeforeCall(String projectKey, String featureFlagKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteFeatureFlag(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling deleteFeatureFlag(Async)");
        }
        Call call = this.deleteFeatureFlagCall(projectKey, featureFlagKey, progressListener, progressRequestListener);
        return call;
    }

    public void deleteFeatureFlag(String projectKey, String featureFlagKey) throws ApiException {
        this.deleteFeatureFlagWithHttpInfo(projectKey, featureFlagKey);
    }

    public ApiResponse<Void> deleteFeatureFlagWithHttpInfo(String projectKey, String featureFlagKey) throws ApiException {
        Call call = this.deleteFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteFeatureFlagAsync(String projectKey, String featureFlagKey, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call deleteFlagConfigScheduledChangesCall(String projectKey, String featureFlagKey, String environmentKey, String scheduledChangeId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/scheduled-changes/{scheduledChangeId}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{scheduledChangeId\\}", this.apiClient.escapeString(scheduledChangeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteFlagConfigScheduledChangesValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, String scheduledChangeId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteFlagConfigScheduledChanges(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling deleteFlagConfigScheduledChanges(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling deleteFlagConfigScheduledChanges(Async)");
        }
        if (scheduledChangeId == null) {
            throw new ApiException("Missing the required parameter 'scheduledChangeId' when calling deleteFlagConfigScheduledChanges(Async)");
        }
        Call call = this.deleteFlagConfigScheduledChangesCall(projectKey, featureFlagKey, environmentKey, scheduledChangeId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteFlagConfigScheduledChanges(String projectKey, String featureFlagKey, String environmentKey, String scheduledChangeId) throws ApiException {
        this.deleteFlagConfigScheduledChangesWithHttpInfo(projectKey, featureFlagKey, environmentKey, scheduledChangeId);
    }

    public ApiResponse<Void> deleteFlagConfigScheduledChangesWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey, String scheduledChangeId) throws ApiException {
        Call call = this.deleteFlagConfigScheduledChangesValidateBeforeCall(projectKey, featureFlagKey, environmentKey, scheduledChangeId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteFlagConfigScheduledChangesAsync(String projectKey, String featureFlagKey, String environmentKey, String scheduledChangeId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteFlagConfigScheduledChangesValidateBeforeCall(projectKey, featureFlagKey, environmentKey, scheduledChangeId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGetCall(String projectKey, String environmentKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/flags/{projectKey}/{environmentKey}/{featureFlagKey}/dependent-flags".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGetValidateBeforeCall(String projectKey, String environmentKey, String featureFlagKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGet(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGet(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGet(Async)");
        }
        Call call = this.flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGetCall(projectKey, environmentKey, featureFlagKey, progressListener, progressRequestListener);
        return call;
    }

    public DependentFlagsByEnvironment flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGet(String projectKey, String environmentKey, String featureFlagKey) throws ApiException {
        ApiResponse<DependentFlagsByEnvironment> resp = this.flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGetWithHttpInfo(projectKey, environmentKey, featureFlagKey);
        return resp.getData();
    }

    public ApiResponse<DependentFlagsByEnvironment> flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGetWithHttpInfo(String projectKey, String environmentKey, String featureFlagKey) throws ApiException {
        Call call = this.flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGetValidateBeforeCall(projectKey, environmentKey, featureFlagKey, null, null);
        Type localVarReturnType = new TypeToken<DependentFlagsByEnvironment>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGetAsync(String projectKey, String environmentKey, String featureFlagKey, final ApiCallback<DependentFlagsByEnvironment> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.flagsProjectKeyEnvironmentKeyFeatureFlagKeyDependentFlagsGetValidateBeforeCall(projectKey, environmentKey, featureFlagKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<DependentFlagsByEnvironment>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call flagsProjectKeyFeatureFlagKeyDependentFlagsGetCall(String projectKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/flags/{projectKey}/{featureFlagKey}/dependent-flags".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call flagsProjectKeyFeatureFlagKeyDependentFlagsGetValidateBeforeCall(String projectKey, String featureFlagKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling flagsProjectKeyFeatureFlagKeyDependentFlagsGet(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling flagsProjectKeyFeatureFlagKeyDependentFlagsGet(Async)");
        }
        Call call = this.flagsProjectKeyFeatureFlagKeyDependentFlagsGetCall(projectKey, featureFlagKey, progressListener, progressRequestListener);
        return call;
    }

    public MultiEnvironmentDependentFlags flagsProjectKeyFeatureFlagKeyDependentFlagsGet(String projectKey, String featureFlagKey) throws ApiException {
        ApiResponse<MultiEnvironmentDependentFlags> resp = this.flagsProjectKeyFeatureFlagKeyDependentFlagsGetWithHttpInfo(projectKey, featureFlagKey);
        return resp.getData();
    }

    public ApiResponse<MultiEnvironmentDependentFlags> flagsProjectKeyFeatureFlagKeyDependentFlagsGetWithHttpInfo(String projectKey, String featureFlagKey) throws ApiException {
        Call call = this.flagsProjectKeyFeatureFlagKeyDependentFlagsGetValidateBeforeCall(projectKey, featureFlagKey, null, null);
        Type localVarReturnType = new TypeToken<MultiEnvironmentDependentFlags>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call flagsProjectKeyFeatureFlagKeyDependentFlagsGetAsync(String projectKey, String featureFlagKey, final ApiCallback<MultiEnvironmentDependentFlags> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.flagsProjectKeyFeatureFlagKeyDependentFlagsGetValidateBeforeCall(projectKey, featureFlagKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<MultiEnvironmentDependentFlags>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getApprovalRequestCall(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/approval-requests/{approvalRequestId}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{approvalRequestId\\}", this.apiClient.escapeString(approvalRequestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getApprovalRequestValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getApprovalRequest(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getApprovalRequest(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getApprovalRequest(Async)");
        }
        if (approvalRequestId == null) {
            throw new ApiException("Missing the required parameter 'approvalRequestId' when calling getApprovalRequest(Async)");
        }
        Call call = this.getApprovalRequestCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, progressListener, progressRequestListener);
        return call;
    }

    public ApprovalRequests getApprovalRequest(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId) throws ApiException {
        ApiResponse<ApprovalRequests> resp = this.getApprovalRequestWithHttpInfo(projectKey, featureFlagKey, environmentKey, approvalRequestId);
        return resp.getData();
    }

    public ApiResponse<ApprovalRequests> getApprovalRequestWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId) throws ApiException {
        Call call = this.getApprovalRequestValidateBeforeCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, null, null);
        Type localVarReturnType = new TypeToken<ApprovalRequests>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getApprovalRequestAsync(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, final ApiCallback<ApprovalRequests> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getApprovalRequestValidateBeforeCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApprovalRequests>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getApprovalRequestsCall(String projectKey, String featureFlagKey, String environmentKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/approval-requests".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getApprovalRequestsValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getApprovalRequests(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getApprovalRequests(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getApprovalRequests(Async)");
        }
        Call call = this.getApprovalRequestsCall(projectKey, featureFlagKey, environmentKey, progressListener, progressRequestListener);
        return call;
    }

    public ApprovalRequests getApprovalRequests(String projectKey, String featureFlagKey, String environmentKey) throws ApiException {
        ApiResponse<ApprovalRequests> resp = this.getApprovalRequestsWithHttpInfo(projectKey, featureFlagKey, environmentKey);
        return resp.getData();
    }

    public ApiResponse<ApprovalRequests> getApprovalRequestsWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey) throws ApiException {
        Call call = this.getApprovalRequestsValidateBeforeCall(projectKey, featureFlagKey, environmentKey, null, null);
        Type localVarReturnType = new TypeToken<ApprovalRequests>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getApprovalRequestsAsync(String projectKey, String featureFlagKey, String environmentKey, final ApiCallback<ApprovalRequests> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getApprovalRequestsValidateBeforeCall(projectKey, featureFlagKey, environmentKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApprovalRequests>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getExpiringUserTargetsCall(String projectKey, String environmentKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/flags/{projectKey}/{featureFlagKey}/expiring-user-targets/{environmentKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getExpiringUserTargetsValidateBeforeCall(String projectKey, String environmentKey, String featureFlagKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getExpiringUserTargets(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getExpiringUserTargets(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getExpiringUserTargets(Async)");
        }
        Call call = this.getExpiringUserTargetsCall(projectKey, environmentKey, featureFlagKey, progressListener, progressRequestListener);
        return call;
    }

    public UserTargetingExpirationForFlags getExpiringUserTargets(String projectKey, String environmentKey, String featureFlagKey) throws ApiException {
        ApiResponse<UserTargetingExpirationForFlags> resp = this.getExpiringUserTargetsWithHttpInfo(projectKey, environmentKey, featureFlagKey);
        return resp.getData();
    }

    public ApiResponse<UserTargetingExpirationForFlags> getExpiringUserTargetsWithHttpInfo(String projectKey, String environmentKey, String featureFlagKey) throws ApiException {
        Call call = this.getExpiringUserTargetsValidateBeforeCall(projectKey, environmentKey, featureFlagKey, null, null);
        Type localVarReturnType = new TypeToken<UserTargetingExpirationForFlags>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getExpiringUserTargetsAsync(String projectKey, String environmentKey, String featureFlagKey, final ApiCallback<UserTargetingExpirationForFlags> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getExpiringUserTargetsValidateBeforeCall(projectKey, environmentKey, featureFlagKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserTargetingExpirationForFlags>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getFeatureFlagCall(String projectKey, String featureFlagKey, List<String> env, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/flags/{projectKey}/{featureFlagKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (env != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "env", env));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFeatureFlagValidateBeforeCall(String projectKey, String featureFlagKey, List<String> env, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFeatureFlag(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getFeatureFlag(Async)");
        }
        Call call = this.getFeatureFlagCall(projectKey, featureFlagKey, env, progressListener, progressRequestListener);
        return call;
    }

    public FeatureFlag getFeatureFlag(String projectKey, String featureFlagKey, List<String> env) throws ApiException {
        ApiResponse<FeatureFlag> resp = this.getFeatureFlagWithHttpInfo(projectKey, featureFlagKey, env);
        return resp.getData();
    }

    public ApiResponse<FeatureFlag> getFeatureFlagWithHttpInfo(String projectKey, String featureFlagKey, List<String> env) throws ApiException {
        Call call = this.getFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, env, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFeatureFlagAsync(String projectKey, String featureFlagKey, List<String> env, final ApiCallback<FeatureFlag> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, env, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getFeatureFlagStatusCall(String projectKey, String environmentKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/flag-statuses/{projectKey}/{environmentKey}/{featureFlagKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFeatureFlagStatusValidateBeforeCall(String projectKey, String environmentKey, String featureFlagKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFeatureFlagStatus(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getFeatureFlagStatus(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getFeatureFlagStatus(Async)");
        }
        Call call = this.getFeatureFlagStatusCall(projectKey, environmentKey, featureFlagKey, progressListener, progressRequestListener);
        return call;
    }

    public FeatureFlagStatus getFeatureFlagStatus(String projectKey, String environmentKey, String featureFlagKey) throws ApiException {
        ApiResponse<FeatureFlagStatus> resp = this.getFeatureFlagStatusWithHttpInfo(projectKey, environmentKey, featureFlagKey);
        return resp.getData();
    }

    public ApiResponse<FeatureFlagStatus> getFeatureFlagStatusWithHttpInfo(String projectKey, String environmentKey, String featureFlagKey) throws ApiException {
        Call call = this.getFeatureFlagStatusValidateBeforeCall(projectKey, environmentKey, featureFlagKey, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlagStatus>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFeatureFlagStatusAsync(String projectKey, String environmentKey, String featureFlagKey, final ApiCallback<FeatureFlagStatus> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFeatureFlagStatusValidateBeforeCall(projectKey, environmentKey, featureFlagKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlagStatus>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getFeatureFlagStatusAcrossEnvironmentsCall(String projectKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/flag-status/{projectKey}/{featureFlagKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFeatureFlagStatusAcrossEnvironmentsValidateBeforeCall(String projectKey, String featureFlagKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFeatureFlagStatusAcrossEnvironments(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getFeatureFlagStatusAcrossEnvironments(Async)");
        }
        Call call = this.getFeatureFlagStatusAcrossEnvironmentsCall(projectKey, featureFlagKey, progressListener, progressRequestListener);
        return call;
    }

    public FeatureFlagStatusAcrossEnvironments getFeatureFlagStatusAcrossEnvironments(String projectKey, String featureFlagKey) throws ApiException {
        ApiResponse<FeatureFlagStatusAcrossEnvironments> resp = this.getFeatureFlagStatusAcrossEnvironmentsWithHttpInfo(projectKey, featureFlagKey);
        return resp.getData();
    }

    public ApiResponse<FeatureFlagStatusAcrossEnvironments> getFeatureFlagStatusAcrossEnvironmentsWithHttpInfo(String projectKey, String featureFlagKey) throws ApiException {
        Call call = this.getFeatureFlagStatusAcrossEnvironmentsValidateBeforeCall(projectKey, featureFlagKey, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlagStatusAcrossEnvironments>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFeatureFlagStatusAcrossEnvironmentsAsync(String projectKey, String featureFlagKey, final ApiCallback<FeatureFlagStatusAcrossEnvironments> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFeatureFlagStatusAcrossEnvironmentsValidateBeforeCall(projectKey, featureFlagKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlagStatusAcrossEnvironments>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getFeatureFlagStatusesCall(String projectKey, String environmentKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/flag-statuses/{projectKey}/{environmentKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFeatureFlagStatusesValidateBeforeCall(String projectKey, String environmentKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFeatureFlagStatuses(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getFeatureFlagStatuses(Async)");
        }
        Call call = this.getFeatureFlagStatusesCall(projectKey, environmentKey, progressListener, progressRequestListener);
        return call;
    }

    public FeatureFlagStatuses getFeatureFlagStatuses(String projectKey, String environmentKey) throws ApiException {
        ApiResponse<FeatureFlagStatuses> resp = this.getFeatureFlagStatusesWithHttpInfo(projectKey, environmentKey);
        return resp.getData();
    }

    public ApiResponse<FeatureFlagStatuses> getFeatureFlagStatusesWithHttpInfo(String projectKey, String environmentKey) throws ApiException {
        Call call = this.getFeatureFlagStatusesValidateBeforeCall(projectKey, environmentKey, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlagStatuses>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFeatureFlagStatusesAsync(String projectKey, String environmentKey, final ApiCallback<FeatureFlagStatuses> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFeatureFlagStatusesValidateBeforeCall(projectKey, environmentKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlagStatuses>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getFeatureFlagsCall(String projectKey, List<String> env, Boolean summary, Boolean archived, BigDecimal limit, BigDecimal offset, String filter, String sort, String tag, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/flags/{projectKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (env != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "env", env));
        }
        if (summary != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("summary", summary));
        }
        if (archived != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("archived", archived));
        }
        if (limit != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        }
        if (offset != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("offset", offset));
        }
        if (filter != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("filter", filter));
        }
        if (sort != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sort", sort));
        }
        if (tag != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tag", tag));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFeatureFlagsValidateBeforeCall(String projectKey, List<String> env, Boolean summary, Boolean archived, BigDecimal limit, BigDecimal offset, String filter, String sort, String tag, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFeatureFlags(Async)");
        }
        Call call = this.getFeatureFlagsCall(projectKey, env, summary, archived, limit, offset, filter, sort, tag, progressListener, progressRequestListener);
        return call;
    }

    public FeatureFlags getFeatureFlags(String projectKey, List<String> env, Boolean summary, Boolean archived, BigDecimal limit, BigDecimal offset, String filter, String sort, String tag) throws ApiException {
        ApiResponse<FeatureFlags> resp = this.getFeatureFlagsWithHttpInfo(projectKey, env, summary, archived, limit, offset, filter, sort, tag);
        return resp.getData();
    }

    public ApiResponse<FeatureFlags> getFeatureFlagsWithHttpInfo(String projectKey, List<String> env, Boolean summary, Boolean archived, BigDecimal limit, BigDecimal offset, String filter, String sort, String tag) throws ApiException {
        Call call = this.getFeatureFlagsValidateBeforeCall(projectKey, env, summary, archived, limit, offset, filter, sort, tag, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlags>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFeatureFlagsAsync(String projectKey, List<String> env, Boolean summary, Boolean archived, BigDecimal limit, BigDecimal offset, String filter, String sort, String tag, final ApiCallback<FeatureFlags> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFeatureFlagsValidateBeforeCall(projectKey, env, summary, archived, limit, offset, filter, sort, tag, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlags>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getFlagConfigScheduledChangeCall(String projectKey, String featureFlagKey, String environmentKey, String scheduledChangeId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/scheduled-changes/{scheduledChangeId}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{scheduledChangeId\\}", this.apiClient.escapeString(scheduledChangeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFlagConfigScheduledChangeValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, String scheduledChangeId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFlagConfigScheduledChange(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getFlagConfigScheduledChange(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getFlagConfigScheduledChange(Async)");
        }
        if (scheduledChangeId == null) {
            throw new ApiException("Missing the required parameter 'scheduledChangeId' when calling getFlagConfigScheduledChange(Async)");
        }
        Call call = this.getFlagConfigScheduledChangeCall(projectKey, featureFlagKey, environmentKey, scheduledChangeId, progressListener, progressRequestListener);
        return call;
    }

    public FeatureFlagScheduledChange getFlagConfigScheduledChange(String projectKey, String featureFlagKey, String environmentKey, String scheduledChangeId) throws ApiException {
        ApiResponse<FeatureFlagScheduledChange> resp = this.getFlagConfigScheduledChangeWithHttpInfo(projectKey, featureFlagKey, environmentKey, scheduledChangeId);
        return resp.getData();
    }

    public ApiResponse<FeatureFlagScheduledChange> getFlagConfigScheduledChangeWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey, String scheduledChangeId) throws ApiException {
        Call call = this.getFlagConfigScheduledChangeValidateBeforeCall(projectKey, featureFlagKey, environmentKey, scheduledChangeId, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlagScheduledChange>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFlagConfigScheduledChangeAsync(String projectKey, String featureFlagKey, String environmentKey, String scheduledChangeId, final ApiCallback<FeatureFlagScheduledChange> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFlagConfigScheduledChangeValidateBeforeCall(projectKey, featureFlagKey, environmentKey, scheduledChangeId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlagScheduledChange>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getFlagConfigScheduledChangesCall(String projectKey, String featureFlagKey, String environmentKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/scheduled-changes".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFlagConfigScheduledChangesValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFlagConfigScheduledChanges(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getFlagConfigScheduledChanges(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getFlagConfigScheduledChanges(Async)");
        }
        Call call = this.getFlagConfigScheduledChangesCall(projectKey, featureFlagKey, environmentKey, progressListener, progressRequestListener);
        return call;
    }

    public FeatureFlagScheduledChanges getFlagConfigScheduledChanges(String projectKey, String featureFlagKey, String environmentKey) throws ApiException {
        ApiResponse<FeatureFlagScheduledChanges> resp = this.getFlagConfigScheduledChangesWithHttpInfo(projectKey, featureFlagKey, environmentKey);
        return resp.getData();
    }

    public ApiResponse<FeatureFlagScheduledChanges> getFlagConfigScheduledChangesWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey) throws ApiException {
        Call call = this.getFlagConfigScheduledChangesValidateBeforeCall(projectKey, featureFlagKey, environmentKey, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlagScheduledChanges>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFlagConfigScheduledChangesAsync(String projectKey, String featureFlagKey, String environmentKey, final ApiCallback<FeatureFlagScheduledChanges> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFlagConfigScheduledChangesValidateBeforeCall(projectKey, featureFlagKey, environmentKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlagScheduledChanges>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getFlagConfigScheduledChangesConflictsCall(String projectKey, String featureFlagKey, String environmentKey, FlagConfigScheduledChangesConflictsBody flagConfigScheduledChangesConflictsBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        FlagConfigScheduledChangesConflictsBody localVarPostBody = flagConfigScheduledChangesConflictsBody;
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/scheduled-changes-conflicts".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getFlagConfigScheduledChangesConflictsValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, FlagConfigScheduledChangesConflictsBody flagConfigScheduledChangesConflictsBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getFlagConfigScheduledChangesConflicts(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getFlagConfigScheduledChangesConflicts(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getFlagConfigScheduledChangesConflicts(Async)");
        }
        if (flagConfigScheduledChangesConflictsBody == null) {
            throw new ApiException("Missing the required parameter 'flagConfigScheduledChangesConflictsBody' when calling getFlagConfigScheduledChangesConflicts(Async)");
        }
        Call call = this.getFlagConfigScheduledChangesConflictsCall(projectKey, featureFlagKey, environmentKey, flagConfigScheduledChangesConflictsBody, progressListener, progressRequestListener);
        return call;
    }

    public FeatureFlagScheduledChangesConflicts getFlagConfigScheduledChangesConflicts(String projectKey, String featureFlagKey, String environmentKey, FlagConfigScheduledChangesConflictsBody flagConfigScheduledChangesConflictsBody) throws ApiException {
        ApiResponse<FeatureFlagScheduledChangesConflicts> resp = this.getFlagConfigScheduledChangesConflictsWithHttpInfo(projectKey, featureFlagKey, environmentKey, flagConfigScheduledChangesConflictsBody);
        return resp.getData();
    }

    public ApiResponse<FeatureFlagScheduledChangesConflicts> getFlagConfigScheduledChangesConflictsWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey, FlagConfigScheduledChangesConflictsBody flagConfigScheduledChangesConflictsBody) throws ApiException {
        Call call = this.getFlagConfigScheduledChangesConflictsValidateBeforeCall(projectKey, featureFlagKey, environmentKey, flagConfigScheduledChangesConflictsBody, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlagScheduledChangesConflicts>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getFlagConfigScheduledChangesConflictsAsync(String projectKey, String featureFlagKey, String environmentKey, FlagConfigScheduledChangesConflictsBody flagConfigScheduledChangesConflictsBody, final ApiCallback<FeatureFlagScheduledChangesConflicts> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getFlagConfigScheduledChangesConflictsValidateBeforeCall(projectKey, featureFlagKey, environmentKey, flagConfigScheduledChangesConflictsBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlagScheduledChangesConflicts>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchExpiringUserTargetsCall(String projectKey, String environmentKey, String featureFlagKey, Object semanticPatchWithComment, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = semanticPatchWithComment;
        String localVarPath = "/flags/{projectKey}/{featureFlagKey}/expiring-user-targets/{environmentKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchExpiringUserTargetsValidateBeforeCall(String projectKey, String environmentKey, String featureFlagKey, Object semanticPatchWithComment, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchExpiringUserTargets(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchExpiringUserTargets(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling patchExpiringUserTargets(Async)");
        }
        if (semanticPatchWithComment == null) {
            throw new ApiException("Missing the required parameter 'semanticPatchWithComment' when calling patchExpiringUserTargets(Async)");
        }
        Call call = this.patchExpiringUserTargetsCall(projectKey, environmentKey, featureFlagKey, semanticPatchWithComment, progressListener, progressRequestListener);
        return call;
    }

    public UserTargetingExpirationForFlags patchExpiringUserTargets(String projectKey, String environmentKey, String featureFlagKey, Object semanticPatchWithComment) throws ApiException {
        ApiResponse<UserTargetingExpirationForFlags> resp = this.patchExpiringUserTargetsWithHttpInfo(projectKey, environmentKey, featureFlagKey, semanticPatchWithComment);
        return resp.getData();
    }

    public ApiResponse<UserTargetingExpirationForFlags> patchExpiringUserTargetsWithHttpInfo(String projectKey, String environmentKey, String featureFlagKey, Object semanticPatchWithComment) throws ApiException {
        Call call = this.patchExpiringUserTargetsValidateBeforeCall(projectKey, environmentKey, featureFlagKey, semanticPatchWithComment, null, null);
        Type localVarReturnType = new TypeToken<UserTargetingExpirationForFlags>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchExpiringUserTargetsAsync(String projectKey, String environmentKey, String featureFlagKey, Object semanticPatchWithComment, final ApiCallback<UserTargetingExpirationForFlags> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchExpiringUserTargetsValidateBeforeCall(projectKey, environmentKey, featureFlagKey, semanticPatchWithComment, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserTargetingExpirationForFlags>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchFeatureFlagCall(String projectKey, String featureFlagKey, PatchComment patchComment, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        PatchComment localVarPostBody = patchComment;
        String localVarPath = "/flags/{projectKey}/{featureFlagKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchFeatureFlagValidateBeforeCall(String projectKey, String featureFlagKey, PatchComment patchComment, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchFeatureFlag(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling patchFeatureFlag(Async)");
        }
        if (patchComment == null) {
            throw new ApiException("Missing the required parameter 'patchComment' when calling patchFeatureFlag(Async)");
        }
        Call call = this.patchFeatureFlagCall(projectKey, featureFlagKey, patchComment, progressListener, progressRequestListener);
        return call;
    }

    public FeatureFlag patchFeatureFlag(String projectKey, String featureFlagKey, PatchComment patchComment) throws ApiException {
        ApiResponse<FeatureFlag> resp = this.patchFeatureFlagWithHttpInfo(projectKey, featureFlagKey, patchComment);
        return resp.getData();
    }

    public ApiResponse<FeatureFlag> patchFeatureFlagWithHttpInfo(String projectKey, String featureFlagKey, PatchComment patchComment) throws ApiException {
        Call call = this.patchFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, patchComment, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchFeatureFlagAsync(String projectKey, String featureFlagKey, PatchComment patchComment, final ApiCallback<FeatureFlag> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchFeatureFlagValidateBeforeCall(projectKey, featureFlagKey, patchComment, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchFlagConfigScheduledChangeCall(String projectKey, String featureFlagKey, FlagConfigScheduledChangesPatchBody flagConfigScheduledChangesPatchBody, String environmentKey, String scheduledChangeId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        FlagConfigScheduledChangesPatchBody localVarPostBody = flagConfigScheduledChangesPatchBody;
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/scheduled-changes/{scheduledChangeId}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{scheduledChangeId\\}", this.apiClient.escapeString(scheduledChangeId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchFlagConfigScheduledChangeValidateBeforeCall(String projectKey, String featureFlagKey, FlagConfigScheduledChangesPatchBody flagConfigScheduledChangesPatchBody, String environmentKey, String scheduledChangeId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchFlagConfigScheduledChange(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling patchFlagConfigScheduledChange(Async)");
        }
        if (flagConfigScheduledChangesPatchBody == null) {
            throw new ApiException("Missing the required parameter 'flagConfigScheduledChangesPatchBody' when calling patchFlagConfigScheduledChange(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchFlagConfigScheduledChange(Async)");
        }
        if (scheduledChangeId == null) {
            throw new ApiException("Missing the required parameter 'scheduledChangeId' when calling patchFlagConfigScheduledChange(Async)");
        }
        Call call = this.patchFlagConfigScheduledChangeCall(projectKey, featureFlagKey, flagConfigScheduledChangesPatchBody, environmentKey, scheduledChangeId, progressListener, progressRequestListener);
        return call;
    }

    public FeatureFlagScheduledChange patchFlagConfigScheduledChange(String projectKey, String featureFlagKey, FlagConfigScheduledChangesPatchBody flagConfigScheduledChangesPatchBody, String environmentKey, String scheduledChangeId) throws ApiException {
        ApiResponse<FeatureFlagScheduledChange> resp = this.patchFlagConfigScheduledChangeWithHttpInfo(projectKey, featureFlagKey, flagConfigScheduledChangesPatchBody, environmentKey, scheduledChangeId);
        return resp.getData();
    }

    public ApiResponse<FeatureFlagScheduledChange> patchFlagConfigScheduledChangeWithHttpInfo(String projectKey, String featureFlagKey, FlagConfigScheduledChangesPatchBody flagConfigScheduledChangesPatchBody, String environmentKey, String scheduledChangeId) throws ApiException {
        Call call = this.patchFlagConfigScheduledChangeValidateBeforeCall(projectKey, featureFlagKey, flagConfigScheduledChangesPatchBody, environmentKey, scheduledChangeId, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlagScheduledChange>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchFlagConfigScheduledChangeAsync(String projectKey, String featureFlagKey, FlagConfigScheduledChangesPatchBody flagConfigScheduledChangesPatchBody, String environmentKey, String scheduledChangeId, final ApiCallback<FeatureFlagScheduledChange> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchFlagConfigScheduledChangeValidateBeforeCall(projectKey, featureFlagKey, flagConfigScheduledChangesPatchBody, environmentKey, scheduledChangeId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlagScheduledChange>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postApplyApprovalRequestCall(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestApplyConfigBody approvalRequestApplyConfigBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApprovalRequestApplyConfigBody localVarPostBody = approvalRequestApplyConfigBody;
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/approval-requests/{approvalRequestId}/apply".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{approvalRequestId\\}", this.apiClient.escapeString(approvalRequestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postApplyApprovalRequestValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestApplyConfigBody approvalRequestApplyConfigBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postApplyApprovalRequest(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling postApplyApprovalRequest(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling postApplyApprovalRequest(Async)");
        }
        if (approvalRequestId == null) {
            throw new ApiException("Missing the required parameter 'approvalRequestId' when calling postApplyApprovalRequest(Async)");
        }
        if (approvalRequestApplyConfigBody == null) {
            throw new ApiException("Missing the required parameter 'approvalRequestApplyConfigBody' when calling postApplyApprovalRequest(Async)");
        }
        Call call = this.postApplyApprovalRequestCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestApplyConfigBody, progressListener, progressRequestListener);
        return call;
    }

    public ApprovalRequests postApplyApprovalRequest(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestApplyConfigBody approvalRequestApplyConfigBody) throws ApiException {
        ApiResponse<ApprovalRequests> resp = this.postApplyApprovalRequestWithHttpInfo(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestApplyConfigBody);
        return resp.getData();
    }

    public ApiResponse<ApprovalRequests> postApplyApprovalRequestWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestApplyConfigBody approvalRequestApplyConfigBody) throws ApiException {
        Call call = this.postApplyApprovalRequestValidateBeforeCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestApplyConfigBody, null, null);
        Type localVarReturnType = new TypeToken<ApprovalRequests>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postApplyApprovalRequestAsync(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestApplyConfigBody approvalRequestApplyConfigBody, final ApiCallback<ApprovalRequests> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postApplyApprovalRequestValidateBeforeCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestApplyConfigBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApprovalRequests>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postApprovalRequestCall(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestConfigBody approvalRequestConfigBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApprovalRequestConfigBody localVarPostBody = approvalRequestConfigBody;
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/approval-requests/{approvalRequestId}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{approvalRequestId\\}", this.apiClient.escapeString(approvalRequestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postApprovalRequestValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestConfigBody approvalRequestConfigBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postApprovalRequest(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling postApprovalRequest(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling postApprovalRequest(Async)");
        }
        if (approvalRequestId == null) {
            throw new ApiException("Missing the required parameter 'approvalRequestId' when calling postApprovalRequest(Async)");
        }
        Call call = this.postApprovalRequestCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestConfigBody, progressListener, progressRequestListener);
        return call;
    }

    public ApprovalRequest postApprovalRequest(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestConfigBody approvalRequestConfigBody) throws ApiException {
        ApiResponse<ApprovalRequest> resp = this.postApprovalRequestWithHttpInfo(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestConfigBody);
        return resp.getData();
    }

    public ApiResponse<ApprovalRequest> postApprovalRequestWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestConfigBody approvalRequestConfigBody) throws ApiException {
        Call call = this.postApprovalRequestValidateBeforeCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestConfigBody, null, null);
        Type localVarReturnType = new TypeToken<ApprovalRequest>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postApprovalRequestAsync(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestConfigBody approvalRequestConfigBody, final ApiCallback<ApprovalRequest> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postApprovalRequestValidateBeforeCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestConfigBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApprovalRequest>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postFeatureFlagCall(String projectKey, FeatureFlagBody featureFlagBody, String clone, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        FeatureFlagBody localVarPostBody = featureFlagBody;
        String localVarPath = "/flags/{projectKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (clone != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("clone", clone));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postFeatureFlagValidateBeforeCall(String projectKey, FeatureFlagBody featureFlagBody, String clone, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postFeatureFlag(Async)");
        }
        if (featureFlagBody == null) {
            throw new ApiException("Missing the required parameter 'featureFlagBody' when calling postFeatureFlag(Async)");
        }
        Call call = this.postFeatureFlagCall(projectKey, featureFlagBody, clone, progressListener, progressRequestListener);
        return call;
    }

    public FeatureFlag postFeatureFlag(String projectKey, FeatureFlagBody featureFlagBody, String clone) throws ApiException {
        ApiResponse<FeatureFlag> resp = this.postFeatureFlagWithHttpInfo(projectKey, featureFlagBody, clone);
        return resp.getData();
    }

    public ApiResponse<FeatureFlag> postFeatureFlagWithHttpInfo(String projectKey, FeatureFlagBody featureFlagBody, String clone) throws ApiException {
        Call call = this.postFeatureFlagValidateBeforeCall(projectKey, featureFlagBody, clone, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postFeatureFlagAsync(String projectKey, FeatureFlagBody featureFlagBody, String clone, final ApiCallback<FeatureFlag> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postFeatureFlagValidateBeforeCall(projectKey, featureFlagBody, clone, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlag>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postFlagConfigScheduledChangesCall(String projectKey, FlagConfigScheduledChangesPostBody flagConfigScheduledChangesPostBody, String featureFlagKey, String environmentKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        FlagConfigScheduledChangesPostBody localVarPostBody = flagConfigScheduledChangesPostBody;
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/scheduled-changes".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postFlagConfigScheduledChangesValidateBeforeCall(String projectKey, FlagConfigScheduledChangesPostBody flagConfigScheduledChangesPostBody, String featureFlagKey, String environmentKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postFlagConfigScheduledChanges(Async)");
        }
        if (flagConfigScheduledChangesPostBody == null) {
            throw new ApiException("Missing the required parameter 'flagConfigScheduledChangesPostBody' when calling postFlagConfigScheduledChanges(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling postFlagConfigScheduledChanges(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling postFlagConfigScheduledChanges(Async)");
        }
        Call call = this.postFlagConfigScheduledChangesCall(projectKey, flagConfigScheduledChangesPostBody, featureFlagKey, environmentKey, progressListener, progressRequestListener);
        return call;
    }

    public FeatureFlagScheduledChange postFlagConfigScheduledChanges(String projectKey, FlagConfigScheduledChangesPostBody flagConfigScheduledChangesPostBody, String featureFlagKey, String environmentKey) throws ApiException {
        ApiResponse<FeatureFlagScheduledChange> resp = this.postFlagConfigScheduledChangesWithHttpInfo(projectKey, flagConfigScheduledChangesPostBody, featureFlagKey, environmentKey);
        return resp.getData();
    }

    public ApiResponse<FeatureFlagScheduledChange> postFlagConfigScheduledChangesWithHttpInfo(String projectKey, FlagConfigScheduledChangesPostBody flagConfigScheduledChangesPostBody, String featureFlagKey, String environmentKey) throws ApiException {
        Call call = this.postFlagConfigScheduledChangesValidateBeforeCall(projectKey, flagConfigScheduledChangesPostBody, featureFlagKey, environmentKey, null, null);
        Type localVarReturnType = new TypeToken<FeatureFlagScheduledChange>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postFlagConfigScheduledChangesAsync(String projectKey, FlagConfigScheduledChangesPostBody flagConfigScheduledChangesPostBody, String featureFlagKey, String environmentKey, final ApiCallback<FeatureFlagScheduledChange> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postFlagConfigScheduledChangesValidateBeforeCall(projectKey, flagConfigScheduledChangesPostBody, featureFlagKey, environmentKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<FeatureFlagScheduledChange>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postReviewApprovalRequestCall(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestReviewConfigBody approvalRequestReviewConfigBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ApprovalRequestReviewConfigBody localVarPostBody = approvalRequestReviewConfigBody;
        String localVarPath = "/projects/{projectKey}/flags/{featureFlagKey}/environments/{environmentKey}/approval-requests/{approvalRequestId}/review".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{approvalRequestId\\}", this.apiClient.escapeString(approvalRequestId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postReviewApprovalRequestValidateBeforeCall(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestReviewConfigBody approvalRequestReviewConfigBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postReviewApprovalRequest(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling postReviewApprovalRequest(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling postReviewApprovalRequest(Async)");
        }
        if (approvalRequestId == null) {
            throw new ApiException("Missing the required parameter 'approvalRequestId' when calling postReviewApprovalRequest(Async)");
        }
        if (approvalRequestReviewConfigBody == null) {
            throw new ApiException("Missing the required parameter 'approvalRequestReviewConfigBody' when calling postReviewApprovalRequest(Async)");
        }
        Call call = this.postReviewApprovalRequestCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestReviewConfigBody, progressListener, progressRequestListener);
        return call;
    }

    public ApprovalRequests postReviewApprovalRequest(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestReviewConfigBody approvalRequestReviewConfigBody) throws ApiException {
        ApiResponse<ApprovalRequests> resp = this.postReviewApprovalRequestWithHttpInfo(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestReviewConfigBody);
        return resp.getData();
    }

    public ApiResponse<ApprovalRequests> postReviewApprovalRequestWithHttpInfo(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestReviewConfigBody approvalRequestReviewConfigBody) throws ApiException {
        Call call = this.postReviewApprovalRequestValidateBeforeCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestReviewConfigBody, null, null);
        Type localVarReturnType = new TypeToken<ApprovalRequests>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postReviewApprovalRequestAsync(String projectKey, String featureFlagKey, String environmentKey, String approvalRequestId, ApprovalRequestReviewConfigBody approvalRequestReviewConfigBody, final ApiCallback<ApprovalRequests> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postReviewApprovalRequestValidateBeforeCall(projectKey, featureFlagKey, environmentKey, approvalRequestId, approvalRequestReviewConfigBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ApprovalRequests>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

