/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.ProgressRequestBody;
import com.launchdarkly.api.ProgressResponseBody;
import com.launchdarkly.api.model.Integration;
import com.launchdarkly.api.model.IntegrationSubscription;
import com.launchdarkly.api.model.Integrations;
import com.launchdarkly.api.model.PatchOperation;
import com.launchdarkly.api.model.SubscriptionBody;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class IntegrationsApi {
    private ApiClient apiClient;

    public IntegrationsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public IntegrationsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteIntegrationSubscriptionCall(String integrationKey, String integrationId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/integrations/{integrationKey}/{integrationId}".replaceAll("\\{integrationKey\\}", this.apiClient.escapeString(integrationKey.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteIntegrationSubscriptionValidateBeforeCall(String integrationKey, String integrationId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling deleteIntegrationSubscription(Async)");
        }
        if (integrationId == null) {
            throw new ApiException("Missing the required parameter 'integrationId' when calling deleteIntegrationSubscription(Async)");
        }
        Call call = this.deleteIntegrationSubscriptionCall(integrationKey, integrationId, progressListener, progressRequestListener);
        return call;
    }

    public void deleteIntegrationSubscription(String integrationKey, String integrationId) throws ApiException {
        this.deleteIntegrationSubscriptionWithHttpInfo(integrationKey, integrationId);
    }

    public ApiResponse<Void> deleteIntegrationSubscriptionWithHttpInfo(String integrationKey, String integrationId) throws ApiException {
        Call call = this.deleteIntegrationSubscriptionValidateBeforeCall(integrationKey, integrationId, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteIntegrationSubscriptionAsync(String integrationKey, String integrationId, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteIntegrationSubscriptionValidateBeforeCall(integrationKey, integrationId, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getIntegrationSubscriptionCall(String integrationKey, String integrationId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/integrations/{integrationKey}/{integrationId}".replaceAll("\\{integrationKey\\}", this.apiClient.escapeString(integrationKey.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getIntegrationSubscriptionValidateBeforeCall(String integrationKey, String integrationId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling getIntegrationSubscription(Async)");
        }
        if (integrationId == null) {
            throw new ApiException("Missing the required parameter 'integrationId' when calling getIntegrationSubscription(Async)");
        }
        Call call = this.getIntegrationSubscriptionCall(integrationKey, integrationId, progressListener, progressRequestListener);
        return call;
    }

    public IntegrationSubscription getIntegrationSubscription(String integrationKey, String integrationId) throws ApiException {
        ApiResponse<IntegrationSubscription> resp = this.getIntegrationSubscriptionWithHttpInfo(integrationKey, integrationId);
        return resp.getData();
    }

    public ApiResponse<IntegrationSubscription> getIntegrationSubscriptionWithHttpInfo(String integrationKey, String integrationId) throws ApiException {
        Call call = this.getIntegrationSubscriptionValidateBeforeCall(integrationKey, integrationId, null, null);
        Type localVarReturnType = new TypeToken<IntegrationSubscription>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getIntegrationSubscriptionAsync(String integrationKey, String integrationId, final ApiCallback<IntegrationSubscription> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getIntegrationSubscriptionValidateBeforeCall(integrationKey, integrationId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IntegrationSubscription>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getIntegrationSubscriptionsCall(String integrationKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/integrations/{integrationKey}".replaceAll("\\{integrationKey\\}", this.apiClient.escapeString(integrationKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getIntegrationSubscriptionsValidateBeforeCall(String integrationKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling getIntegrationSubscriptions(Async)");
        }
        Call call = this.getIntegrationSubscriptionsCall(integrationKey, progressListener, progressRequestListener);
        return call;
    }

    public Integration getIntegrationSubscriptions(String integrationKey) throws ApiException {
        ApiResponse<Integration> resp = this.getIntegrationSubscriptionsWithHttpInfo(integrationKey);
        return resp.getData();
    }

    public ApiResponse<Integration> getIntegrationSubscriptionsWithHttpInfo(String integrationKey) throws ApiException {
        Call call = this.getIntegrationSubscriptionsValidateBeforeCall(integrationKey, null, null);
        Type localVarReturnType = new TypeToken<Integration>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getIntegrationSubscriptionsAsync(String integrationKey, final ApiCallback<Integration> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getIntegrationSubscriptionsValidateBeforeCall(integrationKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Integration>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getIntegrationsCall(final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/integrations";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getIntegrationsValidateBeforeCall(ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getIntegrationsCall(progressListener, progressRequestListener);
        return call;
    }

    public Integrations getIntegrations() throws ApiException {
        ApiResponse<Integrations> resp = this.getIntegrationsWithHttpInfo();
        return resp.getData();
    }

    public ApiResponse<Integrations> getIntegrationsWithHttpInfo() throws ApiException {
        Call call = this.getIntegrationsValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<Integrations>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getIntegrationsAsync(final ApiCallback<Integrations> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getIntegrationsValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<Integrations>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchIntegrationSubscriptionCall(String integrationKey, String integrationId, List<PatchOperation> patchDelta, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        List<PatchOperation> localVarPostBody = patchDelta;
        String localVarPath = "/integrations/{integrationKey}/{integrationId}".replaceAll("\\{integrationKey\\}", this.apiClient.escapeString(integrationKey.toString())).replaceAll("\\{integrationId\\}", this.apiClient.escapeString(integrationId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchIntegrationSubscriptionValidateBeforeCall(String integrationKey, String integrationId, List<PatchOperation> patchDelta, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling patchIntegrationSubscription(Async)");
        }
        if (integrationId == null) {
            throw new ApiException("Missing the required parameter 'integrationId' when calling patchIntegrationSubscription(Async)");
        }
        if (patchDelta == null) {
            throw new ApiException("Missing the required parameter 'patchDelta' when calling patchIntegrationSubscription(Async)");
        }
        Call call = this.patchIntegrationSubscriptionCall(integrationKey, integrationId, patchDelta, progressListener, progressRequestListener);
        return call;
    }

    public IntegrationSubscription patchIntegrationSubscription(String integrationKey, String integrationId, List<PatchOperation> patchDelta) throws ApiException {
        ApiResponse<IntegrationSubscription> resp = this.patchIntegrationSubscriptionWithHttpInfo(integrationKey, integrationId, patchDelta);
        return resp.getData();
    }

    public ApiResponse<IntegrationSubscription> patchIntegrationSubscriptionWithHttpInfo(String integrationKey, String integrationId, List<PatchOperation> patchDelta) throws ApiException {
        Call call = this.patchIntegrationSubscriptionValidateBeforeCall(integrationKey, integrationId, patchDelta, null, null);
        Type localVarReturnType = new TypeToken<IntegrationSubscription>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchIntegrationSubscriptionAsync(String integrationKey, String integrationId, List<PatchOperation> patchDelta, final ApiCallback<IntegrationSubscription> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchIntegrationSubscriptionValidateBeforeCall(integrationKey, integrationId, patchDelta, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IntegrationSubscription>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postIntegrationSubscriptionCall(String integrationKey, SubscriptionBody subscriptionBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        SubscriptionBody localVarPostBody = subscriptionBody;
        String localVarPath = "/integrations/{integrationKey}".replaceAll("\\{integrationKey\\}", this.apiClient.escapeString(integrationKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postIntegrationSubscriptionValidateBeforeCall(String integrationKey, SubscriptionBody subscriptionBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (integrationKey == null) {
            throw new ApiException("Missing the required parameter 'integrationKey' when calling postIntegrationSubscription(Async)");
        }
        if (subscriptionBody == null) {
            throw new ApiException("Missing the required parameter 'subscriptionBody' when calling postIntegrationSubscription(Async)");
        }
        Call call = this.postIntegrationSubscriptionCall(integrationKey, subscriptionBody, progressListener, progressRequestListener);
        return call;
    }

    public IntegrationSubscription postIntegrationSubscription(String integrationKey, SubscriptionBody subscriptionBody) throws ApiException {
        ApiResponse<IntegrationSubscription> resp = this.postIntegrationSubscriptionWithHttpInfo(integrationKey, subscriptionBody);
        return resp.getData();
    }

    public ApiResponse<IntegrationSubscription> postIntegrationSubscriptionWithHttpInfo(String integrationKey, SubscriptionBody subscriptionBody) throws ApiException {
        Call call = this.postIntegrationSubscriptionValidateBeforeCall(integrationKey, subscriptionBody, null, null);
        Type localVarReturnType = new TypeToken<IntegrationSubscription>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postIntegrationSubscriptionAsync(String integrationKey, SubscriptionBody subscriptionBody, final ApiCallback<IntegrationSubscription> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postIntegrationSubscriptionValidateBeforeCall(integrationKey, subscriptionBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<IntegrationSubscription>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

