/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.ProgressRequestBody;
import com.launchdarkly.api.ProgressResponseBody;
import com.launchdarkly.api.model.BigSegmentTargetsBody;
import com.launchdarkly.api.model.PatchOperation;
import com.launchdarkly.api.model.UserSegment;
import com.launchdarkly.api.model.UserSegmentBody;
import com.launchdarkly.api.model.UserSegments;
import com.launchdarkly.api.model.UserTargetingExpirationForSegment;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UserSegmentsApi {
    private ApiClient apiClient;

    public UserSegmentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserSegmentsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call deleteUserSegmentCall(String projectKey, String environmentKey, String userSegmentKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/segments/{projectKey}/{environmentKey}/{userSegmentKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{userSegmentKey\\}", this.apiClient.escapeString(userSegmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call deleteUserSegmentValidateBeforeCall(String projectKey, String environmentKey, String userSegmentKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling deleteUserSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling deleteUserSegment(Async)");
        }
        if (userSegmentKey == null) {
            throw new ApiException("Missing the required parameter 'userSegmentKey' when calling deleteUserSegment(Async)");
        }
        Call call = this.deleteUserSegmentCall(projectKey, environmentKey, userSegmentKey, progressListener, progressRequestListener);
        return call;
    }

    public void deleteUserSegment(String projectKey, String environmentKey, String userSegmentKey) throws ApiException {
        this.deleteUserSegmentWithHttpInfo(projectKey, environmentKey, userSegmentKey);
    }

    public ApiResponse<Void> deleteUserSegmentWithHttpInfo(String projectKey, String environmentKey, String userSegmentKey) throws ApiException {
        Call call = this.deleteUserSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentKey, null, null);
        return this.apiClient.execute(call);
    }

    public Call deleteUserSegmentAsync(String projectKey, String environmentKey, String userSegmentKey, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.deleteUserSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentKey, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }

    public Call getExpiringUserTargetsOnSegmentCall(String projectKey, String environmentKey, String userSegmentKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/segments/{projectKey}/{userSegmentKey}/expiring-user-targets/{environmentKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{userSegmentKey\\}", this.apiClient.escapeString(userSegmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getExpiringUserTargetsOnSegmentValidateBeforeCall(String projectKey, String environmentKey, String userSegmentKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getExpiringUserTargetsOnSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getExpiringUserTargetsOnSegment(Async)");
        }
        if (userSegmentKey == null) {
            throw new ApiException("Missing the required parameter 'userSegmentKey' when calling getExpiringUserTargetsOnSegment(Async)");
        }
        Call call = this.getExpiringUserTargetsOnSegmentCall(projectKey, environmentKey, userSegmentKey, progressListener, progressRequestListener);
        return call;
    }

    public UserTargetingExpirationForSegment getExpiringUserTargetsOnSegment(String projectKey, String environmentKey, String userSegmentKey) throws ApiException {
        ApiResponse<UserTargetingExpirationForSegment> resp = this.getExpiringUserTargetsOnSegmentWithHttpInfo(projectKey, environmentKey, userSegmentKey);
        return resp.getData();
    }

    public ApiResponse<UserTargetingExpirationForSegment> getExpiringUserTargetsOnSegmentWithHttpInfo(String projectKey, String environmentKey, String userSegmentKey) throws ApiException {
        Call call = this.getExpiringUserTargetsOnSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentKey, null, null);
        Type localVarReturnType = new TypeToken<UserTargetingExpirationForSegment>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getExpiringUserTargetsOnSegmentAsync(String projectKey, String environmentKey, String userSegmentKey, final ApiCallback<UserTargetingExpirationForSegment> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getExpiringUserTargetsOnSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserTargetingExpirationForSegment>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getUserSegmentCall(String projectKey, String environmentKey, String userSegmentKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/segments/{projectKey}/{environmentKey}/{userSegmentKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{userSegmentKey\\}", this.apiClient.escapeString(userSegmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getUserSegmentValidateBeforeCall(String projectKey, String environmentKey, String userSegmentKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getUserSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getUserSegment(Async)");
        }
        if (userSegmentKey == null) {
            throw new ApiException("Missing the required parameter 'userSegmentKey' when calling getUserSegment(Async)");
        }
        Call call = this.getUserSegmentCall(projectKey, environmentKey, userSegmentKey, progressListener, progressRequestListener);
        return call;
    }

    public UserSegment getUserSegment(String projectKey, String environmentKey, String userSegmentKey) throws ApiException {
        ApiResponse<UserSegment> resp = this.getUserSegmentWithHttpInfo(projectKey, environmentKey, userSegmentKey);
        return resp.getData();
    }

    public ApiResponse<UserSegment> getUserSegmentWithHttpInfo(String projectKey, String environmentKey, String userSegmentKey) throws ApiException {
        Call call = this.getUserSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentKey, null, null);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getUserSegmentAsync(String projectKey, String environmentKey, String userSegmentKey, final ApiCallback<UserSegment> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getUserSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getUserSegmentsCall(String projectKey, String environmentKey, String tag, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/segments/{projectKey}/{environmentKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (tag != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tag", tag));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getUserSegmentsValidateBeforeCall(String projectKey, String environmentKey, String tag, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getUserSegments(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getUserSegments(Async)");
        }
        Call call = this.getUserSegmentsCall(projectKey, environmentKey, tag, progressListener, progressRequestListener);
        return call;
    }

    public UserSegments getUserSegments(String projectKey, String environmentKey, String tag) throws ApiException {
        ApiResponse<UserSegments> resp = this.getUserSegmentsWithHttpInfo(projectKey, environmentKey, tag);
        return resp.getData();
    }

    public ApiResponse<UserSegments> getUserSegmentsWithHttpInfo(String projectKey, String environmentKey, String tag) throws ApiException {
        Call call = this.getUserSegmentsValidateBeforeCall(projectKey, environmentKey, tag, null, null);
        Type localVarReturnType = new TypeToken<UserSegments>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getUserSegmentsAsync(String projectKey, String environmentKey, String tag, final ApiCallback<UserSegments> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getUserSegmentsValidateBeforeCall(projectKey, environmentKey, tag, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserSegments>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchExpiringUserTargetsOnSegmentCall(String projectKey, String environmentKey, String userSegmentKey, Object semanticPatchWithComment, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = semanticPatchWithComment;
        String localVarPath = "/segments/{projectKey}/{userSegmentKey}/expiring-user-targets/{environmentKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{userSegmentKey\\}", this.apiClient.escapeString(userSegmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchExpiringUserTargetsOnSegmentValidateBeforeCall(String projectKey, String environmentKey, String userSegmentKey, Object semanticPatchWithComment, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchExpiringUserTargetsOnSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchExpiringUserTargetsOnSegment(Async)");
        }
        if (userSegmentKey == null) {
            throw new ApiException("Missing the required parameter 'userSegmentKey' when calling patchExpiringUserTargetsOnSegment(Async)");
        }
        if (semanticPatchWithComment == null) {
            throw new ApiException("Missing the required parameter 'semanticPatchWithComment' when calling patchExpiringUserTargetsOnSegment(Async)");
        }
        Call call = this.patchExpiringUserTargetsOnSegmentCall(projectKey, environmentKey, userSegmentKey, semanticPatchWithComment, progressListener, progressRequestListener);
        return call;
    }

    public UserTargetingExpirationForSegment patchExpiringUserTargetsOnSegment(String projectKey, String environmentKey, String userSegmentKey, Object semanticPatchWithComment) throws ApiException {
        ApiResponse<UserTargetingExpirationForSegment> resp = this.patchExpiringUserTargetsOnSegmentWithHttpInfo(projectKey, environmentKey, userSegmentKey, semanticPatchWithComment);
        return resp.getData();
    }

    public ApiResponse<UserTargetingExpirationForSegment> patchExpiringUserTargetsOnSegmentWithHttpInfo(String projectKey, String environmentKey, String userSegmentKey, Object semanticPatchWithComment) throws ApiException {
        Call call = this.patchExpiringUserTargetsOnSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentKey, semanticPatchWithComment, null, null);
        Type localVarReturnType = new TypeToken<UserTargetingExpirationForSegment>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchExpiringUserTargetsOnSegmentAsync(String projectKey, String environmentKey, String userSegmentKey, Object semanticPatchWithComment, final ApiCallback<UserTargetingExpirationForSegment> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchExpiringUserTargetsOnSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentKey, semanticPatchWithComment, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserTargetingExpirationForSegment>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchUserSegmentCall(String projectKey, String environmentKey, String userSegmentKey, List<PatchOperation> patchOnly, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        List<PatchOperation> localVarPostBody = patchOnly;
        String localVarPath = "/segments/{projectKey}/{environmentKey}/{userSegmentKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{userSegmentKey\\}", this.apiClient.escapeString(userSegmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchUserSegmentValidateBeforeCall(String projectKey, String environmentKey, String userSegmentKey, List<PatchOperation> patchOnly, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchUserSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchUserSegment(Async)");
        }
        if (userSegmentKey == null) {
            throw new ApiException("Missing the required parameter 'userSegmentKey' when calling patchUserSegment(Async)");
        }
        if (patchOnly == null) {
            throw new ApiException("Missing the required parameter 'patchOnly' when calling patchUserSegment(Async)");
        }
        Call call = this.patchUserSegmentCall(projectKey, environmentKey, userSegmentKey, patchOnly, progressListener, progressRequestListener);
        return call;
    }

    public UserSegment patchUserSegment(String projectKey, String environmentKey, String userSegmentKey, List<PatchOperation> patchOnly) throws ApiException {
        ApiResponse<UserSegment> resp = this.patchUserSegmentWithHttpInfo(projectKey, environmentKey, userSegmentKey, patchOnly);
        return resp.getData();
    }

    public ApiResponse<UserSegment> patchUserSegmentWithHttpInfo(String projectKey, String environmentKey, String userSegmentKey, List<PatchOperation> patchOnly) throws ApiException {
        Call call = this.patchUserSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentKey, patchOnly, null, null);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchUserSegmentAsync(String projectKey, String environmentKey, String userSegmentKey, List<PatchOperation> patchOnly, final ApiCallback<UserSegment> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchUserSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentKey, patchOnly, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call postUserSegmentCall(String projectKey, String environmentKey, UserSegmentBody userSegmentBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UserSegmentBody localVarPostBody = userSegmentBody;
        String localVarPath = "/segments/{projectKey}/{environmentKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call postUserSegmentValidateBeforeCall(String projectKey, String environmentKey, UserSegmentBody userSegmentBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling postUserSegment(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling postUserSegment(Async)");
        }
        if (userSegmentBody == null) {
            throw new ApiException("Missing the required parameter 'userSegmentBody' when calling postUserSegment(Async)");
        }
        Call call = this.postUserSegmentCall(projectKey, environmentKey, userSegmentBody, progressListener, progressRequestListener);
        return call;
    }

    public UserSegment postUserSegment(String projectKey, String environmentKey, UserSegmentBody userSegmentBody) throws ApiException {
        ApiResponse<UserSegment> resp = this.postUserSegmentWithHttpInfo(projectKey, environmentKey, userSegmentBody);
        return resp.getData();
    }

    public ApiResponse<UserSegment> postUserSegmentWithHttpInfo(String projectKey, String environmentKey, UserSegmentBody userSegmentBody) throws ApiException {
        Call call = this.postUserSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentBody, null, null);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call postUserSegmentAsync(String projectKey, String environmentKey, UserSegmentBody userSegmentBody, final ApiCallback<UserSegment> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.postUserSegmentValidateBeforeCall(projectKey, environmentKey, userSegmentBody, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserSegment>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateBigSegmentTargetsCall(String projectKey, String environmentKey, String userSegmentKey, BigSegmentTargetsBody bigSegmentTargetsBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        BigSegmentTargetsBody localVarPostBody = bigSegmentTargetsBody;
        String localVarPath = "/segments/{projectKey}/{environmentKey}/{userSegmentKey}/users".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{userSegmentKey\\}", this.apiClient.escapeString(userSegmentKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateBigSegmentTargetsValidateBeforeCall(String projectKey, String environmentKey, String userSegmentKey, BigSegmentTargetsBody bigSegmentTargetsBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling updateBigSegmentTargets(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling updateBigSegmentTargets(Async)");
        }
        if (userSegmentKey == null) {
            throw new ApiException("Missing the required parameter 'userSegmentKey' when calling updateBigSegmentTargets(Async)");
        }
        if (bigSegmentTargetsBody == null) {
            throw new ApiException("Missing the required parameter 'bigSegmentTargetsBody' when calling updateBigSegmentTargets(Async)");
        }
        Call call = this.updateBigSegmentTargetsCall(projectKey, environmentKey, userSegmentKey, bigSegmentTargetsBody, progressListener, progressRequestListener);
        return call;
    }

    public void updateBigSegmentTargets(String projectKey, String environmentKey, String userSegmentKey, BigSegmentTargetsBody bigSegmentTargetsBody) throws ApiException {
        this.updateBigSegmentTargetsWithHttpInfo(projectKey, environmentKey, userSegmentKey, bigSegmentTargetsBody);
    }

    public ApiResponse<Void> updateBigSegmentTargetsWithHttpInfo(String projectKey, String environmentKey, String userSegmentKey, BigSegmentTargetsBody bigSegmentTargetsBody) throws ApiException {
        Call call = this.updateBigSegmentTargetsValidateBeforeCall(projectKey, environmentKey, userSegmentKey, bigSegmentTargetsBody, null, null);
        return this.apiClient.execute(call);
    }

    public Call updateBigSegmentTargetsAsync(String projectKey, String environmentKey, String userSegmentKey, BigSegmentTargetsBody bigSegmentTargetsBody, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateBigSegmentTargetsValidateBeforeCall(projectKey, environmentKey, userSegmentKey, bigSegmentTargetsBody, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

