/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.api;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.api.ApiCallback;
import com.launchdarkly.api.ApiClient;
import com.launchdarkly.api.ApiException;
import com.launchdarkly.api.ApiResponse;
import com.launchdarkly.api.Configuration;
import com.launchdarkly.api.Pair;
import com.launchdarkly.api.ProgressRequestBody;
import com.launchdarkly.api.ProgressResponseBody;
import com.launchdarkly.api.model.UserFlagSetting;
import com.launchdarkly.api.model.UserFlagSettings;
import com.launchdarkly.api.model.UserSettingsBody;
import com.launchdarkly.api.model.UserTargetingExpirationOnFlagsForUser;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;

public class UserSettingsApi {
    private ApiClient apiClient;

    public UserSettingsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public UserSettingsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getExpiringUserTargetsForUserCall(String projectKey, String environmentKey, String userKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/users/{projectKey}/{userKey}/expiring-user-targets/{environmentKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{userKey\\}", this.apiClient.escapeString(userKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getExpiringUserTargetsForUserValidateBeforeCall(String projectKey, String environmentKey, String userKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getExpiringUserTargetsForUser(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getExpiringUserTargetsForUser(Async)");
        }
        if (userKey == null) {
            throw new ApiException("Missing the required parameter 'userKey' when calling getExpiringUserTargetsForUser(Async)");
        }
        Call call = this.getExpiringUserTargetsForUserCall(projectKey, environmentKey, userKey, progressListener, progressRequestListener);
        return call;
    }

    public UserTargetingExpirationOnFlagsForUser getExpiringUserTargetsForUser(String projectKey, String environmentKey, String userKey) throws ApiException {
        ApiResponse<UserTargetingExpirationOnFlagsForUser> resp = this.getExpiringUserTargetsForUserWithHttpInfo(projectKey, environmentKey, userKey);
        return resp.getData();
    }

    public ApiResponse<UserTargetingExpirationOnFlagsForUser> getExpiringUserTargetsForUserWithHttpInfo(String projectKey, String environmentKey, String userKey) throws ApiException {
        Call call = this.getExpiringUserTargetsForUserValidateBeforeCall(projectKey, environmentKey, userKey, null, null);
        Type localVarReturnType = new TypeToken<UserTargetingExpirationOnFlagsForUser>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getExpiringUserTargetsForUserAsync(String projectKey, String environmentKey, String userKey, final ApiCallback<UserTargetingExpirationOnFlagsForUser> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getExpiringUserTargetsForUserValidateBeforeCall(projectKey, environmentKey, userKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserTargetingExpirationOnFlagsForUser>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getUserFlagSettingCall(String projectKey, String environmentKey, String userKey, String featureFlagKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/users/{projectKey}/{environmentKey}/{userKey}/flags/{featureFlagKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{userKey\\}", this.apiClient.escapeString(userKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getUserFlagSettingValidateBeforeCall(String projectKey, String environmentKey, String userKey, String featureFlagKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getUserFlagSetting(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getUserFlagSetting(Async)");
        }
        if (userKey == null) {
            throw new ApiException("Missing the required parameter 'userKey' when calling getUserFlagSetting(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling getUserFlagSetting(Async)");
        }
        Call call = this.getUserFlagSettingCall(projectKey, environmentKey, userKey, featureFlagKey, progressListener, progressRequestListener);
        return call;
    }

    public UserFlagSetting getUserFlagSetting(String projectKey, String environmentKey, String userKey, String featureFlagKey) throws ApiException {
        ApiResponse<UserFlagSetting> resp = this.getUserFlagSettingWithHttpInfo(projectKey, environmentKey, userKey, featureFlagKey);
        return resp.getData();
    }

    public ApiResponse<UserFlagSetting> getUserFlagSettingWithHttpInfo(String projectKey, String environmentKey, String userKey, String featureFlagKey) throws ApiException {
        Call call = this.getUserFlagSettingValidateBeforeCall(projectKey, environmentKey, userKey, featureFlagKey, null, null);
        Type localVarReturnType = new TypeToken<UserFlagSetting>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getUserFlagSettingAsync(String projectKey, String environmentKey, String userKey, String featureFlagKey, final ApiCallback<UserFlagSetting> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getUserFlagSettingValidateBeforeCall(projectKey, environmentKey, userKey, featureFlagKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserFlagSetting>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getUserFlagSettingsCall(String projectKey, String environmentKey, String userKey, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/users/{projectKey}/{environmentKey}/{userKey}/flags".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{userKey\\}", this.apiClient.escapeString(userKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getUserFlagSettingsValidateBeforeCall(String projectKey, String environmentKey, String userKey, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling getUserFlagSettings(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling getUserFlagSettings(Async)");
        }
        if (userKey == null) {
            throw new ApiException("Missing the required parameter 'userKey' when calling getUserFlagSettings(Async)");
        }
        Call call = this.getUserFlagSettingsCall(projectKey, environmentKey, userKey, progressListener, progressRequestListener);
        return call;
    }

    public UserFlagSettings getUserFlagSettings(String projectKey, String environmentKey, String userKey) throws ApiException {
        ApiResponse<UserFlagSettings> resp = this.getUserFlagSettingsWithHttpInfo(projectKey, environmentKey, userKey);
        return resp.getData();
    }

    public ApiResponse<UserFlagSettings> getUserFlagSettingsWithHttpInfo(String projectKey, String environmentKey, String userKey) throws ApiException {
        Call call = this.getUserFlagSettingsValidateBeforeCall(projectKey, environmentKey, userKey, null, null);
        Type localVarReturnType = new TypeToken<UserFlagSettings>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getUserFlagSettingsAsync(String projectKey, String environmentKey, String userKey, final ApiCallback<UserFlagSettings> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getUserFlagSettingsValidateBeforeCall(projectKey, environmentKey, userKey, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserFlagSettings>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call patchExpiringUserTargetsForFlagsCall(String projectKey, String environmentKey, String userKey, Object semanticPatchWithComment, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = semanticPatchWithComment;
        String localVarPath = "/users/{projectKey}/{userKey}/expiring-user-targets/{environmentKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{userKey\\}", this.apiClient.escapeString(userKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call patchExpiringUserTargetsForFlagsValidateBeforeCall(String projectKey, String environmentKey, String userKey, Object semanticPatchWithComment, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling patchExpiringUserTargetsForFlags(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling patchExpiringUserTargetsForFlags(Async)");
        }
        if (userKey == null) {
            throw new ApiException("Missing the required parameter 'userKey' when calling patchExpiringUserTargetsForFlags(Async)");
        }
        if (semanticPatchWithComment == null) {
            throw new ApiException("Missing the required parameter 'semanticPatchWithComment' when calling patchExpiringUserTargetsForFlags(Async)");
        }
        Call call = this.patchExpiringUserTargetsForFlagsCall(projectKey, environmentKey, userKey, semanticPatchWithComment, progressListener, progressRequestListener);
        return call;
    }

    public UserTargetingExpirationOnFlagsForUser patchExpiringUserTargetsForFlags(String projectKey, String environmentKey, String userKey, Object semanticPatchWithComment) throws ApiException {
        ApiResponse<UserTargetingExpirationOnFlagsForUser> resp = this.patchExpiringUserTargetsForFlagsWithHttpInfo(projectKey, environmentKey, userKey, semanticPatchWithComment);
        return resp.getData();
    }

    public ApiResponse<UserTargetingExpirationOnFlagsForUser> patchExpiringUserTargetsForFlagsWithHttpInfo(String projectKey, String environmentKey, String userKey, Object semanticPatchWithComment) throws ApiException {
        Call call = this.patchExpiringUserTargetsForFlagsValidateBeforeCall(projectKey, environmentKey, userKey, semanticPatchWithComment, null, null);
        Type localVarReturnType = new TypeToken<UserTargetingExpirationOnFlagsForUser>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call patchExpiringUserTargetsForFlagsAsync(String projectKey, String environmentKey, String userKey, Object semanticPatchWithComment, final ApiCallback<UserTargetingExpirationOnFlagsForUser> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.patchExpiringUserTargetsForFlagsValidateBeforeCall(projectKey, environmentKey, userKey, semanticPatchWithComment, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<UserTargetingExpirationOnFlagsForUser>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call putFlagSettingCall(String projectKey, String environmentKey, String userKey, String featureFlagKey, UserSettingsBody userSettingsBody, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        UserSettingsBody localVarPostBody = userSettingsBody;
        String localVarPath = "/users/{projectKey}/{environmentKey}/{userKey}/flags/{featureFlagKey}".replaceAll("\\{projectKey\\}", this.apiClient.escapeString(projectKey.toString())).replaceAll("\\{environmentKey\\}", this.apiClient.escapeString(environmentKey.toString())).replaceAll("\\{userKey\\}", this.apiClient.escapeString(userKey.toString())).replaceAll("\\{featureFlagKey\\}", this.apiClient.escapeString(featureFlagKey.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"Token"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call putFlagSettingValidateBeforeCall(String projectKey, String environmentKey, String userKey, String featureFlagKey, UserSettingsBody userSettingsBody, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (projectKey == null) {
            throw new ApiException("Missing the required parameter 'projectKey' when calling putFlagSetting(Async)");
        }
        if (environmentKey == null) {
            throw new ApiException("Missing the required parameter 'environmentKey' when calling putFlagSetting(Async)");
        }
        if (userKey == null) {
            throw new ApiException("Missing the required parameter 'userKey' when calling putFlagSetting(Async)");
        }
        if (featureFlagKey == null) {
            throw new ApiException("Missing the required parameter 'featureFlagKey' when calling putFlagSetting(Async)");
        }
        if (userSettingsBody == null) {
            throw new ApiException("Missing the required parameter 'userSettingsBody' when calling putFlagSetting(Async)");
        }
        Call call = this.putFlagSettingCall(projectKey, environmentKey, userKey, featureFlagKey, userSettingsBody, progressListener, progressRequestListener);
        return call;
    }

    public void putFlagSetting(String projectKey, String environmentKey, String userKey, String featureFlagKey, UserSettingsBody userSettingsBody) throws ApiException {
        this.putFlagSettingWithHttpInfo(projectKey, environmentKey, userKey, featureFlagKey, userSettingsBody);
    }

    public ApiResponse<Void> putFlagSettingWithHttpInfo(String projectKey, String environmentKey, String userKey, String featureFlagKey, UserSettingsBody userSettingsBody) throws ApiException {
        Call call = this.putFlagSettingValidateBeforeCall(projectKey, environmentKey, userKey, featureFlagKey, userSettingsBody, null, null);
        return this.apiClient.execute(call);
    }

    public Call putFlagSettingAsync(String projectKey, String environmentKey, String userKey, String featureFlagKey, UserSettingsBody userSettingsBody, final ApiCallback<Void> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.putFlagSettingValidateBeforeCall(projectKey, environmentKey, userKey, featureFlagKey, userSettingsBody, progressListener, progressRequestListener);
        this.apiClient.executeAsync(call, callback);
        return call;
    }
}

