/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.model.ApprovalRequestReview;
import com.launchdarkly.api.model.ApprovalRequestReviewStatus;
import com.launchdarkly.api.model.SemanticPatchInstruction;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ApprovalRequest {
    @SerializedName(value="_id")
    private String id = null;
    @SerializedName(value="_version")
    private Integer version = null;
    @SerializedName(value="creationDate")
    private Integer creationDate = null;
    @SerializedName(value="requestorId")
    private String requestorId = null;
    @SerializedName(value="reviewStatus")
    private ApprovalRequestReviewStatus reviewStatus = null;
    @SerializedName(value="status")
    private StatusEnum status = null;
    @SerializedName(value="appliedByMemberID")
    private String appliedByMemberID = null;
    @SerializedName(value="appliedDate")
    private Integer appliedDate = null;
    @SerializedName(value="allReviews")
    private List<ApprovalRequestReview> allReviews = null;
    @SerializedName(value="notifyMemberIds")
    private List<String> notifyMemberIds = null;
    @SerializedName(value="instructions")
    private SemanticPatchInstruction instructions = null;
    @SerializedName(value="executionDate")
    private Long executionDate = null;
    @SerializedName(value="operatingOnId")
    private String operatingOnId = null;

    public ApprovalRequest id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ApprovalRequest version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public ApprovalRequest creationDate(Integer creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(value="A unix epoch time in milliseconds specifying the date the approval request was requested")
    public Integer getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Integer creationDate) {
        this.creationDate = creationDate;
    }

    public ApprovalRequest requestorId(String requestorId) {
        this.requestorId = requestorId;
        return this;
    }

    @ApiModelProperty(value="The id of the member that requested the change")
    public String getRequestorId() {
        return this.requestorId;
    }

    public void setRequestorId(String requestorId) {
        this.requestorId = requestorId;
    }

    public ApprovalRequest reviewStatus(ApprovalRequestReviewStatus reviewStatus) {
        this.reviewStatus = reviewStatus;
        return this;
    }

    @ApiModelProperty(value="")
    public ApprovalRequestReviewStatus getReviewStatus() {
        return this.reviewStatus;
    }

    public void setReviewStatus(ApprovalRequestReviewStatus reviewStatus) {
        this.reviewStatus = reviewStatus;
    }

    public ApprovalRequest status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="| Name      | Description | | ---------:| ----------- | | pending   | the approval request has not been applied yet | | completed | the approval request has been applied successfully | | scheduled | the approval request for a scheduled change has been applied successfully | | failed    | the approval request has been applied but the changes were not applied successfully | ")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public ApprovalRequest appliedByMemberID(String appliedByMemberID) {
        this.appliedByMemberID = appliedByMemberID;
        return this;
    }

    @ApiModelProperty(value="The id of the member that applied the approval request")
    public String getAppliedByMemberID() {
        return this.appliedByMemberID;
    }

    public void setAppliedByMemberID(String appliedByMemberID) {
        this.appliedByMemberID = appliedByMemberID;
    }

    public ApprovalRequest appliedDate(Integer appliedDate) {
        this.appliedDate = appliedDate;
        return this;
    }

    @ApiModelProperty(value="A unix epoch time in milliseconds specifying the date the approval request was applied")
    public Integer getAppliedDate() {
        return this.appliedDate;
    }

    public void setAppliedDate(Integer appliedDate) {
        this.appliedDate = appliedDate;
    }

    public ApprovalRequest allReviews(List<ApprovalRequestReview> allReviews) {
        this.allReviews = allReviews;
        return this;
    }

    public ApprovalRequest addAllReviewsItem(ApprovalRequestReview allReviewsItem) {
        if (this.allReviews == null) {
            this.allReviews = new ArrayList<ApprovalRequestReview>();
        }
        this.allReviews.add(allReviewsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<ApprovalRequestReview> getAllReviews() {
        return this.allReviews;
    }

    public void setAllReviews(List<ApprovalRequestReview> allReviews) {
        this.allReviews = allReviews;
    }

    public ApprovalRequest notifyMemberIds(List<String> notifyMemberIds) {
        this.notifyMemberIds = notifyMemberIds;
        return this;
    }

    public ApprovalRequest addNotifyMemberIdsItem(String notifyMemberIdsItem) {
        if (this.notifyMemberIds == null) {
            this.notifyMemberIds = new ArrayList<String>();
        }
        this.notifyMemberIds.add(notifyMemberIdsItem);
        return this;
    }

    @ApiModelProperty(example="[\"memberId\",\"memberId2\"]", value="")
    public List<String> getNotifyMemberIds() {
        return this.notifyMemberIds;
    }

    public void setNotifyMemberIds(List<String> notifyMemberIds) {
        this.notifyMemberIds = notifyMemberIds;
    }

    public ApprovalRequest instructions(SemanticPatchInstruction instructions) {
        this.instructions = instructions;
        return this;
    }

    @ApiModelProperty(value="")
    public SemanticPatchInstruction getInstructions() {
        return this.instructions;
    }

    public void setInstructions(SemanticPatchInstruction instructions) {
        this.instructions = instructions;
    }

    public ApprovalRequest executionDate(Long executionDate) {
        this.executionDate = executionDate;
        return this;
    }

    @ApiModelProperty(value="Timestamp for when instructions will be executed")
    public Long getExecutionDate() {
        return this.executionDate;
    }

    public void setExecutionDate(Long executionDate) {
        this.executionDate = executionDate;
    }

    public ApprovalRequest operatingOnId(String operatingOnId) {
        this.operatingOnId = operatingOnId;
        return this;
    }

    @ApiModelProperty(value="ID of scheduled change to edit or delete")
    public String getOperatingOnId() {
        return this.operatingOnId;
    }

    public void setOperatingOnId(String operatingOnId) {
        this.operatingOnId = operatingOnId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApprovalRequest approvalRequest = (ApprovalRequest)o;
        return Objects.equals(this.id, approvalRequest.id) && Objects.equals(this.version, approvalRequest.version) && Objects.equals(this.creationDate, approvalRequest.creationDate) && Objects.equals(this.requestorId, approvalRequest.requestorId) && Objects.equals((Object)this.reviewStatus, (Object)approvalRequest.reviewStatus) && Objects.equals((Object)this.status, (Object)approvalRequest.status) && Objects.equals(this.appliedByMemberID, approvalRequest.appliedByMemberID) && Objects.equals(this.appliedDate, approvalRequest.appliedDate) && Objects.equals(this.allReviews, approvalRequest.allReviews) && Objects.equals(this.notifyMemberIds, approvalRequest.notifyMemberIds) && Objects.equals(this.instructions, approvalRequest.instructions) && Objects.equals(this.executionDate, approvalRequest.executionDate) && Objects.equals(this.operatingOnId, approvalRequest.operatingOnId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.version, this.creationDate, this.requestorId, this.reviewStatus, this.status, this.appliedByMemberID, this.appliedDate, this.allReviews, this.notifyMemberIds, this.instructions, this.executionDate, this.operatingOnId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApprovalRequest {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    requestorId: ").append(this.toIndentedString(this.requestorId)).append("\n");
        sb.append("    reviewStatus: ").append(this.toIndentedString((Object)this.reviewStatus)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    appliedByMemberID: ").append(this.toIndentedString(this.appliedByMemberID)).append("\n");
        sb.append("    appliedDate: ").append(this.toIndentedString(this.appliedDate)).append("\n");
        sb.append("    allReviews: ").append(this.toIndentedString(this.allReviews)).append("\n");
        sb.append("    notifyMemberIds: ").append(this.toIndentedString(this.notifyMemberIds)).append("\n");
        sb.append("    instructions: ").append(this.toIndentedString(this.instructions)).append("\n");
        sb.append("    executionDate: ").append(this.toIndentedString(this.executionDate)).append("\n");
        sb.append("    operatingOnId: ").append(this.toIndentedString(this.operatingOnId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        PENDING("pending"),
        COMPLETED("completed"),
        SCHEDULED("scheduled"),
        FAILED("failed");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String text) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

