/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="A name and value describing a custom property.")
public class CustomProperty {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="value")
    private List<String> value = null;

    public CustomProperty name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="My property", required=true, value="The name of the property.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CustomProperty value(List<String> value) {
        this.value = value;
        return this;
    }

    public CustomProperty addValueItem(String valueItem) {
        if (this.value == null) {
            this.value = new ArrayList<String>();
        }
        this.value.add(valueItem);
        return this;
    }

    @ApiModelProperty(value="Values for this property.")
    public List<String> getValue() {
        return this.value;
    }

    public void setValue(List<String> value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomProperty customProperty = (CustomProperty)o;
        return Objects.equals(this.name, customProperty.name) && Objects.equals(this.value, customProperty.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomProperty {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

