/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.annotations.SerializedName;
import com.launchdarkly.api.model.Policy;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CustomRoleBody {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="key")
    private String key = null;
    @SerializedName(value="policy")
    private List<Policy> policy = new ArrayList<Policy>();

    public CustomRoleBody name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="revenue team", required=true, value="Name of the custom role.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CustomRoleBody description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Description of revenue team role here", value="Description of the custom role.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public CustomRoleBody key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(example="revenue-team", required=true, value="The 20-hexdigit id or the key for a custom role.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public CustomRoleBody policy(List<Policy> policy) {
        this.policy = policy;
        return this;
    }

    public CustomRoleBody addPolicyItem(Policy policyItem) {
        this.policy.add(policyItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<Policy> getPolicy() {
        return this.policy;
    }

    public void setPolicy(List<Policy> policy) {
        this.policy = policy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomRoleBody customRoleBody = (CustomRoleBody)o;
        return Objects.equals(this.name, customRoleBody.name) && Objects.equals(this.description, customRoleBody.description) && Objects.equals(this.key, customRoleBody.key) && Objects.equals(this.policy, customRoleBody.policy);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.key, this.policy);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomRoleBody {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

