/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.api.model.Links;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class Destination {
    @SerializedName(value="_links")
    private Links links = null;
    @SerializedName(value="_id")
    private String id = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="kind")
    private KindEnum kind = null;
    @SerializedName(value="config")
    private Object config = null;
    @SerializedName(value="on")
    private Boolean on = null;
    @SerializedName(value="version")
    private Integer version = null;

    public Destination links(Links links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public Links getLinks() {
        return this.links;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    public Destination id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="37ed9aad-de0a-4665-932e-41c35587aeea", value="Unique destination ID.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Destination name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Example Google Pub/Sub Destination", value="The destination name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Destination kind(KindEnum kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(example="google-pubsub", value="Destination type (\"google-pubsub\", \"kinesis\", \"mparticle\", or \"segment\")")
    public KindEnum getKind() {
        return this.kind;
    }

    public void setKind(KindEnum kind) {
        this.kind = kind;
    }

    public Destination config(Object config) {
        this.config = config;
        return this;
    }

    @ApiModelProperty(example="{\"project\":\"cool-project\",\"topic\":\"test\"}", value="destination-specific configuration.")
    public Object getConfig() {
        return this.config;
    }

    public void setConfig(Object config) {
        this.config = config;
    }

    public Destination on(Boolean on) {
        this.on = on;
        return this;
    }

    @ApiModelProperty(example="true", value="Whether the data export destination is on or not.")
    public Boolean isOn() {
        return this.on;
    }

    public void setOn(Boolean on) {
        this.on = on;
    }

    public Destination version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="2", value="")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Destination destination = (Destination)o;
        return Objects.equals(this.links, destination.links) && Objects.equals(this.id, destination.id) && Objects.equals(this.name, destination.name) && Objects.equals((Object)this.kind, (Object)destination.kind) && Objects.equals(this.config, destination.config) && Objects.equals(this.on, destination.on) && Objects.equals(this.version, destination.version);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.links, this.id, this.name, this.kind, this.config, this.on, this.version});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Destination {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString((Object)this.kind)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    on: ").append(this.toIndentedString(this.on)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum KindEnum {
        GOOGLE_PUBSUB("google-pubsub"),
        KINESIS("kinesis"),
        MPARTICLE("mparticle"),
        SEGMENT("segment");

        private String value;

        private KindEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static KindEnum fromValue(String text) {
            for (KindEnum b : KindEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<KindEnum> {
            public void write(JsonWriter jsonWriter, KindEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public KindEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return KindEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

