/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class DestinationBody {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="kind")
    private KindEnum kind = null;
    @SerializedName(value="config")
    private Object config = null;
    @SerializedName(value="on")
    private Boolean on = null;

    public DestinationBody name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Example Google Pub/Sub Destination", required=true, value="A human-readable name for your data export destination.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DestinationBody kind(KindEnum kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(example="google-pubsub", required=true, value="The data export destination type. Available choices are kinesis, google-pubsub, mparticle, or segment.")
    public KindEnum getKind() {
        return this.kind;
    }

    public void setKind(KindEnum kind) {
        this.kind = kind;
    }

    public DestinationBody config(Object config) {
        this.config = config;
        return this;
    }

    @ApiModelProperty(example="{\"project\":\"cool-project\",\"topic\":\"test\"}", required=true, value="destination-specific configuration.")
    public Object getConfig() {
        return this.config;
    }

    public void setConfig(Object config) {
        this.config = config;
    }

    public DestinationBody on(Boolean on) {
        this.on = on;
        return this;
    }

    @ApiModelProperty(example="true", value="Whether the data export destination is on or not.")
    public Boolean isOn() {
        return this.on;
    }

    public void setOn(Boolean on) {
        this.on = on;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DestinationBody destinationBody = (DestinationBody)o;
        return Objects.equals(this.name, destinationBody.name) && Objects.equals((Object)this.kind, (Object)destinationBody.kind) && Objects.equals(this.config, destinationBody.config) && Objects.equals(this.on, destinationBody.on);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.kind, this.config, this.on});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DestinationBody {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString((Object)this.kind)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    on: ").append(this.toIndentedString(this.on)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum KindEnum {
        GOOGLE_PUBSUB("google-pubsub"),
        KINESIS("kinesis"),
        MPARTICLE("mparticle"),
        SEGMENT("segment");

        private String value;

        private KindEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static KindEnum fromValue(String text) {
            for (KindEnum b : KindEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<KindEnum> {
            public void write(JsonWriter jsonWriter, KindEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public KindEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return KindEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

