/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.annotations.SerializedName;
import com.launchdarkly.api.model.EnvironmentApprovalSettings;
import com.launchdarkly.api.model.Links;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Environment {
    @SerializedName(value="_links")
    private Links links = null;
    @SerializedName(value="_id")
    private String id = null;
    @SerializedName(value="key")
    private String key = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="apiKey")
    private String apiKey = null;
    @SerializedName(value="mobileKey")
    private String mobileKey = null;
    @SerializedName(value="color")
    private String color = null;
    @SerializedName(value="defaultTtl")
    private BigDecimal defaultTtl = null;
    @SerializedName(value="secureMode")
    private Boolean secureMode = null;
    @SerializedName(value="defaultTrackEvents")
    private Boolean defaultTrackEvents = null;
    @SerializedName(value="tags")
    private List<String> tags = null;
    @SerializedName(value="requireComments")
    private Boolean requireComments = null;
    @SerializedName(value="confirmChanges")
    private Boolean confirmChanges = null;
    @SerializedName(value="approvalSettings")
    private EnvironmentApprovalSettings approvalSettings = null;

    public Environment links(Links links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public Links getLinks() {
        return this.links;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    public Environment id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Environment key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(example="production", value="The key for the environment.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Environment name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Production", value="The name of the environment.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Environment apiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }

    @ApiModelProperty(example="XXX", value="The SDK key for backend LaunchDarkly SDKs.")
    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public Environment mobileKey(String mobileKey) {
        this.mobileKey = mobileKey;
        return this;
    }

    @ApiModelProperty(example="XXX", value="The SDK key for mobile LaunchDarkly SDKs.")
    public String getMobileKey() {
        return this.mobileKey;
    }

    public void setMobileKey(String mobileKey) {
        this.mobileKey = mobileKey;
    }

    public Environment color(String color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(example="417505", value="The swatch color for the environment.")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public Environment defaultTtl(BigDecimal defaultTtl) {
        this.defaultTtl = defaultTtl;
        return this;
    }

    @ApiModelProperty(example="0.0", value="The default TTL.")
    public BigDecimal getDefaultTtl() {
        return this.defaultTtl;
    }

    public void setDefaultTtl(BigDecimal defaultTtl) {
        this.defaultTtl = defaultTtl;
    }

    public Environment secureMode(Boolean secureMode) {
        this.secureMode = secureMode;
        return this;
    }

    @ApiModelProperty(example="false", value="Determines if this environment is in safe mode.")
    public Boolean isSecureMode() {
        return this.secureMode;
    }

    public void setSecureMode(Boolean secureMode) {
        this.secureMode = secureMode;
    }

    public Environment defaultTrackEvents(Boolean defaultTrackEvents) {
        this.defaultTrackEvents = defaultTrackEvents;
        return this;
    }

    @ApiModelProperty(example="false", value="Set to true to send detailed event information for new flags.")
    public Boolean isDefaultTrackEvents() {
        return this.defaultTrackEvents;
    }

    public void setDefaultTrackEvents(Boolean defaultTrackEvents) {
        this.defaultTrackEvents = defaultTrackEvents;
    }

    public Environment tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Environment addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(value="An array of tags for this environment.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Environment requireComments(Boolean requireComments) {
        this.requireComments = requireComments;
        return this;
    }

    @ApiModelProperty(example="false", value="Determines if this environment requires comments for flag and segment changes.")
    public Boolean isRequireComments() {
        return this.requireComments;
    }

    public void setRequireComments(Boolean requireComments) {
        this.requireComments = requireComments;
    }

    public Environment confirmChanges(Boolean confirmChanges) {
        this.confirmChanges = confirmChanges;
        return this;
    }

    @ApiModelProperty(example="false", value="Determines if this environment requires confirmation for flag and segment changes.")
    public Boolean isConfirmChanges() {
        return this.confirmChanges;
    }

    public void setConfirmChanges(Boolean confirmChanges) {
        this.confirmChanges = confirmChanges;
    }

    public Environment approvalSettings(EnvironmentApprovalSettings approvalSettings) {
        this.approvalSettings = approvalSettings;
        return this;
    }

    @ApiModelProperty(value="")
    public EnvironmentApprovalSettings getApprovalSettings() {
        return this.approvalSettings;
    }

    public void setApprovalSettings(EnvironmentApprovalSettings approvalSettings) {
        this.approvalSettings = approvalSettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Environment environment = (Environment)o;
        return Objects.equals(this.links, environment.links) && Objects.equals(this.id, environment.id) && Objects.equals(this.key, environment.key) && Objects.equals(this.name, environment.name) && Objects.equals(this.apiKey, environment.apiKey) && Objects.equals(this.mobileKey, environment.mobileKey) && Objects.equals(this.color, environment.color) && Objects.equals(this.defaultTtl, environment.defaultTtl) && Objects.equals(this.secureMode, environment.secureMode) && Objects.equals(this.defaultTrackEvents, environment.defaultTrackEvents) && Objects.equals(this.tags, environment.tags) && Objects.equals(this.requireComments, environment.requireComments) && Objects.equals(this.confirmChanges, environment.confirmChanges) && Objects.equals(this.approvalSettings, environment.approvalSettings);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.id, this.key, this.name, this.apiKey, this.mobileKey, this.color, this.defaultTtl, this.secureMode, this.defaultTrackEvents, this.tags, this.requireComments, this.confirmChanges, this.approvalSettings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Environment {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    apiKey: ").append(this.toIndentedString(this.apiKey)).append("\n");
        sb.append("    mobileKey: ").append(this.toIndentedString(this.mobileKey)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    defaultTtl: ").append(this.toIndentedString(this.defaultTtl)).append("\n");
        sb.append("    secureMode: ").append(this.toIndentedString(this.secureMode)).append("\n");
        sb.append("    defaultTrackEvents: ").append(this.toIndentedString(this.defaultTrackEvents)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    requireComments: ").append(this.toIndentedString(this.requireComments)).append("\n");
        sb.append("    confirmChanges: ").append(this.toIndentedString(this.confirmChanges)).append("\n");
        sb.append("    approvalSettings: ").append(this.toIndentedString(this.approvalSettings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

