/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Approval settings for an environment. Only appears if the approvals feature is enabled.")
public class EnvironmentApprovalSettings {
    @SerializedName(value="serviceKind")
    private ServiceKindEnum serviceKind = null;
    @SerializedName(value="required")
    private Boolean required = null;
    @SerializedName(value="canReviewOwnRequest")
    private Boolean canReviewOwnRequest = null;
    @SerializedName(value="minNumApprovals")
    private Long minNumApprovals = null;
    @SerializedName(value="canApplyDeclinedChanges")
    private Boolean canApplyDeclinedChanges = null;
    @SerializedName(value="requiredApprovalTags")
    private List<String> requiredApprovalTags = null;

    public EnvironmentApprovalSettings serviceKind(ServiceKindEnum serviceKind) {
        this.serviceKind = serviceKind;
        return this;
    }

    @ApiModelProperty(value="The approvals system used.")
    public ServiceKindEnum getServiceKind() {
        return this.serviceKind;
    }

    public void setServiceKind(ServiceKindEnum serviceKind) {
        this.serviceKind = serviceKind;
    }

    public EnvironmentApprovalSettings required(Boolean required) {
        this.required = required;
        return this;
    }

    @ApiModelProperty(value="Whether any changes to flags in this environment will require approval. You may only set required or requiredApprovalTags, not both.")
    public Boolean isRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public EnvironmentApprovalSettings canReviewOwnRequest(Boolean canReviewOwnRequest) {
        this.canReviewOwnRequest = canReviewOwnRequest;
        return this;
    }

    @ApiModelProperty(value="Whether requesters can approve or decline their own request. They may always comment.")
    public Boolean isCanReviewOwnRequest() {
        return this.canReviewOwnRequest;
    }

    public void setCanReviewOwnRequest(Boolean canReviewOwnRequest) {
        this.canReviewOwnRequest = canReviewOwnRequest;
    }

    public EnvironmentApprovalSettings minNumApprovals(Long minNumApprovals) {
        this.minNumApprovals = minNumApprovals;
        return this;
    }

    @ApiModelProperty(example="2", value="The number of approvals required before an approval request can be applied.")
    public Long getMinNumApprovals() {
        return this.minNumApprovals;
    }

    public void setMinNumApprovals(Long minNumApprovals) {
        this.minNumApprovals = minNumApprovals;
    }

    public EnvironmentApprovalSettings canApplyDeclinedChanges(Boolean canApplyDeclinedChanges) {
        this.canApplyDeclinedChanges = canApplyDeclinedChanges;
        return this;
    }

    @ApiModelProperty(value="Whether changes can be applied as long as minNumApprovals is met, regardless of if any reviewers have declined a request.")
    public Boolean isCanApplyDeclinedChanges() {
        return this.canApplyDeclinedChanges;
    }

    public void setCanApplyDeclinedChanges(Boolean canApplyDeclinedChanges) {
        this.canApplyDeclinedChanges = canApplyDeclinedChanges;
    }

    public EnvironmentApprovalSettings requiredApprovalTags(List<String> requiredApprovalTags) {
        this.requiredApprovalTags = requiredApprovalTags;
        return this;
    }

    public EnvironmentApprovalSettings addRequiredApprovalTagsItem(String requiredApprovalTagsItem) {
        if (this.requiredApprovalTags == null) {
            this.requiredApprovalTags = new ArrayList<String>();
        }
        this.requiredApprovalTags.add(requiredApprovalTagsItem);
        return this;
    }

    @ApiModelProperty(value="An array of tags used to specify which flags with those tags require approval. You may only set requiredApprovalTags or required, not both.")
    public List<String> getRequiredApprovalTags() {
        return this.requiredApprovalTags;
    }

    public void setRequiredApprovalTags(List<String> requiredApprovalTags) {
        this.requiredApprovalTags = requiredApprovalTags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvironmentApprovalSettings environmentApprovalSettings = (EnvironmentApprovalSettings)o;
        return Objects.equals((Object)this.serviceKind, (Object)environmentApprovalSettings.serviceKind) && Objects.equals(this.required, environmentApprovalSettings.required) && Objects.equals(this.canReviewOwnRequest, environmentApprovalSettings.canReviewOwnRequest) && Objects.equals(this.minNumApprovals, environmentApprovalSettings.minNumApprovals) && Objects.equals(this.canApplyDeclinedChanges, environmentApprovalSettings.canApplyDeclinedChanges) && Objects.equals(this.requiredApprovalTags, environmentApprovalSettings.requiredApprovalTags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.serviceKind, this.required, this.canReviewOwnRequest, this.minNumApprovals, this.canApplyDeclinedChanges, this.requiredApprovalTags});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnvironmentApprovalSettings {\n");
        sb.append("    serviceKind: ").append(this.toIndentedString((Object)this.serviceKind)).append("\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("    canReviewOwnRequest: ").append(this.toIndentedString(this.canReviewOwnRequest)).append("\n");
        sb.append("    minNumApprovals: ").append(this.toIndentedString(this.minNumApprovals)).append("\n");
        sb.append("    canApplyDeclinedChanges: ").append(this.toIndentedString(this.canApplyDeclinedChanges)).append("\n");
        sb.append("    requiredApprovalTags: ").append(this.toIndentedString(this.requiredApprovalTags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ServiceKindEnum {
        LAUNCHDARKLY("launchdarkly"),
        SERVICE_NOW("service-now");

        private String value;

        private ServiceKindEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ServiceKindEnum fromValue(String text) {
            for (ServiceKindEnum b : ServiceKindEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ServiceKindEnum> {
            public void write(JsonWriter jsonWriter, ServiceKindEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ServiceKindEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ServiceKindEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

