/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class EnvironmentPost {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="key")
    private String key = null;
    @SerializedName(value="color")
    private String color = null;
    @SerializedName(value="defaultTtl")
    private BigDecimal defaultTtl = null;
    @SerializedName(value="secureMode")
    private Boolean secureMode = null;
    @SerializedName(value="defaultTrackEvents")
    private Boolean defaultTrackEvents = null;
    @SerializedName(value="tags")
    private List<String> tags = null;
    @SerializedName(value="requireComments")
    private Boolean requireComments = null;
    @SerializedName(value="confirmChanges")
    private Boolean confirmChanges = null;

    public EnvironmentPost name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Development", required=true, value="The name of the new environment.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EnvironmentPost key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(example="dev", required=true, value="A project-unique key for the new environment.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public EnvironmentPost color(String color) {
        this.color = color;
        return this;
    }

    @ApiModelProperty(example="417505", required=true, value="A color swatch (as an RGB hex value with no leading '#', e.g. C8C8C8).")
    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public EnvironmentPost defaultTtl(BigDecimal defaultTtl) {
        this.defaultTtl = defaultTtl;
        return this;
    }

    @ApiModelProperty(example="0.0", value="The default TTL for the new environment.")
    public BigDecimal getDefaultTtl() {
        return this.defaultTtl;
    }

    public void setDefaultTtl(BigDecimal defaultTtl) {
        this.defaultTtl = defaultTtl;
    }

    public EnvironmentPost secureMode(Boolean secureMode) {
        this.secureMode = secureMode;
        return this;
    }

    @ApiModelProperty(example="false", value="Determines whether the environment is in secure mode.")
    public Boolean isSecureMode() {
        return this.secureMode;
    }

    public void setSecureMode(Boolean secureMode) {
        this.secureMode = secureMode;
    }

    public EnvironmentPost defaultTrackEvents(Boolean defaultTrackEvents) {
        this.defaultTrackEvents = defaultTrackEvents;
        return this;
    }

    @ApiModelProperty(example="false", value="Set to true to send detailed event information for newly created flags.")
    public Boolean isDefaultTrackEvents() {
        return this.defaultTrackEvents;
    }

    public void setDefaultTrackEvents(Boolean defaultTrackEvents) {
        this.defaultTrackEvents = defaultTrackEvents;
    }

    public EnvironmentPost tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public EnvironmentPost addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(example="[\"tag1\",\"tag2\"]", value="An array of tags for this environment.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public EnvironmentPost requireComments(Boolean requireComments) {
        this.requireComments = requireComments;
        return this;
    }

    @ApiModelProperty(example="false", value="Determines if this environment requires comments for flag and segment changes.")
    public Boolean isRequireComments() {
        return this.requireComments;
    }

    public void setRequireComments(Boolean requireComments) {
        this.requireComments = requireComments;
    }

    public EnvironmentPost confirmChanges(Boolean confirmChanges) {
        this.confirmChanges = confirmChanges;
        return this;
    }

    @ApiModelProperty(example="false", value="Determines if this environment requires confirmation for flag and segment changes.")
    public Boolean isConfirmChanges() {
        return this.confirmChanges;
    }

    public void setConfirmChanges(Boolean confirmChanges) {
        this.confirmChanges = confirmChanges;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnvironmentPost environmentPost = (EnvironmentPost)o;
        return Objects.equals(this.name, environmentPost.name) && Objects.equals(this.key, environmentPost.key) && Objects.equals(this.color, environmentPost.color) && Objects.equals(this.defaultTtl, environmentPost.defaultTtl) && Objects.equals(this.secureMode, environmentPost.secureMode) && Objects.equals(this.defaultTrackEvents, environmentPost.defaultTrackEvents) && Objects.equals(this.tags, environmentPost.tags) && Objects.equals(this.requireComments, environmentPost.requireComments) && Objects.equals(this.confirmChanges, environmentPost.confirmChanges);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.key, this.color, this.defaultTtl, this.secureMode, this.defaultTrackEvents, this.tags, this.requireComments, this.confirmChanges);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EnvironmentPost {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    defaultTtl: ").append(this.toIndentedString(this.defaultTtl)).append("\n");
        sb.append("    secureMode: ").append(this.toIndentedString(this.secureMode)).append("\n");
        sb.append("    defaultTrackEvents: ").append(this.toIndentedString(this.defaultTrackEvents)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    requireComments: ").append(this.toIndentedString(this.requireComments)).append("\n");
        sb.append("    confirmChanges: ").append(this.toIndentedString(this.confirmChanges)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

