/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.annotations.SerializedName;
import com.launchdarkly.api.model.ClientSideAvailability;
import com.launchdarkly.api.model.CustomProperty;
import com.launchdarkly.api.model.Defaults;
import com.launchdarkly.api.model.FeatureFlagConfig;
import com.launchdarkly.api.model.Links;
import com.launchdarkly.api.model.Member;
import com.launchdarkly.api.model.Variation;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FeatureFlag {
    @SerializedName(value="key")
    private String key = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="creationDate")
    private Long creationDate = null;
    @SerializedName(value="includeInSnippet")
    private Boolean includeInSnippet = null;
    @SerializedName(value="temporary")
    private Boolean temporary = null;
    @SerializedName(value="maintainerId")
    private String maintainerId = null;
    @SerializedName(value="tags")
    private List<String> tags = null;
    @SerializedName(value="variations")
    private List<Variation> variations = null;
    @SerializedName(value="goalIds")
    private List<String> goalIds = null;
    @SerializedName(value="_version")
    private Integer version = null;
    @SerializedName(value="customProperties")
    private Map<String, CustomProperty> customProperties = null;
    @SerializedName(value="_links")
    private Links links = null;
    @SerializedName(value="_maintainer")
    private Member maintainer = null;
    @SerializedName(value="environments")
    private Map<String, FeatureFlagConfig> environments = null;
    @SerializedName(value="archivedDate")
    private Long archivedDate = null;
    @SerializedName(value="archived")
    private Boolean archived = null;
    @SerializedName(value="clientSideAvailability")
    private ClientSideAvailability clientSideAvailability = null;
    @SerializedName(value="defaults")
    private Defaults defaults = null;

    public FeatureFlag key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(example="test-feature", value="")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public FeatureFlag name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Test Feature", value="Name of the feature flag.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FeatureFlag description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="This flag controls whether test feature is turned on or not.", value="Description of the feature flag.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FeatureFlag kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(example="boolean", value="Whether the feature flag is a boolean flag or multivariate.")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public FeatureFlag creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(example="1443652232590", value="A unix epoch time in milliseconds specifying the creation time of this flag.")
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public FeatureFlag includeInSnippet(Boolean includeInSnippet) {
        this.includeInSnippet = includeInSnippet;
        return this;
    }

    @ApiModelProperty(example="false", value="")
    public Boolean isIncludeInSnippet() {
        return this.includeInSnippet;
    }

    public void setIncludeInSnippet(Boolean includeInSnippet) {
        this.includeInSnippet = includeInSnippet;
    }

    public FeatureFlag temporary(Boolean temporary) {
        this.temporary = temporary;
        return this;
    }

    @ApiModelProperty(example="false", value="Whether or not this flag is temporary.")
    public Boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(Boolean temporary) {
        this.temporary = temporary;
    }

    public FeatureFlag maintainerId(String maintainerId) {
        this.maintainerId = maintainerId;
        return this;
    }

    @ApiModelProperty(example="561c579cd8fd5c2704000001", value="The ID of the member that should maintain this flag.")
    public String getMaintainerId() {
        return this.maintainerId;
    }

    public void setMaintainerId(String maintainerId) {
        this.maintainerId = maintainerId;
    }

    public FeatureFlag tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public FeatureFlag addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(example="[]", value="An array of tags for this feature flag.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public FeatureFlag variations(List<Variation> variations) {
        this.variations = variations;
        return this;
    }

    public FeatureFlag addVariationsItem(Variation variationsItem) {
        if (this.variations == null) {
            this.variations = new ArrayList<Variation>();
        }
        this.variations.add(variationsItem);
        return this;
    }

    @ApiModelProperty(example="[{\"value\":\"a\"},{\"value\":\"b\"}]", value="The variations for this feature flag.")
    public List<Variation> getVariations() {
        return this.variations;
    }

    public void setVariations(List<Variation> variations) {
        this.variations = variations;
    }

    public FeatureFlag goalIds(List<String> goalIds) {
        this.goalIds = goalIds;
        return this;
    }

    public FeatureFlag addGoalIdsItem(String goalIdsItem) {
        if (this.goalIds == null) {
            this.goalIds = new ArrayList<String>();
        }
        this.goalIds.add(goalIdsItem);
        return this;
    }

    @ApiModelProperty(example="[\"d7239405bd89c930e885aa76\",\"405bc930e88d7239d895aa76\"]", value="An array goals from all environments associated with this feature flag")
    public List<String> getGoalIds() {
        return this.goalIds;
    }

    public void setGoalIds(List<String> goalIds) {
        this.goalIds = goalIds;
    }

    public FeatureFlag version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="23", value="")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public FeatureFlag customProperties(Map<String, CustomProperty> customProperties) {
        this.customProperties = customProperties;
        return this;
    }

    public FeatureFlag putCustomPropertiesItem(String key, CustomProperty customPropertiesItem) {
        if (this.customProperties == null) {
            this.customProperties = new HashMap<String, CustomProperty>();
        }
        this.customProperties.put(key, customPropertiesItem);
        return this;
    }

    @ApiModelProperty(example="{\"bugs\":{\"name\":\"Issue tracker ids\",\"value\":[\"123\",\"456\"]},\"deprecated\":{\"name\":\"Deprecated Date\",\"value\":[]}}", value="A mapping of keys to CustomProperty entries.")
    public Map<String, CustomProperty> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(Map<String, CustomProperty> customProperties) {
        this.customProperties = customProperties;
    }

    public FeatureFlag links(Links links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public Links getLinks() {
        return this.links;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    public FeatureFlag maintainer(Member maintainer) {
        this.maintainer = maintainer;
        return this;
    }

    @ApiModelProperty(value="")
    public Member getMaintainer() {
        return this.maintainer;
    }

    public void setMaintainer(Member maintainer) {
        this.maintainer = maintainer;
    }

    public FeatureFlag environments(Map<String, FeatureFlagConfig> environments) {
        this.environments = environments;
        return this;
    }

    public FeatureFlag putEnvironmentsItem(String key, FeatureFlagConfig environmentsItem) {
        if (this.environments == null) {
            this.environments = new HashMap<String, FeatureFlagConfig>();
        }
        this.environments.put(key, environmentsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public Map<String, FeatureFlagConfig> getEnvironments() {
        return this.environments;
    }

    public void setEnvironments(Map<String, FeatureFlagConfig> environments) {
        this.environments = environments;
    }

    public FeatureFlag archivedDate(Long archivedDate) {
        this.archivedDate = archivedDate;
        return this;
    }

    @ApiModelProperty(example="1443652232590", value="A unix epoch time in milliseconds specifying the archived time of this flag.")
    public Long getArchivedDate() {
        return this.archivedDate;
    }

    public void setArchivedDate(Long archivedDate) {
        this.archivedDate = archivedDate;
    }

    public FeatureFlag archived(Boolean archived) {
        this.archived = archived;
        return this;
    }

    @ApiModelProperty(example="false", value="Whether or not this flag is archived.")
    public Boolean isArchived() {
        return this.archived;
    }

    public void setArchived(Boolean archived) {
        this.archived = archived;
    }

    public FeatureFlag clientSideAvailability(ClientSideAvailability clientSideAvailability) {
        this.clientSideAvailability = clientSideAvailability;
        return this;
    }

    @ApiModelProperty(value="")
    public ClientSideAvailability getClientSideAvailability() {
        return this.clientSideAvailability;
    }

    public void setClientSideAvailability(ClientSideAvailability clientSideAvailability) {
        this.clientSideAvailability = clientSideAvailability;
    }

    public FeatureFlag defaults(Defaults defaults) {
        this.defaults = defaults;
        return this;
    }

    @ApiModelProperty(value="")
    public Defaults getDefaults() {
        return this.defaults;
    }

    public void setDefaults(Defaults defaults) {
        this.defaults = defaults;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureFlag featureFlag = (FeatureFlag)o;
        return Objects.equals(this.key, featureFlag.key) && Objects.equals(this.name, featureFlag.name) && Objects.equals(this.description, featureFlag.description) && Objects.equals(this.kind, featureFlag.kind) && Objects.equals(this.creationDate, featureFlag.creationDate) && Objects.equals(this.includeInSnippet, featureFlag.includeInSnippet) && Objects.equals(this.temporary, featureFlag.temporary) && Objects.equals(this.maintainerId, featureFlag.maintainerId) && Objects.equals(this.tags, featureFlag.tags) && Objects.equals(this.variations, featureFlag.variations) && Objects.equals(this.goalIds, featureFlag.goalIds) && Objects.equals(this.version, featureFlag.version) && Objects.equals(this.customProperties, featureFlag.customProperties) && Objects.equals(this.links, featureFlag.links) && Objects.equals(this.maintainer, featureFlag.maintainer) && Objects.equals(this.environments, featureFlag.environments) && Objects.equals(this.archivedDate, featureFlag.archivedDate) && Objects.equals(this.archived, featureFlag.archived) && Objects.equals(this.clientSideAvailability, featureFlag.clientSideAvailability) && Objects.equals(this.defaults, featureFlag.defaults);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.name, this.description, this.kind, this.creationDate, this.includeInSnippet, this.temporary, this.maintainerId, this.tags, this.variations, this.goalIds, this.version, this.customProperties, this.links, this.maintainer, this.environments, this.archivedDate, this.archived, this.clientSideAvailability, this.defaults);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureFlag {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    includeInSnippet: ").append(this.toIndentedString(this.includeInSnippet)).append("\n");
        sb.append("    temporary: ").append(this.toIndentedString(this.temporary)).append("\n");
        sb.append("    maintainerId: ").append(this.toIndentedString(this.maintainerId)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    variations: ").append(this.toIndentedString(this.variations)).append("\n");
        sb.append("    goalIds: ").append(this.toIndentedString(this.goalIds)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    customProperties: ").append(this.toIndentedString(this.customProperties)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    maintainer: ").append(this.toIndentedString(this.maintainer)).append("\n");
        sb.append("    environments: ").append(this.toIndentedString(this.environments)).append("\n");
        sb.append("    archivedDate: ").append(this.toIndentedString(this.archivedDate)).append("\n");
        sb.append("    archived: ").append(this.toIndentedString(this.archived)).append("\n");
        sb.append("    clientSideAvailability: ").append(this.toIndentedString(this.clientSideAvailability)).append("\n");
        sb.append("    defaults: ").append(this.toIndentedString(this.defaults)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

