/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.annotations.SerializedName;
import com.launchdarkly.api.model.CopyActions;
import com.launchdarkly.api.model.FeatureFlagCopyObject;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FeatureFlagCopyBody {
    @SerializedName(value="source")
    private FeatureFlagCopyObject source = null;
    @SerializedName(value="target")
    private FeatureFlagCopyObject target = null;
    @SerializedName(value="comment")
    private String comment = null;
    @SerializedName(value="includedActions")
    private List<CopyActions> includedActions = null;
    @SerializedName(value="excludedActions")
    private List<CopyActions> excludedActions = null;

    public FeatureFlagCopyBody source(FeatureFlagCopyObject source) {
        this.source = source;
        return this;
    }

    @ApiModelProperty(value="")
    public FeatureFlagCopyObject getSource() {
        return this.source;
    }

    public void setSource(FeatureFlagCopyObject source) {
        this.source = source;
    }

    public FeatureFlagCopyBody target(FeatureFlagCopyObject target) {
        this.target = target;
        return this;
    }

    @ApiModelProperty(value="")
    public FeatureFlagCopyObject getTarget() {
        return this.target;
    }

    public void setTarget(FeatureFlagCopyObject target) {
        this.target = target;
    }

    public FeatureFlagCopyBody comment(String comment) {
        this.comment = comment;
        return this;
    }

    @ApiModelProperty(example="This is a comment string", value="comment will be included in audit log item for change.")
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public FeatureFlagCopyBody includedActions(List<CopyActions> includedActions) {
        this.includedActions = includedActions;
        return this;
    }

    public FeatureFlagCopyBody addIncludedActionsItem(CopyActions includedActionsItem) {
        if (this.includedActions == null) {
            this.includedActions = new ArrayList<CopyActions>();
        }
        this.includedActions.add(includedActionsItem);
        return this;
    }

    @ApiModelProperty(value="Define the parts of the flag configuration that will be copied.")
    public List<CopyActions> getIncludedActions() {
        return this.includedActions;
    }

    public void setIncludedActions(List<CopyActions> includedActions) {
        this.includedActions = includedActions;
    }

    public FeatureFlagCopyBody excludedActions(List<CopyActions> excludedActions) {
        this.excludedActions = excludedActions;
        return this;
    }

    public FeatureFlagCopyBody addExcludedActionsItem(CopyActions excludedActionsItem) {
        if (this.excludedActions == null) {
            this.excludedActions = new ArrayList<CopyActions>();
        }
        this.excludedActions.add(excludedActionsItem);
        return this;
    }

    @ApiModelProperty(value="Define the parts of the flag configuration that will not be copied.")
    public List<CopyActions> getExcludedActions() {
        return this.excludedActions;
    }

    public void setExcludedActions(List<CopyActions> excludedActions) {
        this.excludedActions = excludedActions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureFlagCopyBody featureFlagCopyBody = (FeatureFlagCopyBody)o;
        return Objects.equals(this.source, featureFlagCopyBody.source) && Objects.equals(this.target, featureFlagCopyBody.target) && Objects.equals(this.comment, featureFlagCopyBody.comment) && Objects.equals(this.includedActions, featureFlagCopyBody.includedActions) && Objects.equals(this.excludedActions, featureFlagCopyBody.excludedActions);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.target, this.comment, this.includedActions, this.excludedActions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FeatureFlagCopyBody {\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    comment: ").append(this.toIndentedString(this.comment)).append("\n");
        sb.append("    includedActions: ").append(this.toIndentedString(this.includedActions)).append("\n");
        sb.append("    excludedActions: ").append(this.toIndentedString(this.excludedActions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

