/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.annotations.SerializedName;
import com.launchdarkly.api.model.HierarchicalLinks;
import com.launchdarkly.api.model.IntegrationSubscriptionStatus;
import com.launchdarkly.api.model.Statement;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class IntegrationSubscription {
    @SerializedName(value="_links")
    private HierarchicalLinks links = null;
    @SerializedName(value="_id")
    private String id = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="config")
    private Object config = null;
    @SerializedName(value="statements")
    private List<Statement> statements = null;
    @SerializedName(value="on")
    private Boolean on = null;
    @SerializedName(value="tags")
    private List<String> tags = null;
    @SerializedName(value="_status")
    private IntegrationSubscriptionStatus status = null;

    public IntegrationSubscription links(HierarchicalLinks links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public HierarchicalLinks getLinks() {
        return this.links;
    }

    public void setLinks(HierarchicalLinks links) {
        this.links = links;
    }

    public IntegrationSubscription id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public IntegrationSubscription kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(example="datadog", value="The type of integration associated with this configuration.")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public IntegrationSubscription name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="V2", value="The user-defined name associated with this configuration.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IntegrationSubscription config(Object config) {
        this.config = config;
        return this;
    }

    @ApiModelProperty(example="{\"apiKey\":\"582**************************116\",\"hostURL\":\"https://api.datadoghq.com\"}", value="A key-value mapping of configuration fields.")
    public Object getConfig() {
        return this.config;
    }

    public void setConfig(Object config) {
        this.config = config;
    }

    public IntegrationSubscription statements(List<Statement> statements) {
        this.statements = statements;
        return this;
    }

    public IntegrationSubscription addStatementsItem(Statement statementsItem) {
        if (this.statements == null) {
            this.statements = new ArrayList<Statement>();
        }
        this.statements.add(statementsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Statement> getStatements() {
        return this.statements;
    }

    public void setStatements(List<Statement> statements) {
        this.statements = statements;
    }

    public IntegrationSubscription on(Boolean on) {
        this.on = on;
        return this;
    }

    @ApiModelProperty(example="true", value="Whether or not the integration is currently active.")
    public Boolean isOn() {
        return this.on;
    }

    public void setOn(Boolean on) {
        this.on = on;
    }

    public IntegrationSubscription tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public IntegrationSubscription addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(value="An array of tags for this integration configuration.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public IntegrationSubscription status(IntegrationSubscriptionStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="")
    public IntegrationSubscriptionStatus getStatus() {
        return this.status;
    }

    public void setStatus(IntegrationSubscriptionStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegrationSubscription integrationSubscription = (IntegrationSubscription)o;
        return Objects.equals(this.links, integrationSubscription.links) && Objects.equals(this.id, integrationSubscription.id) && Objects.equals(this.kind, integrationSubscription.kind) && Objects.equals(this.name, integrationSubscription.name) && Objects.equals(this.config, integrationSubscription.config) && Objects.equals(this.statements, integrationSubscription.statements) && Objects.equals(this.on, integrationSubscription.on) && Objects.equals(this.tags, integrationSubscription.tags) && Objects.equals(this.status, integrationSubscription.status);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.id, this.kind, this.name, this.config, this.statements, this.on, this.tags, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IntegrationSubscription {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    statements: ").append(this.toIndentedString(this.statements)).append("\n");
        sb.append("    on: ").append(this.toIndentedString(this.on)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

