/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Policy {
    @SerializedName(value="resources")
    private List<String> resources = null;
    @SerializedName(value="notResources")
    private List<String> notResources = null;
    @SerializedName(value="actions")
    private List<String> actions = null;
    @SerializedName(value="notActions")
    private List<String> notActions = null;
    @SerializedName(value="effect")
    private String effect = null;

    public Policy resources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    public Policy addResourcesItem(String resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public Policy notResources(List<String> notResources) {
        this.notResources = notResources;
        return this;
    }

    public Policy addNotResourcesItem(String notResourcesItem) {
        if (this.notResources == null) {
            this.notResources = new ArrayList<String>();
        }
        this.notResources.add(notResourcesItem);
        return this;
    }

    @ApiModelProperty(value="Targeted resource will be those resources NOT in this list. The \"resources`\" field must be empty to use this field.")
    public List<String> getNotResources() {
        return this.notResources;
    }

    public void setNotResources(List<String> notResources) {
        this.notResources = notResources;
    }

    public Policy actions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    public Policy addActionsItem(String actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<String>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public Policy notActions(List<String> notActions) {
        this.notActions = notActions;
        return this;
    }

    public Policy addNotActionsItem(String notActionsItem) {
        if (this.notActions == null) {
            this.notActions = new ArrayList<String>();
        }
        this.notActions.add(notActionsItem);
        return this;
    }

    @ApiModelProperty(value="Targeted actions will be those actions NOT in this list. The \"actions\" field must be empty to use this field.")
    public List<String> getNotActions() {
        return this.notActions;
    }

    public void setNotActions(List<String> notActions) {
        this.notActions = notActions;
    }

    public Policy effect(String effect) {
        this.effect = effect;
        return this;
    }

    @ApiModelProperty(example="deny", value="Effect of the policy - allow or deny.")
    public String getEffect() {
        return this.effect;
    }

    public void setEffect(String effect) {
        this.effect = effect;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Policy policy = (Policy)o;
        return Objects.equals(this.resources, policy.resources) && Objects.equals(this.notResources, policy.notResources) && Objects.equals(this.actions, policy.actions) && Objects.equals(this.notActions, policy.notActions) && Objects.equals(this.effect, policy.effect);
    }

    public int hashCode() {
        return Objects.hash(this.resources, this.notResources, this.actions, this.notActions, this.effect);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Policy {\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    notResources: ").append(this.toIndentedString(this.notResources)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    notActions: ").append(this.toIndentedString(this.notActions)).append("\n");
        sb.append("    effect: ").append(this.toIndentedString(this.effect)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

