/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.annotations.SerializedName;
import com.launchdarkly.api.model.Member;
import com.launchdarkly.api.model.Policy;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class RelayProxyConfig {
    @SerializedName(value="_id")
    private String id = null;
    @SerializedName(value="_creator")
    private Member creator = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="policy")
    private List<Policy> policy = new ArrayList<Policy>();
    @SerializedName(value="fullKey")
    private String fullKey = null;
    @SerializedName(value="displayKey")
    private String displayKey = null;
    @SerializedName(value="creationDate")
    private Long creationDate = null;
    @SerializedName(value="lastModified")
    private Long lastModified = null;

    public RelayProxyConfig id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public RelayProxyConfig creator(Member creator) {
        this.creator = creator;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Member getCreator() {
        return this.creator;
    }

    public void setCreator(Member creator) {
        this.creator = creator;
    }

    public RelayProxyConfig name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="My relay proxy config", required=true, value="A human-friendly name for the relay proxy configuration")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RelayProxyConfig policy(List<Policy> policy) {
        this.policy = policy;
        return this;
    }

    public RelayProxyConfig addPolicyItem(Policy policyItem) {
        this.policy.add(policyItem);
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public List<Policy> getPolicy() {
        return this.policy;
    }

    public void setPolicy(List<Policy> policy) {
        this.policy = policy;
    }

    public RelayProxyConfig fullKey(String fullKey) {
        this.fullKey = fullKey;
        return this;
    }

    @ApiModelProperty(example="rel-8a3a773d-b75e-48eb-a850-492cda9266eo", value="Full secret key. Only included if creating or resetting the relay proxy configuration")
    public String getFullKey() {
        return this.fullKey;
    }

    public void setFullKey(String fullKey) {
        this.fullKey = fullKey;
    }

    public RelayProxyConfig displayKey(String displayKey) {
        this.displayKey = displayKey;
        return this;
    }

    @ApiModelProperty(example="66eo", required=true, value="The last 4 digits of the unique secret key for this relay proxy configuration")
    public String getDisplayKey() {
        return this.displayKey;
    }

    public void setDisplayKey(String displayKey) {
        this.displayKey = displayKey;
    }

    public RelayProxyConfig creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(example="1443652232590", required=true, value="A unix epoch time in milliseconds specifying the creation time of this relay proxy configuration")
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public RelayProxyConfig lastModified(Long lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @ApiModelProperty(example="1469326565348", required=true, value="A unix epoch time in milliseconds specifying the last time this relay proxy configuration was modified")
    public Long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelayProxyConfig relayProxyConfig = (RelayProxyConfig)o;
        return Objects.equals(this.id, relayProxyConfig.id) && Objects.equals(this.creator, relayProxyConfig.creator) && Objects.equals(this.name, relayProxyConfig.name) && Objects.equals(this.policy, relayProxyConfig.policy) && Objects.equals(this.fullKey, relayProxyConfig.fullKey) && Objects.equals(this.displayKey, relayProxyConfig.displayKey) && Objects.equals(this.creationDate, relayProxyConfig.creationDate) && Objects.equals(this.lastModified, relayProxyConfig.lastModified);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.creator, this.name, this.policy, this.fullKey, this.displayKey, this.creationDate, this.lastModified);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RelayProxyConfig {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    policy: ").append(this.toIndentedString(this.policy)).append("\n");
        sb.append("    fullKey: ").append(this.toIndentedString(this.fullKey)).append("\n");
        sb.append("    displayKey: ").append(this.toIndentedString(this.displayKey)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    lastModified: ").append(this.toIndentedString(this.lastModified)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

