/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Statement {
    @SerializedName(value="resources")
    private List<String> resources = null;
    @SerializedName(value="notResources")
    private List<String> notResources = null;
    @SerializedName(value="actions")
    private List<String> actions = null;
    @SerializedName(value="notActions")
    private List<String> notActions = null;
    @SerializedName(value="effect")
    private EffectEnum effect = null;

    public Statement resources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    public Statement addResourcesItem(String resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public Statement notResources(List<String> notResources) {
        this.notResources = notResources;
        return this;
    }

    public Statement addNotResourcesItem(String notResourcesItem) {
        if (this.notResources == null) {
            this.notResources = new ArrayList<String>();
        }
        this.notResources.add(notResourcesItem);
        return this;
    }

    @ApiModelProperty(value="Targeted resource will be those resources NOT in this list. The \"resources`\" field must be empty to use this field.")
    public List<String> getNotResources() {
        return this.notResources;
    }

    public void setNotResources(List<String> notResources) {
        this.notResources = notResources;
    }

    public Statement actions(List<String> actions) {
        this.actions = actions;
        return this;
    }

    public Statement addActionsItem(String actionsItem) {
        if (this.actions == null) {
            this.actions = new ArrayList<String>();
        }
        this.actions.add(actionsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    public Statement notActions(List<String> notActions) {
        this.notActions = notActions;
        return this;
    }

    public Statement addNotActionsItem(String notActionsItem) {
        if (this.notActions == null) {
            this.notActions = new ArrayList<String>();
        }
        this.notActions.add(notActionsItem);
        return this;
    }

    @ApiModelProperty(value="Targeted actions will be those actions NOT in this list. The \"actions\" field must be empty to use this field.")
    public List<String> getNotActions() {
        return this.notActions;
    }

    public void setNotActions(List<String> notActions) {
        this.notActions = notActions;
    }

    public Statement effect(EffectEnum effect) {
        this.effect = effect;
        return this;
    }

    @ApiModelProperty(value="")
    public EffectEnum getEffect() {
        return this.effect;
    }

    public void setEffect(EffectEnum effect) {
        this.effect = effect;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Statement statement = (Statement)o;
        return Objects.equals(this.resources, statement.resources) && Objects.equals(this.notResources, statement.notResources) && Objects.equals(this.actions, statement.actions) && Objects.equals(this.notActions, statement.notActions) && Objects.equals((Object)this.effect, (Object)statement.effect);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resources, this.notResources, this.actions, this.notActions, this.effect});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Statement {\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    notResources: ").append(this.toIndentedString(this.notResources)).append("\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    notActions: ").append(this.toIndentedString(this.notActions)).append("\n");
        sb.append("    effect: ").append(this.toIndentedString((Object)this.effect)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EffectEnum {
        ALLOW("allow"),
        DENY("deny");

        private String value;

        private EffectEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EffectEnum fromValue(String text) {
            for (EffectEnum b : EffectEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<EffectEnum> {
            public void write(JsonWriter jsonWriter, EffectEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EffectEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EffectEnum.fromValue(String.valueOf(value));
            }
        }
    }
}

