/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.annotations.SerializedName;
import com.launchdarkly.api.model.Statement;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SubscriptionBody {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="statements")
    private List<Statement> statements = null;
    @SerializedName(value="config")
    private Object config = null;
    @SerializedName(value="on")
    private Boolean on = null;
    @SerializedName(value="tags")
    private List<String> tags = null;

    public SubscriptionBody name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Example Datadog Integration", required=true, value="A human-readable name for your subscription configuration.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public SubscriptionBody statements(List<Statement> statements) {
        this.statements = statements;
        return this;
    }

    public SubscriptionBody addStatementsItem(Statement statementsItem) {
        if (this.statements == null) {
            this.statements = new ArrayList<Statement>();
        }
        this.statements.add(statementsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Statement> getStatements() {
        return this.statements;
    }

    public void setStatements(List<Statement> statements) {
        this.statements = statements;
    }

    public SubscriptionBody config(Object config) {
        this.config = config;
        return this;
    }

    @ApiModelProperty(example="{\"apiKey\":\"582**************************116\",\"hostURL\":\"https://api.datadoghq.com\"}", required=true, value="Integration-specific configuration fields.")
    public Object getConfig() {
        return this.config;
    }

    public void setConfig(Object config) {
        this.config = config;
    }

    public SubscriptionBody on(Boolean on) {
        this.on = on;
        return this;
    }

    @ApiModelProperty(example="true", value="Whether the integration subscription is active or not.")
    public Boolean isOn() {
        return this.on;
    }

    public void setOn(Boolean on) {
        this.on = on;
    }

    public SubscriptionBody tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public SubscriptionBody addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(example="[]", value="Tags for the integration subscription.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionBody subscriptionBody = (SubscriptionBody)o;
        return Objects.equals(this.name, subscriptionBody.name) && Objects.equals(this.statements, subscriptionBody.statements) && Objects.equals(this.config, subscriptionBody.config) && Objects.equals(this.on, subscriptionBody.on) && Objects.equals(this.tags, subscriptionBody.tags);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.statements, this.config, this.on, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubscriptionBody {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    statements: ").append(this.toIndentedString(this.statements)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    on: ").append(this.toIndentedString(this.on)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

