/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.annotations.SerializedName;
import com.launchdarkly.api.model.Links;
import com.launchdarkly.api.model.Member;
import com.launchdarkly.api.model.Statement;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Token {
    @SerializedName(value="_links")
    private Links links = null;
    @SerializedName(value="_id")
    private String id = null;
    @SerializedName(value="ownerId")
    private String ownerId = null;
    @SerializedName(value="memberId")
    private String memberId = null;
    @SerializedName(value="_member")
    private Member member = null;
    @SerializedName(value="creationDate")
    private Long creationDate = null;
    @SerializedName(value="lastModified")
    private Long lastModified = null;
    @SerializedName(value="lastUsed")
    private Long lastUsed = null;
    @SerializedName(value="token")
    private String token = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="role")
    private String role = null;
    @SerializedName(value="customRoleIds")
    private List<String> customRoleIds = null;
    @SerializedName(value="inlineRole")
    private List<Statement> inlineRole = null;
    @SerializedName(value="serviceToken")
    private Boolean serviceToken = null;
    @SerializedName(value="defaultApiVersion")
    private Integer defaultApiVersion = null;

    public Token links(Links links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public Links getLinks() {
        return this.links;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    public Token id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Token ownerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public Token memberId(String memberId) {
        this.memberId = memberId;
        return this;
    }

    @ApiModelProperty(value="")
    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public Token member(Member member) {
        this.member = member;
        return this;
    }

    @ApiModelProperty(value="")
    public Member getMember() {
        return this.member;
    }

    public void setMember(Member member) {
        this.member = member;
    }

    public Token creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(example="1443652232590", value="A unix epoch time in milliseconds specifying the creation time of this access token.")
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public Token lastModified(Long lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    @ApiModelProperty(example="1469326565348", value="A unix epoch time in milliseconds specifying the last time this access token was modified.")
    public Long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Long lastModified) {
        this.lastModified = lastModified;
    }

    public Token lastUsed(Long lastUsed) {
        this.lastUsed = lastUsed;
        return this;
    }

    @ApiModelProperty(example="1469326565348", value="A unix epoch time in milliseconds specifying the last time this access token was used to authorize access to the LaunchDarkly REST API.")
    public Long getLastUsed() {
        return this.lastUsed;
    }

    public void setLastUsed(Long lastUsed) {
        this.lastUsed = lastUsed;
    }

    public Token token(String token) {
        this.token = token;
        return this;
    }

    @ApiModelProperty(example="3243", value="The last 4 digits of the unique secret key for this access token. If creating or resetting the token, this will be the full token secret.")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Token name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="My access token", value="A human-friendly name for the access token")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Token role(String role) {
        this.role = role;
        return this;
    }

    @ApiModelProperty(example="writer", value="The name of a built-in role for the token")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Token customRoleIds(List<String> customRoleIds) {
        this.customRoleIds = customRoleIds;
        return this;
    }

    public Token addCustomRoleIdsItem(String customRoleIdsItem) {
        if (this.customRoleIds == null) {
            this.customRoleIds = new ArrayList<String>();
        }
        this.customRoleIds.add(customRoleIdsItem);
        return this;
    }

    @ApiModelProperty(value="A list of custom role IDs to use as access limits for the access token")
    public List<String> getCustomRoleIds() {
        return this.customRoleIds;
    }

    public void setCustomRoleIds(List<String> customRoleIds) {
        this.customRoleIds = customRoleIds;
    }

    public Token inlineRole(List<Statement> inlineRole) {
        this.inlineRole = inlineRole;
        return this;
    }

    public Token addInlineRoleItem(Statement inlineRoleItem) {
        if (this.inlineRole == null) {
            this.inlineRole = new ArrayList<Statement>();
        }
        this.inlineRole.add(inlineRoleItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Statement> getInlineRole() {
        return this.inlineRole;
    }

    public void setInlineRole(List<Statement> inlineRole) {
        this.inlineRole = inlineRole;
    }

    public Token serviceToken(Boolean serviceToken) {
        this.serviceToken = serviceToken;
        return this;
    }

    @ApiModelProperty(value="Whether the token will be a service token https://docs.launchdarkly.com/home/account-security/api-access-tokens#service-tokens")
    public Boolean isServiceToken() {
        return this.serviceToken;
    }

    public void setServiceToken(Boolean serviceToken) {
        this.serviceToken = serviceToken;
    }

    public Token defaultApiVersion(Integer defaultApiVersion) {
        this.defaultApiVersion = defaultApiVersion;
        return this;
    }

    @ApiModelProperty(value="The default API version for this token")
    public Integer getDefaultApiVersion() {
        return this.defaultApiVersion;
    }

    public void setDefaultApiVersion(Integer defaultApiVersion) {
        this.defaultApiVersion = defaultApiVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        return Objects.equals(this.links, token.links) && Objects.equals(this.id, token.id) && Objects.equals(this.ownerId, token.ownerId) && Objects.equals(this.memberId, token.memberId) && Objects.equals(this.member, token.member) && Objects.equals(this.creationDate, token.creationDate) && Objects.equals(this.lastModified, token.lastModified) && Objects.equals(this.lastUsed, token.lastUsed) && Objects.equals(this.token, token.token) && Objects.equals(this.name, token.name) && Objects.equals(this.role, token.role) && Objects.equals(this.customRoleIds, token.customRoleIds) && Objects.equals(this.inlineRole, token.inlineRole) && Objects.equals(this.serviceToken, token.serviceToken) && Objects.equals(this.defaultApiVersion, token.defaultApiVersion);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.id, this.ownerId, this.memberId, this.member, this.creationDate, this.lastModified, this.lastUsed, this.token, this.name, this.role, this.customRoleIds, this.inlineRole, this.serviceToken, this.defaultApiVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Token {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    ownerId: ").append(this.toIndentedString(this.ownerId)).append("\n");
        sb.append("    memberId: ").append(this.toIndentedString(this.memberId)).append("\n");
        sb.append("    member: ").append(this.toIndentedString(this.member)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    lastModified: ").append(this.toIndentedString(this.lastModified)).append("\n");
        sb.append("    lastUsed: ").append(this.toIndentedString(this.lastUsed)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    customRoleIds: ").append(this.toIndentedString(this.customRoleIds)).append("\n");
        sb.append("    inlineRole: ").append(this.toIndentedString(this.inlineRole)).append("\n");
        sb.append("    serviceToken: ").append(this.toIndentedString(this.serviceToken)).append("\n");
        sb.append("    defaultApiVersion: ").append(this.toIndentedString(this.defaultApiVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

