/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.annotations.SerializedName;
import com.launchdarkly.api.model.Statement;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class TokenBody {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="role")
    private String role = null;
    @SerializedName(value="customRoleIds")
    private List<String> customRoleIds = null;
    @SerializedName(value="inlineRole")
    private List<Statement> inlineRole = null;
    @SerializedName(value="serviceToken")
    private Boolean serviceToken = null;
    @SerializedName(value="defaultApiVersion")
    private Integer defaultApiVersion = null;

    public TokenBody name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="My access token", value="A human-friendly name for the access token")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TokenBody role(String role) {
        this.role = role;
        return this;
    }

    @ApiModelProperty(example="writer", value="The name of a built-in role for the token")
    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public TokenBody customRoleIds(List<String> customRoleIds) {
        this.customRoleIds = customRoleIds;
        return this;
    }

    public TokenBody addCustomRoleIdsItem(String customRoleIdsItem) {
        if (this.customRoleIds == null) {
            this.customRoleIds = new ArrayList<String>();
        }
        this.customRoleIds.add(customRoleIdsItem);
        return this;
    }

    @ApiModelProperty(value="A list of custom role IDs to use as access limits for the access token")
    public List<String> getCustomRoleIds() {
        return this.customRoleIds;
    }

    public void setCustomRoleIds(List<String> customRoleIds) {
        this.customRoleIds = customRoleIds;
    }

    public TokenBody inlineRole(List<Statement> inlineRole) {
        this.inlineRole = inlineRole;
        return this;
    }

    public TokenBody addInlineRoleItem(Statement inlineRoleItem) {
        if (this.inlineRole == null) {
            this.inlineRole = new ArrayList<Statement>();
        }
        this.inlineRole.add(inlineRoleItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Statement> getInlineRole() {
        return this.inlineRole;
    }

    public void setInlineRole(List<Statement> inlineRole) {
        this.inlineRole = inlineRole;
    }

    public TokenBody serviceToken(Boolean serviceToken) {
        this.serviceToken = serviceToken;
        return this;
    }

    @ApiModelProperty(value="Whether the token will be a service token https://docs.launchdarkly.com/home/account-security/api-access-tokens#service-tokens")
    public Boolean isServiceToken() {
        return this.serviceToken;
    }

    public void setServiceToken(Boolean serviceToken) {
        this.serviceToken = serviceToken;
    }

    public TokenBody defaultApiVersion(Integer defaultApiVersion) {
        this.defaultApiVersion = defaultApiVersion;
        return this;
    }

    @ApiModelProperty(value="The default API version for this token")
    public Integer getDefaultApiVersion() {
        return this.defaultApiVersion;
    }

    public void setDefaultApiVersion(Integer defaultApiVersion) {
        this.defaultApiVersion = defaultApiVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenBody tokenBody = (TokenBody)o;
        return Objects.equals(this.name, tokenBody.name) && Objects.equals(this.role, tokenBody.role) && Objects.equals(this.customRoleIds, tokenBody.customRoleIds) && Objects.equals(this.inlineRole, tokenBody.inlineRole) && Objects.equals(this.serviceToken, tokenBody.serviceToken) && Objects.equals(this.defaultApiVersion, tokenBody.defaultApiVersion);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.role, this.customRoleIds, this.inlineRole, this.serviceToken, this.defaultApiVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenBody {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    customRoleIds: ").append(this.toIndentedString(this.customRoleIds)).append("\n");
        sb.append("    inlineRole: ").append(this.toIndentedString(this.inlineRole)).append("\n");
        sb.append("    serviceToken: ").append(this.toIndentedString(this.serviceToken)).append("\n");
        sb.append("    defaultApiVersion: ").append(this.toIndentedString(this.defaultApiVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

