/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.annotations.SerializedName;
import com.launchdarkly.api.model.FlagListItem;
import com.launchdarkly.api.model.Links;
import com.launchdarkly.api.model.UserSegmentRule;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UserSegment {
    @SerializedName(value="key")
    private String key = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="tags")
    private List<String> tags = null;
    @SerializedName(value="creationDate")
    private Long creationDate = null;
    @SerializedName(value="included")
    private List<String> included = null;
    @SerializedName(value="excluded")
    private List<String> excluded = null;
    @SerializedName(value="rules")
    private List<UserSegmentRule> rules = null;
    @SerializedName(value="unbounded")
    private Boolean unbounded = null;
    @SerializedName(value="version")
    private Integer version = null;
    @SerializedName(value="_links")
    private Links links = null;
    @SerializedName(value="_flags")
    private List<FlagListItem> flags = null;

    public UserSegment key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(example="beta-testers", required=true, value="Unique identifier for the user segment.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public UserSegment name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Beta Testers", required=true, value="Name of the user segment.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UserSegment description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Users in this segment can access beta features.", value="Description of the user segment.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UserSegment tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public UserSegment addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(example="[\"dev\",\"ops\"]", value="An array of tags for this user segment.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public UserSegment creationDate(Long creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @ApiModelProperty(example="1443652232590", required=true, value="A unix epoch time in milliseconds specifying the creation time of this flag.")
    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Long creationDate) {
        this.creationDate = creationDate;
    }

    public UserSegment included(List<String> included) {
        this.included = included;
        return this;
    }

    public UserSegment addIncludedItem(String includedItem) {
        if (this.included == null) {
            this.included = new ArrayList<String>();
        }
        this.included.add(includedItem);
        return this;
    }

    @ApiModelProperty(value="An array of user keys that are included in this segment.")
    public List<String> getIncluded() {
        return this.included;
    }

    public void setIncluded(List<String> included) {
        this.included = included;
    }

    public UserSegment excluded(List<String> excluded) {
        this.excluded = excluded;
        return this;
    }

    public UserSegment addExcludedItem(String excludedItem) {
        if (this.excluded == null) {
            this.excluded = new ArrayList<String>();
        }
        this.excluded.add(excludedItem);
        return this;
    }

    @ApiModelProperty(value="An array of user keys that should not be included in this segment, unless they are also listed in \"included\".")
    public List<String> getExcluded() {
        return this.excluded;
    }

    public void setExcluded(List<String> excluded) {
        this.excluded = excluded;
    }

    public UserSegment rules(List<UserSegmentRule> rules) {
        this.rules = rules;
        return this;
    }

    public UserSegment addRulesItem(UserSegmentRule rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<UserSegmentRule>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    @ApiModelProperty(value="An array of rules that can cause a user to be included in this segment.")
    public List<UserSegmentRule> getRules() {
        return this.rules;
    }

    public void setRules(List<UserSegmentRule> rules) {
        this.rules = rules;
    }

    public UserSegment unbounded(Boolean unbounded) {
        this.unbounded = unbounded;
        return this;
    }

    @ApiModelProperty(example="false", value="Controls whether this is considered a \"big segment\" which can support an unlimited numbers of users. Include/exclude lists sent with this payload are not used in big segments. Contact your account manager for early access to this feature.")
    public Boolean isUnbounded() {
        return this.unbounded;
    }

    public void setUnbounded(Boolean unbounded) {
        this.unbounded = unbounded;
    }

    public UserSegment version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(value="")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public UserSegment links(Links links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public Links getLinks() {
        return this.links;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    @ApiModelProperty(value="")
    public List<FlagListItem> getFlags() {
        return this.flags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSegment userSegment = (UserSegment)o;
        return Objects.equals(this.key, userSegment.key) && Objects.equals(this.name, userSegment.name) && Objects.equals(this.description, userSegment.description) && Objects.equals(this.tags, userSegment.tags) && Objects.equals(this.creationDate, userSegment.creationDate) && Objects.equals(this.included, userSegment.included) && Objects.equals(this.excluded, userSegment.excluded) && Objects.equals(this.rules, userSegment.rules) && Objects.equals(this.unbounded, userSegment.unbounded) && Objects.equals(this.version, userSegment.version) && Objects.equals(this.links, userSegment.links) && Objects.equals(this.flags, userSegment.flags);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.name, this.description, this.tags, this.creationDate, this.included, this.excluded, this.rules, this.unbounded, this.version, this.links, this.flags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserSegment {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    included: ").append(this.toIndentedString(this.included)).append("\n");
        sb.append("    excluded: ").append(this.toIndentedString(this.excluded)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("    unbounded: ").append(this.toIndentedString(this.unbounded)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    flags: ").append(this.toIndentedString(this.flags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

