/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UserSegmentBody {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="key")
    private String key = null;
    @SerializedName(value="description")
    private String description = null;
    @SerializedName(value="unbounded")
    private Boolean unbounded = null;
    @SerializedName(value="tags")
    private List<String> tags = null;

    public UserSegmentBody name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="new segment", required=true, value="A human-friendly name for the user segment.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UserSegmentBody key(String key) {
        this.key = key;
        return this;
    }

    @ApiModelProperty(example="new-segment", required=true, value="A unique key that will be used to reference the user segment in feature flags.")
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public UserSegmentBody description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(example="Users in this segment will have access to beta features.", value="A description for the user segment.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public UserSegmentBody unbounded(Boolean unbounded) {
        this.unbounded = unbounded;
        return this;
    }

    @ApiModelProperty(example="false", value="Controls whether this is considered a \"big segment\" which can support an unlimited numbers of users. Include/exclude lists sent with this payload are not used in big segments. Contact your account manager for early access to this feature.")
    public Boolean isUnbounded() {
        return this.unbounded;
    }

    public void setUnbounded(Boolean unbounded) {
        this.unbounded = unbounded;
    }

    public UserSegmentBody tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public UserSegmentBody addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(value="Tags for the user segment.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSegmentBody userSegmentBody = (UserSegmentBody)o;
        return Objects.equals(this.name, userSegmentBody.name) && Objects.equals(this.key, userSegmentBody.key) && Objects.equals(this.description, userSegmentBody.description) && Objects.equals(this.unbounded, userSegmentBody.unbounded) && Objects.equals(this.tags, userSegmentBody.tags);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.key, this.description, this.unbounded, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserSegmentBody {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    unbounded: ").append(this.toIndentedString(this.unbounded)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

