/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.annotations.SerializedName;
import com.launchdarkly.api.model.Links;
import com.launchdarkly.api.model.Statement;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Webhook {
    @SerializedName(value="_links")
    private Links links = null;
    @SerializedName(value="_id")
    private String id = null;
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="secret")
    private String secret = null;
    @SerializedName(value="on")
    private Boolean on = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="statements")
    private List<Statement> statements = null;
    @SerializedName(value="tags")
    private List<String> tags = null;

    public Webhook links(Links links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(value="")
    public Links getLinks() {
        return this.links;
    }

    public void setLinks(Links links) {
        this.links = links;
    }

    public Webhook id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(value="")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Webhook url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="https://example.com/example", value="The URL of the remote webhook.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Webhook secret(String secret) {
        this.secret = secret;
        return this;
    }

    @ApiModelProperty(example="frobozz", value="If defined, the webhooks post request will include a X-LD-Signature header whose value will contain an HMAC SHA256 hex digest of the webhook payload, using the secret as the key.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public Webhook on(Boolean on) {
        this.on = on;
        return this;
    }

    @ApiModelProperty(example="true", value="Whether this webhook is enabled or not.")
    public Boolean isOn() {
        return this.on;
    }

    public void setOn(Boolean on) {
        this.on = on;
    }

    public Webhook name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Example hook", value="The name of the webhook.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Webhook statements(List<Statement> statements) {
        this.statements = statements;
        return this;
    }

    public Webhook addStatementsItem(Statement statementsItem) {
        if (this.statements == null) {
            this.statements = new ArrayList<Statement>();
        }
        this.statements.add(statementsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Statement> getStatements() {
        return this.statements;
    }

    public void setStatements(List<Statement> statements) {
        this.statements = statements;
    }

    public Webhook tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public Webhook addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(value="Tags assigned to this webhook.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Webhook webhook = (Webhook)o;
        return Objects.equals(this.links, webhook.links) && Objects.equals(this.id, webhook.id) && Objects.equals(this.url, webhook.url) && Objects.equals(this.secret, webhook.secret) && Objects.equals(this.on, webhook.on) && Objects.equals(this.name, webhook.name) && Objects.equals(this.statements, webhook.statements) && Objects.equals(this.tags, webhook.tags);
    }

    public int hashCode() {
        return Objects.hash(this.links, this.id, this.url, this.secret, this.on, this.name, this.statements, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Webhook {\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    on: ").append(this.toIndentedString(this.on)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    statements: ").append(this.toIndentedString(this.statements)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

