/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.api.model;

import com.google.gson.annotations.SerializedName;
import com.launchdarkly.api.model.Statement;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class WebhookBody {
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="secret")
    private String secret = null;
    @SerializedName(value="sign")
    private Boolean sign = null;
    @SerializedName(value="on")
    private Boolean on = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="statements")
    private List<Statement> statements = null;
    @SerializedName(value="tags")
    private List<String> tags = null;

    public WebhookBody url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(example="https://example.com/example", required=true, value="The URL of the remote webhook.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public WebhookBody secret(String secret) {
        this.secret = secret;
        return this;
    }

    @ApiModelProperty(example="<password>", value="If sign is true, and the secret attribute is omitted, LaunchDarkly will automatically generate a secret for you.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public WebhookBody sign(Boolean sign) {
        this.sign = sign;
        return this;
    }

    @ApiModelProperty(required=true, value="If sign is false, the webhook will not include a signature header, and the secret can be omitted.")
    public Boolean isSign() {
        return this.sign;
    }

    public void setSign(Boolean sign) {
        this.sign = sign;
    }

    public WebhookBody on(Boolean on) {
        this.on = on;
        return this;
    }

    @ApiModelProperty(example="true", required=true, value="Whether this webhook is enabled or not.")
    public Boolean isOn() {
        return this.on;
    }

    public void setOn(Boolean on) {
        this.on = on;
    }

    public WebhookBody name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Example hook", value="The name of the webhook.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WebhookBody statements(List<Statement> statements) {
        this.statements = statements;
        return this;
    }

    public WebhookBody addStatementsItem(Statement statementsItem) {
        if (this.statements == null) {
            this.statements = new ArrayList<Statement>();
        }
        this.statements.add(statementsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Statement> getStatements() {
        return this.statements;
    }

    public void setStatements(List<Statement> statements) {
        this.statements = statements;
    }

    public WebhookBody tags(List<String> tags) {
        this.tags = tags;
        return this;
    }

    public WebhookBody addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @ApiModelProperty(example="[]", value="Tags for the webhook.")
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookBody webhookBody = (WebhookBody)o;
        return Objects.equals(this.url, webhookBody.url) && Objects.equals(this.secret, webhookBody.secret) && Objects.equals(this.sign, webhookBody.sign) && Objects.equals(this.on, webhookBody.on) && Objects.equals(this.name, webhookBody.name) && Objects.equals(this.statements, webhookBody.statements) && Objects.equals(this.tags, webhookBody.tags);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.secret, this.sign, this.on, this.name, this.statements, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WebhookBody {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    sign: ").append(this.toIndentedString(this.sign)).append("\n");
        sb.append("    on: ").append(this.toIndentedString(this.on)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    statements: ").append(this.toIndentedString(this.statements)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

