/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import android.os.Process;
import androidx.annotation.NonNull;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class BackgroundThreadExecutor {
    private final ThreadFactory threadFactory = new PriorityThreadFactory(10);

    BackgroundThreadExecutor() {
    }

    ExecutorService newFixedThreadPool(int nThreads) {
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), this.threadFactory);
    }

    private static class PriorityThreadFactory
    implements ThreadFactory {
        private final int threadPriority;

        PriorityThreadFactory(int threadPriority) {
            this.threadPriority = threadPriority;
        }

        @Override
        public Thread newThread(@NonNull Runnable runnable) {
            return new Thread(() -> {
                try {
                    Process.setThreadPriority((int)this.threadPriority);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                runnable.run();
            });
        }
    }
}

